 /* **++$ **  FACILITY:  PRIVDCL.C Version 2.0 ** **  MODULE DESCRIPTION:  **= **	PRIVDCL allows non-privileged users to execute DCL command F **	procedures which require privileges.  A simple data file stipulates> **	which users may execute a registered command file, and whatE **	privileges are required.  The command procedure itself is executed D **	in a subprocess that terminates when the procedure is finished or **	prematurely interrupted.  ** **  AUTHORS: ** **      Robert Lowe  **! **  CREATION DATE:  November 1993  ** **  DESIGN ISSUES: ** ** **  ASSOCIATED FILES:  **     **  	PRIVDCL_FUNCTIONS.C0 **		Source code for functions called from main() **' **	PRIVDCL_MSG.H (from PRIVDCL_MSG.MSG)  **		PRIVDCL-specific messages  ** **	PRIVDCL.DAT7 **		This text file is used to hold descriptions of each 9 **		"privileged command".  Each has three required lines, > **		followed by a blank line: (1) the privileged command name,< **		(2) the DCL command to execute; it is highly recommendedA **		that this be a controlled command procedure; PRIVDCL.EXE will @ **		pass along parameters from the image invocation command line> **		(foreign command required) to the DCL command; and (3) the> **		users allowed to use the command (username, or UIC with or< **		without wildcards).  Each command must be preceeded by a, **		blank line or comment (! in column one). ** **	PRIVDCL.LOG< **		Logfile to which one-line timestamp records are written,8 **		including time, username, and the privileged command: **		invoked.  PRIVDCL_STARTUP.COM creates a new version of+ **		this file, typically at system startup.  ** **	PRIVDCL.COM: **		This command file is a shell to the actual DCL command; **		found in PRIVDCL.DAT; this has the small side effect of @ **		limiting the actual DCL command to seven parameters.  Before< **		the DCL command is executed, commands can be executed to< **		ensure process specific, job, and even group logicals do< **		not effect the spawned subprocess, e.g. modifications to> **		logicals the the logical name table LNM$PROCESS_DIRECTORY,$ **		or the addition of LNM$FILE_DEV. **     **	PRIVDCL_STARTUP.COMB **		Creates a new version of the logfile, and installs PRIVDCL.EXE= **		(requires CMEXEC to affect privileges, and SYSPRV to read # **		data file and write to logfile.  ** **  LOGICAL NAMES: ** **	PRIVDCL_DIR< **		This logical must exist in the system table in executive= **		mode.  It points to the location of the executable image, < **		the data file, and the logfile.  This location should be> **		world "reachable" with EXECUTE access, but not readable or8 **		writeable.  I recommend SYS$COMMON:[SYSMGR.PRIVDCL]. ** **  MODIFICATION HISTORY:  **B **	24-Jul-1997	Extensive modifications to allow rights identifiers: **			to be used as a means of allowing access to commands.4 **			Identifiers are entered into PRIVDCL.DAT on the6 **			"users" line between angle brackets.  The maximum9 **			number of identifiers held by the calling user which * **			will be evaluated is set by MAX_HELD. **-- */   /*	Define constants  */   #define TRUE 1 #define FALSE 0  #define BLANK 0  #define NON_BLANK 1   C /*	User identifiers from data source can be either in username, UIC H **	or identifier format.  UICS can be either in alphanumeric, or numericF **	form.  If the UIC is a single identifier in brackets, it is assumedC **	to correspond to the username.  In [group,member] format, either D **	part be wildcarded with an asterisk, e.g. [group,*].  Identifiers7 **	are surrounded by angle brackets, e.g. <identifier>. ? **	The following three constants are used to show which form of F **	"identifier" is used to represent the user(s) authorized to perform" **	any given "privileged command". */   #define IDENT 2 
 #define UIC 1  #define USERNAME 0  I #define MAX_HELD  32	/* Maximum number of identifiers that will be looked 6 			** up to match against an identifier UID for access 			** to a command.  			*/ H #define MAX_ATOMS 10	/* How many user identifiers can be associated with# 			** any given privileged command.  			*/   @ /*	The following are item codes for the external string edittingD **	function str_edit(<*string>,<item-code>), which alters the actualD **	string pointed to, and returns the length of the resultant string */   #define TRIM 1 #define UPCASE 2 #define COMPRESS 4 #define COLLAPSE 8   /* ** **  INCLUDE FILES  ** */   #include <stdio.h> #include <ctype.h> #include <string.h>  #include <descrip.h> #include <lnmdef.h>  #include <psldef.h>  #include <jpidef.h>  #include <clidef.h>  #include <ssdef.h> #include <prvdef.h>  #include <starlet.h> #include <stdlib.h>  #include <lib$routines.h> 9 #include "privdcl_msg.h"	/* Facility specific messages */   M long int  procpriv[2] = {0,0};	/* Process permanent privs, which are modified / 				** since the subprocess inherits these into ! 				** PROCPRIV and CURPRIV masks  				*/K long int oprocpriv[2] = {0,0};  /* Original process permanent privileges */    struct priv_struct     { / 	char name[9];		/* Name of the privilege		   */ ; 	int  value;		/* Bit value using PRV$M_<name> symbols    */ ; 	int  index;		/* Index into long word array aka quadword */      };   	   $ struct priv_struct privileges[37] =      { # 	{ "CMKRNL",   PRV$M_CMKRNL,   0 }, # 	{ "CMEXEC",   PRV$M_CMEXEC,   0 }, # 	{ "SYSNAM",   PRV$M_SYSNAM,   0 }, # 	{ "GRPNAM",   PRV$M_GRPNAM,   0 }, # 	{ "ALLSPOOL", PRV$M_ALLSPOOL, 0 }, # 	{ "DETACH",   PRV$M_DETACH,   0 }, # 	{ "DIAGNOSE", PRV$M_DIAGNOSE, 0 }, # 	{ "LOG_IO",   PRV$M_LOG_IO,   0 }, # 	{ "GROUP",    PRV$M_GROUP,    0 }, # 	{ "NOACNT",   PRV$M_NOACNT,   0 }, # 	{ "PRMCEB",   PRV$M_PRMCEB,   0 }, # 	{ "PRMMBX",   PRV$M_PRMMBX,   0 }, # 	{ "PSWAPM",   PRV$M_PSWAPM,   0 }, # 	{ "ALTPRI",   PRV$M_ALTPRI,   0 }, # 	{ "SETPRV",   PRV$M_SETPRV,   0 }, # 	{ "TMPMBX",   PRV$M_TMPMBX,   0 }, # 	{ "WORLD",    PRV$M_WORLD,    0 }, # 	{ "MOUNT",    PRV$M_MOUNT,    0 }, # 	{ "OPER",     PRV$M_OPER,     0 }, # 	{ "EXQUOTA",  PRV$M_EXQUOTA,  0 }, # 	{ "NETMBX",   PRV$M_NETMBX,   0 }, # 	{ "VOLPRO",   PRV$M_VOLPRO,   0 }, # 	{ "PHY_IO",   PRV$M_PHY_IO,   0 }, # 	{ "BUGCHK",   PRV$M_BUGCHK,   0 }, # 	{ "PRMGBL",   PRV$M_PRMGBL,   0 }, # 	{ "SYSGBL",   PRV$M_SYSGBL,   0 }, # 	{ "PFNMAP",   PRV$M_PFNMAP,   0 }, # 	{ "SHMEM",    PRV$M_SHMEM,    0 }, # 	{ "SYSPRV",   PRV$M_SYSPRV,   0 }, # 	{ "BYPASS",   PRV$M_BYPASS,   0 }, # 	{ "SYSLCK",   PRV$M_SYSLCK,   0 }, # 	{ "SHARE",    PRV$M_SHARE,    0 }, 9 	{ "UPGRADE",  1,	      1 },	/* No symbolic values for */ 9 	{ "DOWNGRADE",2,	      1 },	/* privileges stored in   */ 9 	{ "GRPPRV",   4,	      1 },	/* the 2nd longword       */  	{ "READALL",  8,	      1 }, 	{ "SECURITY", 64,	      1 }     };     H /* Function prototypes.  See each function for a detailed description */  ( size_t str_edit( char *, unsigned int );: size_t parse_elements( char *, char *element[MAX_ATOMS] ); size_t match_uid( void ); , size_t uid_type( char *, char **, char ** );? void   set_privs( long int *, size_t, char *privs[MAX_ATOMS] );      /*	EXTERNAL IDENTIFIERS	*/  ? size_t num_uids = 0;		/* Number of UIDs for authorized users of ( 				** the specified privileged command. 				*/D char *uid[MAX_ATOMS];		/* Pointers to each of the UIDs found.  These/ 				** point to parts of the line read from the 0 				** data file; nulls are laid over separators 				*/F size_t num_privs = 0;		/* Number of privileges required for command */M char *priv_to_set[MAX_ATOMS];	/* Pointers to each of those privileges      */   A /*	Pointers to user information retrieved from $GETJPI call.  The B **	longword UIC is converted with an $FAO call to both numeric andA **	alphanumeric format.  The function uid_type() points group and E **	member identifiers to the correct location; char *no_group is used 0 **	when the alphanumeric form only has one part. */ char *username;  char *group_n; char *member_n;  char *group_a; char *member_a;  char *no_group = "*";  char *no_user  = (void *) 0;  N char held_id [MAX_HELD][31] = { "\0" };	/* Identifiers held by calling user */= size_t num_held = 0;			/* Num of identifiers held by user  */ = size_t id_present = FALSE;		/* Flag if identifier(s) used for % 					** "authenticating" this command  					*/   " /********************************/   main( int argc, char *argv[] ) {   ;     typedef struct			/* struct for various item lists    */        {  	short buf_len;  	short item_code;  	void *buf_addr; 	void *ret_len_addr;
       }	ITEM;   H     typedef long int quadword[2];	/* Make up quadword                 */  +     size_t i, length, start, add_quote = 0;      long int status;  N     static char lognam[] = "PRIVDCL_DIR"; /* Location of data and log files */K     $DESCRIPTOR(lognam_desc,lognam);	  /* Descriptor for logical name    */ A     unsigned char acmode;		  /* Access mode for logical name   */ C     static char equiv_nam[128];		  /* Store equivalance name	    */ B     static short equivlen;		  /* Length of equivalance name     */K     $DESCRIPTOR(table,"LNM$SYSTEM");	  /* Descriptor for name table      */   J     ITEM list[] = {sizeof(equiv_nam),LNM$_STRING,equiv_nam,&equivlen,0,0};  N     /* Information gathered about the current user or "caller"              */N     /************************************************************************/6     ITEM jpi_itmlst[4];			/* $GETJPI item list		    */?     quadword jpi_iosb;			/* I/O status block -> $getjpi call */   H     static char calling_user[13];	/* Current (caller) user's username */C     short calling_user_len;		/* Length of returned username      */ 9     long uic_lw;			/* UIC returned in longword format  */ ;     short uic_len;			/* Length in bytes                  */   I     $DESCRIPTOR(ctrstr_desc,"!%U !-!%I "); /* Descriptor for $FAO call to ' 					   ** convert UIC longword to both $ 					   ** alpha and numeric formats
 					   */B     unsigned short faolen;		/* Length of returned string        */A     static char uics[80];		/* Location to write back results   */ G     $DESCRIPTOR(uics_desc,uics);	/* Descriptor for string for $FAO   */   9     char *uic_u;			/* Pointer to alphanumeric form;    */ 9     char *uic_i;			/* numeric form, within uics[]      */          static char namebuf[31];N     $DESCRIPTOR(namebuf_desc,namebuf);  /* Descriptor for returned ID       */N     $DESCRIPTOR(name_desc,calling_user);/* Descriptor for caller username   */N     unsigned int bin_holder[2] = { 0 }; /* For getting rights IDs of user   */#     unsigned int idasc_context = 0;      unsigned int resid = 0; "     unsigned int bin_id,context=0;     unsigned short namelen;   K     long int imagpriv[2] = { 0, 0 };	/* IMAGPRIV mask for installed img  */     N     /* Information to lookup in PRIVDCL.DAT and determine access to cmd     */N     /************************************************************************/M     static char datfilnam[128] = "\0";	/* Fully expanded filename for .DAT */ :     char *filnam;			/* Pointer to that filename         */:     FILE *infile;			/* FILE pointer to PRIVDCL.DAT      */  ;     char line[81];			/* Line read from PRIVDCL.DAT       */ :     int line_len;			/* Length of line read from .DAT    */A     int prev_lin = BLANK;		/* Was previous line blank|comment? */ ?     int found = FALSE;			/* Found flag for privileged cmd    */   8     char *cmd;				/* Pointer to privileged command    */=     char dclcmd[81];			/* Associated DCL command           */ @     char req_privs[81];			/* Required privileges line         */<     char users[81];			/* Auth users of privileged command */?     int match = FALSE;			/* Current user match one of those? */   N     /* Execution of the privileged command                                  */N     /************************************************************************/;     FILE *logfile;			/* FILE pointer for logfile         */ M     static char logfilnam[128] = "\0";	/* Logfile name                     */ A     static char time[32];		/* Timestamp for logfile entry      */ G     $DESCRIPTOR(time_desc,time);	/* Descriptor for character string  */ <     short time_len;			/* Length of returned string        */  K     static char spawncmd[256] = "@";	/* DCL command for LIB$SPAWN()      */ (     $DESCRIPTOR(spawncmd_desc,spawncmd);  N     /* Description of each flag preceeds actual LIB$SPAWN() call below      */C     unsigned long int spawn_flags = (CLI$M_NOCLISYM|CLI$M_NOLOGNAM|  				     CLI$M_TRUSTED);  @     long int spawn_stat;		/* Status of spawn                  */G     $DESCRIPTOR(cli_desc,"DCL");	/* CLI string descriptor            */   N     long int arglist[5] = { 4,1,0,1,0 };  /* Argument list for settng privs */>     /*  This struct shows the format of the argument list, but.     **  it is implemented as a longword array.     **     **  struct {3     **	long int num_params;	** Number of parameters .     **	long int enbflg;	** Enable flag        ,     **	void *prvadr;		** Priv mask address  .     **	long int prmflg;	** Permanent          ,     **	void *prvprv;		** Previous privileges     **  } arglist;     */  #     long int ctrlmask = 0x02000000;      long int oldctrlmask; #     long int curpriv[2] = { 0, 0 };   5     /*  Exit if no privileged command is supplied  */      if ( argc <= 1 ) 	exit( PRIVDCL_NOCMD );        acmode = PSL$C_EXEC;@     lognam_desc.dsc$w_length = str_edit(lognam,COLLAPSE|UPCASE);  (     list[0].buf_len = sizeof(equiv_nam);.     memset (equiv_nam,'\0',sizeof(equiv_nam));  L     /*  Translate PRIVDCL_DIR logical name.  Exit if there is no translation0     **  in executive mode from the system table.     */L     if(((status = sys$trnlnm(0,&table,&lognam_desc,&acmode,&list)) &1) != 1)                   exit(status);      equiv_nam[equivlen] = '\0'; #     strcpy( datfilnam, equiv_nam ); 0     filnam = strcat( datfilnam, "PRIVDCL.DAT" );  7     /*  Try to open the data file; exit if we cannot */       infile = fopen(filnam, "r");     if (infile == NULL)  	exit(PRIVDCL_CANTOPEN);  I     /*  Search through the file for a command that matches the one given. J     **  The command must be preceeded the beginning of file, a blank line,     **  or a comment.      */     cmd = argv[1];0     line_len = str_edit( cmd, COLLAPSE|UPCASE );  -     while (fgets( line, 80, infile ) != NULL)      {  	if ( (line[0] == '!') || 4 	     (str_edit(line,COMPRESS|UPCASE|TRIM) == 0) ) { 	    prev_lin = BLANK; 	} 	else	{ C 	    if ( ( strcmp( line, cmd ) == 0 ) && ( prev_lin == BLANK ) ) {  		found = TRUE;  		fgets( dclcmd, 80, infile );! 		fgets( req_privs, 80, infile );  		fgets( users, 80, infile ); 
 #ifdef _debug ! 		printf( "\nCmd:\t%s\n", line );  		printf( "DCL:\t%s", dclcmd ); $ 		printf( "Privs:\t%s", req_privs );" 		printf( "Users:\t%s\n", users ); #endif* 		num_uids = parse_elements( users, uid );
 #ifdef _debug / 		printf( "Number of users: %ld\n", num_uids ); ! 		for (i=0; i < num_uids; i++ ) { . 		    printf( "User %2d: /%s/\n", i, uid[i] ); 		}  #endif 		break; 	    } 	    prev_lin = NON_BLANK; 	}     }      fclose(infile);      if ( !found )  	exit( PRIVDCL_IVVERB );  L     /*  Continue if we found the command, the corresponding DCL command, theI     **  required privileges, and the users allowed access to the command. K     **  Begin by getting the calling user's username and UIC in numeric and E     **  identifier format.  Also, get the IMAGPRIV privilege mask for      **  possible use later.      */1     jpi_itmlst[0].buf_len	= sizeof(calling_user); ,     jpi_itmlst[0].item_code	= JPI$_USERNAME;+     jpi_itmlst[0].buf_addr	= &calling_user; 3     jpi_itmlst[0].ret_len_addr	= &calling_user_len;      jpi_itmlst[1].buf_len	= 4;'     jpi_itmlst[1].item_code	= JPI$_UIC; %     jpi_itmlst[1].buf_addr	= &uic_lw; *     jpi_itmlst[1].ret_len_addr	= &uic_len;     jpi_itmlst[2].buf_len	= 4;,     jpi_itmlst[2].item_code	= JPI$_IMAGPRIV;&     jpi_itmlst[2].buf_addr	= imagpriv;&     jpi_itmlst[2].ret_len_addr	= NULL;     jpi_itmlst[3].buf_len	= 0;      jpi_itmlst[3].item_code	= 0;  F     if (((status = sys$getjpiw(0,0,0,&jpi_itmlst,jpi_iosb,0,0))&1)!=1) 	exit(status);       if ((jpi_iosb[0] & 1) != 1)  	exit(status);  *     calling_user[calling_user_len] = '\0';'     i = str_edit( calling_user, TRIM );   "     ctrstr_desc.dsc$w_length	= 10;      uics_desc.dsc$w_length	= 80;  J     if (((status = sys$fao(&ctrstr_desc,&faolen,&uics_desc,uic_lw))&1)!=1) 	exit(status);       uic_u = uics;o"     for (i=0; uics[i] != ' '; i++) 	;     uics[i++] = '\0';f     uic_i = &uics[i];h     while (uics[i] != ' ') 	i++;m     uics[i] = '\0';*  J     /*  Point to username, and numeric/identifier UIC parts; then test for5     **  a match against the list of authorized users.e     */6     i = uid_type( calling_user, &group_a, &username );/     i = uid_type( uic_u, &group_n, &member_n );1/     i = uid_type( uic_i, &group_a, &member_a );T  5     if ( id_present ) {				/* Lookup IDs if needed */c1 	name_desc.dsc$w_length = strlen( calling_user );L   	/*(3 	**  Translate the HOLDER NAME to its BINARY VALUE.  	*/   4 	status = sys$asctoid ( &name_desc, &bin_holder, 0); 	if ( ( status & 1 ) != 1 )e 	  lib$stop ( status );h   	/*uE 	** Make repeated calls to SYS$FIND_HELD to return all identifiers(s)n 	** held by a specified holder.e 	*/e  ? 	  bin_holder[2] = 0;        /* complete the quadword holder */r$ 	  while ( status == SS$_NORMAL )  {B 	    status = sys$find_held ( &bin_holder, &bin_id, 0, &context );  $ 	    if ( status == SS$_IVIDENT )  {
 #ifdef _debug	6 	      printf ( "\nIdentifier is of invalid format" ); #endif 	      lib$stop( status ); 	    }
 #ifdef _debug % 	    if ( status == SS$_NOSUCHID )  {o/ 	      printf ( "\nHolder does not exist OR" );iC 	      printf ( "\nNo more identifiers for the specified holder" );a 	    } #endif  F 	  /* If an identifier is found, translate the BINARY IDENTIFIER VALUE 	  ** to its IDENTIFIER NAME.y 	  */a  % 	    if ( status != SS$_NOSUCHID )  {a8                 status = sys$idtoasc ( bin_id, &namelen,N                                      &namebuf_desc,&resid, 0, &idasc_context);)                 if ( ( status & 1 ) != 1) *                       lib$stop ( status );
 #ifdef _debugnC                 printf("\nIdentifier: %s Id:  %d ",namebuf, resid);t #endif 		str_edit( namebuf, TRIM );) 		strcpy( held_id[num_held++], namebuf );  	    } 	  } 	  num_held--;     }t       match = match_uid();       if (!match)L 	exit( PRIVDCL_NOPRIV );  N     /************************************************************************/L     /*  If the user is allowed access, then point to the individual requiredM         privilege names, build the DCL command line (including any parameterss,         passed to the target DCL procedure).     */9     num_privs = parse_elements( req_privs, priv_to_set );e  *     time_desc.dsc$w_length = sizeof(time);2     status = sys$asctim(&time_len,&time_desc,0,0);     time[time_len] = '\0';  A     strcat( spawncmd, equiv_nam );	/* Location of PRIVDCL_DIR  */*B     strcat( spawncmd, "PRIVDCL " );	/* PRIVDCL.COM shell file   */?     strcat( spawncmd, dclcmd );		/* Command from PRIVDCL.DAT */e  M     /*  Now double any quotations found in any command line arguments so thatc@     **  they will be presevered in the callout from PRIVDCL.COM.     */#     start = strlen( spawncmd ) - 1;y      for ( i=2; i < argc; i++ ) {@ 	spawncmd[start++] = ' ';	/* Add space between each parameter */5 	add_quote = ( strpbrk( argv[i], "\t\v " ) != NULL );t 	if ( add_quote )h 		spawncmd[start++] = '"';5 	length = sprintf( &spawncmd[start], "%s", argv[i] );  	start += length;. 	if ( add_quote )i 		spawncmd[start++] = '"';     }a7     spawncmd[start] = '\0';		/* Terminate the string */eK     spawncmd_desc.dsc$w_length = start;	/* Fill in the descriptor length */I  F     /* Turn on privileges bits for the previously identified, required=     ** privileges.  These are to be set in the PROCPRIV mask.*     */  @     set_privs( (long int *) &procpriv, num_privs, priv_to_set );  L     /*  Build the name and location of logfile.  As in every other case, theK     **  translation of the exec mode logical from the system table is used,eL     **  rather than the logical name itself so that we aren't fooled by evilA     **  trickery.  Open the file, and write the timestamp record.      */  #     strcpy( logfilnam, equiv_nam );g0     filnam = strcat( logfilnam, "PRIVDCL.LOG" );  &     logfile = fopen( logfilnam, "a" );     if (logfile == NULL) 	exit( PRIVDCL_NOLOGFILE );   E     fprintf( logfile, "%-25s%-14s%-16s\n", time, calling_user, cmd );      fclose(logfile);  H     /*  Block all ASTs from user mode and disable CTRL/Y.  Blocking ASTsH     **  is necessary to ensure that the user cannot interrupt the image,4     **  e.g. SYS$FORCEX(), and retaining privileges.     **  H     **  When an installed image is activated, its IMAGPRIV mask is OR-edH     **  with the processes CURPRIV mask, and PROCPRIV is written back toG     **  CURPRIV during image rundown.  A subprocess inherits the parentiC     **  process' PROCPRIV as its PROCPRIV/CURPRIV, and the parent's G     **  CURPRIV as its AUTHPRIV.  Thus, we must alter the PROCPRIV masktE     **  for the subprocess, while removing unneeded privileges in the I     **  IMAGPRIV mask from the CURPRIV mask.  We rely on CMEXEC privilege 3     **  for modifying process permanent privileges.*     **  @     **  Note the use of the spawn flags in the LIB$SPAWN() call:J     **	  CLI$M_NOCLISYM   No symbols are inherited from the parent process@     **	  CLI$M_NOLOGNAM   No process logical names are inherited<     **	  CLI$M_TRUSTED    Allowing use from captive accounts     */  C     if(((status = lib$disable_ctrl(&ctrlmask, &oldctrlmask))&1)!=1)V          lib$stop(status);4     status = sys$setast( 0 );		/* No AST delivery */       /*D     **  Provided as description only; implemented as longword array.     **     **  arglist.num_params = 4;0     **  arglist.enbflg	= 1;M     **  arglist.prmflg	= 1;P#     **  arglist.prvadr	= &procpriv;P$     **  arglist.prvprv	= &oprocpriv;     */  &     arglist[2] = (long int) &procpriv;'     arglist[4] = (long int) &oprocpriv;0  -     status = sys$cmexec(sys$setprv, arglist);O       arglist[1] = 0; %     arglist[2] = (long int) &curpriv;0D     arglist[3] = 0; 	/* Temporary, i.e. CURPRIV not PROCPRIV mask */     arglist[4] = 0;O       /*D     **  The complement of the combination of the original privilegesB     **  and those just set, leaves us with a mask of privileges toA     **  disable.  We then AND this result with the IMAGPRIV mask, A     **  which identifies only those privileges from the installed,=     **  image, making it easier to turn them off and back on.P     */  2     curpriv[0] =  ~( procpriv[0] | oprocpriv[0] );2     curpriv[1] =  ~( procpriv[1] | oprocpriv[1] );     curpriv[0] &= imagpriv[0];     curpriv[1] &= imagpriv[1];  
 #ifdef _debug4E     printf( "CURPRIVs to disable: %x %x\n", curpriv[1], curpriv[0] );,G     printf( "IMAGPRIV mask:       %x %x\n", imagpriv[1], imagpriv[0] );e #endif  D     status = sys$setprv( 0, &curpriv, 0, 0 ); /* IMGPRIV disabled */  G     status = lib$spawn(&spawncmd_desc,0,0,&spawn_flags,0,0,&spawn_stat,t 			0,0,0,0,&cli_desc);  L     /*  Disable previously set privileges by turning off every privilege not,     **  set before the first call to $setprv     */  
 #ifdef _debugn2     printf( "Back from spawned subprocess...\n" ); #endif  F     status = sys$setprv( 1, &curpriv, 0, 0 ); /* IMGPRIV re-enabled */  
 #ifdef _debugoK     printf( "Status from fully re-enabling IMAGPRIV mask = %d\n", status );	 #endif  >     arglist[1] = 0;		/* Flag set to disable privs this time */&     arglist[2] = (long int) &procpriv;     arglist[3] = 1;r'     arglist[4] = (long int) &oprocpriv;         procpriv[0] = ~oprocpriv[0];      procpriv[1] = ~oprocpriv[1];  -     status = sys$cmexec(sys$setprv, arglist);c  
 #ifdef _debug$H     printf( "Status from turning off PROCPRIV privs = %d\n\n", status );  E     printf( "\n New privs:\t%08lx %08lx\nOrig privs:\t%08lx %08lx\n",a 		procpriv[0],procpriv[1], 		oprocpriv[0],oprocpriv[1] ); #endif  E     status = sys$setast( 1 );    /* Allow AST deliveries again ;-) */;:     if(((status = lib$enable_ctrl(&oldctrlmask, 0))&1)!=1)          lib$stop(status); }A