 	options /EXTEND 	function PWD_Restore()  c~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~m c  This function is used to restore the password info of the specified user(s) from the PASWORD storage file.  c~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ 	include		'PASSWORD.INC'6 	logical*1	Do_Remove /.FALSE./, Skip_Restore /.FALSE./+ 	integer*4	Max_Diff_Time(2), Diff_Result(2)  	external	LIB$_NEGTIM  c~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~S c   Create a binary delta time for a non-modified record (max diff is 01:00:00.00).  c~~~Y 	Sts = SYS$BINTIM('0 01:00:00.00', Max_Diff_Time)					! Saved but not modified time diff. 1 	if (.not. Sts) call LIB$SIGNAL(%val(Sts))						!  c~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~" c   Open the PASSWORD storage file c~~~: 	Sts = PWD_Open_SAV_File()								! Open the PASSWORD file1 	if (.not. Sts) call LIB$SIGNAL(%val(Sts))						!  c~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~( c   Check for /REMOVE, /CONFIRM and /LOG c~~~K 	if (CLI$PRESENT('REMOVE'))  Do_Remove = .TRUE.						! /REMOVE specified ?? L 	if (CLI$PRESENT('CONFIRM')) Confirm   = .TRUE.						! /CONFIRM specified ??H 	if (CLI$PRESENT('LOG'))     Log       = .TRUE.						! /LOG specified ?? c~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ c   Per user specified, check whether a record exists. If existing, and /CONFIRM is specified ask whether to restoreit or not.{ c   If the modified flag is set, and the password date differs from the stored date, issue a warning and skip the user, the z c   password has been changed while we were working with the account. If the modified flag is not set, and the stored dateQ c   differs more then 1 hour from the SYSUAF date, the user will also be skipped.  c~~~5 	Dummy = 'Y'										! default confirmation is Y(es) Q 	Sts = CLI$GET_VALUE('USER', PIO.Username, PIO.UN_Len)					! Get 1st user to save F 	do while (Sts .and. (Dummy .ne. 'Q'))							! For all users specifiede 	  read (SAV_Lun, keyeq=PIO.Username(1:PIO.UN_Len), iostat=Sts) PIN			! Get storage info (if present) 6 	  if (Sts .eq. 0) then									! user record found ???             if (PIN.Restored) then								! Restore flag set ?? Z 	      call LIB$SIGNAL(PWD_ALRRESTORED, %val(1), PIO.Username(1:PIO.UN_Len))		! say so and; 	      Skip_Restore = .TRUE.								! Set skip restore flag  	    endif										!  c~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~_ c   If Sts equals 0 (zero), an existing record is found. See whether it can be restored or not.  c~~~K 	    if (Confirm .and. .not. Skip_Restore) then						! need confirmation ?? A 	      write (6, 10) PIO.Username(1:PIO.UN_Len)						! Ask for it 4 	      read  (5,  5) Dummy								! get confirmation? 	      Sts = STR$UPCASE(Dummy, Dummy)							! make it uppercase 7 	      if (.not. Sts) call LIB$SIGNAL(%val(Sts))						! E 	      if (Dummy .eq. 'A') then								! Rest without confirmation ?? 2 	        Dummy = 'Y'									! Set answer to Y(es); 	        Confirm = .FALSE.								! No further confirmation  	      endif										!  	    endif										! O 	    if ((Dummy .eq. 'Y') .and. (.not. Skip_Restore)) then				! Restore info ?? S 	      Sts = SYS$GETUAI(,, PIO.Username(1:PIO.UN_Len), GPI,,,)				! Get SYSUAF info B 	      if (Sts .eq. RMS$_RNF) then							! No such user anymore ??_ 	        call LIB$SIGNAL(PWD_NONEXUSER, %val(1), PIO.Username(1:PIO.UN_Len),		! say nonexisting X      +				PWD_NOTRESTORED, %val(1), PIO.USername(1:PIO.UN_Len))		! and info not restored* 	      else										! else (SYSUAF check)8 	        if (.not. Sts) call LIB$SIGNAL(%val(Sts))					! c~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~} c   If we used PASSWORD MODIFY to save and change the password, the stored date is later than the SYSUAF date. If this is not B c   the case, we issue a PWD_CHANGED message, and we skip the user c~~~F 	        if (PIN.Modified) then								! Did we modify the password ??i 	          Sts = LIB$SUB_TIMES(PIN.Store_Date, PIC.Pwd1_Date, Diff_Result)		! Must give a positive result G 	          if (Sts .eq. %loc(LIB$_NEGTIM)) then						! It's negative ?? o 	            call LIB$SIGNAL(PWD_CHANGED, %val(2), PIO.USername(1:PIO.UN_Len),		! say password has been changed ,      +				    PIC.Pwd1_Date,						! and whenV      +				    PWD_NOTRESTORED, %val(1), PIO.Username(1:PIO.UN_Len))	! say not restored+ 	          else										! It's positive ?? ] 	            Sts = SYS$SETUAI(,, PIO.Username(1:PIO.UN_Len), SPI,,,)			! Restore the password < 	            if (.not. Sts) call LIB$SIGNAL(%val(Sts))					!A 	            if (Do_Remove) then								! Remove after restore ?? = 	              delete (SAV_Lun, iostat=Sts)						! then do so > 	              if (Sts .ne. 0) then							! something wrong ??B 	                call ERRSNS(,,,, Sts)							! Get VMS status codeD 	                call LIB$SIGNAL(%val(Sts), %val(0),					! signal itY      +				        PWD_RESTORED,%val(1),PIO.Username(1:PIO.UN_Len),	! password is restored \      +				       PWD_NOTREMOVED, %val(1), PIO.USername(1:PIO.UN_Len))	! but info not removed 	              else									! " 	                if (Log)								!s      +	                  call LIB$SIGNAL(PWD_RESTORED, %val(1), PIO.Username(1:PIO.UN_Len),	! say password restored R      +					  PWD_REMOVED, %val(1), PIO.Username(1:PIO.UN_Len)) 	! and info removed 	              endif									! 	            else									! B 	              PIN.Restored = .TRUE.							! Set the restored flagN 	              rewrite (SAV_Lun, iostat=Sts) PIN						! And rewrite the record> 	              if (Sts .ne. 0) then							! something wrong ??B 	                call ERRSNS(,,,, Sts)							! Get VMS status codeD 	                call LIB$SIGNAL(%val(Sts), %val(0),					! signal itY      +				        PWD_RESTORED,%val(1),PIO.Username(1:PIO.UN_Len),	! password is restored _      +				        PWD_NOTUPDATE, %val(1), PIO.USername(1:PIO.UN_Len))	! but info is not updated  	              else									! " 	                if (Log)								!s      +	                  call LIB$SIGNAL(PWD_RESTORED, %val(1), PIO.Username(1:PIO.UN_Len),	! say password restored Q      +					  PWD_UPDATED, %val(1), PIO.Username(1:PIO.UN_Len))	! and info updated  	              endif									! 	            endif									! 	          endif										! * 	        else										! else PIN.Modified c~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~a c   If the modified flag has not been set, the max time difference is not to exceed Max_Diff_Time  c~~~i 	          Sts = LIB$SUB_TIMES(PIN.Pwd1_Date, PIN.Store_Date, Diff_Result)		! Must give a positive result G 	          if (Sts .eq. %loc(LIB$_NEGTIM)) then						! It's negative ?? v 	            call LIB$SIGNAL(PWD_NOTCHANGED,  %val(1), PIO.USername(1:PIO.UN_Len))	! say password has not been changed+ 	          else										! It's positive ?? h 	            Sts = LIB$SUB_TIMES(Max_Diff_Time, Diff_Result, Max_Diff_Time)		! Check the time differenceH 	            if (Sts .eq. %loc(LIB$_NEGTIM)) then					! It's negative ??W 	              call LIB$SIGNAL(PWD_TOOLATE, %val(1), Diff_Result,			! Say it's too late W      +				      PWD_NOTRESTORED, %val(1), PIO.Username(1:PIO.UN_Len))	! so not restored , 	            else									! still in time ??_ 	              Sts = SYS$SETUAI(,, PIO.Username(1:PIO.UN_Len), SPI,,,)			! Restore the password > 	              if (.not. Sts) call LIB$SIGNAL(%val(Sts))					!B 	              PIN.Restored = .TRUE.							! Set the restored flagN 	              rewrite (SAV_Lun, iostat=Sts) PIN						! And rewrite the record> 	              if (Sts .ne. 0) then							! something wrong ??B 	                call ERRSNS(,,,, Sts)							! Get VMS status codeD 	                call LIB$SIGNAL(%val(Sts), %val(0),					! signal it\      +				        PWD_NOTUPDATE, %val(1), PIO.USername(1:PIO.UN_Len))	! with additional info 	              endif									!4 	            endif									! End SUB_TIMES time diff: 	          endif										! End SUB_TIMES check pw changed* 	        endif										! End PIN.Modified* 	      endif										! End (SYSUAF check)7 	    else										! else of 'If (Dummy)' - Dummy = 'N' V 	      if (Do_Remove .and. Skip_Restore) then						! remove already restored record ??8 	        delete (SAV_Lun, iostat=Sts)							! then do so9 	        if (Sts .ne. 0) then								! something wrong ?? = 	          call ERRSNS(,,,, Sts)								! Get VMS status code ? 	          call LIB$SIGNAL(%val(Sts), %val(0),						! signal it Y      +				   PWD_NOTREMOVED, %val(1), PIO.USername(1:PIO.UN_Len))		! but info not removed  	        else										!c 	          call LIB$SIGNAL(PWD_REMOVED, %val(1), PIO.USername(1:PIO.UN_Len))		! signal info removed  	        endif										!  	      endif										! i 	      if (Log) call LIB$SIGNAL(PWD_NOTRESTORED, %val(1), PIO.Username(1:PIO.UN_Len))	! show NOT restored F 	      Skip_Restore = .FALSE.								! and reset the skip restore flag% 	    endif										! end 'if (Dummy) + 	  else											! else (read user record)  c~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~h c   Sts is NOT equal to 0 (zero), than it must be 36 (ATTACCNON - Attempt to access non-existent record) c~~~4 	    if (Sts .ne. 36) then								! NOT ATTACCNON ??9 	      call ERRSNS(,,,, Sts)								! Get VMS status code 7 	      call LIB$SIGNAL(%val(Sts))							! and signal it  	    else										!g 	      call LIB$SIGNAL(PWD_NOTSAVED, %val(1), PIO.Username(1:PIO.UN_Len))		! Say no saved info for user  	    endif										! + 	  endif											! end (read user record)  c~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~+ c   Now get next username to save info from  c~~~N 	  Sts = CLI$GET_VALUE('USER', PIO.Username, PIO.UN_Len)					! Next please.... 	enddo											!K 	if (Sts .eq. %loc(CLI$_ABSENT)) Sts = SS$_NORMAL					! No more found ?? OK  c~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~U c   The info of all users specified has been saved, close the storage file and return  c~~~; 	Sts = PWD_Close_SAV_File()								! Close the storage file 1 	if (.not. Sts) call LIB$SIGNAL(%val(Sts))						!  c~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ c   Format statements  c~~~ 5	format (A)M 10	format (' %PWD-I-RESTORE, restore password info for user 'A' (Y/[N]) : '$)  c~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~; c   We are ready, exit with last completion status recorded  c~~~9 	PWD_Restore = Sts									! Save final completion status 7 	CALLG_Sts = Sts										! also as GALLG return status * 	end											! and return to main module c~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ c=================================================================================================================================== c~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~