/* KEYWORDS.H Created on 21-Dec-92 10:05 pm */

struct ItemNode {
  char *name;
  int (*init_routine)();
  int ini_data;
  int (*frmt_routine)();
  unsigned short int clearance;
};

#ifdef GLOBAL
int /* declare all initialization routines */
  init$dummy(),
  init$global(),
  init$io(),
  init$jpi(),
  init$pages(),
  init$state(),
  init$syi(),
  init$type(),
  init$where();
int /* declare all formatting routines */
  cvt$access_mode(),
  cvt$cluster_members(),
  cvt$cputim(),
  cvt$creprc_flags(),
  cvt$current_time(),
  cvt$devices(),
  cvt$elapsed_time(),
  cvt$epid_to_ipid(),
  cvt$global_word(),
  cvt$hex_12(),
  cvt$hex_6(),
  cvt$hex_8(),
  cvt$idlecpu(),
  cvt$idleterminal(),
  cvt$image(),
  cvt$io(),
  cvt$jobtype(),
  cvt$mailcount(),
  cvt$mode(),
  cvt$msgmsk(),
  cvt$nodename(),
  cvt$numeric(),
  cvt$numeric_hex(),
  cvt$numeric_oct(),
  cvt$organization(),
  cvt$pages(),
  cvt$phdflags(),
  cvt$physical_terminal(),
  cvt$privilege(),
  cvt$queue(),
  cvt$state(),
  cvt$sts(),
  cvt$text(),
  cvt$time(),
  cvt$type(),
  cvt$uaf_flags(),
  cvt$uic(),
  cvt$uptime(),
  cvt$where(),
  cvt$who(),
  format_literal();;
globaldef int max_keywords = 138;

globaldef struct ItemNode keywords[] = {
    {"ACCOUNT", init$jpi, JPI$_ACCOUNT, cvt$text, 1},
    {"APTCNT", init$jpi, JPI$_APTCNT, cvt$numeric, 1},
    {"ASTACT", init$jpi, JPI$_ASTACT, cvt$access_mode, 1},
    {"ASTCNT", init$jpi, JPI$_ASTCNT, cvt$numeric, 1},
    {"ASTEN", init$jpi, JPI$_ASTEN, cvt$access_mode, 1},
    {"ASTLM", init$jpi, JPI$_ASTLM, cvt$numeric, 1},
    {"AUTHPRI", init$jpi, JPI$_AUTHPRI, cvt$numeric, 1},
    {"AUTHPRIV", init$jpi, JPI$_AUTHPRIV, cvt$privilege, 1},
    {"BIOCNT", init$jpi, JPI$_BIOCNT, cvt$numeric, 1},
    {"BIOLM", init$jpi, JPI$_BIOLM, cvt$numeric, 1},
    {"BJOBCNT", init$global, SYS$GW_BJOBCNT, cvt$global_word, 1},
    {"BOOTTIME", init$syi, (SYI$_BOOTTIME<<16)+8, cvt$time, 1},
    {"BUFIO", init$jpi, JPI$_BUFIO, cvt$numeric, 1},
    {"BYTCNT", init$jpi, JPI$_BYTCNT, cvt$numeric, 1},
    {"BYTLM", init$jpi, JPI$_BYTLM, cvt$numeric, 1},
    {"CLINAME", init$jpi, JPI$_CLINAME, cvt$text, 1},
    {"CLUSTER_FSYSID", init$syi, (SYI$_CLUSTER_FSYSID<<16)+6, cvt$hex_6, 1},
    {"CLUSTER_FTIME", init$syi, (SYI$_CLUSTER_FTIME<<16)+8, cvt$time, 1},
    {"CLUSTER_MEMBERS", init$dummy, 0, cvt$cluster_members, 1},
    {"CONTIG_GBLPAGES", init$syi, (SYI$_CONTIG_GBLPAGES<<16)+4, cvt$numeric, 1},
    {"CPU", init$syi, (SYI$_CPU<<16)+4, cvt$numeric, 1},
    {"CPULIM", init$jpi, JPI$_CPULIM, cvt$cputim, 1},
    {"CPUTIM", init$jpi, JPI$_CPUTIM, cvt$cputim, 1},
    {"CREPRC_FLAGS", init$jpi, JPI$_CREPRC_FLAGS, cvt$creprc_flags, 1},
    {"CURPRIV", init$jpi, JPI$_CURPRIV, cvt$privilege, 1},
    {"DEVICES", init$jpi, JPI$_PID, cvt$devices, 1},
    {"DFPFC", init$jpi, JPI$_DFPFC, cvt$numeric, 1},
    {"DFWSCNT", init$jpi, JPI$_DFWSCNT, cvt$numeric, 1},
    {"DIOCNT", init$jpi, JPI$_DIOCNT, cvt$numeric, 1},
    {"DIOLM", init$jpi, JPI$_DIOLM, cvt$numeric, 1},
    {"DIRIO", init$jpi, JPI$_DIRIO, cvt$numeric, 1},
    {"EFCS", init$jpi, JPI$_EFCS, cvt$numeric_hex, 1},
    {"EFCU", init$jpi, JPI$_EFCU, cvt$numeric_hex, 1},
    {"EFWM", init$jpi, JPI$_EFWM, cvt$numeric_hex, 1},
    {"ELAPSED", init$jpi, JPI$_LOGINTIM, cvt$elapsed_time, 1},
    {"ENQCNT", init$jpi, JPI$_ENQCNT, cvt$numeric, 1},
    {"ENQLM", init$jpi, JPI$_ENQLM, cvt$numeric, 1},
    {"FILCNT", init$jpi, JPI$_FILCNT, cvt$numeric, 1},
    {"FILLM", init$jpi, JPI$_FILLM, cvt$numeric, 1},
    {"FREE_GBLPAGES", init$syi, (SYI$_FREE_GBLPAGES<<16)+4, cvt$numeric, 1},
    {"FREE_GBLSECTS", init$syi, (SYI$_FREE_GBLSECTS<<16)+4, cvt$numeric, 1},
    {"FREP0VA", init$jpi, JPI$_FREP0VA, cvt$numeric_hex, 1},
    {"FREP1VA", init$jpi, JPI$_FREP1VA, cvt$numeric_hex, 1},
    {"FREPTECNT", init$jpi, JPI$_FREPTECNT, cvt$numeric, 1},
    {"GBLPAGES", init$syi, (SYI$_GBLPAGES<<16)+4, cvt$numeric, 1},
    {"GBLSECTIONS", init$syi, (SYI$_GBLSECTIONS<<16)+4, cvt$numeric, 1},
    {"GPGCNT", init$jpi, JPI$_GPGCNT, cvt$numeric, 1},
    {"GRP", init$jpi, JPI$_GRP, cvt$numeric_oct, 1},
    {"HW_NAME", init$syi, (SYI$_HW_NAME<<16)+31, cvt$text, 1},
    {"IDLECPU", init$jpi, JPI$_CPUTIM, cvt$idlecpu, 1},
    {"IDLETERMINAL", init$jpi, JPI$_TERMINAL, cvt$idleterminal, 1},
    {"IJOBCNT", init$global, SYS$GW_IJOBCNT, cvt$global_word, 1},
    {"IMAGE", init$jpi, JPI$_IMAGNAME, cvt$image, 1},
    {"IMAGECOUNT", init$jpi, JPI$_IMAGECOUNT, cvt$numeric, 1},
    {"IMAGNAME", init$jpi, JPI$_IMAGNAME, cvt$text, 1},
    {"IMAGPRIV", init$jpi, JPI$_IMAGPRIV, cvt$privilege, 1},
    {"IO", init$io, 0, cvt$io, 1},
    {"IPID", init$jpi, JPI$_PID, cvt$epid_to_ipid, 1},
    {"JOBPRCCNT", init$jpi, JPI$_JOBPRCCNT, cvt$numeric, 1},
    {"JOBTYPE", init$jpi, JPI$_JOBTYPE, cvt$jobtype, 1},
    {"LOGINTIM", init$jpi, JPI$_LOGINTIM, cvt$time, 1},
    {"MAILCOUNT", init$jpi, JPI$_USERNAME, cvt$mailcount, 1},
    {"MASTER_PID", init$jpi, JPI$_MASTER_PID, cvt$numeric_hex, 1},
    {"MAXDETACH", init$jpi, JPI$_MAXDETACH, cvt$numeric, 1},
    {"MAXJOBS", init$jpi, JPI$_MAXJOBS, cvt$numeric, 1},
    {"MAXPROCESSCNT", init$syi, (SYI$_MAXPROCESSCNT<<16)+4, cvt$numeric, 1},
    {"MEM", init$jpi, JPI$_MEM, cvt$numeric_oct, 1},
    {"MODE", init$jpi, JPI$_MODE, cvt$mode, 1},
    {"MSGMASK", init$jpi, JPI$_MSGMASK, cvt$msgmsk, 1},
    {"NJOBCNT", init$global, SYS$GW_NJOBCNT, cvt$global_word, 1},
    {"NODENAME", init$syi, (SYI$_NODENAME<<16)+15, cvt$nodename, 1},
    {"NODE_AREA", init$syi, (SYI$_NODE_AREA<<16)+4, cvt$numeric, 1},
    {"NODE_CSID", init$syi, (SYI$_NODE_CSID<<16)+4, cvt$numeric_hex, 1},
    {"NODE_HWTYPE", init$syi, (SYI$_NODE_HWTYPE<<16)+4, cvt$text, 1},
    {"NODE_HWVERS", init$syi, (SYI$_NODE_HWVERS<<16)+12, cvt$hex_12, 1},
    {"NODE_NUMBER", init$syi, (SYI$_NODE_NUMBER<<16)+4, cvt$numeric, 1},
    {"NODE_QUORUM", init$syi, (SYI$_NODE_QUORUM<<16)+2, cvt$numeric, 1},
    {"NODE_SWINCARN", init$syi, (SYI$_NODE_SWINCARN<<16)+8, cvt$hex_8, 1},
    {"NODE_SWTYPE", init$syi, (SYI$_NODE_SWTYPE<<16)+4, cvt$text, 1},
    {"NODE_SWVERS", init$syi, (SYI$_NODE_SWVERS<<16)+4, cvt$text, 1},
    {"NODE_SYSTEMID", init$syi, (SYI$_NODE_SYSTEMID<<16)+6, cvt$hex_6, 1},
    {"NODE_VOTES", init$syi, (SYI$_NODE_VOTES<<16)+2, cvt$numeric, 1},
    {"ORGANIZATION", init$dummy, 0, cvt$organization, 1},
    {"OWNER", init$jpi, JPI$_OWNER, cvt$numeric_hex, 1},
    {"PAGEFLTS", init$jpi, JPI$_PAGEFLTS, cvt$numeric, 1},
    {"PAGES", init$pages, 0, cvt$pages, 1},
    {"PAGFILCNT", init$jpi, JPI$_PAGFILCNT, cvt$numeric, 1},
    {"PAGFILLOC", init$jpi, JPI$_PAGFILLOC, cvt$numeric_hex, 1},
    {"PGFLQUOTA", init$jpi, JPI$_PGFLQUOTA, cvt$numeric, 1},
    {"PHDFLAGS", init$jpi, JPI$_PHDFLAGS, cvt$phdflags, 1},
    {"PHYSICAL", init$jpi, JPI$_TERMINAL, cvt$physical_terminal, 1},
    {"PHYSICALPAGES", init$syi, (SYI$_PHYSICALPAGES<<16)+4, cvt$numeric, 1},
    {"PID", init$jpi, JPI$_PID, cvt$numeric_hex, 1},
    {"PPGCNT", init$jpi, JPI$_PPGCNT, cvt$numeric, 1},
    {"PRCCNT", init$jpi, JPI$_PRCCNT, cvt$numeric, 1},
    {"PRCLM", init$jpi, JPI$_PRCLM, cvt$numeric, 1},
    {"PRCNAM", init$jpi, JPI$_PRCNAM, cvt$text, 1},
    {"PRI", init$jpi, JPI$_PRI, cvt$numeric, 1},
    {"PRIB", init$jpi, JPI$_PRIB, cvt$numeric, 1},
    {"PROCCNT", init$global, SCH$GW_PROCCNT, cvt$global_word, 1},
    {"PROCPRIV", init$jpi, JPI$_PROCPRIV, cvt$privilege, 1},
    {"PROC_INDEX", init$jpi, JPI$_PROC_INDEX, cvt$numeric, 1},
    {"QUEUE", init$jpi, JPI$_PID, cvt$queue, 1},
    {"SCSNODE", init$syi, (SYI$_SCSNODE<<16)+4, cvt$numeric, 1},
    {"SCSSYSTEMID", init$syi, (SYI$_SCSSYSTEMID<<16)+4, cvt$numeric, 1},
    {"SCSSYSTEMIDH", init$syi, (SYI$_SCSSYSTEMIDH<<16)+4, cvt$numeric, 1},
    {"SHRFILLM", init$jpi, JPI$_SHRFILLM, cvt$numeric, 1},
    {"SID", init$syi, (SYI$_SID<<16)+4, cvt$numeric_hex, 1},
    {"SITESPEC", init$jpi, JPI$_SITESPEC, cvt$numeric_hex, 1},
    {"STATE", init$state, JPI$_STATE, cvt$state, 1},
    {"STS", init$jpi, JPI$_STS, cvt$sts, 1},
    {"SWPFILLOC", init$jpi, JPI$_SWPFILLOC, cvt$numeric_hex, 1},
    {"TABLENAME", init$jpi, JPI$_TABLENAME, cvt$text, 1},
    {"TERMINAL", init$jpi, JPI$_TERMINAL, cvt$text, 1},
    {"TEST1", init$jpi, JPI$_USERNAME, cvt$text, 1},
    {"TEST2", init$jpi, JPI$_USERNAME, cvt$text, 2},
    {"TEST3", init$jpi, JPI$_USERNAME, cvt$text, 3},
    {"TEST4", init$jpi, JPI$_USERNAME, cvt$text, 4},
    {"TIME", init$dummy, 0, cvt$current_time, 1},
    {"TMBU", init$jpi, JPI$_TMBU, cvt$numeric, 1},
    {"TQCNT", init$jpi, JPI$_TQCNT, cvt$numeric, 1},
    {"TQLM", init$jpi, JPI$_TQLM, cvt$numeric, 1},
    {"TYPE", init$type, 0, cvt$type, 1},
    {"UAF_FLAGS", init$jpi, JPI$_UAF_FLAGS, cvt$uaf_flags, 1},
    {"UIC", init$jpi, JPI$_UIC, cvt$uic, 1},
    {"UPTIME", init$dummy, 0, cvt$uptime, 1},
    {"USERNAME", init$jpi, JPI$_USERNAME, cvt$text, 1},
    {"VERSION", init$syi, (SYI$_VERSION<<16)+8, cvt$text, 1},
    {"VIRTPEAK", init$jpi, JPI$_VIRTPEAK, cvt$numeric, 1},
    {"VOLUMES", init$jpi, JPI$_VOLUMES, cvt$numeric, 1},
    {"WHERE", init$where, 0, cvt$where, 1},
    {"WHO", init$jpi, JPI$_USERNAME, cvt$who, 1},
    {"WSAUTH", init$jpi, JPI$_WSAUTH, cvt$numeric, 1},
    {"WSAUTHEXT", init$jpi, JPI$_WSAUTHEXT, cvt$numeric, 1},
    {"WSEXTENT", init$jpi, JPI$_WSEXTENT, cvt$numeric, 1},
    {"WSPEAK", init$jpi, JPI$_WSPEAK, cvt$numeric, 1},
    {"WSQUOTA", init$jpi, JPI$_WSQUOTA, cvt$numeric, 1},
    {"WSSIZE", init$jpi, JPI$_WSSIZE, cvt$numeric, 1},
    {"", 0, 0, format_literal}  };

#else
globalref struct ItemNode keywords[];
globalref int max_keywords;
#endif
