<?php
/*
Fetch the settings file.  This MUST appear before ANY other tags.
*/
if (!@include_once('settings.php')) {
	die('Unable to open settings.php.  Feeling helpful?  Send an email to the webmaster.');
}
function table_missing($find_this_table) {
	$tablenames = array();
	$tablelist = mysql_query("SHOW TABLES");
	while (list($tname) = mysql_fetch_row($tablelist)) {
		array_push($tablenames, $tname);
	}
	mysql_free_result($tablelist);
	if (in_array($find_this_table, $tablenames)) {
		return false;
	}
	return true;
}
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transistional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="<?php echo $language; ?>" lang="<?php echo $language; ?>">

<head>
<base target="_top" />
<link href="stylesheets/default.css" rel="stylesheet" title="Default" type="text/css" />
<meta name="developer" content="Anthony Boyd" />
<title><?php echo $blog_name; ?>: database setup</title>
</head>

<body>

<div id="old_content">

<?php
$using_mysql = strpos($dbms, 'mysql');
if ($using_mysql === false) {
?>

<h1>Manual database setup needed.</h1>

<p>You are not using MySQL, so I cannot (yet) create the tables for you.  Use whatever database client you prefer to make this table.  Name the table: pb3_trackbacks.  It should have 8 fields:</p>

<ol>
<li>trackback_id</li>
<li>topic_id</li>
<li>updated_on</li>
<li>ip_address</li>
<li>url</li>
<li>blog_name</li>
<li>title</li>
<li>excerpt</li>
</ol>

<p>The trackback_id field should be unique/primary key, and it should autoincrement.  #1, #2, and #5 should be required fields.  #3 should be an automatic timestamp.</p>

<h2>PostgreSQL example</h2>

<p>I don't run PostgreSQL.  This is my best guess.  I have no idea how to make PostgreSQL do an automated timestamp, so I've used a plain timestamp field.  Let me know if you have hints for me.  Here is what I <em>think</em> PostgreSQL would use:</p>

<pre style="font-size: small">
CREATE SEQUENCE pb3_trackbacks_id_seq start 1 increment 1 maxvalue 2147483647 minvalue 1 cache 1;
CREATE TABLE pb3_trackbacks (
	trackback_id int4 DEFAULT nextval('pb3_trackbacks_id_seq'::text) NOT NULL,
	topic_id int4 NOT NULL,
	updated_on timestamp,
	ip_address varchar(15),
	url varchar(255) NOT NULL,
	blog_name varchar(127),
	title varchar(127) DEFAULT 'Untitled' NOT NULL,
	excerpt varchar(255),
	CONSTRAINT pb3_trackbacks_pkey PRIMARY KEY (trackback_id)
);
</pre>

<h2>MySQL example</h2>

<p>And here is what I <em>am</em> using when I create that table with MySQL.  Hopefully between the example above and the one below, you can figure out how to create the table for your database.</p>

<pre>
CREATE TABLE pb3_trackbacks (
	trackback_id int(11) NOT NULL auto_increment,
	topic_id int(11) NOT NULL,
	updated_on timestamp(14) NOT NULL,
	ip_address varchar(15),
	url varchar(255) NOT NULL,
	blog_name varchar(127),
	title varchar(127) NOT NULL default 'Untitled',
	excerpt varchar(255),
	PRIMARY KEY (trackback_id)
);
</pre>

<p>Once you have created the table, remove this file (createtable.php) from your server.</p>

<?php
}
else {
	if (table_missing("pb3_trackbacks")) {
		$query = "CREATE TABLE pb3_trackbacks (";
		$query .= "	trackback_id int(11) NOT NULL auto_increment,";
		$query .= "	topic_id int(11) NOT NULL,";
		$query .= "	updated_on timestamp(14) NOT NULL,";
		$query .= "	ip_address varchar(15),";
		$query .= "	url varchar(255) NOT NULL,";
		$query .= "	blog_name varchar(127),";
		$query .= "	title varchar(127) NOT NULL default 'Untitled',";
		$query .= "	excerpt varchar(255),";
		$query .= "	PRIMARY KEY (trackback_id))";
		if( !($result = $db->sql_query($query)) ) {
?>
<h1>Manual database setup needed.</h1>

<p>I tried to create the MySQL table, but it didn't work.  You will need to use a database client to create this table for your database.  Here is the SQL:</p>

<pre>
CREATE TABLE pb3_trackbacks (
	trackback_id int(11) NOT NULL auto_increment,
	topic_id int(11) NOT NULL,
	updated_on timestamp(14) NOT NULL,
	ip_address varchar(15),
	url varchar(255) NOT NULL,
	blog_name varchar(127),
	title varchar(127) NOT NULL default 'Untitled',
	excerpt varchar(255),
	PRIMARY KEY (trackback_id)
);
</pre>

<?php
		}
		if (table_missing("pb3_trackbacks")) {
?>
<h1>Manual database setup needed.</h1>

<p>I tried to create the MySQL table, but it didn't work.  You will need to use a database client to create this table for your database.  Here is the SQL:</p>

<pre>
CREATE TABLE pb3_trackbacks (
	trackback_id int(11) NOT NULL auto_increment,
	topic_id int(11) NOT NULL,
	updated_on timestamp(14) NOT NULL,
	ip_address varchar(15),
	url varchar(255) NOT NULL,
	blog_name varchar(127),
	title varchar(127) NOT NULL default 'Untitled',
	excerpt varchar(255),
	PRIMARY KEY (trackback_id)
);
</pre>

<?php
		}
		else {
?>
<h1>Success!</h1>

<p>The table was created automatically.  You should now remove this file (createtable.php) from your server.</p>

<?php
		}
	}
	else {
?>
<h1>Table already exists!</h1>

<p>The table has already been created.  You should now remove this file (createtable.php) from your server.</p>

<?php
	}
}
?>

</div>

</body>
</html>
