  A ZOO(1)                  REFERENCE MANUAL                   ZOO(1)    NAME:      zoo - manipulate archives of files in compressed form   SYNOPSIS<      zoo {acfDeghHlLPTuUvVx}[aAcCdEfghImMnNoOpPqSu1:/.@n+-=]      archive [file] ... $      zoo -command archive [file] ...
      zoo h   DESCRIPTION ?      Zoo is used to create and maintain collections of files in A      compressed form.  It uses a Lempel-Ziv compression algorithm @      that gives space savings in the range of 20% to 80% depend-A      ing on the type of file data.  Zoo can store and selectively @      extract multiple generations of the same file.  Data can beA      recovered from damaged archives by skipping the damaged por- >      tion and locating undamaged data with the help of fiz(1).  @      This documentation is for version 2.1.  Changes from previ-@      ous versions are described in the section labelled CHANGES.  =      The command zoo h gives a summary of commands.  Extended 1      multiscreen help can be obtained with zoo H.   A      Zoo will not add an archive to itself, nor add the archive's A      backup (with .bak extension to the filename) to the archive.   @      Zoo has two types of commands:  Expert commands, which con-A      sist of one command letter followed by zero or more modifier ?      characters, and Novice commands, which consist of a hyphen >      (`-') followed by a command word that may be abbreviated.?      Expert commands are case-sensitive but Novice commands are 	      not.   =      When zoo adds a file to an existing archive, the default <      action is to maintain one generation of each file in an<      archive and to mark any older generation as deleted.  A@      limit on the number of generations to save can be specified@      by the user for an entire archive, or for each file indivi-A      dually, or both.  Zoo deletes a stored copy of an added file =      if necessary to prevent the number of stored generations -      from exceeding the user-specified limit.   ;      Deleted files may be later undeleted.  Archives may be 7      packed to recover space occupied by deleted files.   <      All commands assume that the archive name ends with the>      characters .zoo unless a different extension is supplied.        Novice commands  ?      Novice commands may be abbreviated to a hyphen followed by ?      at least one command character.  Each Novice command works >      in two stages. First, the command does its intended work.@      Then, if the result was that one or more files were deletedA      in the specified archive, the archive is packed.  If packing @      occurs, the original unpacked archive is always left behind      with an extension of .bak.   <      No Novice command ever stores the directory prefix of a
      file.  (      The Novice commands are as follows.  5      -add    Adds the specified files to the archive.   
      -freshen @           Adds a specified file to the archive if and only if an;           older file by the same name already exists in the            archive.        -delete7           Deletes the specified files from the archive.         -update=           Adds a specified file to the archive either:  if an ;           older file by the same name already exists in the :           archive or:  if a file by the same name does not'           already exist in the archive.   
      -extract ?           Extracts the specified files from the archive.  If no 4           file is specified all files are extracted.  
      -moveA           Equivalent to -add except that source files are deleted            after addition.         -print ?           Equivalent to -extract except that extracted data are "           sent to standard output.  
      -list>           Gives information about the specified archived files;           including any attached comments.  If no files are @           specified all files are listed.  Deleted files are not           listed.   
      -test?           Equivalent to -extract except that the extracted data @           are not saved but any errors encountered are reported.  
      -comment ?           Allows the user to add or update comments attached to ?           archived files.  When prompted, the user may:  type a ?           carriage return to skip the file, leaving any current ?           comment unchanged;  or type a (possibly null) comment >           of up to 32,767 characters terminated by /end (case-?           insensitive) on a separate line;  or type the end-of- A           file character (normally control D) to skip all remain-            ing files.        -delete&           Deletes the specified files.  I      The correspondence between Novice and Expert commands is as follows.   =      Novice                                        Equivalent A      Command    Description                        Expert Command A      ____________________________________________________________ 6      -add       add files to archive               aP:4      -extract   extract files from archive         x7      -move      move files to archive              aMP: 6      -test      test archive integrity             xNd5      -print     extract files to standard output   xp 5      -delete    delete files from archive          DP 5      -list      list archive contents              VC 8      -update    add new or newer files             aunP:7      -freshen   by add newer files                 auP: 4      -comment   add comments to files              c        Expert commands  .      The general format of expert commands is:  <      zoo {acfDeghHlLPTuUvVx}[aAcCdEfghImMnNoOpPqSu1:/.@n+-=]      archive [file] ...   @      The characters enclosed within {} are commands.  Choose anyA      one of these.  The characters enclosed within [] just to the @      right of the {} are modifiers and zero or more of these may@      immediately follow the command character.  All combinations9      of command and modifier characters may not be valid.   4      Files are added to an archive with the command:  .      zoo {au}[cfhIMnPqu:+-] archive [file] ...        Command characters are:  ;      a    Add each specified file to archive.  Any already- @           archived copy of the file is deleted if this is neces-A           sary to avoid exceeding the user-specified limit on the >           number of generations of the file to maintain in the           archive.  A      u    Do an update of the archive.  A specified file is added ?           to the archive only if a copy of it is already in the A           archive and the copy being added is newer than the copy !           already in the archive.   <      The following modifiers are specific to these commands.  @      M    Move files to archive.  This makes zoo delete (unlink)>           the original files after they have been added to theA           archive.  Files are deleted after addition of all files <           to the archive is complete and after any requested?           packing of the archive has been done, and only if zoo            detected no errors.   @      n    Add new files only.  A specified file is added only if*           it isn't already in the archive.  >      h    Use the high performance compression algorithm. This>           option may be used with either the add (a) or filter?           (f) commands to gain extra compression at the expense A           of using somewhat more processor time. Extracting files ?           compressed with the method is usually slightly faster 3           than those saved with the default method.   3      P    Pack archive after files have been added.   A      u    Applied to the a command, this modifier makes it behave '           identically to the u command.   ?           The combination of the n modifier with the u modifier ?           or u command causes addition of a file to the archive A           either if the file is not already in the archive, or if =           the file is already in the archive but the archived 2           copy is older than the copy being added.  ?      :    Do not store directory names.  In the absence of this @           modifier zoo stores the full pathname of each archived           file.   @      I    Read filenames to be archived from standard input. Zoo@           will read its standard input and assume that each line>           of text contains a filename.  Under AmigaDOS and theA           **IX family, the entire line is used.  Under MS-DOS and A           VAX/VMS, zoo assumes that the filename is terminated by >           a blank, tab, or newline; thus it is permissible for9           the line of text to contain more than one field A           separated by white space, and only the first field will            be used.  @           Under the **IX family of operating systems, zoo can be(           used as follows in a pipeline:  -                find . -print | zoo aI sources   =           If the I modifier is specified, no filenames may be .           supplied on the command line itself.  ;      +,-  These modifiers take effect only if the a command A           results in the creation of a new archive.  + causes any ?           newly-created archive to have generations enabled.  - ?           is provided for symmetry and causes any newly-created A           archive to have generations disabled;  this is also the 2           default if neither + nor - is specified.  :      Files are extracted from an archive with the command:  ,      zoo {ex}[dNoOpqS./@] archive [file] ...  @      The e and x commands are synonymous.  If no file was speci-4      fied, all files are extracted from the archive.  =      The following modifiers are specific to the e and x com-       mands:   :      N    Do not save extracted data but report any errors           encountered.  ?      O    Overwrite files.  Normally, if a file being extracted >           would overwrite an already-existing file of the same@           name, zoo asks you if you really want to overwrite it.@           You may answer the question with `y', which means yes,@           overwrite; or `n', which means no, don't overwrite; or@           `a', which means assume the answer is `y' for this and@           all subsequent files.  The O modifier makes zoo assume@           that files may always be overwritten.  Neither answer-?           ing the question affirmatively nor using O alone will 2           cause read-only files to be overwritten.  @           On **IX systems, however, doubling this modifier as OO?           will force zoo to unconditionally overwrite any read- ?           protected files with extracted files if it can do so.   ;           The O, N, and p modifiers are mutually exclusive.   <      S    Supersede newer files on disk with older extracted<           files.  Unless this modifier is used, zoo will notA           overwrite a newer existing file with an older extracted            file.   @      o    This is equivalent to the O modifier if and only if it<           is given at least twice.  It is otherwise ignored.  A      p    Pipe extracted data to standard output.  Error messages >           are piped to standard output as well.  However, if a?           bad CRC is detected, an error message is sent both to 0           standard error and to standard output.  ?      /    Extract to original pathname.  Any needed directories >           must already exist.  In the absence of this modifierA           all files are extracted into the current directory.  If >           this modifier is doubled as //, required directories6           need not exist and are created if necessary.  @      The management of multiple generations of archived files is      done with the commands:  +      zoo gl[Aq]{+-=}number archive files .. *      zoo gc[q]{+-=}number archive files ..      zoo gA[q]- archive       zoo gA[q]+ archive   A      The first form, gl, adjusts the generation limit of selected A      files by the specified value.  If the form =n is used, where A      n is a decimal number, this sets the generation limit to the <      specified value.  If + or - are used in placed of = the@      effect is to increment or decrement the generation limit by3      the specified value.  For example, the command              zoo gl=5 xyz :    :      sets the generation limit of each file in the archive*      xyz.zoo to a value of 5.  The command             zoo gl-3 xyz :    @      decrements the generation limit of each file in the archive$      to 3 less than it currently is.  A      If the A modifier is used, the archive-wide generation limit       is adjusted instead.   A      The number of generations of a file maintained in an archive A      is limited by the file generation limit, or the archive gen- =      eration limit, whichever is lower.  As a special case, a A      generation limit of 0 stands for no limit.  Thus the default A      file generation limit of 0 and archive generation limit of 3 >      limits the number of generations of each file in a newly-      created archive to three.  <      The generation limit specified should be in the range 0?      through 15;  any higher numbers are interpreted modulo 16.   ?      The second form of the command, using gc, adjusts the gen- A      eration count of selected files.  Each file has a generation @      count of 1 when it is first added to an archive.  Each time=      a file by the same name is added again to an archive, it <      receives a generation count that is one higher than the?      highest generation count of the archived copy of the file. <      The permissible range of generation counts is 1 through>      65535.  If repeated manipulations of an archive result in>      files having very high generation counts, they may be set>      back to lower numbers with the gc command.  The syntax of>      the command is analogous to the syntax of the gl command,@      except that the A modifier is not applicable to the gc com-
      mand.  =      The third form, gA-, disables generations in an archive. >      Generations are off when an archive is first created, but=      may be enabled with the fourth form of the command, gA+. >      When generations are disabled in an archive, zoo will not?      display generation numbers in archive listings or maintain @      multiple generations.  Generations can be re-enabled at anyA      time, though manipulation of an archive with repeated inter- @      spersed gA- and gA+ commands may result in an archive whose+      behavior is not easily understandable.   0      Archived files are listed with the command:  :      zoo {lLvV}[aAcCdfgmqvV@/1+-] archive[.zoo] [file] ...  =      l    Information presented includes the date and time of A           each file, its original and current (compressed) sizes, =           and the percentage size decrease due to compression =           (labelled CF or compression factor).  If a file was ;           added to the archive in a different timezone, the =           difference between timezones is shown in hours as a =           signed number.  As an example, if the difference is A           listed as +3, this means that the file was added to the ;           archive in a timezone that is 3 hours west of the >           current timezone.  The file time listed is, however,@           always the original timestamp of the archived file, as?           observed by the user who archived the file, expressed >           as that user's local time.  (Timezone information is?           stored and displayed only if the underlying operating (           system knows about timezones.)  @           If no filename is supplied all files are listed except           deleted files.  ;           Zoo selects which generation(s) of a file to list /           according to the following algorithm.   @           If no filename is supplied, only the latest generation7           of each file is listed.  If any filenames are ?           specified, and a generation is specified for an argu- >           ment, only the requested generation is listed.  If a@           filename is specified ending with the generation char->           acter (`:' or `;'), all generations of that file are=           listed.  Thus a filename argument of the form zoo.c >           will cause only the latest generation of zoo.c to be=           listed;  an argument of the form zoo.c:4 will causeCA           generation 4 of zoo.c to be listed;  and an argument ofr?           the form zoo.c: or zoo.c:* will cause all generationsH            of zoo.c to be listed.  ?      L    This is similar to the l command except that all sup-]>           plied arguments must be archives and all non-deleted@           generations of all files in each archive appear in the           listing.  @           On **IX systems, on which the shell expands arguments,>           if multiple archives are to be listed, the L command=           must be used.  On other systems (VAX/VMS, AmigaDOS,m?           MSDOS) on which wildcard expansion is done internallyp@           by zoo, wildcards may be used in the archive name, and?           a multiple archive listing obtained, using the l com-1           mand.r  ?      v    This causes any comment attached to the archive to beE6           listed in addition to the other information.  =      V    This causes any comment attached to the archive and >           also any comment attached to each file to be listed.  A           Both the V and v command characters can also be used ase,           modifiers to the l and L commands.  >      In addition to the general modifiers described later, the@      following modifiers can be applied to the archive list com-      mands.   >      a    This gives a single-line format containing both eachA           filename and the name of the archive, sorted by archivea<           name.  It is especially useful with the L command,@           since the result can be further sorted on any field to?           give a master listing of the entire contents of a seto           of archives.  ?      A    This causes any comment attached to the archive to be            listed.i  @      g    This modifier causes file generation information to be>           listed about the archive.  For each file listed, the=           user-specified generation limit, if any, is listed.s@           For example, `3g' for a file means that the user wants@           no more than three generations of the file to be kept.A           In archives created by older versions of zoo, the list-iA           ing will show `-g', meaning that no generation informa-e?           tion is kept and multiple generations of the file area           not being maintained.   <           In addition to the generation information for each=           file, the archive-wide generation limit, if any, is ?           shown at the end of the listing.  If generations have >           been disabled by the user, this is so indicated, for           example:  ?                Archive generation limit is 3 (generations off).i  A           For more information about generations see the descrip-i            tion of the g command.  ?      m    This modifier is currently applicable to **IX systemse?           only.  It causes the mode bits (file protection code)f:           of each file to be listed as a three-digit octal?           number.  Currently zoo preserves only the lowest nine A           mode bits.  Their meanings are as described in the **IX 1           documentation for the chmod(1) command.t  @      C    This modifier causes the stored cyclic redundancy code=           (CRC) for each archived file to be shown as a four-a#           digit hexadecimal number.x  @      1    This forces one filename to be listed per line.  It is9           most useful in combination with the f modifier.c  =      /    This forces any directory name to be always listed,t?           even in fast columnized listings that do not normallyd&           include any directory names.  A      +,-  The - modifier causes trailing generation numbers to be <           omitted from filenames.  The + modifier causes the@           trailing generation numbers to be shown, which is also6           the default if neither - nor + is specified.  @      Files may be deleted and undeleted from an archive with the      following commands:  #      zoo {DU}[Pq1] archive file ...d  @      The D command deletes the specified files and the U command>      undeletes the specified files.  The 1 modifier (the digitA      one, not the letter ell) forces deletion or undeletion of athA      most one file.  If multiple instances of the same file existe=      in an archive, use of the 1 modifier may allow selectives       extraction of one of these.  :      Comments may be added to an archive with the command:        zoo c[A] archivee  <      Without the modifier A, this behaves identically to the?      -comment command.  With the modifier A, the command servese>      to add or update the comment attached to the archive as aA      whole.  This comment may be listed with the lA, LA, v, and VN>      commands.  Applying the cA command to an archive that wasA      created with an older version of zoo will result in an error_A      message requesting that the user first pack the archive with-=      the P command.  This reorganizes the archive and creates #      space for the archive comment.x  >      The timestamp of an archive may be adjusted with the com-
      mand:        zoo T[q] archive   :      Zoo normally attempts to maintain the timestamp of an@      archive to reflect the age of the newest file stored in it.@      Should the timestamp ever be incorrect it can be fixed with      the T command.l  /      An archive may be packed with the command:f        zoo P[EPq] archive   ?      If the backup copy of the archive already exists, zoo will =      refuse to pack the archive unless the P modifier is also @      given.  The E modifier causes zoo not to save a backup copy?      of the original archive after packing.  A unique temporaryc@      file in the current directory is used to initially hold theA      packed archive.  This file will be left behind if packing is :      interrupted or if for some reason this file cannot be@      renamed to the name of the original archive when packing is      complete.  <      Packing removes any garbage data appended to an archiveA      because of Xmodem file transfer and also recovers any wasteda;      space remaining in an archive that has been frequentlyA>      updated or in which comments were replaced.  Packing also=      updates the format of any archive that was created by ani?      older version of zoo so that newer features (e.g. archive-o@      wide generation limit, archive comment) become fully avail-
      able.  ?      Zoo can act as a pure compression or uncompression filter,p@      reading from standard input and writing to standard output.'      This is achieved with the command:l        zoo f{cu}[h  >      where c specifies compression, u specifies uncompression,9      and h used in addition requests the high-performance ;      compression be used.  A CRC value is used to check thed>      integrity of the data.  The compressed data stream has no@      internal archive structure and contains multiple files onlyA      if the input data stream was already structured, as might bey-      obtained, for example, from tar or cpio.   <       Modem transfers can be speeded up with these commands:  8                zoo fc < file | sz ... rz | zoo fu > file          General modifiers  @      The following modifiers are applicable to several commands:  ?      c    Applied to the a and u commands, this causes the user A           to be prompted for a comment for each file added to theaA           archive.  If the file being added has replaced, or is atA           newer generation of, a file already in the archive, any @           comment attached to that file is shown to the user and=           becomes attached to the newly-added file unless the :           user changes it.  Possible user responses are as=           described for the -comment command.  Applied to theaA           archive list command l, the c modifier causes the list-h9           ing of any comments attached to archived files.   >       .   In conjunction with / or // this modifier causes anyA           extracted pathname beginning with `/' to be interpretedo=           relative to the current directory, resulting in thee>           possible creation of a subtree rooted at the current=           directory.  In conjunction with the command P the . A           modifier causes the packed archive to be created in the =           current directory.  This is intended to allow users =           with limited disk space but multiple disk drives to            pack large archives.  @      d    Most commands that act on an archive act only on files>           that are not deleted.  The d modifier makes commands>           act on both normal and deleted files.  If doubled as<           dd, this modifier forces selection only of deleted           files.  @      f    Applied to the a and u commands, the f modifier causes=           fast archiving by adding files without compression. =           Applied to l it causes a fast listing of files in a            multicolumn format.n  A      q    Be quiet.  Normally zoo lists the name of each file and 7           what action it is performing.  The q modifieri=           suppresses this.  When files are being extracted toe?           standard output, the q modifier suppresses the headere?           preceding each file.  When archive contents are beingl9           listed, this modifier suppresses any header and-;           trailer.  When a fast columnized listing is beingt>           obtained, this modifier causes all output to be com-?           bined into a single set of filenames for all archives-           being listed.e  >           When doubled as qq, this modifier suppresses WARNING?           messages, and when tripled as qqq, ERROR messages arev9           suppressed too.  FATAL error messages are nevere           suppressed.t  *      Recovering data from damaged archives  A      The @ modifier allows the user to specify the exact position A      in an archive where zoo should extract a file from, allowing A      damaged portions of an archive to be skipped.  This modifier >      must be immediately followed by a decimal integer without<      intervening spaces, and possibly by a comma and another?      decimal integer, giving a command of the form l@m or l@m,n A      (to list archive contents) or x@m or x@m,n (to extract files A      from an archive).  Listing or extraction begin at position m @      in the archive.  The value of m must be the position within@      the archive of an undamaged directory entry.  This position:      is usually obtained from fiz(1) version 2.0 or later.  A      If damage to the archive has shortened or lengthened it, all A      positions within the archive may be changed by some constantd;      amount.  To compensate for this, the value of n may be A      specified.  This value is also usually obtained from fiz(1).e>      It should be the position in the archive of the file dataA      corresponding to the directory entry that has been specified =      with m.  Thus if the command x@456,575 is given, it will ?      cause the first 456 bytes of the archive to be skipped and >      extraction to begin at offset 456;  in addition, zoo will>      attempt to extract the file data from position 575 in the@      archive instead of the value that is found in the directory?      entry read from the archive.  For example, here is some ofu=      the output of fiz when it acts on a damaged zoo archive:l        ****************o&          2526: DIR  [changes] ==>   95          2587: DATAl      ****************c'          3909: DIR  [copyrite] ==> 1478c          3970: DATA           4769: DATA       ****************   >      In such output, DIR indicates where fiz found a directory=      entry in the archive, and DATA indicates where fiz foundh<      file data in the archive.  Filenames located by fiz are=      enclosed in square brackets, and the notation "==>   95"s@      indicates that the directory entry found by fiz at position;      2526 has a file data pointer to position 95.  (This isi>      clearly wrong, since file data always occur in an archive@      after their directory entry.)  In actuality, fiz found file=      data at positions 2587, 3970, and 4769.  Since fiz foundm9      only two directory entries, and each directory entryi?      corresponds to one file, one of the file data positions is5      an artifact.   9      In this case, commands to try giving to zoo might bem=      x@2526,2587 (extract beginning at position 2526, and getyA      file data from position 2587), x@3090,3970 (extract at 3090, >      get data from 3970) and x@3909,4769 (extract at 3909, get9      data from 4769).  Once a correctly-matched directoryy?      entry/file data pair is found, zoo will in most cases syn-m?      chronize with and correctly extract all files subsequentlyi<      found in the archive.  Trial and error should allow all;      undamaged files to be extracted.  Also note that self-l?      extracting archives created using sez (the Self-Extractinge?      Zoo utility for MS-DOS), which are normally executed on anu@      MS-DOS system for extraction, can be extracted on non-MSDOS>      systems using zoo's damaged-archive recovery method using      the @ modifier.        Wildcard handling  ?      Under the **IX family of operating systems, the shell nor-i@      mally expands wildcards to a list of matching files.  Wild-?      cards that are meant to match files within an archive musti@      therefore be escaped or quoted.  When selecting files to beA      added to an archive, wildcard conventions are as defined for =      the shell.  When selecting files from within an archive,l9      wildcard handling is done by zoo as described below.   ;      Under MS-DOS and AmigaDOS, quoting of wildcards is notwA      needed.  All wildcard expansion of filenames is done by zoo,o@      and wildcards inside directory names are expanded only when:      listing or extracting files but not when adding them.  =      The wildcard syntax interpreted by zoo is limited to thes      following characters.  :      *    Matches any sequence of zero or more characters.  '      ?    Matches any single character.   8           Arbitrary combinations of * and ? are allowed.  @      /    If a supplied pattern contains a slash anywhere in it,A           then the slash separating any directory prefix from thei=           filename must be matched explicitly.  If a supplieda=           pattern contains no slashes, the match is selectives           only on the filename.   @      c-c  Two characters separated by a hyphen specify a charac-@           ter range.  All filenames beginning with those charac-=           ters will match.  The character range is meaningfuli@           only by itself or preceded by a directory name.  It is@           not specially interpreted if it is part of a filename.        : and ;A           These characters are used to separate a filename from ar@           generation number and are used when selecting specific@           generations of archived files.  If no generation char-@           acter is used, the filename specified matches only theA           latest generation of the file.  If the generation char-eA           acter is specified, the filename and the generation areo@           matched independently by zoo's wildcard mechanism.  IfA           no generation is specified following the : or ; charac-s=           ter, all generations of that file will match.  As aoA           special case, a generation number of 0 matches only then@           latest generation of a file, while ^0 matches all gen-:           erations of a file except the latest one.  If no@           filename is specified preceding the generation charac-=           ter, all filenames will match.  As a corollary, the @           generation character by itself matches all generations           of all files.   @      MS-DOS users should note that zoo does not treat the dot as@      a special character, and it does not ignore characters fol-;      lowing an asterisk.  Thus * matches all filenames; *.*n>      matches filenames containing a dot; *_* matches filenamesA      containing an underscore;  and *z matches all filenames thataA      end with the character z, whether or not they contain a dot.n        Usage hints  @      The Novice command set in zoo is meant to provide an inter-@      face with functionality and format that will be familiar to?      users of other similar archive utilities.  In keeping withH?      this objective, the Novice commands do not maintain or useoA      any subdirectory information or allow the use of zoo's abil-t=      ity to maintain multiple generations of files.  For thisf@      reason, users should switch to exclusively using the Expert"      commands as soon as possible.  A      Although the Expert command set is quite large, it should be,?      noted that in almost every case, all legal modifiers for aS@      command are fully orthogonal.  This means that the user can;      select any combination of modifiers, and when they acta=      together, they will have the intuitively obvious effect.,>      Thus the user need only memorize what each modifier does,=      and then can combine them as needed without much furtherd
      thought.t  =      For example, consider the a command which is used to add ?      files to an archive.  By itself, it simply adds the speci-e<      fied files.  To cause only already-archived files to be@      updated if their disk copies have been modified, it is only@      necessary to add the u modifier, making the command au.  To9      cause only new files (i.e., files not already in thel?      archive) to be added, the n modifier is used to create thea<      command an.  To cause both already-archived files to beA      updated and new files to be added, the u and n modifiers canf?      be used together, giving the command aun.  Since the order ?      of modifiers is not significant, the command could also bet	      anu.s  ?      Further, the c modifier can be used to cause zoo to promptm>      the user for a comment to attach to each file added.  And=      the f modifier can cause fast addition (addition without >      compression).  It should be obvious then that the command?      auncf will cause zoo to update already-archived files, add A      new files, prompt the user for comments, and do the addition @      of files without any compression.  Furthermore, if the user?      wishes to move files to the archive, i.e., delete the disk >      copy of each file after it is added to the archive, it is?      only necessary to add the M modifier to the command, so it >      becomes auncfM.  And if the user also wishes to cause theA      archive to be packed as part of the command, thus recoveringn?      space from any files that are replaced, the command can bet=      modified to auncfMP by adding the P modifier that causes,
      packing.i  ?      Similarly, the archive listing commands can be built up by A      combining modifiers.  The basic command to list the contentso=      of an archive is l.  If the user wants a fast columnizednA      listing, the f modifier can be added to give the lf command.m=      Since this listing will have a header giving the archiveoA      name and a trailer summarizing interesting information about ?      the archive, such as the number of deleted files, the user A      may wish to "quieten" the listing by suppressing these;  the <      relevant modifier is q, which when added to the command>      gives lfq.  If the user wishes to see the **IX mode (file?      protection) bits, and also information about multiple gen- @      erations, the modifiers m (show mode bits) and g (show gen-A      eration information) can be added, giving the command lfqmg.w@      If the user also wishes to see an attached archive comment,?      the modifier A (for archive) will serve.  Thus the commandt?      lfqmgA will give a fast columnized listing of the archive, >      suppressing any header and trailer, showing mode bits and@      generation information, and showing any comment attached to@      the archive as a whole.  If in addition individual comments;      attached to files are also needed, simply append the cF@      modifier to the command, making it lfqmgAc.  The above com-A      mand will not show any deleted files, however;  to see them,T?      use the d modifier, making the command lfqmgAcd (or doubleu;      it as in lfqmgAcdd if only the deleted files are to be ?      listed).  And if the user also wishes to see the CRC value @      for each file being listed, the modifier C will do this, as<      in the command lfqmgAcdC, which gives a fast columnized?      listing of all files, including deleted files, showing anytA      archive comment and file comments, and file protection codestA      and generation information, as well as the CRC value of each 
      file.  A      Note that the above command lfqmgAcdC could also be abbrevi-m?      ated to VfqmgdC because the command V is shorthand for lcAe>      (archive listing with all comments shown).  Similarly the@      command v is shorthand for lA (archive listing with archive>      comment shown).  Both V and v can be used as modifiers to/      any of the other archive listing commands.e        Generations  A      By default, zoo assumes that only the latest generation of at=      specified file is needed.  If generations other than the A      latest one need to be selected, this may be done by specify-e=      ing them in the filename.  For example, the name stdio.hh>      would normally refer to the latest generation of the file@      stdio.h stored in a zoo archive.  To get an archive listing;      showing all generations of stdio.h in the archive, theP>      specification stdio.h:* could be used (enclosed in singleA      quotes if necessary to protect the wildcard character * fromdA      the shell).  Also, stdio.h:0 selects only the latest genera-a>      tion of stdio.h, while stdio.h:^0 selects all generations?      except the latest one.  The : character here separates thet@      filename from the generation number, and the character * is@      a wildcard that matches all possible generations.  For con-A      venience, the generation itself may be left out, so that theaA      name stdio.h: (with the : but without a generation number orp=      a wildcard) matches all generations exactly as stdio.h:*a
      does.  @      If a generation is specified but no filename is present, asA      in :5, :*, or just :, all filenames of the specified genera-lA      tion will be selected.  Thus :5 selects generation 5 of each <      file, and :* and : select all generations of all files.  ?      It is important to note that zoo's idea of the latest gen--=      eration of a file is not based upon searching the entirep?      archive.  Instead, whenever zoo adds a file to an archive, ?      it is marked as being the latest generation.  Thus, if the ?      latest generation of a file is deleted, then no generationnA      of that file is considered the latest any more.  This can bea@      surprising to the user.  For example, if an archive alreadyA      contains the file stdio.h:5 and a new copy is added, appear- @      ing in the archive listing as stdio.h:6, and then stdio.h:6?      is deleted, the remaining copy stdio.h:5 will no longer be 9      considered to be the latest generation, and the filee>      stdio.h:5, even if undeleted, will no longer appear in anA      archive listing unless generation 5 (or every generation) isd:      specifically requested.  This behavior will likely be(      improved in future releases of zoo.   FILESc1      xXXXXXX - temporary file used during packingm)      archive_name.bak - backup of archiveh   SEE ALSO      compress(1), fiz(1)   BUGS=      When files are being added to an archive on a non-MS-DOS A      system, it is possible for zoo to fail to detect a full disklA      and hence create an invalid archive.  This bug will be fixed-      in a future release.   @      Files with generation counts that wrap around from 65535 to@      1 are not currently handled correctly.  If a file's genera-<      tion count reaches a value close to 65535, it should be@      manually set back down to a low number.  This may be easily@      done with a command such as gc-65000, which subtracts 65000<      from the generation count of each specified file.  This/      problem will be fixed in a future release.   @      Although zoo on **IX systems preserves the lowest nine modeA      bits of regular files, it does not currently do the same for       directories.u  :      Currently zoo's handling of the characters : and ; in<      filenames is not robust, because it interprets these to=      separate a filename from a generation number.  A quotingk.      mechanism will eventually be implemented.  @      Standard input cannot be archived nor can a created archive=      be sent to standard output.  Spurious error messages maya6      appear if the filename of an archive is too long.  @      Since zoo never archives any file with the same name as the=      archive or its backup (regardless of any path prefixes), A      care should be taken to make sure that a file to be archived A      does not coincidentally have the same name as the archive ittA      is being added to.  It usually suffices to make sure that noeA      file being archived is itself a zoo archive.  (Previous ver-m>      sions of zoo sometimes tried to add an archive to itself.%      This bug now seems to be fixed.)e  >      Only regular files are archived; devices and empty direc-A      tories are not.  Support for archiving empty directories and @      for preserving directory attributes is planned for the near      future.  ?      Early versions of MS-DOS have a bug that prevents "." from >      referring to the root directory;  this leads to anomalous?      results if the extraction of paths beginning with a dot is       attempted.p  ;      VAX/VMS destroys case information unless arguments areR=      enclosed in double quotes.  For this reason if a commande<      given to zoo on a VAX/VMS system includes any uppercase=      characters, it must be enclosed in double quotes.  Unders=      VAX/VMS, zoo does not currently restore file timestamps; <      this will be fixed as soon as I figure out RMS extendedA      attribute blocks, or DEC supplies a utime() function, which-o?      ever occurs first.  Other VMS bugs, related to file struc-s=      tures, can often be overcome by using the program bilf.cm      that is supplied with zoo.   >      It is not currently possible to create a zoo archive con-=      taining all zoo archives that do not contain themselves.    DIAGNOSTICS ?      Error messages are intended to be self-explanatory and arec=      divided into three categories.  WARNINGS are intended tosA      inform the user of an unusual situation, such as a CRC errortA      during extraction, or -freshening of an archive containing aw?      file newer than one specified on the command line.  ERRORS A      are fatal to one file, but execution continues with the nexti>      file if any.  FATAL errors cause execution to be aborted.?      The occurrence of any of these causes an exit status of 1.g?      Normal termination without any errors gives an exit statush>      of 0.  (Under VAX/VMS, however, to avoid an annoying mes-5      sage, zoo always exits with an error code of 1.)e  
 COMPATIBILITYn>      All versions of zoo on all systems are required to create@      archives that can be extracted and listed with all versions@      of zoo on all systems, regardless of filename and directory>      syntax or archive structure;  furthermore, any version ofA      zoo must be able to fully manipulate all archives created by ?      all lower-numbered versions of zoo on all systems.  So far*A      as I can tell, this upward compatibility (all manipulations) ?      and downward compatiblity (ability to extract and list) is A      maintained by zoo versions up to 2.01.  Version 2.1 adds thet<      incompatibility that if high-performance compression is@      used, earlier versions cannot extract files compressed with;      version 2.1.  This is the only incompatibility that isdA      permissible.  You are forbidden, with the force of copyright @      law, to create from the zoo source code any derivative work@      that violates this compatibility goal, whether knowingly or@      through negligence.  If any violation of this compatibility@      goal is observed, this should be considered a serious prob-      lem and reported to me.   CHANGES =      Here is a list of changes occurring from version 1.50 to5@      version 2.01.  In parentheses is given the version in which      each change occurred.  :      -    (1.71) New modifiers to the list commands permitA           optional suppression of header and trailer information,t>           inclusion of directory names in columnized listings,'           and fast one-column listings.i  '      -    (1.71) Timezones are handled.d  ?      -    (1.71) A bug was fixed that had made it impossible tot@           individually update comments for a file whose name did*           not correspond to MS-DOS format.  >      -    (1.71) A change was made that now permits use of the(           shared library on the **IX PC.  :      -    (1.71) VAX/VMS is now supported reasonably well.  =      -    (2.00) A comment may now be attached to the archiveM           itself.u  ;      -    (2.00) The OO option allows forced overwriting ofd           read-only files.  =      -    (2.00) Zoo will no longer extract a file if a newerl?           copy already exists on disk;  the S option will over-            ride this.  @      -    (2.00) File attributes are preserved for **IX systems.  ?      -    (2.00) Multiple generations of the same file are sup-a           ported.n  @      -    (2.00) Zoo will now act as a compression or decompres-<           sion filter on a stream of data and will use a CRC?           value to check the integrity of a data stream that is            uncompressed.   @      -    (2.00) A bug was fixed that caused removal of a direc-<           tory link if files were moved to an archive by the%           superuser on a **IX system.t  9      -    (2.00) The data recovery modifier @ was greatly @           enhanced.  Self-extracting archives created for MS-DOS@           systems can now be extracted by zoo on any system with           help from fiz(1).   ?      -    (2.01) A bug was fixed that had caused the first gen- @           eration of a file to sometimes unexpectedly show up in           archive listings.   @      -    (2.01) A bug was fixed that had caused the MS-DOS ver-A           sion to silently skip files that could not be extractedm-           because of insufficient disk space.a  ;      -    (2.01) A bug was fixed that had sometimes made ita@           impossible to selectively extract a file by specifyingA           its name, even though all files could be extracted fromg<           the archive by not specifying any filenames.  This=           occurred when a file had been archived on a longer-a<           filename system (e.g. AmigaDOS) and extraction was?           attempted on a shorter-filename system (e.g. MS-DOS).   >      -    (2.01) A change was made that will make zoo preserve@           the mode (file protection) of a zoo archive when it is?           packed.  This is effective only if zoo is compiled tot?           preserve and restore file attributes.  Currently this &           is so only for **IX systems.  @      -    (2.01) A bug was fixed that had caused an update of an4           archive to not always add all newer files.  ?      -    (2.01) Blanks around equal signs in commands given toA=           "make" were removed from the mk* scripts for bettero?           compatiblity with more **IX implementations including            Sun's.  >      -    (2.1) Compression is now greatly improved if the "h"           option is used.   >      -    (2.1) The default behavior is to preserve full path-"           names during extraction.  >      -    (2.1) On some systems, extraction of files using the?           older (default) compression method is greatly speededa
           up.   7      -    (2.1) Extended multiscreen help is available.o  A      -    (2.1) Memory allocation is improved, so that the MS-DOS <           version will not prematurely abort when updating a           large archive.  =      -    (2.1) The VAX/VMS version preserves file timestampse           during extraction.  ?      -    (2.1) The default archive-wide generation limit, wheno(           generations are enabled, is 3.   FUTURE DIRECTIONSd?      A revised version of zoo is in the works that will be ableh@      to write newly-created archives to standard output and will?      support multivolume archives.  It will be upward and down-o.      ward compatible with this version of zoo.   ACKNOWLEDGEMENTS?      The zoo archiver was initially developed using Microsoft Ct;      3.0 on a PC clone manufactured by Toshiba of Japan andiA      almost sold by Xerox.  Availability of the following systemsuA      was helpful in achieving portability: Paul Homchick's Compaqo@      running Microport System V/AT;  The Eskimo BBS somewhere in?      Oregon running Xenix/68000; Greg Laskin's system 'gryphon'a9      which is an Intel 310 running Xenix/286;  Ball Statee?      University's AT&T 3B2/300, UNIX PC, and VAX-11/785 (4.3BSDe@      and VAX/VMS) systems.  In addition J. Brian Waters provided>      feedback to help me make the code compilable on his Amiga?      using Manx/Aztec C.  The executable version 2.0 for MS-DOSl8      is currently compiled with Borland's Turbo C++ 1.0.  ?      Thanks are due to the following people and many others too       numerous to mention.n  >      J. Brian Waters <jbwaters@bsu-cs.bsu.edu>, who has worked?      diligently to port zoo to AmigaDOS, created Amiga-specifice,      code, and continues keeping it updated.  <      Paul Homchick <rutgers!cgh!paul>, who provided numerous,      detailed reports about some nasty bugs.  =      Bill Davidsen <davidsen@crdos1.crd.ge.com>, who providedm;      numerous improvements to this manual, contributed mul-a=      tiscreen help, and provided many useful bug reports, bug /      fixes, code improvements, and suggestions.   =      Mark Alexander <amdahl!drivax!alexande>, who provided me       with some bug fixes.a  @      Haruhiko Okumura, who wrote the ar archiver and some excel-;      lent compression code, which I adapted for use in zoo.t  @      Randal L. Barnes <rlb@skyler.mavd.honeywell.com>, who (with?      Randy Magnuson) wrote the code to support the preservations&      of file timestamps under VAX/VMS.  ?      Raymond D. Gardner, who contributed replacement uncompres- ;      sion code that on some systems is twice as fast as thel      original.  @      Greg Yachuk and Andre Van Dalen, who independently modified?      MS-DOS zoo to support multivolume archives.  (This supports*      is not yet in this official release.)   AUTHOR      Rahul Dhesi