J /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *<  *                %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%\=  *                %% \___________________________________%% \ >  *                %% |                                   %%  \?  *                %% |              ViewFile             %%   \ @  *                %% |          Utility.c  c2004         %%    \@  *                %% |            Lyle W. West           %%    |@  *                %% |                                   %%    |@  *                %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%    |@  *                \                                        \   |@  *                 \                                        \  |@  *                  \                                        \ |@  *                   \________________________________________\|  *  *  *A  *     Copyright (C) 2001-2004 Lyle W. West, All Rights Reserved. K  *     Permission is granted to copy and use this program provided [1] this K  *     copyright notice is preserved, and [2] no financial gain is involved K  *     in copying the program.  This program may not be sold as "shareware" J  *     or "public domain" software without the express, written permission  *     of the author.   *M  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */    #include "version.h" #pragma module Utility VERSION   #include  <stdio.h>  #include  <descrip.h>  #include  <fcntl.h>  #include  <iodef.h>  #include  <jpidef.h> #include  <lnmdef.h> #include  <psldef.h> #include  <rms.h>  #include  <ssdef.h>  #include  <starlet.h>  #include  <stdlib.h> #include  <string.h> #include  <types.h>  #include  <unixio.h> #include  <Xm/Xm.h>  #include  <Xm/ArrowB.h>  #include  <Xm/BulletinB.h> #include  <Xm/Command.h> #include  <Xm/DialogS.h> #include  <Xm/Form.h>  #include  <Xm/FileSB.h>  #include  <Xm/Label.h> #include  <Xm/LabelG.h>  #include  <Xm/MainW.h> #include  <Xm/MessageB.h>  #include  <Xm/MenuShell.h> #include  <Xm/PushB.h> #include  <Xm/PushBG.h>  #include  <Xm/RowColumn.h> #include  <Xm/ScrollBar.h> #include  <Xm/ScrolledW.h> #include  <Xm/ScrolledWP.h>  #include  <Xm/SelectioB.h> #include  <Xm/Text.h>  #include  <Xm/TextF.h> #include  "defs.h" #include  "externs.h"   E char cmdstr[NUMCMDS][14];       /* used exclusively in this module */    extern void FsbButtonCB(); extern void CloseDlgCB();  extern void InputDlgCB();  extern void OptionMenuCB();  extern void MainWinCB(); extern void CacheSort(); extern void ResponseCB();   E #define DVI$_FULLDEVNAM 232     /* used exclusively in this module */   N /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  *    Function: ErrorPopupH  * Description: A user action has caused an event which prevents desiredE  *              action to occur. Create a popup window which requires .  *              user acknowlegment to continue  *O  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */ + void ErrorPopup(char *message, char *title)  {      Widget Button;  .         /* format title and message strings */  >     if(title) CsTitleStr = XmStringCreateLtoR(title, charset);D     else CsTitleStr = XmStringCreateLtoR("ViewFile Error", charset);8     CsMessageStr = XmStringCreateLtoR(message, charset);  A         /* if ErrorPopDlg already created, just skip init code */        if(!ErrorPopDlg) {         n = 0;*         XtSetArg(args[n], XmNx, 260); n++;*         XtSetArg(args[n], XmNy, 385); n++;:         XtSetArg(args[n], XmNdefaultPosition, False); n++;;         XtSetArg(args[n], XmNdialogTitle, CsTitleStr); n++; ?         XtSetArg(args[n], XmNmessageString, CsMessageStr); n++; P         XtSetArg(args[n], XmNdialogStyle, XmDIALOG_FULL_APPLICATION_MODAL); n++;6         XtSetArg(args[n], XmNshadowThickness, 3); n++;O         ErrorPopDlg = XmCreateMessageDialog(TopParent, "ErrorPopDlg", args, n);   G         Button = XmMessageBoxGetChild(ErrorPopDlg, XmDIALOG_OK_BUTTON);           XtUnmanageChild(Button);I         Button = XmMessageBoxGetChild(ErrorPopDlg, XmDIALOG_HELP_BUTTON);           XtUnmanageChild(Button);  S         XtAddCallback(ErrorPopDlg, XmNcancelCallback, CloseDlgCB, RESP_CANCEL_BTN);      } 
     else {;         XtSetArg(args[n], XmNdialogTitle, CsTitleStr); n++; ?         XtSetArg(args[n], XmNmessageString, CsMessageStr); n++; *         XtSetValues(ErrorPopDlg, args, n);     }        XmStringFree(CsTitleStr);      XmStringFree(CsMessageStr);      XtManageChild(ErrorPopDlg);  }       N /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  *    Function: SaveCachePopupC  * Description: User selected Save button from CacheDlg popup. This F  *              provides user-defined filespec or a default filespec. F  *              Note that saved filespec can only be loaded during theG  *              image startup period, but can be saved anytime viewfile   *              is active.  *O  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */  void SaveCachePopup()  {      Widget Button;     XmString CsFilespec;     XmString CsPlabel;     XmString CsPtitle;  <     CsFilespec = XmStringCreateLtoR(CacheFileSpec, charset);>     CsPtitle = XmStringCreateLtoR("Save Cache List", charset);7     CsPlabel = XmStringCreateLtoR("Save to:", charset);   
     n = 0;5     XtSetArg(args[n], XmNdialogTitle, CsPtitle); n++; >     XtSetArg(args[n], XmNselectionLabelString, CsPlabel); n++;'     XtSetArg(args[n], XmNokLabelString, 2         XmStringCreateLtoR("Save", charset)); n++;+     XtSetArg(args[n], XmNcancelLabelString, 3         XmStringCreateLtoR("Close", charset)); n++; /     XtSetArg(args[n], XmNtextColumns, 36); n++; L     XtSetArg(args[n], XmNdialogStyle, XmDIALOG_FULL_APPLICATION_MODAL); n++;6     XtSetArg(args[n], XmNtextString, CsFilespec); n++;2     XtSetArg(args[n], XmNshadowThickness, 3); n++;3     XtSetArg(args[n], XmNautoUnmanage, False); n++; B     SaveDlg = XmCreatePromptDialog(TopParent, "SaveDlg", args, n);     XtManageChild(SaveDlg);     C     Button = XmSelectionBoxGetChild(SaveDlg, XmDIALOG_HELP_BUTTON);      XtUnmanageChild(Button);  F     XtAddCallback (SaveDlg, XmNokCallback, InputDlgCB, SAVE_SAVE_BTN);K     XtAddCallback (SaveDlg, XmNcancelCallback, CloseDlgCB, SAVE_CLOSE_BTN);        XmStringFree(CsPtitle);      XmStringFree(CsPlabel);      XmStringFree(CsFilespec);  }       N /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  *    Function: ChangeDirPopupF  * Description: Create popup dialog shell which includes a single lineJ  *              text widget to get user input for a new filepath location.G  *              Note that the default Ok, Cancel and Help label strings J  *              are modified to more closely reflect the actions performed"  *              by this operation.  *O  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */  void ChangeDirPopup()  {      Widget Button;  A     CsTitleStr = XmStringCreateLtoR("Change Directory", charset); >     CsLabelStr = XmStringCreateLtoR("New FilePath:", charset);  E         /* widget is not initialized, create it and initialize it. If E            widget previously used, callback routine will have noticed /            the ChangeDirDlg value is nonzero */   
     n = 0;&     XtSetArg(args[n], XmNx, 260); n++;&     XtSetArg(args[n], XmNy, 385); n++;8     XtSetArg(args[n], XmNdialogTitle, CsTitleStr);  n++;@     XtSetArg(args[n], XmNselectionLabelString, CsLabelStr); n++;'     XtSetArg(args[n], XmNokLabelString, 4         XmStringCreateLtoR("Change", charset)); n++;+     XtSetArg(args[n], XmNcancelLabelString, 3         XmStringCreateLtoR("Close", charset)); n++; 3     XtSetArg(args[n], XmNautoUnmanage, False); n++; 6     XtSetArg(args[n], XmNdefaultPosition, False); n++;/     XtSetArg(args[n], XmNtextColumns, 35); n++; 2     XtSetArg(args[n], XmNshadowThickness, 3); n++;L     XtSetArg(args[n], XmNdialogStyle, XmDIALOG_FULL_APPLICATION_MODAL); n++;L     ChangeDirDlg = XmCreatePromptDialog(TopParent, "ChangeDirDlg", args, n);H     Button = XmSelectionBoxGetChild(ChangeDirDlg, XmDIALOG_HELP_BUTTON);     XtUnmanageChild(Button);I     ChangeDirTextw = XmSelectionBoxGetChild(ChangeDirDlg, XmDIALOG_TEXT);       XtManageChild(ChangeDirDlg);  N     XtAddCallback (ChangeDirDlg, XmNokCallback, InputDlgCB, CHDIR_CHANGE_BTN);3     XtAddCallback (ChangeDirDlg, XmNcancelCallback, %         CloseDlgCB, CHDIR_CLOSE_BTN);        XmStringFree(CsTitleStr);      XmStringFree(CsLabelStr);  }     N /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  *    Function: FindStrPopupF  * Description: Create popup dialog shell which includes a single lineG  *              text widget to get user input for a search string. Also I  *              create reverse searcg toggle button and a pseudo label to D  *              display number of matching strings which were found.G  *              Note that the default Ok, Cancel and Help label strings J  *              are modified to more closely reflect the actions performed"  *              by this operation.  *O  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */  void FindStrPopup()  {      char ToggleStr[30];      Widget Button, FindLbl; $     Widget bbrd, rowcol_v, rowcol_h;     Widget TargetTxtTmp;  <     CsTitleStr = XmStringCreateLtoR("Find String", charset);<     CsLabelStr = XmStringCreateLtoR("Search for:", charset);  A         /* widget is not initialized, so create and manage it. If @            widget previously used, callback routines will notice-            the FindStrDlg value is nonzero */   
     n = 0;&     XtSetArg(args[n], XmNx, 435); n++;&     XtSetArg(args[n], XmNy, 250); n++;+     XtSetArg(args[n], XmNheight, 180); n++; *     XtSetArg(args[n], XmNwidth, 360); n++;/     XtSetArg(args[n], XmNmarginHeight, 0); n++; .     XtSetArg(args[n], XmNmarginWidth, 0); n++;3     XtSetArg(args[n], XmNautoUnmanage, False); n++; 2     XtSetArg(args[n], XmNshadowThickness, 3); n++;7     XtSetArg(args[n], XmNdefaultButtonType, None); n++; 6     XtSetArg(args[n], XmNdefaultPosition, False); n++;8     XtSetArg(args[n], XmNdialogTitle, CsTitleStr);  n++;@     XtSetArg(args[n], XmNselectionLabelString, CsLabelStr); n++;'     XtSetArg(args[n], XmNokLabelString, 2         XmStringCreateLtoR("Find", charset)); n++;+     XtSetArg(args[n], XmNcancelLabelString, 3         XmStringCreateLtoR("Clear", charset)); n++; )     XtSetArg(args[n], XmNhelpLabelString, 3         XmStringCreateLtoR("Close", charset)); n++; >     XtSetArg(args[n], XmNdialogStyle, XmDIALOG_MODELESS); n++;I     FindStrDlg = XmCreateMessageDialog(TopParent, "FindStrDlg", args, n);   I     XtAddCallback (FindStrDlg, XmNokCallback, InputDlgCB, FIND_FIND_BTN); N     XtAddCallback (FindStrDlg, XmNcancelCallback, InputDlgCB, FIND_CLEAR_BTN);L     XtAddCallback (FindStrDlg, XmNhelpCallback, CloseDlgCB, FIND_CLOSE_BTN);  C         /* get widget id of Find (OK) button in FindStrDlg popup */   C     FindBtn = XmMessageBoxGetChild(FindStrDlg, XmDIALOG_OK_BUTTON);   6         /* create a bulletin board for the workarea */  
     n = 0;$     XtSetArg(args[n], XmNy, 0); n++;+     XtSetArg(args[n], XmNheight, 105); n++; /     XtSetArg(args[n], XmNmarginHeight, 0); n++; 2     XtSetArg(args[n], XmNshadowThickness, 0); n++;>     bbrd = XmCreateBulletinBoard(FindStrDlg, "bbrd", args, n);     XtManageChild(bbrd);  7         /* create a label for the search text window */   
     n = 0;7     CpStr = XmStringCreateLtoR("Search for:", charset); %     XtSetArg(args[n], XmNx, 20); n++; $     XtSetArg(args[n], XmNy, 5); n++;2     XtSetArg(args[n], XmNlabelString, CpStr); n++;6     FindLbl = XmCreateLabel(bbrd, "FindLbl", args, n);     XtManageChild(FindLbl);   8         /* create a text window for the search string */  
     n = 0;%     XtSetArg(args[n], XmNx, 20); n++; %     XtSetArg(args[n], XmNy, 30); n++; .     XtSetArg(args[n], XmNmarginWidth, 0); n++;*     XtSetArg(args[n], XmNwidth, 320); n++;2     XtSetArg(args[n], XmNshadowThickness, 3); n++;?     FindStrTextw = XmCreateText(bbrd, "FindStrTextw", args, n);       XtManageChild(FindStrTextw);4     XtAddCallback(FindStrTextw, XmNactivateCallback,+                 InputDlgCB, FIND_FIND_BTN); 8     XtAddCallback(FindStrTextw, XmNvalueChangedCallback,.                 InputDlgCB, FIND_VAL_CHANGED);  2         /* create a standard vertical RowColumn */  
     n = 0;%     XtSetArg(args[n], XmNx, 20); n++; %     XtSetArg(args[n], XmNy, 65); n++; <     rowcol_v = XmCreateRowColumn(bbrd, "rowcol_v", args, n);     XtManageChild(rowcol_v);  A         /* create horizontal RowColumn inside the vertical one */   
     n = 0;9     XtSetArg(args[n], XmNorientation, XmHORIZONTAL); n++; 2     XtSetArg(args[n], XmNshadowThickness, 0); n++;@     rowcol_h = XmCreateRowColumn(rowcol_v, "rowcol_h", args, n);     XtManageChild(rowcol_h);  J         /* create togglebutton for search direction (child of rowcol_h) */  
 #ifdef VAX'     sprintf(ToggleStr, "Find Reverse");  #else '     sprintf(ToggleStr, "Find Forward");  #endif3     CpStr = XmStringCreateLtoR(ToggleStr, charset);   
     n = 0;2     XtSetArg(args[n], XmNlabelString, CpStr); n++;5     XtSetArg(args[n], XmNhighlightThickness, 0); n++; 3     XtSetArg(args[n], XmNset, FindReverseFlg); n++; /     XtSetArg(args[n], XmNmarginRight, 35); n++; +     XtSetArg(args[n], XmNspacing, 10); n++; 2     XtSetArg(args[n], XmNshadowThickness, 0); n++;O     FindReverseBtn = XmCreateToggleButton(rowcol_h, "FindReverseBtn", args, n); "     XtManageChild(FindReverseBtn);     XmStringFree(CpStr);:     XtAddCallback(FindReverseBtn, XmNvalueChangedCallback,2                         InputDlgCB, FIND_REV_BTN);  2         /* for vax, search revers not available */  
 #ifdef VAX@     XtSetSensitive(FindReverseBtn, False);  /* rtl limitation */ #endif  ?         /* create togglebutton for reset (child of rowcol_h) */   O     sprintf(ToggleStr, "Search from %s", FindReverseFlg ? "End" : "Beginning"); 3     CpStr = XmStringCreateLtoR(ToggleStr, charset);   
     n = 0;2     XtSetArg(args[n], XmNlabelString, CpStr); n++;5     XtSetArg(args[n], XmNhighlightThickness, 0); n++; *     XtSetArg(args[n], XmNset, False); n++;.     XtSetArg(args[n], XmNmarginRight, 0); n++;+     XtSetArg(args[n], XmNspacing, 10); n++; 2     XtSetArg(args[n], XmNshadowThickness, 0); n++;M     SearchFromBtn = XmCreateToggleButton(rowcol_h, "SearchFromBtn", args, n); !     XtManageChild(SearchFromBtn);      XmStringFree(CpStr);9     XtAddCallback(SearchFromBtn, XmNvalueChangedCallback, 3                         InputDlgCB, FIND_FROM_BTN);        XtManageChild(FindStrDlg);9     XmProcessTraversal(FindStrTextw, XmTRAVERSE_CURRENT);        XmStringFree(CsTitleStr);      XmStringFree(CsLabelStr);  }     N /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  *    Function: InitMainWindowD  * Description: Initialize Bulletin Board widgets. These include theD  *              arrow up/down buttons, regular pushbuttons, dialog  E  *              widget to display file and the target filespec label.   *O  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */  void InitMainWindow()  {      int indx = 0;      char labelstr[80];     Widget ScrollLbl, pulldown;   D         /* Create a text widget for filespec label (CurFileTextw) */  &     sprintf(labelstr, "%s", VERSION);   
     n = 0;%     XtSetArg(args[n], XmNx, 10); n++; %     XtSetArg(args[n], XmNy, 10); n++; +     XtSetArg(args[n], XmNcolumns, 80); n++; /     XtSetArg(args[n], XmNeditable, False); n++; <     XtSetArg(args[n], XmNcursorPositionVisible, False); n++;2     XtSetArg(args[n], XmNshadowThickness, 0); n++;5     XtSetArg(args[n], XmNhighlightThickness, 0); n++; /     XtSetArg(args[n], XmNvalue, labelstr); n++; I     CurFileTextw = XmCreateTextField(TopParent, "CurFileTextw", args, n);       XtManageChild(CurFileTextw);  2         /* Create ScrolledText to display file  */  
     n = 0;%     XtSetArg(args[n], XmNx, 10); n++; $     XtSetArg(args[n], XmNy,35); n++;(     XtSetArg(args[n], XmNrows, 24); n++;+     XtSetArg(args[n], XmNcolumns, 80); n++; C     XtSetArg(args[n], XmNeditable, False); n++;     /* read-only */*;     XtSetArg(args[n], XmNeditMode, XmMULTI_LINE_EDIT); n++;%C     XtSetArg(args[n], XmNscrollBarDisplayPolicy, XmAS_NEEDED); n++;_<     XtSetArg(args[n], XmNautoShowCursorPosition, True); n++;<     XtSetArg(args[n], XmNcursorPositionVisible, False); n++;2     XtSetArg(args[n], XmNshadowThickness, 3); n++;1     XtSetArg(args[n], XmNtraversalOn, True); n++; H     ViewWindow = XmCreateScrolledText(TopParent, "ViewWindow", args, n);     XtManageChild(ViewWindow);       XtAddCallback(ViewWindow, *                   XmNmotionVerifyCallback,                   ResponseCB, &                   VIEW_MOTION_VERIFY);  =     XtVaGetValues(XtParent(ViewWindow), XmNverticalScrollBar,          &ViewWindowVsb, NULL);  .         /* Create Open button for View file */  
     n = 0;0     CpStr = XmStringCreateLtoR("Open", charset);)     XtSetArg(args[n], XmNwidth, 80); n++;A*     XtSetArg(args[n], XmNheight, 30); n++;%     XtSetArg(args[n], XmNx, 35); n++;v&     XtSetArg(args[n], XmNy, 410); n++;7     XtSetArg(args[n], XmNhighlightOnEnter, False); n++; 2     XtSetArg(args[n], XmNtraversalOn, False); n++;2     XtSetArg(args[n], XmNlabelString, CpStr); n++;2     XtSetArg(args[n], XmNshadowThickness, 3); n++;F     OpenBtn = XmCreatePushButtonGadget(TopParent, "OpenBtn", args, n);J     XtAddCallback(OpenBtn, XmNactivateCallback, MainWinCB, MAIN_OPEN_BTN);     XtManageChild(OpenBtn);h     XmStringFree(CpStr);  *         /* Create PushButton for Search */  
     n = 0;2     CpStr = XmStringCreateLtoR("Search", charset);)     XtSetArg(args[n], XmNwidth, 80); n++;i*     XtSetArg(args[n], XmNheight, 30); n++;&     XtSetArg(args[n], XmNx, 185); n++;&     XtSetArg(args[n], XmNy, 410); n++;7     XtSetArg(args[n], XmNhighlightOnEnter, False); n++;.2     XtSetArg(args[n], XmNtraversalOn, False); n++;2     XtSetArg(args[n], XmNlabelString, CpStr); n++;2     XtSetArg(args[n], XmNshadowThickness, 3); n++;J     SearchBtn = XmCreatePushButtonGadget(TopParent, "SearchBtn", args, n);1     XtAddCallback(SearchBtn, XmNactivateCallback, $         MainWinCB, MAIN_SEARCH_BTN);     XtManageChild(SearchBtn);X     XmStringFree(CpStr);  2         /* create rowcol widget for Option menu */  
     n = 0;&     XtSetArg(args[n], XmNx, 325); n++;&     XtSetArg(args[n], XmNy, 405); n++;*     XtSetArg(args[n], XmNwidth, 140); n++;*     XtSetArg(args[n], XmNheight, 40); n++;2     XtSetArg(args[n], XmNresizeWidth, False); n++;3     XtSetArg(args[n], XmNresizeHeight, False); n++; 3     XtSetArg(args[n], XmNnumColumns, NUMCMDS); n++;e6     XtSetArg(args[n], XmNpacking, XmPACK_COLUMN); n++;C     OptRowCol = XmCreateRowColumn(TopParent, "OptRowCol", args, n);*     XtManageChild(OptRowCol);*  3         /* fill CmdName array with button labels */i  &     strcpy(cmdstr[0], " Change Dir ");"     strcpy(cmdstr[1], " Recall ");%     strcpy(cmdstr[2], " File Info ");w!     strcpy(cmdstr[3], " Cache ");rD     strcpy(cmdstr[4], "---------");        /* poor mans separator */$     strcpy(cmdstr[5], " Logicals ");#     strcpy(cmdstr[6], " Display ");c!     strcpy(cmdstr[7], " Image ");;      strcpy(cmdstr[8], " Help ");D     strcpy(cmdstr[9], "---------");        /* poor mans separator */!     strcpy(cmdstr[10], " Exit ");   2         /* Create pulldown menu for option menu */  L     pulldown = (Widget)XmCreatePulldownMenu(OptRowCol, "pulldown", NULL, 0);+     for(indx = 0; indx < NUMCMDS; indx++) {          n = 0;-         XtSetArg(args[n], XmNwidth, 80); n++; .         XtSetArg(args[n], XmNheight, 30); n++;3         XtSetArg(args[n], XmNsensitive, True); n++;i6         XtSetArg(args[n], XmNtraversalOn, False); n++;6         XtSetArg(args[n], XmNshadowThickness, 3); n++;=         CmdOptions[indx] = XmCreatePushButtonGadget(pulldown,m#             cmdstr[indx], args, n);O<         XtAddCallback(CmdOptions[indx], XmNactivateCallback,C             OptionMenuCB, indx + 300); /* +300 is for 'user_data */o     }"'     XtManageChildren(CmdOptions, indx);e  2         /* some buttons are unusable at startup */  >     XtSetSensitive(CmdOptions[2], False);      /* file info */E     XtSetSensitive(CmdOptions[4], False);      /* pseudo separator */ E     XtSetSensitive(CmdOptions[9], False);      /* pseudo separator */PA     if(!HelpEnable)             /* Help not enabled by default */a-         XtSetSensitive(CmdOptions[8], False);a3     if(!CacheEnable) {         /* Cache disabled */ :         XtSetSensitive(CmdOptions[3], False);  /* cache */     }T     =         /* Create option menu and attach the pulldown menu */P  
     n = 0;3     XtSetArg(args[n], XmNsubMenuId, pulldown); n++;*:     XtSetArg(args[n], XmNmenuHistory, CmdOptions[0]); n++;&     XtSetArg(args[n], XmNx, 325); n++;&     XtSetArg(args[n], XmNy, 410); n++;2     XtSetArg(args[n], XmNtraversalOn, False); n++;2     XtSetArg(args[n], XmNshadowThickness, 3); n++;I     CmdOptMenu = XmCreateOptionMenu(OptRowCol, "CmdOptionMenu", args, n);      XtManageChild(CmdOptMenu);%     XtSetSensitive(CmdOptMenu, True);*  8         /* Create UpArrow to scroll towards beginning */  
     n = 0;&     XtSetArg(args[n], XmNx, 550); n++;&     XtSetArg(args[n], XmNy, 410); n++;)     XtSetArg(args[n], XmNwidth, 30); n++;;*     XtSetArg(args[n], XmNheight, 30); n++;:     XtSetArg(args[n], XmNarrowDirection, XmARROW_UP); n++;2     XtSetArg(args[n], XmNshadowThickness, 3); n++;2     XtSetArg(args[n], XmNtraversalOn, False); n++;=     UpBtn = XmCreateArrowButton(TopParent, "UpBtn", args, n);a     XtManageChild(UpBtn);rJ     XtAddCallback(UpBtn, XmNactivateCallback, MainWinCB, MAIN_UARROW_BTN);  7         /* Create DownArrow to scroll towards bottom */]  
     n = 0;&     XtSetArg(args[n], XmNx, 635); n++;&     XtSetArg(args[n], XmNy, 410); n++;)     XtSetArg(args[n], XmNwidth, 30); n++;e*     XtSetArg(args[n], XmNheight, 30); n++;<     XtSetArg(args[n], XmNarrowDirection, XmARROW_DOWN); n++;2     XtSetArg(args[n], XmNshadowThickness, 3); n++;2     XtSetArg(args[n], XmNtraversalOn, False); n++;A     DownBtn = XmCreateArrowButton(TopParent, "DownBtn", args, n);      XtManageChild(DownBtn);aL     XtAddCallback(DownBtn, XmNactivateCallback, MainWinCB, MAIN_DARROW_BTN);  5         /* Create 'Scroll' label for arrow buttons */d  
     n = 0;2     CpStr = XmStringCreateLtoR("Scroll", charset);&     XtSetArg(args[n], XmNx, 590); n++;&     XtSetArg(args[n], XmNy, 415); n++;2     XtSetArg(args[n], XmNlabelString, CpStr); n++;?     ScrollLbl = XmCreateLabel(TopParent, "ScrollLbl", args, n);*     XtManageChild(ScrollLbl);*     XmStringFree(CpStr);   }*  N /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  *    Function: InfoPopup A  * Description: User requested some type of ViewFile information. B  *              Create a popup window which will display this infoE  *              and requires user acknowlegment to proceed. Note thatpD  *              this is a generic routine which is called by severalH  *              routines to display that functions specific information.  *O  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */e* void InfoPopup(char *message, char *title) {e     Widget InfoPopDlg;     Widget Unbutton;  4     CsTitleStr = XmStringCreateLtoR(title, charset);8     CsMessageStr = XmStringCreateLtoR(message, charset);  
     n = 0;&     XtSetArg(args[n], XmNx, 260); n++;&     XtSetArg(args[n], XmNy, 385); n++;8     XtSetArg(args[n], XmNdialogTitle, CsTitleStr);  n++;6     XtSetArg(args[n], XmNdefaultPosition, False); n++;3     XtSetArg(args[n], XmNautoUnmanage, False); n++;e;     XtSetArg(args[n], XmNmessageString, CsMessageStr); n++;t'     XtSetArg(args[n], XmNokLabelString,e3         XmStringCreateLtoR("Close", charset)); n++;b2     XtSetArg(args[n], XmNshadowThickness, 3); n++;L     XtSetArg(args[n], XmNdialogStyle, XmDIALOG_FULL_APPLICATION_MODAL); n++;M     InfoPopDlg = XmCreateInformationDialog(TopParent, "InfoPopDlg", args, n);m     XtManageChild(InfoPopDlg);?     XtAddCallback(InfoPopDlg, XmNokCallback, CloseDlgCB, NULL);o  .     /* remove unneeded CANCEL & HELP button */  H     Unbutton = XmMessageBoxGetChild(InfoPopDlg, XmDIALOG_CANCEL_BUTTON);     XtUnmanageChild(Unbutton);F     Unbutton = XmMessageBoxGetChild(InfoPopDlg, XmDIALOG_HELP_BUTTON);     XtUnmanageChild(Unbutton);     XmStringFree(CsTitleStr);L     XmStringFree(CsMessageStr);n }i    N /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  *    Function: WarnPopupDH  * Description: A user action has caused an event which prevents desiredE  *              action to occur. Create a popup window which requires*.  *              user acknowlegment to continue  *O  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */p* void WarnPopup(char *message, char *title) {      Widget Dshell;     Widget WarnPop;n     Widget Unbutton;  >     if(title) CsTitleStr = XmStringCreateLtoR(title, charset);F     else CsTitleStr = XmStringCreateLtoR("ViewFile Warning", charset);8     CsMessageStr = XmStringCreateLtoR(message, charset);<     CsOkStr = XmStringCreateLtoR(" Acknowledged ", charset);  
     n = 0;%     XtSetArg(args[n], XmNx,260); n++; &     XtSetArg(args[n], XmNy, 385); n++;3     XtSetArg(args[n], XmNautoUnmanage, False); n++;*7     XtSetArg(args[n], XmNdialogTitle, CsTitleStr); n++;T;     XtSetArg(args[n], XmNmessageString, CsMessageStr); n++;,'     XtSetArg(args[n], XmNokLabelString,t3         XmStringCreateLtoR("Close", charset)); n++;i6     XtSetArg(args[n], XmNdefaultPosition, False); n++;2     XtSetArg(args[n], XmNshadowThickness, 3); n++;L     XtSetArg(args[n], XmNdialogStyle, XmDIALOG_FULL_APPLICATION_MODAL); n++;C     WarnPop = XmCreateWarningDialog(TopParent, "WarnPop", args, n);o<     XtAddCallback(WarnPop, XmNokCallback, CloseDlgCB, NULL);  2         /* remove unneeded CANCEL & HELP button */  E     Unbutton = XmMessageBoxGetChild(WarnPop, XmDIALOG_CANCEL_BUTTON);      XtUnmanageChild(Unbutton);C     Unbutton = XmMessageBoxGetChild(WarnPop, XmDIALOG_HELP_BUTTON);      XtUnmanageChild(Unbutton);       XmStringFree(CsTitleStr);g     XmStringFree(CsMessageStr);;     XmStringFree(CsOkStr);       XtManageChild(WarnPop);  }     N /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  *    Function: TextPosToRowColgI  * Description: Asumming target window is configured as a 24x80 character H  *              display, compute current row and colunm values using theK  *              current cursor offset from the beginning of the text string"G  *              contained within the window. This routine positions themG  *              ViewWindow scrollbar as a result of a search operation.o  *O  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */FL int TextPosToRowCol(Widget TextW, XmTextPosition CurPos, int *row, int *col) {B     int status = 0; "     XmTextPosition TextWinTop = 0;     Position TopY = 0;     Position x = 0;      Position y = 0;r  2     status = XmTextPosToXY(TextW, CurPos, &x, &y);     if(!status) return(False);,     TextWinTop = XmTextXYToPos(TextW, 0, y);     if(TextWinTop) {8         XmTextPosToXY(TextW, TextWinTop - 1, &x, &TopY);M         if(!(y - TopY)) y++;            /* kludge to avoid divbyzero fault */m%         *row = (int)(y / (y - TopY));h     }1     else *row = 0;  *     *col = (int)(CurPos - TextWinTop) + 1;     return True; }s      J /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  *    Function: ScanFiletypes D  * Description: scan a directory and list only those files which areJ  *              percieved to be ascii text. Basically, we reject filetypesE  *              known to be non-ascii, obj, exe, etc. This routine isAA  *              called each time the fsb filter oreration occurs.e  *K  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */ 8 void ScanFiletypes(Widget widget, XtPointer search_data) {AL     int NumFiles = 0;           /* count of qualified files in target dir */8     int context = 0;            /* $find_file context */;     int flags = 0;              /* $find_file user flags */k5     int indx = 0;               /* number of files */F     int reject = 0;)     int status = RMS$_NORMAL;x     int status2 = 0;     char path[80];L     char resultant_file[132];   /* file mask, probably contains wild chrs */     char titlestr[80];     char typestr[20];      char *mask;DB     char *ptr1;                 /* general purpose char pointer */B     char *ptr2;                 /* general purpose char pointer */A     XmString names[MAXFILE];    /* maximum of 256 files in dir */u2     FILE_LST *FilePtr;          /* file pointer */     FILE_LST *AscFileList;      $DESCRIPTOR(Dsc_Path, path);*     $DESCRIPTOR(Dsc_File, resultant_file);  +     XmFileSelectionBoxCallbackStruct *cbs = 9         (XmFileSelectionBoxCallbackStruct *) search_data;c  7         /* get filepath string from fsb filter textw */   
     mask = 0;o>     XmStringGetLtoR(cbs->mask, XmFONTLIST_DEFAULT_TAG, &mask);     if(!mask) return; 
 #ifdef VF_DBG !     printf("Target: %s\n", mask);) #endif  D         /* scan the target dir for a total count of files, we do notF            worry about qualifying filetypes here, waste some memory */  >     sprintf(path, "%s", mask);  /* could have used strcpy() */     NumFiles = 0; )     Dsc_Path.dsc$w_length = strlen(path);g     status = RMS$_NORMAL;[#     while (status == RMS$_NORMAL) {t         n = 0;D         status = lib$find_file(&Dsc_Path, &Dsc_File, &context, 0, 0,1                                &status2, &flags);c#         if(status != RMS$_NORMAL) { )             if(status == RMS$_NMF) break;i             else {>                 if(status == RMS$_FNF || status == RMS$_DNF) {:                     sprintf(titlestr, "Target Not Found");N                     sprintf(Buffer, "Unable to open target filespec:\n'%s'%s",>                         path, "\nVerify filespec is correct");3                     ErrorPopup(&Buffer, &titlestr);                      break;                 }r"                 else exit(status);
             }g	         }T         NumFiles++;      } )     status = LIB$FIND_FILE_END(&context); 
 #ifdef VF_DBG *     printf("Total files: %d\n", NumFiles); #endif  ?         /* allocate space for saving all qualified filespecs */   9     AscFileList = calloc(NumFiles + 1, sizeof(FILE_LST));0     FilePtr = AscFileList;  B         /* now get all files which do not have a filetype from the<            list below and save in structure 'AscFileList' */       context = 0;     NumFiles = 0;r)     Dsc_Path.dsc$w_length = strlen(path);u     status = RMS$_NORMAL; #     while (status == RMS$_NORMAL) {_         reject = 0;eD         status = lib$find_file(&Dsc_Path, &Dsc_File, &context, 0, 0,1                                &status2, &flags);t#         if(status != RMS$_NORMAL) {*)             if(status == RMS$_NMF) break;*             else {>                 if(status == RMS$_FNF || status == RMS$_DNF) {:                     sprintf(titlestr, "Target Not Found");N                     sprintf(Buffer, "Unable to open target filespec:\n'%s'%s",>                         path, "\nVerify filespec is correct");3                     ErrorPopup(&Buffer, &titlestr);*                     break;                 } "                 else exit(status);
             }i	         }L+         ptr1 = strchr(resultant_file, ' ');d         if(ptr1) *ptr1 = 0;l  G         /* If the boolean GetAllFiles is set, we will display all fileseH            in target directory. Else filetypes will be qualified to list            only ascii files */           if(GetAllFiles) {[:                 strcpy(FilePtr->FileName, resultant_file);                 FilePtr++;                 NumFiles++;m	         }k         else {0             ptr1 = strrchr(resultant_file, '.');             if(ptr1) {                 ptr1++;n)                 ptr2 = strchr(ptr1, ';');T#                 if(ptr2) *ptr2 = 0; &                 strcpy(typestr, ptr1);5                 if(!strcmp(typestr, "BCK")) reject++; 5                 if(!strcmp(typestr, "DIR")) reject++;A5                 if(!strcmp(typestr, "EXE")) reject++;w5                 if(!strcmp(typestr, "GIF")) reject++;+5                 if(!strcmp(typestr, "HLB")) reject++; 5                 if(!strcmp(typestr, "JPG")) reject++;M5                 if(!strcmp(typestr, "OBJ")) reject++;B5                 if(!strcmp(typestr, "OLB")) reject++;[5                 if(!strcmp(typestr, "ZIP")) reject++;g%                 if(ptr2) *ptr2 = ';';s                 if(!reject) { >                     strcpy(FilePtr->FileName, resultant_file);                     FilePtr++;                     NumFiles++;,                 },
 #ifdef VF_DBGa                 else {8                     ptr1 = strrchr(resultant_file, ']');$                     if(ptr1) ptr1++;3                     printf("Rejected: %s\n", ptr1);                  }t #endif
             }v*             if(NumFiles == MAXFILE) break;	         }      }*)     status = LIB$FIND_FILE_END(&context); 
 #ifdef VF_DBGt.     printf("Qualified files: %d\n", NumFiles); #endif  -         /* reset FilePtr to start of array */]       FilePtr = AscFileList;
     n = 0;&     while(strlen(FilePtr->FileName)) {I         names[n] = (XmString) XmStringCreateLocalized(FilePtr->FileName);+         FilePtr++;         n++;     }   
     n = 0;4     XtSetArg(args[n], XmNfileListItems, names); n++;;     XtSetArg(args[n], XmNfileListItemCount, NumFiles); n++; -     XtSetArg(args[n], XmNdirSpec, mask); n++;,1     XtSetArg(args[n], XmNlistUpdated, True); n++;a!     XtSetValues(widget, args, n);      cfree(AscFileList);)8     while(NumFiles > 0) XmStringFree(names[--NumFiles]); }f    a  N /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  *    Function: SaveCache+G  * Description: User selected the Save button from the SaveCache popup.xG  *              Open the specified file and write the contents of cache]H  *              table to file. Close the file when complete and unmanage  *              the popup.  *O  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */  void SaveCache() {      int indx = 0;a     int itemcount = 0;     int status = 0;t     short length = 0;X     char datestr[24];      char titlestr[40];     char *ListItem;a     char *ptr;#     $DESCRIPTOR(Dsc_Date, datestr);   2     status = sys$asctim(&length, &Dsc_Date, 0, 0);     datestr[length] = 0;     ptr = strchr(datestr, '.');g     if(ptr) *ptr = 0;+  (     CacheFp = fopen(CacheFileSpec, "w");     if(!CacheFp) {-         sprintf(titlestr, "File Open Error");]=         sprintf(Buffer, "Unable to open input file:\n'%s'%s",HH                 CacheFileSpec,"\nfor read. Verify filespec is correct");'         ErrorPopup(&Buffer, &titlestr);K         return;      }w  =     fprintf(CacheFp, "# ViewFile.Vfr - Saved Cache paths\n");t2     fprintf(CacheFp, "# ViewFile: %s\n", VERSION);2     fprintf(CacheFp, "#  Created: %s\n", datestr);     fprintf(CacheFp, "# \n");c/     fprintf(CacheFp, "@ %d \n", NumCacheItems);i  
     indx = 0; !     while(indx < NumCacheItems) { H         status = XmStringGetLtoR(CsCacheList[indx], charset, &ListItem);'         if(status != SS$_NORMAL) break;c-         fprintf(CacheFp, "  %s\n", ListItem);          indx++;      }c     fprintf(CacheFp, "# \n");y(     fprintf(CacheFp, "# End of file\n");     fclose(CacheFp);     Modified = False;i     XtUnmanageChild(SaveDlg);l }n      N /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  *    Function: GetPhysicalPath J  * Description: Given a filepath as input, assume it is at least partiallyK  *              a logical name. Expand that logical and append, if present,AH  *              the directory info present in the input path to create aJ  *              physical filepath devoid of the logical name. Save this asG  *              a second element in the cache array with the input path M  *              to this routine. At exit the composed physical path is placedtN  *              in the global location 'CachePhysPath'. This routine also willM  *              correctly handle raw disk name as part of the input filepath.r  *O  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */f$ int GetPhysicalPath(char *CheckPath) {a     int Done = 0;oK     int attributes = 0;             /* returned attributes of eqv string */r     int indx = 0;e     int max_indx = 0;*I     int nocase = LNM$M_CASE_BLIND;  /* resolve lnm without case issues */s     int status;h     short length = 0;a     char acmode = PSL$C_USER;SJ     char DirStr[80];                /* portion of path string after lnm */H     char LnmStr[35];                /* logical name from input string */<     char LnmTable[30];              /* logical name table */     char NewPath[80];t     char *ptr;  ?     struct {short len, code; int *bufadr, *retlen;} LnmItem[4];   %     $DESCRIPTOR(Dsc_Table, LnmTable);e!     $DESCRIPTOR(Dsc_Lnm, LnmStr);a(     $DESCRIPTOR(Dsc_Eqv, CachePhysPath);  )     memset(&LnmItem, 0, sizeof(LnmItem));m5     memset(&CachePhysPath, 0, sizeof(CachePhysPath));;H     strcpy(NewPath, CheckPath);         /* local copy of input string */I     strcpy(LnmTable, "LNM$FILE_DEV");   /* any table we have access to */   .         /* initialize item list for $trnlnm */  &     LnmItem[0].len = sizeof(max_indx);%     LnmItem[0].code = LNM$_MAX_INDEX;;"     LnmItem[0].bufadr = &max_indx;     LnmItem[0].retlen = 0;(     LnmItem[1].len = sizeof(attributes);&     LnmItem[1].code = LNM$_ATTRIBUTES;$     LnmItem[1].bufadr = &attributes;     LnmItem[1].retlen = 0;+     LnmItem[2].len = sizeof(CachePhysPath); "     LnmItem[2].code = LNM$_STRING;'     LnmItem[2].bufadr = &CachePhysPath;       LnmItem[2].retlen = &length;     LnmItem[3].len = 0;      LnmItem[3].code = 0;  0         /* assume all chars prior to ':' to be a1            logical name. Translate that string */n  '     memset(&DirStr, 0, sizeof(DirStr));      ptr = strchr(NewPath, ':');r
     if(ptr) {A         *ptr = 0;           strcpy(LnmStr, NewPath);         *ptr = ':';t         ptr++;         if(*ptr == '[') {;             ptr++;              strcpy(DirStr, ptr);	         })0         else memset(&DirStr, 0, sizeof(DirStr));     }t  .     Dsc_Table.dsc$w_length = strlen(LnmTable);'     Dsc_Table.dsc$a_pointer = LnmTable;r*     Dsc_Lnm.dsc$w_length = strlen(LnmStr);#     Dsc_Lnm.dsc$a_pointer = LnmStr;t1     Dsc_Eqv.dsc$w_length = sizeof(CachePhysPath);e*     Dsc_Eqv.dsc$a_pointer = CachePhysPath;  J     status = sys$trnlnm(&nocase, &Dsc_Table, &Dsc_Lnm, &acmode, &LnmItem);:     if(status == SS$_NORMAL) CachePhysPath[length] = '\0';
     else {  J         /* perhaps user entered a raw device path, DKA100:[ZXC], for whichL            $trnlnm cannot translate the string prior to the colon. If statusM            is 0x1bc, test for a valid device and return SS$_NORMAL if true */n  $         if(status == SS$_NOLOGNAM) {7             Dsc_Eqv.dsc$w_length = sizeof(LnmEquivStr);e0             Dsc_Eqv.dsc$a_pointer = LnmEquivStr;A             status = lib$getdvi(&DVI$_FULLDEVNAM, 0, &Dsc_Lnm, 0,t#                 &Dsc_Eqv, &length); :             if(status != SS$_NORMAL) return(SS$_NOLOGNAM);$             LnmEquivStr[length] = 0;1             strcpy(CachePhysPath, LnmEquivStr+1);l'             strcat(CachePhysPath, "[");r+             strcat(CachePhysPath, &DirStr);s             return(SS$_NORMAL);e	         }s%         if(status == SS$_BUFFEROVF) {]@             printf("GetPhysicalPath: output buffer overflow\n");3             printf(" Logical Path: %s\n", NewPath); ;             printf("Physical Path: %s\n\n", CachePhysPath);e	         }]         else return(status);     } &     ptr = strrchr(CachePhysPath, ']');
     if(ptr) {t*         if(LNM$M_CONCEALED & attributes) {             *ptr = 0;t*             strcat(CachePhysPath, DirStr);	         }s>         else if(strlen(DirStr)) strcat(CachePhysPath, DirStr);     }G  B         /* while we have translated a logical to a device specificB            path, the device may still be a logical device and will:            need to be reduced to a physical device name */  %     ptr = strchr(CachePhysPath, ':');E
     if(ptr) {          *ptr = 0;=&         strcpy(LnmStr, CachePhysPath);         *ptr = ':';          ptr++;,         if(*ptr == '[') strcpy(DirStr, ptr);0         else memset(&DirStr, 0, sizeof(DirStr));     }l  L         /* Now we go deeper, since last lnm translation could have uncoveredJ            a lnm searchlist logical. If so, check each index until we haveK            a valid path. The resultant path may not be down to the physical I            device name, but will be close enough to be somewhat unique */e  *     Dsc_Lnm.dsc$w_length = strlen(LnmStr);#     Dsc_Lnm.dsc$a_pointer = LnmStr; )     LnmItem[2].len = sizeof(LnmEquivStr);*%     LnmItem[2].bufadr = &LnmEquivStr;pJ     status = sys$trnlnm(&nocase, &Dsc_Table, &Dsc_Lnm, &acmode, &LnmItem);     if(status == SS$_NORMAL) {&         LnmItem[0].len = sizeof(indx);%         LnmItem[0].code = LNM$_INDEX;e"         LnmItem[0].bufadr = &indx;         LnmItem[0].retlen = 0;         while(!Done) {>             status = sys$trnlnm(&nocase, &Dsc_Table, &Dsc_Lnm,#                 &acmode, &LnmItem); '             LnmEquivStr[length] = '\0'; /             strcpy(CachePhysPath, LnmEquivStr);e-             ptr = strchr(CachePhysPath, ']');              if(ptr) {d2                 if(LNM$M_CONCEALED & attributes) {                     *ptr = 0;r.                     ptr = strchr(DirStr, '[');                     if(ptr) {"                         ptr++;3                         strcat(CachePhysPath, ptr); E                         sprintf(LnmEquivStr, "%s*.*", CachePhysPath);m<                         status = CheckFilePath(LnmEquivStr);2                         if(status == SS$_NORMAL) {I                             memset(&LnmEquivStr, 0, sizeof(LnmEquivStr)); (                             Done = True;                         }M                     }o                 }B
             }t             else {A                 if(strlen(DirStr)) strcat(CachePhysPath, DirStr);T=                 sprintf(LnmEquivStr, "%s*.*", CachePhysPath);t4                 status = CheckFilePath(LnmEquivStr);*                 if(status == SS$_NORMAL) {A                     memset(&LnmEquivStr, 0, sizeof(LnmEquivStr));*                     break;                 }e
             }              indx++;i,             if(indx > max_indx) Done = True;	         }      }      return(SS$_NORMAL);e }r    N /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  *    Function: CheckPrvF  * Description: Verify user running this image has sufficient privs toH  *              read any file on system. ViewFile is written as a SysMgrI  *              tool, so if general user access is desired, the user must*F  *              tolerate the resultant popup, or code must be changed.  *O  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */i void CheckPrv()  {i     int status;      int procpriv[2] = 0;     char titlestr[80];@     struct  {short len, code; int *bufadr, *retlen;} JpiItem[2];  &     JpiItem[0].len = sizeof(procpriv);$     JpiItem[0].code = JPI$_PROCPRIV;"     JpiItem[0].bufadr = &procpriv;     JpiItem[0].retlen = 0;     JpiItem[1].len = 0;o     JpiItem[1].code = 0;  5     status = sys$getjpiw(0, 0, 0, &JpiItem, 0, 0, 0);o+     if(procpriv[1] & PRV$M_READALL) return;p
     else {         DoBell(0);)         sprintf(titlestr, "User Access");*         sprintf(Buffer,*O                 "Insufficient privilege to read EVERY file on system.\n%s%s%s",dP                     "This NOT a fatal condition. Continued usage may display\n",O                     "occasional access messages. Add READALL priv or define\n", T                     "VF_NOPRIVCHECK TRUE to eliminate this popup at image startup");&         WarnPopup(&Buffer, &titlestr);         Buffer[0] = '\0';*     }* }     N /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  *    Function: RemoveCacheItemeE  * Description: User has selected a list item from the cache list andxF  *              then selected the Remove button. The callback routine H  *              has determined the list position and the string at that K  *              position, passed to us as *DeleteItem. Create an ascii copy G  *              of the cache list, find the matching string, clear that G  *              location and move all upstream items down one position.rL  *              Then write tha ascii list back to the compound string array.D  *              This routine simulates the Motif XmListRemoveItem().  *O  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */l& void RemoveCacheItem(char *DeleteItem) {      int done = 0;a     int indx = 0;S     int rindx = 0;     int status;      char *PathStr;  H         /* copy each CsCacheList compound string into the ascii array */  /     memset(&CacheArray, 0, sizeof(CacheArray)); 1     for(indx = 0; indx < NumCacheItems; indx++) {LG         status = XmStringGetLtoR(CsCacheList[indx], charset, &PathStr);i*         strcpy(CacheArray[indx], PathStr);     }e  A         /* find the alphabetic location for new string and insert @            new string, moving the remainder down in the array */  
     indx = 0; 6     while(strcmp(DeleteItem, CacheArray[indx]) != 0 &&%         indx < NumCacheItems) indx++;d;     memset(&CacheArray[indx], 0, sizeof(CacheArray[indx]));      rindx = indx+1;_"     while(rindx < NumCacheItems) {4         strcpy(CacheArray[indx], CacheArray[rindx]);         indx++;          rindx++;     }t<     memset(&CacheArray[indx], 0, sizeof(CacheArray[rindx]));  E         /* free all XmStrings in CsCacheList so we can reload them */f  0     for(indx = 0; indx < NumCacheItems; indx++) (         XmStringFree(CsCacheList[indx]);  A         /* now copy the contents of the ascii array into to cachet4            compound string list in the same order */       NumCacheItems--;1     for(indx = 0; indx < NumCacheItems; indx++) {tJ         CsCacheList[indx] = XmStringCreateLtoR(CacheArray[indx], charset);J         XtFree(CacheArray[indx]);   /* XmStringGetLtoR allocates memory */     }t  2         /* inform Cache widget about the change */  4     sprintf(CacheUsageStr, "Cache Usage: %2d of %d",         NumCacheItems, MAXCSH);a
     n = 0;)     XtSetArg(args[n], XmNlistLabelString,N9         XmStringCreateLtoR(CacheUsageStr, charset)); n++;;<     XtSetArg(args[n], XmNlistItemCount, NumCacheItems); n++;6     XtSetArg(args[n], XmNlistItems, CsCacheList); n++;#     XtSetValues(CacheDlg, args, n);      Modified = True;     NewAscCacheList();     XmUpdateDisplay(CacheDlg); }O      N /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  *    Function: AddCacheItemE  * Description: The flag AutoCacheAdd is True, so the cache logic has J  *              finally called us to add a filepath to the Cache list and K  *              has provided the new path as *NewItem. Create an ascii copySH  *              of the cache list, find the position to insert new path,J  *              move subsequnt items down one slot in memory and inset newF  *              item. Convert ascii list to a compound string list andH  *              notify list widget of the change. This routine simulates3  *              the Motif XmListAddItem() function.;  *O  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */f  void AddCacheItem(char *NewItem) {h     int done = 0;e     int indx = 0;i     int rindx = 0;     int status = 0;r     int UpperBound = 0;l     int LowerBound = 0;      char *PathStr;     char *ptr;  H         /* copy each CsCacheList compound string into the ascii array */  /     memset(&CacheArray, 0, sizeof(CacheArray)); 1     for(indx = 0; indx < NumCacheItems; indx++) { G         status = XmStringGetLtoR(CsCacheList[indx], charset, &PathStr); *         strcpy(CacheArray[indx], PathStr);     }   A         /* find the alphabetic location for new string and insertt@            new string, moving the remainder down in the array */  
     indx = 0;      while(!done) {L         if(!strlen(CacheArray[indx])) {  /* only used when array is empty */.             strcpy(CacheArray[indx], NewItem);             done = TRUE;             break;	         }e3         if(strcmp(NewItem, CacheArray[indx]) > 0) {e:             while(strcmp(NewItem, CacheArray[indx]) > 0 &&-                 indx < NumCacheItems) indx++;)"             rindx = NumCacheItems;!             while(rindx > indx) { ?                 strcpy(CacheArray[rindx], CacheArray[rindx-1]);                  rindx--;I                 memset(&CacheArray[rindx], 0, sizeof(CacheArray[rindx])); 
             } .             strcpy(CacheArray[indx], NewItem);             done = TRUE;	         }          else {"             rindx = NumCacheItems;!             while(rindx > indx) { ?                 strcpy(CacheArray[rindx], CacheArray[rindx-1]);                  rindx--;I                 memset(&CacheArray[rindx], 0, sizeof(CacheArray[rindx]));t
             }I.             strcpy(CacheArray[indx], NewItem);             done = TRUE;	         }e     }   E         /* free all XmStrings in CsCacheList so we can reload them */s  0     for(indx = 0; indx < NumCacheItems; indx++) (         XmStringFree(CsCacheList[indx]);  ;         /* now copy the contents of the array into to cache 4            compound string list in the same order */       NumCacheItems++;1     for(indx = 0; indx < NumCacheItems; indx++) {uJ         CsCacheList[indx] = XmStringCreateLtoR(CacheArray[indx], charset);J         XtFree(CacheArray[indx]);   /* XmStringGetLtoR allocates memory */     }e  2         /* inform Cache widget about the change */  4     sprintf(CacheUsageStr, "Cache Usage: %2d of %d",         NumCacheItems, MAXCSH);*
     n = 0;)     XtSetArg(args[n], XmNlistLabelString, 9         XmStringCreateLtoR(CacheUsageStr, charset)); n++;C<     XtSetArg(args[n], XmNlistItemCount, NumCacheItems); n++;6     XtSetArg(args[n], XmNlistItems, CsCacheList); n++;#     XtSetValues(CacheDlg, args, n);a     Modified = True;     NewAscCacheList();     XmUpdateDisplay(CacheDlg); }*  