J /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *<  *                %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%\=  *                %% \___________________________________%% \ >  *                %% |                                   %%  \?  *                %% |              ViewFile             %%   \ @  *                %% |          ViewFile.c  c2004        %%    \@  *                %% |            Lyle W. West           %%    |@  *                %% |                                   %%    |@  *                %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%    |@  *                \                                        \   |@  *                 \                                        \  |@  *                  \                                        \ |@  *                   \________________________________________\|  *  *  *A  *     Copyright (C) 2001-2004 Lyle W. West, All Rights Reserved. K  *     Permission is granted to copy and use this program provided [1] this K  *     copyright notice is preserved, and [2] no financial gain is involved K  *     in copying the program.  This program may not be sold as "shareware" J  *     or "public domain" software without the express, written permission  *     of the author.   *K  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */    #include "version.h" #pragma module ViewFile VERSION    #include  <stdio.h>  #include  <descrip.h>  #include  <fcntl.h>  #include  <iodef.h>  #include  <jpidef.h> #include  <lnmdef.h> #include  <psldef.h> #include  <ssdef.h>  #include  <starlet.h>  #include  <stdlib.h> #include  <string.h> #include  <types.h>  #include  <unixio.h> #include  <X11/dxmhelpb.h> #include  <X11/Xlib.h> #include  <X11/Keysymdef.h>  #include  <Xm/Xm.h>  #include  <Xm/ArrowB.h>  #include  <Xm/BulletinB.h> #include  <Xm/Command.h> #include  <Xm/DialogS.h> #include  <Xm/Form.h>  #include  <Xm/FileSB.h>  #include  <Xm/Label.h> #include  <Xm/LabelG.h>  #include  <Xm/MainW.h> #include  <Xm/MessageB.h>  #include  <Xm/MenuShell.h> #include  <Xm/PushB.h> #include  <Xm/PushBG.h>  #include  <Xm/RowColumn.h> #include  <Xm/ScrollBar.h> #include  <Xm/ScrolledW.h> #include  <Xm/ScrolledWP.h>  #include  <Xm/SelectioB.h> #include  <Xm/Text.h>  #include  <Xm/TextF.h> #include  "defs.h" #include  "viewfile.xbm"  D int CacheItemPos;           /* cache list, selected item position */F int CacheSelPos;            /* position in cache list last selected */G int FsbSelectPos;           /* fsb files list selected item position */ B int MotionCount;            /* used for search and mouse hilite */= int NumCacheItems;          /* cache list, number of items */ : int NumFound;               /* number of search matches */@ int NumRecallItems;         /* says how full recall buffer is */E int RecallItemPos;          /* recall list, selected item position */ G int RecallSelPos;           /* position in recall list last selected */ B int ViewFileSize;           /* size in bytes of target viewfile */D int n;                      /* number of XtSetArg values declared */  = Boolean AutoCacheAdd;       /* add filepaths to cache list */ < Boolean AutoFilter;         /* auto Filter enabled if set */6 Boolean CacheEnable;        /* Cache enabled if set */G Boolean ChangeDirFlag;      /* user selected ChangeDir option button */ @ Boolean CheckPrivs;         /* verify user has READALL if set */: Boolean FindReverseFlg;     /* if set, search backwards */F Boolean FindStrFlag;        /* user selected the Find option button */H Boolean FirstPass;          /* indicates first pattern search in file */B Boolean GetAllFiles;        /* show all filetypes in fsb if set */< Boolean HelpEnable;         /* Help dialog enabled if set */< Boolean LoadCacheFile;      /* cache file load at startup */@ Boolean Modified;           /* cache list modified, not saved */A Boolean NoMoreMatch;        /* no more matching search strings */ < Boolean OpenErr;            /* indicates fatal open error */> Boolean OmitVersions;       /* file versions omitted if set */4 Boolean SeaHiliteRev;       /* search hilite type */6 Boolean ViewPathSet;        /* fsb default path set */    : char Buffer[1024];          /* general character buffer */J char CacheArray[MAXCSH][80]; /* Ascii array for Cache add, delete, load */D char CacheFileSpec[80];     /* file specified to load Cache array */H char CachePhysPath[80];     /* physical path string of a logical path */3 char CacheUsageStr[40];     /* items vs maxitems */ > char FilterPattern[30];     /* fsb filter reference pattern */5 char FindStrTxt[80];        /* ascii search string */ D char LastInpDlgTxt[80];     /* last filter str from motion/modify */D char LnmEquivStr[80];       /* input/output string for CheckLnm() */? char RecallArray[11][80];   /* Ascii array for recall lookup */ B char ViewFileHelpLib[80];   /* file specified for ViewFile help */@ char ViewFilePath[132];     /* full filespec without filename */= char ViewFileSpec[132];     /* full filespec with filename */ ? char ViewFileStr[132];      /* input filename for ViewWindow */   C String InpDlgTxt;           /* General purpose character pointer */   E XmString CpStr;             /* General purpose compound str widget */ ? XmString CsButtonStr;       /* General purpose button widget */ > XmString CsCancelStr;       /* General purpose button label */> XmString CsHelpStr;         /* General purpose button label */> XmString CsLabelStr;        /* General purpose label widget */@ XmString CsMessageStr;      /* General purpose message widget */> XmString CsOkStr;           /* General purpose button label */A XmString CsTitleStr;        /* General purpose titlestr widget */   < XmString CsCacheList[MAXCSH];   /* Cache Cs filepath list */  B XmTextPosition EofPos;      /* find string end of file position */; XmTextPosition LastPos;     /* find string last position */ ? XmTextPosition PrevPos;     /* find string previous position */ < XmTextPosition StartPos;    /* find string start position */  C XmStringCharSet charset = (XmStringCharSet) XmFONTLIST_DEFAULT_TAG;   ? Arg args[25];               /* structure for XtSetArg values */ @ Display *dpy;               /* viewfile X11 display structure */  = Widget AddPathBtn;          /* cache addpath toggle button */ ? Widget AutoFilterBtn;       /* fsb auto filter toggle button */ 4 Widget CacheDlg;            /* Cache popup dialog */3 Widget CacheListw;          /* Cache list widget */ D Widget ChangeDirDlg;        /* dialog widget for Change Dir popup */B Widget ChangeDirTextw;      /* text widget for Change Dir popup */ Widget CmdOptMenu; Widget CmdOptions[NUMCMDS]; > Widget CurFileTextw;        /* dynamic Filespec ViewFileLbl */A Widget DownBtn;             /* down arrow button (main window) */ 4 Widget ErrorPopDlg;         /* error popup dialog */J Widget ExitDlg;             /* exit verify popup for unsaved cache list */A Widget FindBtn;             /* Find button in FindStrDlg popup */ < Widget FindReverseBtn;      /* Find Reverse toggle button */B Widget FindStrDlg;          /* dialog widget for Find Str popup */< Widget FindStrTextw;        /* text widget for FindStrDlg */: Widget FoundLbl;            /* number of search matches *// Widget FsbClearBtn;         /* Fsb apply btn */ . Widget FsbDirListw;         /* Fsb dir list */0 Widget FsbFileListw;        /* Fsb files list */0 Widget FsbFilterBtn;        /* Fsb filter btn */1 Widget FsbFilterTextw;      /* Fsb Filter Text */ 2 Widget FsbPopupDlg;         /* Fsb dialog popup */G Widget FsbTextw;            /* Fsb file selected text (file to load) */ 0 Widget HelpDlg;             /* DxmHelp dialog */9 Widget OpenBtn;             /* init/manage FsbPopupDlg */ ? Widget OptRowCol;           /* parent rowcol for Option Menu */ 8 Widget RecallDlg;           /* RecallDlg popup dialog */0 Widget RecallListw;         /* RecallDlg list */0 Widget RecallTextw;         /* RecallDlg text */< Widget RemoveBtn;           /* Cache dialog Remove button */4 Widget SaveBtn;             /* Recall Save button */; Widget SaveDlg;             /* save Cache array contents */ ; Widget SearchBtn;           /* init/manage search dialog */ C Widget SearchFromBtn;       /* search from begiining/end of file */ 3 Widget ShowLnmDlg;          /* ShowFlags() popup */ K Widget TargetTxtTmp;        /* copy of ViewWindow text widget for search */ ; Widget TopParent;           /* application highest level */ 1 Widget UpBtn;               /* up arrow button */ 7 Widget ViewfileLbl;         /* static ViewFile label */ 9 Widget ViewWindow;          /* viewfile display window */ E Widget ViewWindowVsb;       /* viewfile display window V scrollbar */ 6 Widget WarnPop;             /* warning popup dialog */   FILE *CacheFp;
 FILE *ViewFp;    FILE_LST  *AscFileList;  CACHE_LST *AscCacheList;   char *fallbackResources[] = {    "ViewFile*borderWidth: 0",&   "ViewFile.geometry: 700x460+10+220",N   "ViewFile*fontList: -adobe-helvetica-bold-r-normal--12-*-*-*-*-*-iso8859-1",^   "ViewFile*ViewWindow*fontList: -dec-terminal-medium-r-normal--14-100-100-100-c-8-iso8859-1",$   "ViewFile*ViewWindow*columns: 80",+   "ViewFile*ErrorPopup*geometry: +260+385", _   "ViewFile*InfoPopDlg*fontList: -dec-terminal-medium-r-normal--14-100-100-100-c-80-iso8859-1", a   "ViewFile*DisplayTextW*fontList: -dec-terminal-medium-r-normal--14-100-100-100-c-80-iso8859-1", V   "ViewFile*HelpDlg*fontList: -adobe-helvetica-bold-r-normal--12-*-*-*-*-*-iso8859-1",   "ViewFile*selectColor: Blue",    NULL };   extern void CheckPrv();  extern void EventHandler();  extern void FileSelectCB();  extern void InitFsbDlg();  extern void InitCacheDlg();  extern void InitRecallDlg(); extern void LoadViewFile();  extern void OptionMenuCB();  extern void CacheDlgCB();  extern void CacheSort(); extern void ReformatCache(); extern void CloseDlgCB();  extern void RecallDlgCB(); extern void ResponseCB();  extern void ScanFiletypes();     int main(int argc, char **argv)  {      int status;      char AppTitleBuf[80];      char IconName[80];     char *ptr;     Widget toplevel;     XtAppContext app_context;   K         /* check for GETALLFILES logical, default no getallfiles (clear) */   *     strcpy(LnmEquivStr, "VF_GETALLFILES");$     status = CheckLnm(&LnmEquivStr);     if(status == SS$_NORMAL) {@         if(strcmp(LnmEquivStr, "TRUE") == 0) GetAllFiles = TRUE;     }   I         /* check for AUTOFILTER logical, default no autofilter (clear) */   )     strcpy(LnmEquivStr, "VF_AUTOFILTER"); $     status = CheckLnm(&LnmEquivStr);     if(status == SS$_NORMAL) {?         if(strcmp(LnmEquivStr, "TRUE") == 0) AutoFilter = TRUE;      }   M         /* check for HILITEREVERSE logical, default is HILITEUNDER (clear) */   ,     strcpy(LnmEquivStr, "VF_HILITEREVERSE");$     status = CheckLnm(&LnmEquivStr);     if(status == SS$_NORMAL) {A         if(strcmp(LnmEquivStr, "TRUE") == 0) SeaHiliteRev = TRUE;      }   D         /* check for HELPENABLE logical, default is Help disabled */  )     strcpy(LnmEquivStr, "VF_HELPENABLE"); $     status = CheckLnm(&LnmEquivStr);     if(status == SS$_NORMAL) {?         if(strcmp(LnmEquivStr, "TRUE") == 0) HelpEnable = TRUE;           else HelpEnable = FALSE;     }   G         /* check for HELPLIB logical, regardless of HelpEnable state */   &     strcpy(LnmEquivStr, "VF_HELPLIB");$     status = CheckLnm(&LnmEquivStr);B     if(status == SS$_NORMAL) strcpy(ViewFileHelpLib, LnmEquivStr);D     else strcpy(ViewFileHelpLib, "DECW$USER_DEFAULTS:VIEWFILE.HLB");  F         /* check for NOPRIVCHECK logical, default is to check privs */  *     strcpy(LnmEquivStr, "VF_NOPRIVCHECK");$     status = CheckLnm(&LnmEquivStr);     if(status == SS$_NORMAL) {@         if(strcmp(LnmEquivStr, "TRUE") == 0) CheckPrivs = FALSE;         else CheckPrivs = TRUE;      }      else CheckPrivs = TRUE;   H         /* check for CACHE_ENABLE logical, default enable Cache (set) */  +     strcpy(LnmEquivStr, "VF_CACHE-ENABLE"); $     status = CheckLnm(&LnmEquivStr);     if(status == SS$_NORMAL) {.         if(strcmp(LnmEquivStr, "TRUE") == 0) {<             CacheEnable = TRUE;    /* enable cache option */@             AutoCacheAdd = FALSE;  /* don't add to cache list */	         } !         else CacheEnable = FALSE;      }      else CacheEnable = FALSE;     >     /* Following logicals are tested only if cache is enabled,0        otherwise their values are unimportant */       if(CacheEnable) { D         /* check for CACHEFILE logical, else use default filespec */  ,         strcpy(LnmEquivStr, "VF_CACHEFILE");(         status = CheckLnm(&LnmEquivStr);D         if(status == SS$_NORMAL) strcpy(CacheFileSpec, LnmEquivStr);F         else strcpy(CacheFileSpec, "DECW$USER_DEFAULTS:VIEWFILE.VFR");  F         /* check for CACHEADD logical, default disable AutoCacheAdd */  +         strcpy(LnmEquivStr, "VF_CACHEADD"); (         status = CheckLnm(&LnmEquivStr);"         if(status == SS$_NORMAL) {E             if(strcmp(LnmEquivStr, "TRUE") == 0) AutoCacheAdd = TRUE; &             else AutoCacheAdd = FALSE;	         } "         else AutoCacheAdd = FALSE;  @         /* check for CACHELOAD logical, default False (clear) */  ,         strcpy(LnmEquivStr, "VF_CACHELOAD");(         status = CheckLnm(&LnmEquivStr);"         if(status == SS$_NORMAL) {2             if(strcmp(LnmEquivStr, "TRUE") == 0) {%                 LoadCacheFile = True; 
             } 	         }      }   >         /* if input file specified on command line, load it */       if (argc == 2) {&         strcpy(ViewFileSpec, argv[1]);         if(OmitVersions) {,             ptr = strchr(ViewFileSpec, ';');              if(ptr) *ptr = '\0';	         }      }   8         /* Get the name of the node we are running on */  K     strcpy(LnmEquivStr, "SYS$NET_SERVICES_3");  /* vms version dependant */ $     status = CheckLnm(&LnmEquivStr);     ptr = &LnmEquivStr[1];     while(*ptr) {          *ptr = tolower(*ptr);          ptr++;     }      ;         /* Initialize toolkit and set fallback resources */   B     toplevel = XtAppInitialize (&app_context, "ViewFile", NULL, 0,J                                 &argc, argv, &fallbackResources, args, 0);       dpy = XtDisplay(toplevel);  :         /*  Set toplevel title, icon pix, and icon name */  9     sprintf(AppTitleBuf," ViewFile on %s ", LnmEquivStr); )     sprintf(IconName, "%s", LnmEquivStr);   
     n = 0;2     XtSetArg(args[n], XmNtitle, AppTitleBuf); n++;2     XtSetArg(args[n], XmNiconName, IconName); n++;$     XtSetArg(args[n], XmNiconPixmap,6             XCreateBitmapFromData(XtDisplay(toplevel),3             RootWindowOfScreen(XtScreen(toplevel)),              viewfile_bits,             viewfile_width, #             viewfile_height)); n++; $     XtSetValues (toplevel, args, n);  ?         /*  Create a bulletinboard widget as the main window */   
     n = 0;$     XtSetArg(args[n], XmNx,10); n++;%     XtSetArg(args[n], XmNy,220); n++; +     XtSetArg(args[n], XmNheight, 460); n++; *     XtSetArg(args[n], XmNwidth, 700); n++;6     XtSetArg(args[n], XmNhighlightOnEnter, True); n++;.     XtSetArg(args[n], XmNnoResize, True); n++;;     XtSetArg(args[n], XmNresizePolicy, XmRESIZE_NONE); n++; F     TopParent = XmCreateBulletinBoard(toplevel, "TopParent", args, n);     XtManageChild(TopParent);   M     if(CheckPrivs) CheckPrv(); /* ideally user can read any file on system */        InitMainWindow(); #     if(CacheEnable) InitCacheDlg();      InitFsbDlg();      InitRecallDlg();  !     if(argc == 2) LoadViewFile();      XtRealizeWidget(toplevel);  O     XtInsertEventHandler(ViewWindow,     /* add event handler to this widget */ >                          KeyPressMask,   /* event to handle */O                          False,          /* call handler when nonmaskable event 7                                             arrives? */ E                          EventHandler,   /* event handler function */ K                          NULL,           /* data passed to event handler */ K                          XtListHead);    /* add before existing handlers */      XtAppMainLoop(app_context);  }       N /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  *    Function: CheckFileType D  * Description: Attempt to determine if selected file is actually anG  *              ascii file. Determination is based on the record format%D  *              info returned by fstat() and also by the actual fileA  *              type string of the target file. Files of specific H  *              formats and types automatically generate a warning popupE  *              leaving the user to decide whether to display or not.   *O  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */  int CheckFileType()  {      int retval = 0;      int fd = 0;      struct stat rms_info;%     char nambuf[80];     char typbuf[32];     char titlestr[80];     char *ptr = 0;  9         /* get filestat info into 'rms_info' structure */   )     fd = open(ViewFileSpec, O_RDONLY, 0);      if(fd == -1) {         DoBell(0);-         sprintf(titlestr, "File Open Error");_=         sprintf(Buffer, "Unable to open input file:\n'%s'%s",sK                 ViewFileSpec,"\nfor read. Please verify correct filespec");r-         ErrorPopup(&Buffer, &titlestr, TRUE);c         Buffer[0] = '\0';f,         XmTextSetString(ViewWindow, Buffer);         OpenErr = TRUE;m         return(fd);s     }e+     memset(&rms_info, 0, sizeof(rms_info));t"     retval = fstat(fd, &rms_info);     close(fd);  .         /* now get filetype string (suffix) */  *$     ptr = strchr(ViewFileSpec, ']');<     if(ptr) {                   /* we have full path info */         ptr++;=         strcpy(nambuf, ptr);    /* filename has been saved */h"         ptr = strchr(nambuf, '.');         if(ptr) {e             ptr++;9             strcpy(typbuf, ptr);    /* so has filetype */>	         }      }.@     else {                      /* we have just filename info */(         ptr = strchr(ViewFileSpec, '.');         if(ptr) {              *ptr = 0; A             strcpy(nambuf, ptr);    /* filename has been saved *//             *ptr = '.';/             ptr++;              strcpy(typbuf, ptr);	         }c     }X  !     switch(rms_info.st_fab_rfm) { D         case FAB$C_UDF:         /* undefined (also stream binary) */T         case FAB$C_STM:         /* RMS-11 stream (valid only for sequential org)  */O         case FAB$C_STMLF:       /* LF stream (valid only for sequential org) */PO         case FAB$C_STMCR:       /* CR stream (valid only for sequential org) */ D             if(!strcmp(typbuf, "CARD") || !strcmp(typbuf, "card")) {0                 ViewFileSize = rms_info.st_size;                 return(FALSE);
             }l             break;  :         case FAB$C_FIX:         /* fixed length records */B             if(!strcmp(typbuf, "EXE") || !strcmp(typbuf, "exe")) {0                 ViewFileSize = rms_info.st_size;                 return(FALSE);
             }              break;  =         case FAB$C_VAR:         /* variable length records */r<         case FAB$C_VFC:         /* variable fixed control */B             if(!strcmp(typbuf, "OBJ") || !strcmp(typbuf, "obj")) {0                 ViewFileSize = rms_info.st_size;                 return(FALSE);
             }l             break;     } $     ViewFileSize = rms_info.st_size;     return(TRUE);  }o    N /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  *    Function: LoadViewFileB  * Description: User entered a filename on commandline or selectedE  *              a file from the File Selection Popup. The target filePC  *              name is currently saved in 'ViewFileSpec'. Transfers@  *              file contents to 'ViewWindow', perform necessary#  *              cleanup, and returnb  *O  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */o void LoadViewFile()  {      int status;y     char filename[80];     char pathlabel[132];     char pathstrtmp[132];e     char *ptr;     char *text;   %     strcpy(pathstrtmp, ViewFileSpec);      status = CheckFileType();s     if(status != SS$_NORMAL) {  G             /* if 'status' is -1, we had a file open error. Just ignorerI                it here, the 'OpenErr' flag has been set and when the user D                acknowledges the Error Popup, the callback forces the&                exit of the program. */           if(status != -1) {             DoBell(0);1             sprintf(pathlabel, "ViewFile Error");CH             sprintf(Buffer, "Selected file does not appear to be%s%s%s",?                     "\nan ascii file. Attempting to view this", B                     "\nfile could produce unpredictable results.",C                     "\nYou must use other tools to examine file.");e2             ErrorPopup(&Buffer, &pathlabel, TRUE);             Buffer[0] = '\0';*             strcpy(Buffer, "");s0             XmTextSetString(ViewWindow, Buffer);	         }      }m
     else {2         text = XtMalloc((unsigned)(ViewFileSize));&         memset(text, 0, ViewFileSize);5         ViewFp = fopen(ViewFileSpec, "r", "shr=get");f:         fread(text, sizeof(char), ViewFileSize+1, ViewFp);"         text[ViewFileSize] = '\0';*         XmTextSetString(ViewWindow, text);         fclose(ViewFp);          XtFree(text); (         ptr = strchr(ViewFileSpec, ']');         if(!ptr) {,             ptr = strchr(ViewFileSpec, ':');             if(!ptr) {/                 strcpy(filename, ViewFileSpec);t&                 text = getenv("PATH");+                 strcpy(ViewFileSpec, text);n/                 strcat(ViewFileSpec, filename); 
             }S	         }      }r     if(!ViewPathSet) {)         strcpy(pathstrtmp, ViewFileSpec);p&         ptr = strchr(pathstrtmp, ']');         if(ptr) {r             ptr++;"             strcpy(filename, ptr);             *ptr = '\0';	         }          else {*             ptr = strchr(pathstrtmp, ':');             if(ptr) {c                 ptr++;&                 strcpy(filename, ptr);                 ptr--;                 *ptr = '\0';/                 status = CheckLnm(&pathstrtmp);o
             }e             else {&                 text = getenv("PATH");)                 strcpy(pathstrtmp, text);g
             } 	         }iL         strcpy(ViewFilePath, pathstrtmp); /* path from disk to lowest dir */L         strcpy(ViewFileSpec, pathstrtmp); /* path from disk thru filename */'         strcat(ViewFileSpec, filename); G         strcpy(ViewFileStr, filename);    /* the actual display file */A  0         sprintf(pathlabel, " %s", ViewFileSpec);         n = 0;4         XtSetArg(args[n], XmNvalue, pathlabel); n++;+         XtSetValues(CurFileTextw, args, n);i$         XtManageChild(CurFileTextw);$         XmUpdateDisplay(ViewWindow);           n = 0;'         XtSetArg(args[n], XmNdirectory, <             XmStringCreateLtoR(ViewFilePath, charset)); n++;*         XtSetValues(FsbPopupDlg, args, n);         ViewPathSet = TRUE;      }*  0         /* move cursor to top of display file */       StartPos = 0;r0     XmTextSetTopCharacter(ViewWindow, StartPos);C     XtSetSensitive(CmdOptions[2], True);   /* 'File Info' button */  }*    N /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  *    Function: InitFsbDlgI  * Description: Create and initialize file selection box for loading text G  *              files into the ViewWindow widget. This includes to non-eI  *              statnt selection box option of a togglebutton widget usediF  *              to control display of rms verion info of target files.  *O  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */i void InitFsbDlg()F {F     char actionstr[80];b     XmString CsAction;     XmString CpStr;g     Widget FsbHelp, OptionsLbl;l     Widget rowcol_v, rowcol_h;  =         /* create File Selection box for 'Open' pushbutton */B  
     n = 0;&     XtSetArg(args[n], XmNx, 150); n++;&     XtSetArg(args[n], XmNy, 260); n++;*     XtSetArg(args[n], XmNwidth, 365); n++;;     XtSetArg(args[n], XmNresizePolicy, XmRESIZE_NONE); n++; %     XtSetArg(args[n], XmNdialogTitle,wG         XmStringCreateLtoR("ViewFile Target Selection", charset)); n++;o'     XtSetArg(args[n], XmNokLabelString, 4         XmStringCreateLtoR("Select", charset)); n++;+     XtSetArg(args[n], XmNcancelLabelString,t3         XmStringCreateLtoR("Clear", charset)); n++; )     XtSetArg(args[n], XmNhelpLabelString,m3         XmStringCreateLtoR("Close", charset)); n++; +     XtSetArg(args[n], XmNfilterLabelString,m9         XmStringCreateLtoR("Filter Path", charset)); n++; .     XtSetArg(args[n], XmNselectionLabelString,?         XmStringCreateLtoR("Selected FileSpec", charset)); n++; 3     XtSetArg(args[n], XmNautoUnmanage, False); n++;*6     XtSetArg(args[n], XmNdefaultPosition, False); n++;2     XtSetArg(args[n], XmNshadowThickness, 3); n++;/     XtSetArg(args[n], XmNtextColumns, 35); n++; L     XtSetArg(args[n], XmNdialogStyle, XmDIALOG_FULL_APPLICATION_MODAL); n++;=     XtSetArg(args[n], XmNfileSearchProc, ScanFiletypes); n++;oP     FsbPopupDlg = XmCreateFileSelectionDialog(TopParent, "FsbPopupDlg",args, n);  4         /* get widget ids of selected fsb chilren */  L     FsbHelp = XmFileSelectionBoxGetChild(FsbPopupDlg, XmDIALOG_HELP_BUTTON);F     FsbTextw = XmFileSelectionBoxGetChild(FsbPopupDlg, XmDIALOG_TEXT);J     FsbFileListw = XmFileSelectionBoxGetChild(FsbPopupDlg, XmDIALOG_LIST);M     FsbDirListw = XmFileSelectionBoxGetChild(FsbPopupDlg, XmDIALOG_DIR_LIST);V:     FsbFilterBtn = XmFileSelectionBoxGetChild(FsbPopupDlg,         XmDIALOG_APPLY_BUTTON); 9     FsbClearBtn = XmFileSelectionBoxGetChild(FsbPopupDlg,m          XmDIALOG_CANCEL_BUTTON);<     FsbFilterTextw = XmFileSelectionBoxGetChild(FsbPopupDlg,         XmDIALOG_FILTER_TEXT);  B         /* define needed callback operations. Note the client data>            string constants reflect application names, not the>            official button names used in the docs/libraries */  L     XtAddCallback(FsbPopupDlg, XmNokCallback, FileSelectCB, FSB_SELECT_BTN);O     XtAddCallback(FsbPopupDlg, XmNapplyCallback, FileSelectCB, FSB_FILTER_BTN);vO     XtAddCallback(FsbPopupDlg, XmNcancelCallback, FileSelectCB, FSB_CLEAR_BTN); M     XtAddCallback(FsbPopupDlg, XmNhelpCallback, FileSelectCB, FSB_CLOSE_BTN);t  D         /* add callbacks to catch both ModifyVerify and ValueChangedG            on the fsb filter text widget. This is for the Cache and ther'            Add New Filepaths options */n       if(AutoFilter) {>         XtAddCallback(FsbFilterTextw, XmNmodifyVerifyCallback,-               FileSelectCB, FILT_MOD_VERIFY);*>         XtAddCallback(FsbFilterTextw, XmNvalueChangedCallback,.               FileSelectCB, FILT_VAL_CHANGED);     }t  2         /* create a standard vertical RowColumn */  
     n = 0;%     XtSetArg(args[n], XmNx, 20); n++;A%     XtSetArg(args[n], XmNy, 65); n++;*C     rowcol_v = XmCreateRowColumn(FsbPopupDlg, "rowcol_v", args, n);      XtManageChild(rowcol_v);  A         /* create horizontal RowColumn inside the vertical one */   
     n = 0;9     XtSetArg(args[n], XmNorientation, XmHORIZONTAL); n++;e2     XtSetArg(args[n], XmNshadowThickness, 0); n++;@     rowcol_h = XmCreateRowColumn(rowcol_v, "rowcol_h", args, n);     XtManageChild(rowcol_h);  1         /* create Auto Filtering toggle button */A  K     sprintf(actionstr, "Filter Mode - %s", AutoFilter ? "Auto" : "Normal"); 6     CsAction = XmStringCreateLtoR(actionstr, charset);  
     n = 0;5     XtSetArg(args[n], XmNlabelString, CsAction); n++;m.     XtSetArg(args[n], XmNmarginLeft, 15); n++;/     XtSetArg(args[n], XmNmarginRight, 20); n++;p+     XtSetArg(args[n], XmNspacing, 10); n++;r5     XtSetArg(args[n], XmNhighlightThickness, 0); n++;;2     XtSetArg(args[n], XmNshadowThickness, 0); n++;/     XtSetArg(args[n], XmNset, AutoFilter); n++; M     AutoFilterBtn = XmCreateToggleButton(rowcol_h, "AutoFilterBtn", args, n);N!     XtManageChild(AutoFilterBtn);v     XmStringFree(CsAction);   9     XtAddCallback(AutoFilterBtn, XmNvalueChangedCallback,C.                   FileSelectCB, AUTOFILT_BTN); }A    N /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  *    Function: CheckLnmL  * Description: Function to translate a provided logical name to the definedJ  *              equivalence string. All accessable logical name tables areK  *              searched until a match is found. If successful the returned K  *              equivalence string is copied to the memory location used to K  *              provide the input logical name (*lnmstr). In all cases, theoB  *              return status of SYS$TRNLNM is returned to caller.  *O  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */y int CheckLnm(char *lnmstr) { I     int nocase = LNM$M_CASE_BLIND;  /* resolve lnm without case issues */sK     int eqvattrb = 0;               /* returned attributes of eqv string */U     int lnmstat = 0;     short eqv_len = 0;     short tbl_len = 0;?     char acmode = PSL$C_USER;       /* always from user mode */V<     char LnmTable[80];              /* logical name table */=     char LnmDef[80];                /* logical name string */tI     char LnmEqv[80];                /* logical name equivalence string */S  >     struct {short len, code; int *bufadr, *retlen;} lnmitm[4];  %     $DESCRIPTOR(Dsc_Table, LnmTable); !     $DESCRIPTOR(Dsc_Lnm, LnmDef);i!     $DESCRIPTOR(Dsc_Eqv, LnmEqv);t  '     memset(&LnmEqv, 0, sizeof(LnmEqv));a     strcpy(LnmDef, lnmstr); %     strcpy(LnmTable, "LNM$FILE_DEV");)  .     Dsc_Table.dsc$w_length = strlen(LnmTable);'     Dsc_Table.dsc$a_pointer = LnmTable;**     Dsc_Lnm.dsc$w_length = strlen(LnmDef);#     Dsc_Lnm.dsc$a_pointer = LnmDef; *     Dsc_Eqv.dsc$w_length = sizeof(LnmEqv);#     Dsc_Eqv.dsc$a_pointer = LnmEqv;   %     lnmitm[0].len = sizeof(eqvattrb);f%     lnmitm[0].code = LNM$_ATTRIBUTES; !     lnmitm[0].bufadr = &eqvattrb;d     lnmitm[0].retlen = 0; %     lnmitm[1].len = sizeof(LnmTable);_      lnmitm[1].code = LNM$_TABLE;!     lnmitm[1].bufadr = &LnmTable;r      lnmitm[1].retlen = &tbl_len;#     lnmitm[2].len = sizeof(LnmEqv);w!     lnmitm[2].code = LNM$_STRING;      lnmitm[2].bufadr = &LnmEqv;i      lnmitm[2].retlen = &eqv_len;     lnmitm[3].len = 0;     lnmitm[3].code = 0;V  J     lnmstat = sys$trnlnm(&nocase, &Dsc_Table, &Dsc_Lnm, &acmode, &lnmitm);     if(lnmstat == SS$_NORMAL) {i         LnmEqv[eqv_len] = '\0';e!         LnmTable[tbl_len] = '\0';n         strcpy(lnmstr, LnmEqv);u     }w7     if(lnmstat & LNM$M_CONCEALED) return(SS$_NOLOGNAM);      else return(lnmstat);; }     N /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  *    Function: InitCacheDlgI  * Description: Create and initialize cache selection box. This widget is,H  *              used for reloading filepaths previously viewed but sinceI  *              superceded by another path. Currently, up to 35 filespecs H  *              are alpha sorted for easier identifcation. Filepaths areG  *              added when the fsb filter string is changed to a valid.xF  *              filepath. If LoadCacheFile is set we call LoadCache toF  *              to load the file specified in CacheFileSpec. If a loadG  *              error occurs CacheDlg initialization completes, but the]%  *              cache list is empty..g  *O  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */r void InitCacheDlg()t {a     int status = 0;e     char ToggleStr[80]; 2     Widget CacheListLblw, CacheTextw, CacheSelLbl;     Widget rowcol_v, rowcol_h;  5     sprintf(CacheUsageStr, "Cache Usage: %2d of %d",  #             NumCacheItems, MAXCSH);;       if(LoadCacheFile) {i         status = LoadCache();(         if(!status) {e"             LoadCacheFile = False;             NumCacheItems = 0;             return; 	         }rJ         sprintf(CacheUsageStr, "Usage: %2d of %d", NumCacheItems, MAXCSH);     }h  <         /* create a selection dialog for Cache operations */  
     n = 0;&     XtSetArg(args[n], XmNx, 150); n++;&     XtSetArg(args[n], XmNy, 280); n++;+     XtSetArg(args[n], XmNheight, 335); n++;/*     XtSetArg(args[n], XmNwidth, 365); n++;%     XtSetArg(args[n], XmNdialogStyle, .         XmDIALOG_FULL_APPLICATION_MODAL); n++;3     XtSetArg(args[n], XmNautoUnmanage, False); n++;*6     XtSetArg(args[n], XmNdefaultPosition, False); n++;8     XtSetArg(args[n], XmNlistVisibleItemCount, 10); n++;;     XtSetArg(args[n], XmNresizePolicy, XmRESIZE_NONE); n++;s2     XtSetArg(args[n], XmNshadowThickness, 3); n++;     if(LoadCacheFile) {r:         XtSetArg(args[n], XmNlistItems, CsCacheList); n++;@         XtSetArg(args[n], XmNlistItemCount, NumCacheItems); n++;     }o
     else {0         XtSetArg(args[n], XmNlistItems, 0); n++;4         XtSetArg(args[n], XmNlistItemCount, 0); n++;     }t%     XtSetArg(args[n], XmNdialogTitle,*>         XmStringCreateLtoR("Cache Repository", charset)); n++;2     XtSetArg(args[n], XmNshadowThickness, 3); n++;'     XtSetArg(args[n], XmNokLabelString,u4         XmStringCreateLtoR("Select", charset)); n++;*     XtSetArg(args[n], XmNapplyLabelString,4         XmStringCreateLtoR("Remove", charset)); n++;+     XtSetArg(args[n], XmNcancelLabelString,)2         XmStringCreateLtoR("Save", charset)); n++;)     XtSetArg(args[n], XmNhelpLabelString, 3         XmStringCreateLtoR("Close", charset)); n++; )     XtSetArg(args[n], XmNlistLabelString,o9         XmStringCreateLtoR(CacheUsageStr, charset)); n++;TL     XtSetArg(args[n], XmNdialogStyle, XmDIALOG_FULL_APPLICATION_MODAL); n++;G     CacheDlg = XmCreateSelectionDialog(TopParent, "CacheDlg", args, n);m  5         /* get widget ids of selectionbox children */m  A     CacheListw = XmSelectionBoxGetChild(CacheDlg, XmDIALOG_LIST);xJ     CacheListLblw = XmSelectionBoxGetChild(CacheDlg, XmDIALOG_LIST_LABEL);M     CacheSelLbl = XmSelectionBoxGetChild(CacheDlg, XmDIALOG_SELECTION_LABEL); A     CacheTextw = XmSelectionBoxGetChild(CacheDlg, XmDIALOG_TEXT);;H     RemoveBtn = XmSelectionBoxGetChild(CacheDlg, XmDIALOG_APPLY_BUTTON);!     XtUnmanageChild(CacheSelLbl);       XtUnmanageChild(CacheTextw);%     XtSetSensitive(RemoveBtn, False);   /         /* add pushbutton and list callbacks */   G     XtAddCallback(CacheDlg, XmNokCallback, CacheDlgCB, CSH_SELECT_BTN);*J     XtAddCallback(CacheDlg, XmNapplyCallback, CacheDlgCB, CSH_REMOVE_BTN);I     XtAddCallback(CacheDlg, XmNcancelCallback, CacheDlgCB, CSH_SAVE_BTN);.H     XtAddCallback(CacheDlg, XmNhelpCallback, CacheDlgCB, CSH_CLOSE_BTN);9     XtAddCallback(CacheListw, XmNbrowseSelectionCallback,m#         CacheDlgCB, CSH_ITEM_SEL);    2         /* create a standard vertical RowColumn */  
     n = 0;%     XtSetArg(args[n], XmNx, 20); n++; &     XtSetArg(args[n], XmNy, 205); n++;@     rowcol_v = XmCreateRowColumn(CacheDlg, "rowcol_v", args, n);     XtManageChild(rowcol_v);  A         /* create horizontal RowColumn inside the vertical one */;  
     n = 0;9     XtSetArg(args[n], XmNorientation, XmHORIZONTAL); n++;*2     XtSetArg(args[n], XmNshadowThickness, 0); n++;*     XtSetArg(args[n], XmNheight, 55); n++;@     rowcol_h = XmCreateRowColumn(rowcol_v, "rowcol_h", args, n);     XtManageChild(rowcol_h);  0         /* create Add Filepaths toggle button */  1     sprintf(ToggleStr, "Auto Add Filepaths - %s",V8                 AutoCacheAdd ? "Enabled" : "Disabled ");3     CpStr = XmStringCreateLtoR(ToggleStr, charset);   
     n = 0;2     XtSetArg(args[n], XmNlabelString, CpStr); n++;5     XtSetArg(args[n], XmNhighlightThickness, 0); n++; 1     XtSetArg(args[n], XmNset, AutoCacheAdd); n++;T/     XtSetArg(args[n], XmNmarginRight, 20); n++;*+     XtSetArg(args[n], XmNspacing, 10); n++; 2     XtSetArg(args[n], XmNshadowThickness, 0); n++;G     AddPathBtn = XmCreateToggleButton(rowcol_h, "AddPathBtn", args, n);f     XtManageChild(AddPathBtn);     XmStringFree(CpStr);  6     XtAddCallback(AddPathBtn, XmNvalueChangedCallback,+                   ResponseCB, ADDPATH_BTN);w       NewAscCacheList(); }     N /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  *    Function: InitHelpDlgoG  * Description: Create the help dialog. ViewFile uses the DxmHelpdialogrE  *              widget from the DECwindows Toolkit Extensions group. *G  *              Although DxmHelp was designed to be called in a multui-yG  *              level pulldown menubar setup, most of the features have1A  *              been implemented by calling from the Option menu.h  *O  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */o void InitHelpDlg() {o     char HlpStr[50];     XmString CsOverview;     XmString CsNoHlbMsg;  6         /* create some comp strs regarding help lib */  +     sprintf(HlpStr, "%s", ViewFileHelpLib);f)     CpStr = XmStringCreateSimple(HlpStr);s&     sprintf(HlpStr, "%s", "Overview");.     CsOverview = XmStringCreateSimple(HlpStr);.     sprintf(HlpStr, "Cannot open VF_HELPLIB");.     CsNoHlbMsg = XmStringCreateSimple(HlpStr);  6         /* create the Help widget with some options */  
     n = 0;%     XtSetArg(args[n], XmNx, 20); n++; %     XtSetArg(args[n], XmNy, 20); n++; *     XtSetArg(args[n], DXmNapplicationName,/         XmStringCreateSimple("ViewFile")); n++;l%     XtSetArg(args[n], DXmNcloseLabel, ,         XmStringCreateSimple("Close")); n++;3     XtSetArg(args[n], DXmNlibrarySpec, CpStr); n++;a:     XtSetArg(args[n], DXmNbadlibMessage, CsNoHlbMsg); n++;7     XtSetArg(args[n], DXmNdefaultPosition, False); n++;w7     XtSetArg(args[n], DXmNfirstTopic, CsOverview); n++; 2     XtSetArg(args[n], XmNshadowThickness, 3); n++;1     XtSetArg(args[n], XmNfontList, charset); n++;'A     HelpDlg = DXmCreateHelpDialog(TopParent, "DxmHelp", args, n);F     XtManageChild(HelpDlg);e  $         /* Add the unmap callback */  I     XtAddCallback(HelpDlg, XmNunmapCallback, CloseDlgCB, HELP_CLOSE_BTN);      XmStringFree(CpStr);     XmStringFree(CsNoHlbMsg);{ }         N /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  *    Function: InitRecallDlg J  * Description: Create and initialize recall selection box. This widget isF  *              used for loading filepaths previously viewed but sinceM  *              superceded by another file. Currently, up to MAXRCL filespecs L  *              can be stored until the oldest is over written by the newst.O  *              A filepath are added when the File Selection 'Select' button isnM  *              pressed. Unlike the Cache, there is no provision to load the  K  *              circular buffer externally. While the user is not obligated <  *              to use this function, it cannot be disabled.  *O  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */S void InitRecallDlg() {a     int status = 0;A     char ToggleStr[80];a(     Widget RecallListLblw, RecallSelLbl;     Widget RecallLisLbl;  =         /* create a selection dialog for Recall operations */r  
     n = 0;*     XtSetArg(args[n], XmNwidth, 480); n++;%     XtSetArg(args[n], XmNdialogStyle, 2             XmDIALOG_FULL_APPLICATION_MODAL); n++;0     XtSetArg(args[n], XmNmarginHeight, 15); n++;/     XtSetArg(args[n], XmNmarginWidth, 15); n++;;3     XtSetArg(args[n], XmNautoUnmanage, False); n++;m5     XtSetArg(args[n], XmNdefaultPosition, True); n++;08     XtSetArg(args[n], XmNlistVisibleItemCount, 10); n++;;     XtSetArg(args[n], XmNresizePolicy, XmRESIZE_NONE); n++;*,     XtSetArg(args[n], XmNlistItems, 0); n++;0     XtSetArg(args[n], XmNlistItemCount, 0); n++;2     XtSetArg(args[n], XmNshadowThickness, 3); n++;%     XtSetArg(args[n], XmNdialogTitle,a@             XmStringCreateLtoR("Recall History", charset)); n++;2     XtSetArg(args[n], XmNshadowThickness, 3); n++;'     XtSetArg(args[n], XmNokLabelString,i8             XmStringCreateLtoR("Select", charset)); n++;*     XtSetArg(args[n], XmNapplyLabelString,
 #ifdef ARF6             XmStringCreateLtoR("Keep", charset)); n++; #elseFD         /* keep -> retain, preserve, save, stash, store, transfer */6             XmStringCreateLtoR("Save", charset)); n++; #endif+     XtSetArg(args[n], XmNcancelLabelString,b7             XmStringCreateLtoR("Clear", charset)); n++;a)     XtSetArg(args[n], XmNhelpLabelString,[7             XmStringCreateLtoR("Close", charset)); n++;)L     XtSetArg(args[n], XmNdialogStyle, XmDIALOG_FULL_APPLICATION_MODAL); n++;I     RecallDlg = XmCreateSelectionDialog(TopParent, "RecallDlg", args, n);   5         /* get widget ids of selectionbox children */L  C     RecallListw = XmSelectionBoxGetChild(RecallDlg, XmDIALOG_LIST); L     RecallListLblw = XmSelectionBoxGetChild(RecallDlg, XmDIALOG_LIST_LABEL);O     RecallSelLbl = XmSelectionBoxGetChild(RecallDlg, XmDIALOG_SELECTION_LABEL);aC     RecallTextw = XmSelectionBoxGetChild(RecallDlg, XmDIALOG_TEXT);lJ     RecallLisLbl = XmSelectionBoxGetChild(RecallDlg, XmDIALOG_LIST_LABEL);G     SaveBtn = XmSelectionBoxGetChild(RecallDlg, XmDIALOG_APPLY_BUTTON);e"     XtUnmanageChild(RecallSelLbl);"     XtUnmanageChild(RecallLisLbl);!     XtUnmanageChild(RecallTextw);]#     XtSetSensitive(SaveBtn, False);   /         /* add pushbutton and list callbacks */   I     XtAddCallback(RecallDlg, XmNokCallback, RecallDlgCB, RCL_SELECT_BTN);oJ     XtAddCallback(RecallDlg, XmNapplyCallback, RecallDlgCB, RCL_SAVE_BTN);L     XtAddCallback(RecallDlg, XmNcancelCallback, RecallDlgCB, RCL_CLEAR_BTN);J     XtAddCallback(RecallDlg, XmNhelpCallback, RecallDlgCB, RCL_CLOSE_BTN);:     XtAddCallback(RecallListw, XmNbrowseSelectionCallback,(             RecallDlgCB, RCL_ITEM_SEL);  }s      