'\" t
.\" the previous line makes man call tbl
.if t .po .9i
.TH XFIG 1 "Release 2.1.5 (Protocol 2.1)" "UNIX Version"
.SH NAME
xfig \- Facility for Interactive Generation of figures under X11
.SH SYNOPSIS
.B xfig
[\fIoptions\fP]
[\fIfile\fP]
.SH DESCRIPTION
.I Xfig 
is a menu-driven tool that allows the user to draw and manipulate objects
interactively in an X window.  
.B It runs under X version 11 
.B release 4 or higher
and requires a two- or three-button mouse.  
.I file 
specifies the name of a file to be edited. The description of objects in
the file will be read at the start of \fIxfig\fP. 
.PP
When using a two-button mouse
use the <Meta> key and the right button at the same time to effect 
the action of the middle button.
.PP
The \fITransFig\fP package is used to print the output from \fIxfig\fP.
.PP
Note for previous \fIxfig\fP users:
.PP
The \fIf2p\fP and \fIf2ps\fP translators have been phased out
because the \fITransFig\fP package from Micah Beck is a more general
purpose translator for more graphics languages.
The \fITransFig\fP package can be used as a back-end processor to \fIxfig\fP 
to produce various types of output:
.IP "LaTeX - "12 
\fIfig2dev -L latex\fP translates \fIxfig\fP to \fILaTeX\fP
picture environment commands which can be
processed along with other
.I LaTeX
commands.
.IP "Postscript -
\fIfig2dev -L ps\fP produces a \fIPostScript\fP output.
.IP "Pic -
\fIfig2dev -L pic\fP produces a pic output.
.IP "PiCTeX -
\fIfig2dev -L pictex\fP produces
.I PiCTeX
output.
This contains macros that can be used with the
.I PiCTeX
environment under
.I TeX
or
.I LaTeX.
.IP "Others -
\fIfig2dev\fP has options for these other languages:
\fIbox\fP,
\fIepic\fP,
\fIeepic\fP,
and \fIeepicemu\fP.
.PP
The \fITransFig\fP package is available via anonymous ftp from 
export.lcs.mit.edu in /contrib/transfig.tar.Z.
.LP
Note: \fITransFig\fP versions 2.1.4 and later support color 
output for \fIPostScript\fP.
.SH OPTIONS
.TP
\fB-geom[etry]\fP \fIWxH+X+Y\fP
Specifies the geometry for Fig application.
.TP
\fB-iconG[eometry]\fP \fI+X+Y\fP
Specifies the position for the icon.
.TP
.B \-ri[ght]
Change the position of the side panel window to the right of the canvas window
(default: left).
.TP
.B \-le[ft]
Change the position of the side panel window to the left of the canvas window.
.TP
.B \-mo[nochrome]
Use black and white only. 
.TP
.B \-L[andscape]
Make \fIxfig\fP come up in landscape mode (10" x 8").  This is the default.
.TP
.B \-P[ortrait]
Make \fIxfig\fP come up in portrait mode (8" x 9").
.TP
\fB-pw[idth]\fP \fIunits\fP
Make \fIxfig\fP come up \fIunits\fP wide (where units are either cm or in).
.TP
\fB-ph[eight]\fP \fIunits\fP
Make \fIxfig\fP come up \fIunits\fP high (where units are either cm or in).
.TP
.B \-tr[ack]
Turn on cursor (mouse) tracking arrows (default).
.TP
.B \-not[rack]
Turn off cursor (mouse) tracking arrows.
.TP
.B \-inc[hes]
Make inches the unit of choice (default).
.TP
.B \-me[tric]
Make centimeters the unit of choice.
.TP
.B \-inv[verse]
Use inverse video (white on black).
.TP
.B \-fg \fIcolor\fP
Use \fIcolor\fP as the foreground color and default color for objects.
.B \-bg \fIcolor\fP
Use \fIcolor\fP as the background color for the canvas and buttons.
.TP
.B \-de[bug]
Turn on debugging mode.  Prints various debugging messages like font names etc.
.TP
\fB-nor[mal]\fP \fIfont\fP
Cause the font used for the message panel and ruler numbers to be \fIfont\fP.
This font is also used on the canvas when the selected font is not available
in an X11 font (default = fixed).
.TP
\fB-bu[tton]\fP \fIfont\fP
Cause the font used for most buttons to be \fIfont\fP (default = 6x13).
.TP
\fB-bol[d]\fP \fIfont\fP
Cause the font used for displaying confirmation messages to be \fIfont\fP (default = 8x13bold).
.TP
\fB-startf[ontsize]\fP \fIpointsize\fP
Set the default font size for text objects (default = 12pt).
.TP
\fB-startp[sFont]\fP \fIfont\fP
Set the starting font name for \fIPostscript\fP fonts.
.TP
\fB-startl[atexFont]\fP \fIfont\fP
Set the starting font name for \fILaTeX\fP fonts.
.TP
.B \-sh[owallbuttons]\fP
Show all the \fIxfig\fP indicator buttons instead of only those relevant
to the current drawing mode.  Normally, the buttons \fIline width\fP, 
\fIarea-fill\fP, \fIgrid mode\fP, \fItext size\fP, etc. are only visible when 
they are relevant to the current drawing mode.  
The \fB-showallbuttons\fP option makes all
of the indicator buttons visible at all times.  This takes up more screen
real estate, but allows the user to see all settable parameters.
.TP
.B \-internalBW \fIwidth\fP
Use lines of width \fIwidth\fP between all buttons and panels (default = 1).
.TP
.B \-lat[exfonts]
Start \fIxfig\fP with \fILaTeX\fP font selection.  Normally, the \fIPostScript\fP fonts are
available as the default.  This flag selects the \fILaTeX\fP fonts to start.
.TP
.B \-sp[ecialtext]
Start \fIxfig\fP with the \fIspecial text\fP mode for text objects.
.TP
.B \-sc[alablefonts]
Allows use of the X11R5 scalable fonts.
.TP
.B \-k[eyFile] \fIcompose-key-file\fP
Use \fIcompose-key-file\fP instead of \fICompKeyDB\fP for compose (meta) key 
database.  If there are no "/"s in the name, the file must reside in the \fIxfig\fP 
library directory, \fI$XFIGLIBDIR\fP, usually /usr/local/lib/X11/xfig.
If there are any "/"s in the name it is taken as is (not relative
to \fI$XFIGLIBDIR\fP).
If there is a leading "~/" in the string then the ~ is expanded to the 
user's home directory.
.TP
.B \-fl[ushleft]
Set the print option to print the figure flush left.  
The default is to center the figure on the page.
.TP
.B \-te[xtoutline]
Specifies that xfig will draw a red (on color machines) outline 
of the "actual" bounding box of text objects.
This is mostly useful for determining what rotated text will look like 
since xfig doesn't show the text rotation on the canvas.
.TP
.B \-e[xportLanguage] \fIlanguage\fP
Specifies the language to be used for when exporting a fig file.
Choices are: 

.TS
l l.
Name	Language
_
box	LaTeX box (figure boundary)
latex	LaTeX picture
epic	LaTeX picture + epic macros
eepic	LaTeX picture + eepic macros
eepicemu	LaTeX picture + eepicemu macros
pictex	PiCTeX macros
eps	Encapuslated Postscript
ps	Postscript
pstex	Combined PS/LaTeX (PS part)
pstex_t	Combined PS/LaTeX (LaTeX part)
textyl	Textyl special commands
tpic	TPIC
pic	PIC
xbm	X11 Bitmap
.TE

.SH "GRAPHICAL OBJECTS"
The objects in \fIxfig\fP are divided into \fBprimitive objects\fP and
\fBcompound objects\fP. The primitive objects are: \fIARC\fP, \fICIRCLE\fP,
\fICLOSED SPLINE\fP, \fIELLIPSE\fP, \fIPOLYLINE\fP, \fIPOLYGON\fP,
\fIENCAPSULATED POSTSCRIPT\fP, \fIBOX\fP, \fIARC-BOX\fP, \fISPLINE\fP, 
and \fITEXT\fP.  
.PP
A primitive object can be moved, rotated, flipped vertically or horizontally,
scaled, copied, aligned within a compound object or erased.
The TEXT primitive may not be flipped. It may be rotated but only the markers 
show the rotation (on-screen).  Text IS rotated on \fIPostScript\fP output.
The attributes of any primitive object can be edited using a popup
panel (discussed below), so you can, for instance, set the position
of an object manually.
.PP
A compound object is composed of primitive objects. The primitive objects
that constitute a compound can not be individually modified, but they can
be manipulated as an entity; a compound can be moved, rotated, flipped
vertically or horizontally, scaled, copied or erased.  A compound that 
contains any boxes, arc-boxes, ellipses or circles may only be rotated by 
90 degrees.
.PP
Objects may overlap other objects according to their "depth".  Objects with
larger depth number are obscured by objects with smaller depth.
.PP
\fIRegular\fP polygons may be created using a special drawing mode, but a
general \fIPOLYGON\fP is created as a result, which may then be modified, i.e.
the individual vertices may be moved if desired.
.SH "DISPLAY WINDOWS"
Nine regions comprise the display area of \fIxfig\fP: the 
command region, top ruler, side ruler, drawing mode region, 
editing mode region, message region,
indicator region with buttons to set and show current line thickness,
line style, color, area-fill gray color and several other settings, mouse 
function indicator region and canvas region. 
(The mouse function indicator region was inspired by the UPS
debugger from the University of Kent.)
The drawing and editing mode regions may be placed (together) to the left or 
right of the the canvas window (default: left).
.SH "COMMAND PANEL FUNCTIONS"
.TP
.I Quit
Exit from \fIxfig\fP, discarding the figure. If the figure has been modified and
not saved, the user will be asked to 
confirm the action, by clicking mouse button 1 on a confirm/cancel popup menu.
.TP
.I Delete ALL
Delete all objects from the canvas window (may be undone).
.TP
.I Undo
Undo the last object creation, deletion or modification.
.TP
.I Redraw
Redraw the canvas.
.TP
.I Paste
Paste the object previously copied into the cut/paste file into the current 
figure (at its original position).
.TP
.I File
Pressing mouse button 3 on this button invokes \fISave\fP function without 
popping up the file panel.
.br
Mouse button 1 or \fI<Meta>f\fP pops up a panel which contains several 
file-related functions:
.\".PP
.\" .po +.5i
.\" .nr LL 6i
.RS .5i
.TP
.I Current Filename
This is read-only AsciiTextWidget which contains the filename that will be used
to write output to a file \fIif there is no name specified in\fP the
\fIFilename\fP panel.
.TP
.I Filename
This is an editable AsciiTextWidget which contains the filename selected
either by clicking on a filename from the \fIAlternatives\fP list or
by typing a name in directly.
Pressing return in the Filename window will \fILoad\fP the file and copy
the name to the \fICurrent Filename\fP widget.
.TP
.I (File) Alternatives
Pressing mouse button 1 on a filename in the file alternatives
window will select that file by copying the filename into \fIFilename\fP window.
Pressing return in this window will \fILoad\fP the file specified in the
\fIFilename\fP window (if any) or the \fICurrent Filename\fP widget.
.TP
.I Filename Mask
A wildcard mask may be typed into this editable AsciiTextWidget to restrict
the search of filenames to a subset ala the \fIls\fP command.
Pressing return in this window will automatically 
rescan the current directory.
This string may be set by setting the X toolkit resource 
\fB*file_panel*mask*string\fP.
.TP
.I Current Directory
This is an editable AsciiTextWidget which shows the current directory.
It may be modified by the user to manually set a directory name.  When
return is pressed in this window the directory specified is scanned for 
files matching the \fIFilenamemask\fP, if any.

The ~ (tilde) character may be used to specify a user's home directory, ala
unix shell tilde expansion.
.TP
.I (Directory) Alternatives
Pressing mouse button 1 on a directory name in the directory
alternatives list will do a "change directory" to that directory.

Pressing mouse button 3 in either the file or 
\fIDirectory Alternatives\fP window will do a "change directory" to the 
parent directory.
.TP
.I Home
Pressing this button will change the directory to the \f3$HOME\f1 directory
of the user.
.TP
.I Rescan
Pressing this button or \fI<Meta>r\fP will rescan the 
current directory.
.TP
.I Cancel
Pressing this button or \fI<Meta>c\fP will pop down the \fIFile\fP panel 
without making any changes to the directory or file name.
.TP
.I Save
Pressing this button or \fI<Meta>s\fP will save the current contents of the 
canvas in the file specified in the 
\fIFilename\fP window \fIif any\fP, or the name specified in the 
\fICurrent Filename\fP if the former is empty.
If the file already exists a confirmation popup menu will appear
asking the user to confirm or cancel the save.
If there is a filename in the \fIFilename\fP window it is copied to the
\fICurrent Filename\fP window.
.TP
.I Load
Pressing this button or \fI<Meta>l\fP will clear the canvas of any 
current figure and read the figure from the filename specified 
in the \fIFilename\fP menu item \fIif any\fP, or the name 
specified in the \fICurrent Filename\fP if the former is empty.
If there is a figure currently on the canvas and any modifications 
have been made to it and not saved, a popup query 
window will first appear asking if the user wishes to discard the current 
figure or cancel the \fILoad\fP operation.

A popup message window will appear and diagnostic messages will be written
if \fIxfig\fP changes any "illegal" object values to legal values.  For example,
older versions of \fIxfig\fP were lax about initializing unused parts such as 
\fIdepth\fP, and would produce very large, random values.
\fIXfig\fP now will "clean up" bad values and inform you when it does so.
Also, if you read in an older file format, \fIxfig\fP will inform you that
it is converting it to the current format for that version of \fIxfig\fP.
.br
This window can be popped down by clicking the mouse button on the 
\fIDismiss\fP button.
.TP
.I Merge Read
Pressing this button or \fI<Meta>r\fP will read the figure from the filename 
specified in the \fIFilename\fP window \fIif any\fP, or the name 
specified in the \fICurrent Filename\fP if the former is empty,
and merge it with the figure already shown on the canvas.

See \fILoad\fP above for a description of the popup message window.
.\".PP
.\".po -.5i
.\".nr LL 6.5i
.RE
.TP
.I Export
Will let you export the figure to an output file in one of several formats.
Pressing mouse button 3 on this button invokes \fIExport\fP function without 
popping up the export panel.
.br
Mouse button 1 or \fI<Meta>e\fP pops up a directory browser widget and 
a menu with several export-related functions:
.\".PP
.\".po +.5i
.\".nr LL 6i
.RS .5i
.TP
.I Magnification
This is an editable AsciiTextWidget which contains the magnification to use
when translating figure to the output language.  The default is 100%.
.TP
.I Orientation
This button will toggle the output orientation between Landscape (horizontal)
and Portrait (vertical).  The default orientation is the same as the mode
that \fIxfig\fP was started with.
.TP
.I Justification
This window will only be sensitive when the language selected is "ps" (\fIPostScript\fP).
You may choose that the figure is \fIflush left\fP or \fIcentered\fP in the
output file.
.TP
.I Language
The translation language to use for \fIxfig\fP output when output is 
directed to a file.  The default is \fIPostScript\fP.
The figure may be saved as an X11 bitmap by choosing \fIXbitmap\fP as the
output language.
The bitmap is created from the figure, the size of which is determined
by the enclosing rectangle of all the figure plus a small border.
.TP
.I Default Output Filename
This is read-only AsciiTextWidget which contains the filename that will be used
to write output to a file \fIif there is no name specified in\fP Output File.
The default is the figure name plus an extension that reflects the output
language used, e.g. myfigure.ps if PostScript is the current language used.
If the file already exists a confirmation popup menu will appear
asking the user to confirm or cancel the save.
.TP
.I Output Filename
This is an editable AsciiTextWidget which contains the filename to use
to write output to a file.
Pressing return in this window will \fIExport\fP the file and copy
the name to the \fIDefault Output Filename\fP widget.
If the file already exists a confirmation popup menu will appear
asking the user to confirm or cancel the save.
.TP
.I (File) Alternatives
Pressing mouse button 1 on a filename in the file alternatives
window will select that file by copying the filename into \fIFilename\fP window.
Pressing return in this window will \fIExport\fP the file and copy
the name to the \fIDefault Output Filename\fP widget.
.TP
.I Filename Mask
A wildcard mask may be typed into this editable AsciiTextWidget to restrict
the search of filenames to a subset ala the \fIls\fP command.
Pressing return in this window will automatically 
rescan the current directory.
This string may be set by setting the X toolkit resource 
\fB*export_panel*mask*string\fP.
.TP
.I Current Directory
This is an editable AsciiTextWidget which shows the current directory.
It may be modified by the user to manually set a directory name.  When
return is pressed in this window the directory specified is scanned for 
files matching the \fIFilenamemask\fP, if any.

The ~ (tilde) character may be used to specify a user's home directory, ala
unix shell tilde expansion.
.TP
.I (Directory) Alternatives
Pressing mouse button 1 on a directory name in the directory
alternatives list will do a "change directory" to that directory.

Pressing mouse button 3 in either the file or 
\fIDirectory Alternatives\fP window will do a "change directory" to the 
parent directory.
.TP
.I Home
Pressing this button will change the directory to the \f3$HOME\f1 directory
of the user.
.TP
.I Rescan
Pressing this button or \fI<Meta>r\fP will rescan the current directory.
.TP
.I Cancel
Pressing this button or \fI<Meta>c\fP will pop down the \fIExport\fP menu 
without doing any print operation.
.TP
.I Export
Pressing this button or \fI<Meta>e\fP will write (export) the figure 
to the file using the selected language.
If the file already exists, a confirmation window will popup to ask the 
user to confirm the write or cancel.
Pressing return in the Output Filename window will also Export the file.
.\".PP
.\".po -.5i
.\".nr LL 6.5i
.RE
.TP
.I Print 
Pressing mouse button 3 on this button invokes \fIPrint to Printer\fP function 
without popping up the print panel.  Pressing the \fIShift\fP key and 
mouse button 3 invokes the \fIPrint to Batch\fP function.
Pressing mouse button 1 or \fI<Meta>p\fP pops up a menu with several 
print-related functions:
.\".PP
.\".po +.5i
.\".nr LL 6i
.RS .5i
.TP
.I Magnification
This is an AsciiTextWidget which contains the magnification to use
when translating figure to the output language.
.TP
.I Orientation
This button will toggle the output orientation between Landscape (horizontal)
and Portrait (vertical).  The default orientation is the same as the mode
that \fIxfig\fP was started with.
.bp
.TP
.I Justification
This button will bring up a sub-menu from which you may choose
\fIcenter\fP or \fIflush left\fP to justify the figure on the page.  The
default is \fIflush left\fP.
.TP
.I Printer
This is an AsciiTextWidget which contains the printer to 
use if output is directed to a printer.  The name of the printer may 
be set setting the X toolkit resource \fB*printer*string\fP.
.TP
.I Dismiss
Pressing this button or \fI<Meta>c\fP will pop down the \fIPrint\fP menu.
.TP
.I Print to Batch
Pressing this button or \fI<Meta>b\fP will append the figure (in PostScript form)
to a batch file.
The \fIPrint to Printer\fP button will send the batch file to the printer.
.TP
.I Clear Batch File
Pressing this button or \fI<Meta>x\fP will erase the accumulated figures from 
the batch file.
.TP
.I Print to Printer
Pressing this button or \fI<Meta>p\fP will send the current figure 
(or the batch file if it is has any figures in it) to the printer, 
by passing it through \fIfig2dev\fP to convert it to PostScript 
then to the unix \fIlpr\fP (on BSD equivalent Unixes) 
or \fIlp\fP (on SYSV systems) program.  If the batch file is printed by this
button then it is removed after printing.

Note that the figure that is printed is what you see on the canvas,
not necessarily the figure file.  I.e., if you haven't saved the figure
since the last changes, the figure from the canvas is printed.  
\fIXfig\fP writes the figure to a temporary file to do this.  
The name of the file is \fIXFIGTMPDIR\fB/xfig-print\fR\fIPID\fP, where 
\fIXFIGTMPDIR\fP is the value of the environment variable by that name and
\fIPID\fP is the process ID of \fIxfig\fP.  If the environment variable
\fIXFIGTMPDIR\fP is empty or not set, the \fB/tmp\fR directory is used.
.\".PP
.\".po -.5i
.\".nr LL 6.5i
.RE

.SH "INDICATOR PANEL COMMAND DESCRIPTIONS"
.PP
The indicator panel contains buttons to set certain drawing parameters, such as
line thickness, canvas grid, rotation angle etc.
All of the buttons use the same mouse buttons for setting values.  
Pressing mouse button 1 on the indicator will pop up a panel
in which either a value may be typed (e.g. for a line thickness) or the
mouse may be clicked on one of several buttons (e.g. for grid style or 
font name).  For those that expect a value, pressing return in the value
part of the window will set the new value and pop down the menu.
.PP
Pressing mouse button 2 on an indicator will decrement the value
(e.g. for line thickness)
or cycle through the options in one direction (e.g. font names), while pressing 
mouse button 3 will increment the value or cycle through the options
in the other direction.
.TP
.I ZOOM SCALE
The canvas zoom scale may be set/increased/decreased with this button.
The zoom scale is displayed within the zoom button. Ruler,
grid and linewidth are scaled, too.  
Pressing mouse button 2 will decrease the zoom factor by 1.0 unless it
is less than 1.0 already in which case it will reduce to the nearest 0.25.
Pressing mouse button 3 will increase the zoom factor by 1.0 unless it
is less than 1.0 in which case it will increase it to the nearest 0.25.
Pressing the control key and mouse button 3 together will 
set the zoom scale to 1.
.sp
The figure may also be zoomed by defining a zoom rectangle by pressing 
the control key and mouse button 1 together.  This will define one corner
of the zoom rectangle.  Move the mouse and click mouse button 1 again to 
define the opposite corner of the zoom rectangle.
.bp
.TP
.I GRID MODE
With this button the user may select no grid,
1/4 inch (5mm in metric mode) grid or 1/2 inch (10mm) grid.
.TP
.I POINT POSITION
This button controls the coarseness of object placement on the canvas. 
The options are exact (on pixel) placement, 1/16 inch (2mm in metric mode), 1/4
inch (5mm) or 1/2 inch (10mm).  This allows the user to easily place objects
in horizontal or vertical alignment.

This also restricts which objects may be "picked up" by the mouse when editing.
If a corner of an object is not positioned on the canvas on a multiple
of the point positioning resolution you may not be able to pick it.  If this 
happens, a black square will temporarily appear above the mouse cursor.  
This square will also appear anytime the user tries to pick a nonexistent
object.
.TP
.I ROTATION ANGLE
The rotation angle for rotating objects may be set/increased/decreased with
this button.
Note that not all objects may be rotated, and certain objects may only be
rotated by certain angles.
Pressing mouse button 2 will decrease the angle in steps of 15 degrees,
while mouse button 3 will increase the angle the same amount.
To select other angles, press mouse button 1 and
enter the angle in the popup menu.
.TP
.I DEPTH
The depth at which new objects will be created may be set/increased/decreased 
with this button.
.TP
.I NUMBER OF POLYGON SIDES
The number of sides used in creating a \fIREGULAR POLYGON\fP is set with
this button.
.TP
.I SMART-LINKS MODE
This button controls the smart-links mode.  When turned on, lines which
link box-like objects together (henceforth called \fIlinks\fP) are treated
specially when one of the box-like objects is moved.
When set to \fIMOVE\fP mode, the end point of the link which touches
(or is very near) the perimeter of the box is moved with the
box so that the box and the end point remain linked.
When set to \fISLIDE\fP mode, the end segment of the link slides so
that the box remains linked and the angle of the end segment is maintained.
This is useful for keeping the last segment of a link horizontal or vertical.

(At the moment, this mode only works for the \fIMOVE\fP and \fICOPY\fP
functions and only works for \fIPOLYLINE\fP links and box-like objects.
Another limitation at the moment is that if both ends of a link touch
the box being operated on, only one end of the link will be adjusted.)
.TP
.I VERTICAL ALIGN
This sets the vertical alignment mode for the \fIALIGN\fP button in the
editing mode panel.  The choices are no vertical alignment, align to top edge,
middle or bottom edge of compound.  
The \fIHORIZONTAL ALIGN\fP and \fIVERTICAL ALIGN\fP indicator settings are 
used together to align objects inside a compound or in canvas.
.TP
.I HORIZONTAL ALIGN
This sets the horizontal alignment mode for the \fIALIGN\fP button in the
editing mode panel.  The choices are no horizontal alignment, align to left edge,
middle or right edge of compound.
The \fIHORIZONTAL ALIGN\fP and \fIVERTICAL ALIGN\fP indicator settings are 
used together to align objects inside a compound or in canvas.
.TP
.I ANGLE GEOMETRY
The following settings are available to restrict the drawing angle of line
segments in \fIPOLYLINES\fP, \fIPOLYGONS\fP and \fISPLINES\fP.
.\".po +.5i
.\".nr LL 6i
.RS .5i
.TP
.I UNRESTRICTED
Allow lines to be drawn with any slope.  This is the default setting.
.TP
.I LATEX LINE
Allow lines to be drawn only at slopes which can be handled by \fILaTeX\fP picture
environment lines: slope = x/y, where x,y are integers in the range [-6,6].
.TP
.I LATEX VECTOR
Allow lines to be drawn only at slopes which can be handled by \fILaTeX\fP picture
environment vectors: slope = x/y, where x,y are integers in the range [-4,4].
.TP

.I MANHATTAN-MOUNTAIN
Allow lines to be drawn in the horizontal, vertical or diagonal direction only.
.TP
.I MANHATTAN
Enforce drawing of lines in the horizontal and vertical direction only.
The name \fIManhattan\fP comes from the horizontal/vertical look of the Manhattan
(New York City) skyline.
.TP
.I MOUNTAIN
Enforce drawing of only diagonal lines.
The name comes from the pointed shape of mountains.
.\".PP
.\".po -.5i
.\".nr LL 6.5i
.RE
.TP
.I FILL STYLE
This button allows the user to select the area fill darkness (grey scale)
for all objects except \fITEXT\fP and \fIENCAPSULATED POSTSCRIPT\fP,
or to turn off area fill altogether.
.TP
.I COLOR
The user may select one of eight predefined colors to draw with, or select 
that the \fIdefault\fP (-fg) color is to be used.  The eight colors are black,
blue, green, cyan, red, magenta, yellow and white.  Note that \fITransFig\fP
versions 2.1.4 and later support color output for \fIPostScript\fP.
On monochrome screens the objects are created with the selected color,
but black is used to draw the objects on the canvas.
.TP
.I LINE WIDTH
The width of lines may be selected with this button.  Zero width lines may be
drawn for the purpose of having filled areas without outlines.
.TP
.I LINE STYLE
The choices for line style are solid, dashed and dotted.  Once created,
a dashed or dotted line may be edited to change the length of dashes
or the spacing of dots respectively.
The dash length and dot gap can be changed from the default 
using the popup menu.
.TP
.I BOX CURVE
The radius of the corners on \fIARC-BOX\fP objects may be set with this
button.
.TP
.I ARROW MODE
This button selects the auto-arrow mode for drawing lines.  The options are
no arrow heads, backward-pointing arrow head, forward-pointing
arrow head or both.  If one or both arrow head modes are turned on, then 
arrow heads are automatically drawn when drawing
\fIPOLYLINE\fP, \fISPLINE\fP or \fIARC\fP objects.
.TP
.I TEXT JUSTIFICATION
The adjustment of text may be set to \fIleft\fP, \fIcenter\fP or 
\fIright justification\fP.
.TP
.I TEXT SIZE
The text size may be set/increased/decreased with this button.  The default
is 12 points.
.TP
.I TEXT STEP
The interline spacing of text may be set/increased/decreased with this button.
The number displayed gives the multiple of the font height
that will be placed between lines on hitting \fI<return>\fP.  The default
is a factor of 1.2 times the current font size.
.TP
.I TEXT FONT
This button allows a selection of 35 fonts available for most Apple 
\fIPostScript\fP printers.
There are two buttons at the top of the menu.  The \fIcancel\fP button pops
down the menu without changing the current font.  The \fIuse latex fonts\fP
will switch the menu to the \fILaTeX\fP font choices.  
When the \fILaTeX\fP font menu is up, besides a \fIcancel\fP button
there is a button to switch back to the \fIPostScript\fP fonts.

The name of the font is printed in the font itself so that one may see 
what that font looks like.
If a corresponding X11 font exists, new text is created 
on the canvas using that font.
\fIxfig\fP uses the size of X11 font closest to that selected 
by the font size button.
If the X11 font doesn't exist, \fIxfig\fP uses the font 
selected by the "-normal" option.
To abort selection of a font, click mouse button 1 on \fIcancel\fP.

.SH "DRAWING AND EDITING MODE PANELS"
Icons in the drawing and editing mode panel windows represent 
object manipulation functions,
modes and other drawing or modification aids.
Manipulation functions are selected by positioning the cursor over the icon
representing the desired drawing/editing function and
clicking mouse button 1.  The selected icon is highlighted, and
a message describing its function appears in the message window.
The hilighting remains on until another function is selected.
.SH "DRAWING MODE PANEL COMMAND DESCRIPTIONS"
.PP
The drawing mode panel contains buttons used to create the various \fIxfig\fP
objects.
Once the drawing mode is selected, the object is created by moving
the mouse to the point on the canvas where the object is to be placed
and pressing and releasing mouse button 1.  
After that the mouse is moved to the second point and 
mouse button 1 is again pressed for the next point.  
For those objects which may have more than two points (e.g. a line), 
mouse button 1 may be pressed for each successive point, and 
mouse button 2 must be pressed to finish the object.  
To create a single point
using the \fIPOLYLINE\fP button, press and release mouse button 2.
For the \fIARC\fP object, which requires exactly three
points mouse button 1 is used for all three points.
.PP
At any time mouse button 3 may be pressed to cancel the
creation of the object.
.TP
.I ARC
Create an arc.  Specify three points using mouse button 1.  The first and 
last points will form the endpoints of the arc and the second specifies 
any point on the arc.
.TP
.I BOX
Create rectangular boxes.  
Start by clicking mouse button 1 on any corner of the desired box and
finish with the same mouse button on the diagonally opposite corner of 
the box.
.TP
.I ARC-BOX
Create rectangular boxes with rounded corners.  
Start and finish with mouse button 1 in the same way as \fIBOX\fP.
The radius of the corners is selected by the \fIBOX CURVE\fP button.
.TP
.I CIRCLE 
Create circles by specifying their radii or diameters.
Click mouse button 1 on the center of the circle and drag the mouse
until the desired radius or diameter is attained.  Click 
mouse button 1 again to finish the circle.
.TP
.I ELLIPSE
Create ellipses using the same procedure as for the drawing of circles.
.TP
.I ENCAPSULATED POSTSCRIPT OBJECT (EPS)
Click mouse button 1 on any corner
for the \fIEPS\fP object and finish by clicking mouse button 1
again on the diagonally opposite corner.  The \fIEDIT\fP 
popup panel will appear and the file name of the \fIEPS\fP object
may be entered.  After pressing \fIDONE\fP or \fIAPPLY\fP 
(see the description of the EDIT panel for the difference between 
the \fIDONE\fP and \fIAPPLY\fP buttons) the bitmap
part of the \fIEPS\fP object will appear in the box just created.  If no
\fIEPS\fP file is available yet or no name is entered or there is no
\fIpreview bitmap\fP in the \fIEPS\fP file, pressing \fIDONE\fP 
will pop down the edit panel and the word 
\fI<empty>\fP or the \fIEPS\fP file name will remain in the \fIEPS\fP box.
Later, when the name of the \fIEPS\fP file is known or the file is available,
you may re-read the \fIEPS\fP file using the popup edit panel and the bitmap
part of the \fIEPS\fP file will replace the name in the box.
.br
If you want the original size of the \fIEPS\fP object, press the "Use orig size"
button and the eps bitmap will enlarge or shrink to the size specified in the
preview bitmap of the \fIEPS\fP file.  If you want the \fIEPS\fP object to
be approximately the size of the rectangle specified with the mouse but want
the aspect ratio to be same as the original, press either "Shrink to orig" or
"Enlarge to orig" buttons.  You must press the APPLY button to see these effects.
.TP
.I INTERPOLATED SPLINE
Create (cubic spline) spline objects.
Enter control vectors in the same way as for creation of a
\fIPOLYLINE\fP object.
At least three points (two control vectors) must be entered.
The spline will pass through the entered points.
.TP
.I POLYLINE
Create polylines (line segments connecting a sequence of points).
Enter points by clicking mouse button 1 at the desired positions on the
canvas window.  Click mouse button 2 to finish.
.TP
.I POLYGON
Same as \fIPOLYLINE\fP
except that a line segment is drawn connecting the first and last
points entered.
.TP
.I REGULAR POLYGON
The number of sides is first selected with the \fINUM SIDES\fP
button in the indicator panel.  Then mouse button 1 is clicked on
the center and the mouse dragged to the desired size.  The object
may be rotated as it is being created by moving the mouse up or down
relative to the starting point.  Click mouse button 1 to finish.
.TP
.I CLOSED INTERPOLATED SPLINE
Create closed or periodic splines.  The function is similar
to \fIPOLYGON\fP except that a closed interpolated spline is drawn.
The spline will pass through the points (knots).
.TP
.I CLOSED SPLINE
Create closed or periodic spline objects.
The function is similar to \fIPOLYGON\fP
except that a closed spline will be drawn instead of polygon.
The entered points are just control points; i.e. the spline will
not pass any of these points.
.TP
.I SPLINE
Create (quadratic spline) spline objects.
Enter control vectors in the same way as for creation of a
\fIPOLYLINE\fP object.
At least three points (two control vectors) must be entered.
The spline will only pass through the two end points.
.TP
.I TEXT
Create text strings. Click mouse button 1 at the desired position on
the canvas window, then enter text from the keyboard.  Text may be pasted
from the PRIMARY cut buffer (xterm cut/paste buffer) by pressing the
\fIF18\fP function key (the \fIPaste\fP key on Sun keyboards)
or any key/button defined in the translation 
table for the canvas.  See the default \fIFig.ad\fP file for example.
Text is drawn using the current font, font size and justification settings.
A DEL or ^H (backspace) will delete a character, while a ^X will 
erase the entire line.
Finish by clicking mouse button 2 or typing the \fI<return>\fP key.  
If \fI<return>\fP is used, the text pointer automatically moves to the next "line",
a distance of the font height times the value in the TEXT STEP button,
and text input mode is re-entered.  To finish text fully, click 
mouse button 2 or choose any panel button that changes 
modes (e.g. box, save, etc).
To edit text, click on an existing text string with mouse button 1.
Insertion of characters will take place at that point.  Or, use the popup
\fIEDIT\fP mode to modify the text.
.sp
Eight-bit characters may be entered using the meta (compose) key.
For example, to create an "a umlaut", hold down the meta key while pressing
the letter "a", then press " (quote).  To create a "c cedilla", use <meta>c
followed by comma.
The following is a list of all special characters available using the meta key:
.bp
.nf
.ta .5i
Keys	Character Name

!!	upside-down exclamation point
??	upside-down question mark
C/	cent sign
L-	British pound
OX	currency
Y-	yen
__	broken vertical bar
SO	section
""	dieresis
CO	copyright
RO	registered trademark
_a	ordfeminine
_o	ordmasculine
<<	guillemotleft
>>	guillemotright
-|	notsign
--	hyphen
+-	plusminus
^-	macron
^*	degree
^.	periodcentered
^1	onesuperior
^2	twosuperior
^3	threesuperior
14	onequarter
12	onehalf
34	threequarters
\\	acute
**	multiply
-:	division
/u	mu
P!	paragraph
A`	A accent grave
A'	A accent acute
A^	A accent circumflex
A~	A accent tilde
A"	A dieresis
A*	A ring
AE	AE
a`	a accent grave
a'	a accent acute
a^	a accent circumflex
a~	a accent tilde
a"	a dieresis
a*	a ring
ae	ae
C,	C cedilla
c,	c cedilla
D-	Eth
d-	eth
E`	E accent grave
E'	E accent acute
E^	E accent circumflex
E"	E dieresis
e`	e accent grave
e'	e accent acute
e^	e accent circumflex
e"	e dieresis
I`	I accent grave
I'	I accent acute
I^	I accent circumflex
I"	I accent dieresis
i`	i accent grave
i'	i accent acute
i^	i accent circumflex
i"	i dieresis
N~	N tilde
n~	n tilde
O`	O accent grave
O'	O accent acute
O^	O accent circumflex
O~	O accent tilde
O"	O dieresis
O/	O slash
o`	o accent grave
o/	o accent acute
o^	o accent circumflex
o~	o accent tilde
o"	o dieresis
o/	o slash
P|	Thorn
p|	thorn
ss	German ss (s-zed)
U`	U accent grave
U'	U accent acute
U^	U accent circumflex
U"	U dieresis
u`	u accent grave
u'	u accent acute
u^	u accent circumflex
u"	u dieresis
Y'	Y accent acute
y'	y accent acute
y"	y dieresis
.fi

.SH "EDITING MODE PANEL COMMAND DESCRIPTIONS"
When a button in the editing mode panel is pressed, any
objects that may be affected by that editing operation will show their
corner markers.  Only those objects may be affected by the particular
edit mode.  In cases where two edit modes exist for one button, it
may be that the corner markers will appear for objects that may be
affected by one button but not the other.
.bp
.SH "SELECTING OBJECTS"
When multiple objects have points in common, e.g. two boxes that
touch at one corner, only one object can be selected by clicking on
that point. To select other objects, hold down the shift key while
pressing mouse button 1: the markers of one object will be
temporarily highlighted.  By repeatedly clicking mouse button 1 while
holding down the shift key, it is possible to cycle through all candidates for
selection at that point. To perform the selected action, e.g. 
deleting one box, click on the point without holding down the
shift key.  The operation will be performed on the highlighted object.
\fBNote:\fP
If the mouse is not clicked near enough to an object marker or for whatever
reason \fIxfig\fP cannot "find" the object the user is trying to select,
a black square will temporarily appear above the mouse cursor.
.TP
.I GLUE COMPOUND
Compound objects are created by first tagging the objects to be compounded
and then pressing mouse button 3 to group the tagged
objects into a compound object.  Single objects are tagged by clicking
on them with mouse button 1.  A number of objects can be tagged at
once by using mouse button 2 to define the upper-left and
lower-right corners of a region enclosing the objects.
Tagged objects are shown with highlighted markers.
Tagged objects which are selected (see the SELECTING OBJECTS section above)
will be temporarily unhighlighted.
There is currently no special command to tag or untag all of the objects
within a figure.  You can untag all of the objects by changing from
GLUE mode to some other mode (apart from BREAK) and back again.
.TP
.I BREAK COMPOUND
Break a compound object to allow manipulation of its component parts.
Click mouse button 1 on one of the corner markers of the compound 
object or along one of the imaginary lines defining the compound box.
Clicking with mouse button 2 will achieve the same effect
but will also tag the component parts (although you will not see the
tags until you change to the GLUE mode).  You can use this feature
to easily alter the objects within a compound.
.TP
.I SCALE OBJECT
Any object may be scaled.  If mouse button 1 is pressed on a
\fIBOX\fP or \fIARC-BOX\fP object, then that object will be scaled
proportionally to its aspect ratio.  If mouse button 2 is pressed
on any object, that object will be scaled up or down about its center.
Text may only be scaled if inside a compound object and then only if 
its \fIRIGID\fP flag is set to \fINORMAL\fP (using the popup edit panel).
See the \fITransFig\fP manual for description of text options.
.TP
.I ALIGN
Align objects.  Click mouse button 1 to align objects inside a compound object 
or mouse button 2 to align all objects on canvas according to the
setting in the \fIVERTICAL ALIGN\fP and \fIHORIZONTAL ALIGN\fP indicators.  
The choices are the cumulative effect of vertically aligning the objects 
to the \fITOP\fP, \fIMIDDL\fPE or \fIBOTTO\fPM edge and horizontally aligning 
to the \fILEF\fPT, \fIMIDDL\fPE or \fIRIGH\fPT edge of the compound.
.TP
.I MOVE POINT
Modify the position of a point of any object except \fITEXT\fP and 
\fICOMPOUND\fP objects.
For unrestrained movement, click mouse button 1 over the desired 
point, reposition the point, and click the \fIleft\fP button again.
For horizontally or vertically constrained move, click mouse button 2 
on the desired point and move either horizontally or vertically.
Notice that once you choose the direction (horizontal or vertical), movement
is constrained in that direction.  If, after moving the mouse initially, it
is moved in the other direction a greater distance than the current position
of the mouse relative to the starting point, then that will be the new
constraint direction.  In otherwords if you first move the mouse 
\fIhorizontally\fP one inch (say) then move it \fIvertically\fP 
1.3 inches, the direction will switch to \fIvertical\fP until any 
\fIhorizontal\fP motion exceeds 1.3 inches.
When the object is positioned where desired, click mouse button 1 to
place it if that button was used to start the move (unconstrained), 
or mouse button 2 (constrained) if that button was used.
.TP
.I MOVE
Move object.  Click mouse button 1 (unconstrained move) or mouse button 2
(constrained move) on any corner marker of the object to be moved.
The horizontal/vertical constrained movement (mouse button 2) works 
exactly as described for \fIMOVE POINT\fP.
.TP
.I ADD POINTS
Add points to \fIPOLYLINE\fP, \fIPOLYGON\fP, \fISPLINE\fP,
or \fICLOSED SPLINE\fP objects (points of a \fIBOX\fP can not be added
or deleted).  Note that a \fIREGULAR POLYGON\fP is really an ordinary
\fIPOLYGON\fP, so adding points to this object is allowed and does NOT keep 
the polygon regular.
.TP
.I COPY / CUT TO CUT BUFFER
Copy object to canvas or cut buffer.  Click mouse button 1 (unconstrained 
copy) or mouse button 2 (constrained copy) on any corner marker of 
the object to be copied (for \fICIRCLE\fP and \fIELLIPSE\fP
objects, mouse may also be clicked on their circumferences).
The object will be duplicated and then moved exactly as in \fIMOVE\fP.
If mouse button 3 is clicked on an object, that object is copied 
to the cut buffer for pasting into this or another figure.
The file used for the cut buffer is called \f3.xfig\f1
in the user's \f3$HOME\f1 directory.  This allows a user to run two or more
xfig processes and cut/paste objects between them.
If there is no \f3$HOME\f1, a file is created in a temporary directory
called \f3xfig\f2PID\f1 where \f2PID\f1 is the xfig process ID.  
The temporary directory used is specified in the environment variable
\fIXFIGTMPDIR/\fR.  If that variable is empty or not set then \fI/tmp\fP is used.
.TP
.I DELETE POINTS
Delete points from \fIPOLYLINE\fP, \fIPOLYGON\fP, \fISPLINE\fP,
or \fICLOSED SPLINE\fP.  Objects (points of a \fIBOX\fP or \fIARC-BOX\fP 
can not be added or deleted).  
Note that a \fIREGULAR POLYGON\fP is really an ordinary
\fIPOLYGON\fP, so deleting points from this object is allowed and does NOT 
keep the polygon regular.
.TP
.I DELETE
Click mouse button 1 on an object to delete the object.
Delete a \fIregion\fP of the canvas by clicking mouse button 2
and dragging the mouse to define an area of objects to delete.
Clicking mouse button 3 on an object will copy the object 
to the cut buffer (see \fICOPY/CUT TO CUT BUFFER\fP above).
.TP
.I EDIT OBJECT
Edit settings for an existing object.
Click mouse button 1 on the object and a pop-up menu will appear
showing existing settings for the object.  Some of the menu entries
may be changed by typing new values in the appropriate windows. These
are editable Ascii\%TextWidgets and allow cut and paste.
Others pop up a sub-menu of multiple choices when pressed and held.
Yet others are buttons which toggle a setting on or off (e.g. arrow
heads on lines).

Press the "done" button to apply the changes to the object and finish.
Press the "apply" button to apply the changes but keep the menu up for
further changes.  Press the "cancel" button to cancel the changes and 
pop down the menu.

The following table shows which settings are used for the different objects.
.if n .RS -.1i
.nf
.TS
l c 1 c 1 c 1 c 1 c 1 c 1 c 1 c 1 c.
Object	\(dgAngle	Area	Line	Line	Box	\(ddDepth	Color	Radius	Text Font/
		Fill	Width	Style	Curve				Just./Size
_
Arc		X	X	X		X	X
_
Arc-Box		X	X	X	X	X	X
_
Circle	X	X	X	X		X	X	X
_
Ellipse	X	X	X	X		X	X	X
_
EPS						X	X
_
Box,Polygon,	X	X	X		X	X
Line,Spline
_
Text	X					X	X		X
_
.TE
.fi
.if n .RE

\(dg The angle may be set, but the object will only be rotated on \fIPostScript\fP
output.

\(dd The depth defines how overlapping objects are displayed. Objects with
a greater depth value are obstructed by objects with smaller depth value. 
The maximum depth allowed is 1000.

.TP
.I UPDATE
By pressing mouse button 1 on an object, the current settings for
the indicator buttons (line width, line style, area fill etc.) which
have been selected for update are copied into that object.  
When \fIxfig\fP is started, all indicator buttons which are components of objects
are selected for update.  To unselect an indicator, click on the update button
and click mouse button 1 on the small button in the upper-right 
corner of the indicator.  When that indicator is selected the foreground color
(default black) shows.  When it is unselected the background color (default white)
shows.
.sp
If mouse button 2 is clicked on an object, the settings in the object 
that are selected by the indicator buttons are copied into those indicator button
settings.  Thus, one may copy selected attributes of one object to another.
.TP
.I FLIP VERTICALLY
Flip the object up/down (mouse button 1) or copy the object and flip it
(mouse button 2). Point to part of the object, click
the appropriate button.  That object will be flipped vertically 
about that point.
.TP
.I FLIP HORIZONTALLY
Flip the object left/right (mouse button 1) or copy the object and flip it
(mouse button 2). Point to part of the object, click
the appropriate button.  That object will be flipped horizontally 
about that point.
.TP
.I ROTATE CLOCKWISE
Rotate the object (mouse button 1) or copy and rotate it 
(mouse button 2) -N degrees (clockwise), where N is the amount 
set in the rotation indicator button.  The object is rotated about 
the chosen point.
Not all objects can be rotated, and not all can be rotated at arbitrary
angles.  For example, \fIBOX\fP, \fIARC-BOX\fP and \fIEPS\fP objects may
only be rotated by 90 degrees.
Text objects may be rotated although only the markers are rotated on 
the screen, but the text
itself is not displayed rotated because of the limitations of the X11
Window System.  Text IS rotated correctly on \fIPostScript\fP output, however.
.TP
.I ROTATE COUNTER-CLOCKWISE
Rotate the object (mouse button 1) or copy (mouse button 2) 
+N degrees (counter-clockwise), where N is the amount set in the rotation
indicator button.  The object is rotated about the chosen
point.
.TP
.I SPLINE <-> POLYLINE
Turn \fIPOLYGON\fP into a \fICLOSED INTERPOLATED SPLINE\fP object, or
turn \fIPOLYLINE\fP into a \fIINTERPOLATED SPLINE\fP object.
.TP
.I ADD/DELETE ARROWS
Add or delete arrow heads of \fIARC\fP, \fIPOLYLINE\fP or \fISPLINE\fP
objects.  Add an arrow head by clicking mouse button 1 on the 
endpoint of the object.  Delete an arrow head by clicking 
mouse button 2 on the endpoint or arrow head.  The length and thickness
of the arrowheads may be modified using the popup edit panel.
.SH "PANNING"
The figure may be panned by clicking mouse button 1, 2 or 3
in the rulers.  Clicking mouse button 1 in the top ruler
will pan the image to left the by 1/2 inch (1cm in metric mode),
adjusted for zoom factor. Clicking mouse button 3 in the top ruler 
will pan the image right by the same amount.
By pressing and \fIholding\fP mouse button 2 the user may drag
the ruler by the amount desired, thus panning the image by that amount.
.PP
The figure is panned up and down in the same way by clicking the mouse
in the ruler on the right of the canvas.  Also, the figure can be returned
to its origin by clicking mouse button 1 in the units 
(e.g. \fIcm\fP or \fIin\fP) box.
.PP
The arrow keys may also be used to pan the image and the home key to
return the figure to the origin.  Also, pressing the Control Key and 
mouse button 2 will pan the figure to the origin.

.SH X DEFAULTS
The overall widget name(Class) is xfig(Fig).  These
resources correspond to the command line arguments:
.nf
.sp
.TS
L 1 L 1 L 1 L 1 L.
Name	Class	Type	Default	Command-line
				equivalent
_
justify	Justify 	boolean	false	-left (false) and
				   -right (true)
landscape	Orientation 	boolean	true	-Landscape and 
				   -Portrait
pwidth	Width	integer	10(8)	-pwidth
pheight	Height	integer	8(9.5)	-pheight
trackCursor	Track	boolean	on	-track and -notrack
inches	Inches	boolean	true	-inches, -imperial, 
				   -centimeters and
				   -metric
reverseVideo	ReverseVideo	boolean	off	-inverse
debug	Debug	boolean	off	-debug
latexfonts	Latexfonts	boolean	off	-latexfonts
normalFont	NormalFont	string	fixed	-normal
boldFont	ButtonFont	string	8x13bold	-bold
startfontsize	StartFontSize	integer	12	-startfontsize
startpsFont	StartpsFont	string	Times-Roman	-startpsFont
startlatexFont	StartlatexFont	string	Default	-startlatexFont
showallbuttons	ShowAllButtons	boolean	false	-showallbuttons
internalborderwidth	InternalBorderWidth	integer	1	-internalBW
scalablefonts	ScalableFonts	boolean	false	-scalablefonts
specialtext	SpecialText	boolean	false	-specialtext
monochrome	Monochrome	boolean	false	-monochrome
keyFile	KeyFile	string	CompKeyDB	-keyFile
exportLanguage	ExportLanguage	string	eps	-exportLanguage
flushleft	FlushLeft	boolean	false	-flushleft
textoutline	TextOutline	boolean	false	-textoutline
color0	Color0	pixel	black
color1	Color1	pixel	blue
color2	Color2	pixel	green
color3	Color3	pixel	cyan
color4	Color4	pixel	red
color5	Color5	pixel	magenta
color6	Color6	pixel	yellow
color7	Color7	pixel	white
_
.TE
The following are the default keyboard accelerators as distributed 
in the Fig.ad app-defaults file:
.TS
l l.
Keys (Context)	Function
(Main xfig panels)
<Meta>q	Quit xfig
<Meta>d	Delete all objects from canvas
<Meta>u	Undo
<Meta>r	Redraw
<Meta>t	pasTe xfig cutbuffer onto canvas
<Meta>f	popup File menu
<Meta>e	popup Export menu
<Meta>p	popup Print menu

(Popup file panel)
<Meta>r	Rescan current directory
<Meta>c	Cancel
<Meta>l	Load figure
<Meta>s	Save figure
<Meta>m	Merge read into current figure

(Popup export panel)
<Meta>r	Rescan current dirctory
<Meta>c	Cancel
<Meta>e	Export figure

(Popup print panel)
<Meta>c	Cancel
<Meta>b	print to Batch file
<Meta>p	Print to printer
<Meta>x	clear batch file
.TE
.fi
.SH WIDGET TREE
Below is the widget structure of \fIxfig\fP.
The widget class name is given first, followed by the widget instance name.
.nf
.ta .5i 1i 1.5i 2i 2.5i 3i 3.5i 4i 4.5i

Fig  xfig
	Form  form
		Form  commands
			Command  quit
			Command  delete_all
			Command  undo
			Command  redraw
			Command  paste
			Command  file
			Command  export
			Command  print
		Label  message
		Label  mouse_panel
		Box  mode_panel
			Label  label
			Command  button (one for each of the 16 drawing mode buttons)
			Label  label
			Command  button (one for each of the 18 editing mode buttons)
		Label  topruler
		Label  canvas
		Label  unitbox
		Label  sideruler
		Viewport ind_viewport
			Core  clip
			Scrollbar  horizontal
			Box  ind_panel
				Form  button_form
					Command  button (one for each of the 20 indicator buttons)
					Toggle  update (only those indicators that affect creation
							of objects have update toggles)

		TransientShell  xfig_ps_font_menu
			Box  menu
				Form  buttons
					Command  cancel
					Command  use_latex_fonts
				Command  pane (one for each of the 35 Postscript font panes)

		TransientShell  xfig_latex_font_menu
			Box  menu
				Form  buttons
					Command  cancel
					Command  use_postscript_fonts
				Command  pane (one for each of the 6 LaTeX font panes)

	TransientShell  xfig_file_menu
		Form  file_panel
			Label  file_status
			Label  num_objects
			Label  cur_file_label
			Text  cur_file_name
			Label  file_label
			Text  file_name
			Label file_alt_label
			Viewport  vport
				Core  clip
				Scrollbar  vertical
				List  file_list_panel
			Label  mask_label
			Text  mask
			Label  dir_label
			Text  dir_name
			Label  dir_alt_label
			Command home
			Viewport  dirvport
				Core  clip
				Scrollbar  vertical
				List  dir_list_panel
			Command  rescan
			Command  cancel
			Command  save
			Command  load
			Command  merge

	TransientShell  xfig_export_menu
		Form  export_panel
			Label  mag_label
			Text  magnification
			Label  orient_label
			MenuButton  orientation
				SimpleMenu  menu
					SmeBSB  Portrait 
					SmeBSB  Landscape
			Label  just_label
			MenuButton  justify
				SimpleMenu  menu
					SmeBSB  Flush left
					SmeBSB  Centered  
			Label  lang_label
			MenuButton  language     
				SimpleMenu  menu
					SmeBSB  LaTeX box (figure boundary)
					SmeBSB  LaTeX picture
					SmeBSB  LaTeX picture + epic macros
					SmeBSB  LaTeX picture + eepic macros
					SmeBSB  LaTeX picture + eepicemu macros
					SmeBSB  PiCTeX macros
					SmeBSB  Encapsulated Postscript
					SmeBSB  Postscript
					SmeBSB  Combined PS/LaTeX (PS part)
					SmeBSB  Combined PS/LaTeX (LaTeX part)
					SmeBSB  Textyl \especial commands
					SmeBSB  TPIC 
					SmeBSB  PIC
					SmeBSB  X11 Bitmap
			Label  export_mode_label
			MenuButton  export_mode
				SimpleMenu  menu
					SmeBSB  Overwrite     
					SmeBSB  Append    
			Label  def_file_label
			Label  def_file_name
			Label  out_file_name
			Text  file
			Label  file_alt_label
			Viewport  vport
				Core  clip
				Scrollbar  vertical
				List  file_list_panel
			Label  mask_label
			Text  mask
			Label  dir_label
			Text  dir_name
			Label  dir_alt_label
			Command home
			Viewport  dirvport
				Core  clip
				Scrollbar  vertical
				List  dir_list_panel
			Command  rescan
			Command  cancel
			Command  export

	TransientShell  xfig_print_menu
		Form  print_panel
			Label  printer_image
			Label  mag_label
			Text  magnification
			Label  orient_label
			MenuButton  landscape
				SimpleMenu  menu
					SmeBSB  portrait 
					SmeBSB  landscape
			Label  just_label
			MenuButton  justify
				SimpleMenu  menu
					SmeBSB  flush left
					SmeBSB  centered  
			Label  dir_label
			Text  printer
			Command  dismiss
			Command  print_batch
			Command  clear_batch
			Command  print

	TransientShell  xfig_file_msg
		Form  file_msg_panel
			Text  file_msg_win
			Command  dismiss

	TransientShell  query_popup
		Form  query_form
			Label  message
			Command  yes
			Command  no
			Command  cancel

	NOTE:  The following is a \fItypical\fP popup edit panel (for \fIARC-BOX\fP)
	       The panel will be different for other objects.

	TransientShell  xfig_edit_panel
		Form  form
			Label  POLYLINE:ArcBox
			Label  image
			Command  done
			Command  apply
			Command  cancel
			Label   
			Label  Width =
			Text  Width =
			Label  Color =
			Text  Color =
			Label  Depth =
			Text  Depth =
			Label  Area fill =
			MenuButton  No fill
				SimpleMenu  menu
					SmeBSB  No fill
					SmeBSB  Filled 
			Label  Fill density % =
			Text  Fill density % =
			Label  Line style =
			MenuButton  Solid Line 
				SimpleMenu  menu
					SmeBSB  Solid Line 
					SmeBSB  Dashed Line
					SmeBSB  Dotted Line
			Label  Dash length/Dot gap =
			Text  Dash length/Dot gap =
			Label  Top Left:
			Label  Top Left:
			Text  Top Left:
			Label  Top Left:
			Text  Top Left:
			Label  Bottom Right:
			Label  Bottom Right:
			Text  Bottom Right:
			Label  Bottom Right:
			Text  Bottom Right:
			Label  Radius =
			Text  Radius =
.fi
.SH BUGS and RESTRICTIONS
Please send bug reports, fixes, new features etc. to:
.br
bvsmith@lbl.gov
(Brian V. Smith)
.PP
Not all operations employ smart redrawing of objects which are altered
as a by product of the operation.  You may need to use \fIRedraw\fP
in these cases.
.PP
Must compile \fIxfig\fP with \fB-DOPENWIN\fP in order to make \fIxfig\fP handle
OpenWindows scalable fonts correctly.
.PP
Some servers do not allow bitmaps/pixmaps taller than the screen height
or wider than the screen width.  That is why there is a limit on the width
of the top ruler and height of the side ruler.  If you need wider/taller
rulers AND your server allows bigger pixmaps, you may define MAX_TOPRULER_WD
and/or MAX_SIDERULER_HT in your Imakefile in the DEFINES line.  For example,
to have a maximum top ruler width of 1160 pixels, add  
-DMAX_TOPRULER_WD=1160 to your DEFINES line in the Imakefile.
.PP
There is a bug in OpenWindows 2.0 which relates to pixmaps in widgets.
You must compile \fIxfig\fP with the \fB-DOPENWIN_BUG\fP option for this problem.
.PP
If the image is panned or the \fIxfig\fP window iconified and de-iconified
during the middle of an operation (e.g. while drawing a line), the picture
will be distorted.  This can be corrected using \fIRedraw\fP after the
operation is complete.
.PP
Rotated text will be displayed horizontally on the screen.  
They will be rotated only when printed on \fIPostScript\fP output.
.PP
Corners of object scaled with point positioning in one of the grid 
modes will not always fall on the grid line, but to the closest pixel.
.SH "SEE ALSO"
Brian W. Kernighan
.I "PIC - A Graphics Language for Typesetting User Manual"
.br
fig2dev(1) (\fITransFig\fP package)
.SH ACKNOWLEDGEMENT
Many thanks goes to Professor Donald E. Fussell who inspired the
creation of this tool.
.SH COPYRIGHT
Original Copyright (c) 1985 by Supoj Sutanthavibul
.PP
Permission to use, copy, modify, distribute, and sell this software and its
documentation for any purpose is hereby granted without fee, provided that
the above copyright notice appear in all copies and that both that
copyright notice and this permission notice appear in supporting
documentation, and that the name of M.I.T. not be used in advertising or
publicity pertaining to distribution of the software without specific,
written prior permission.  M.I.T. makes no representations about the
suitability of this software for any purpose.  It is provided "as is"
without express or implied warranty.
.PP
\fIPostScript\fP is a trademark of Adobe Systems Incorporated.
.PP
The following copyright pertains to copies of the files Xosdefs.h and Xfuncs.h
in the fig.h file.
.sp
Copyright 1991 Massachusetts Institute of Technology
.sp
Permission to use, copy, modify, distribute, and sell this software and its
documentation for any purpose is hereby granted without fee, provided that
the above copyright notice appear in all copies and that both that
copyright notice and this permission notice appear in supporting
documentation, and that the name of M.I.T. not be used in advertising or
publicity pertaining to distribution of the software without specific,
written prior permission.  M.I.T. makes no representations about the
suitability of this software for any purpose.  It is provided "as is"
without express or implied warranty.

M.I.T. DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL M.I.T.
BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION
OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN 
CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
.SH FILES
.TP
CompKeyDB - Data base of compose (meta) key sequences for 8-bit characters.  
Must be installed in \fB$(XFIGLIBDIR)\fP with 'make install', or may be
specified with command line option -keyFile or X toolkit resource keyFile.
See the \fIImakefile\fP.
.TP
Doc/FORMAT2.1 - Description of Fig file format.
.TP
CHANGES - Description of bug fixes/new features.
.SH AUTHORS
Many people have contributed to \fIxfig\fP.  Here is a list of the people who
have contributed the most (in chronological order):
.sp
Original author:
.br
Supoj Sutanthavibul, University of Texas at Austin 
.sp
The \fILaTeX\fP line drawing modes were contributed by:
.br
Frank Schmuck, Cornell University
.bp
Original X11 port by:
.br
Ken Yap, Rochester
.sp
Variable window sizes, cleanup of X11 port, right hand side panel:
.br
Dana Chee, Bellcore
.sp
Cleanup of color port to X11 by:
.br
John T. Kohl, MIT
.sp
\fBVersion 2.0:\fP
.br
Area fill, multiple line thicknesses, multiple fonts and font sizes,
bottom panel, line style/thickness modification of objects by:
.br
Brian V. Smith, Lawrence Berkeley Laboratory
.br
(standard disclaimer applies)
.br
(bvsmith@lbl.gov)
.sp
Popup change-object menu by:
.br
Jon Tombs
.br
Frank Schmuck 
.sp
Zooming and panning functions, shift key select mechanism by:
.br
Dieter Pellkofer
.br
Henning Spruth
.sp
Depth feature by:
.br
Mike Lutz
.sp
\fBVersion 2.1:\fP
.br
Indicator panel, file menu popup, print menu popup,
panning with rulers, mouse function window, regular polygon,
rubberbanding of circles/ellipses, filled splines on canvas,
dashed/dotted splines on canvas, update button,
arbitrary angle rotation of objects, alignment in compound,
object scaling, constrained copy/move, corner markers for compound,
context sensitive corner markers, smarter redraw, undo for compound
and point move for boxes, cancel object creation, point positioning
to three resolutions, \fITransFig\fP scalable text, hidden text, 
special text, save of figure on crash by:
.sp
Paul King (king@cs.uq.oz.au)
.br
with help from:
.br
Brian V. Smith (bvsmith@lbl.gov)
and Micah Beck (beck@cs.cornell.edu)
.sp
Encapsulated \fIPostScript\fP importing by:
.br
Brian Boyter
.sp
Color implementation and pan/zoom with ctrl key/mouse by:
.br
Henning Spruth
.sp
International characters by:
.br
Herve Soulard
.sp
Directory Browser based on XDir by:
.br
Win Treese, Digital Equipment Corporation
.sp
Rotated ellipses by:
.br
James Tough, Dept. of Computer Science, Heriot-Watt University, Scotland
