#!/bin/bash
################################################
# Build an rpm package
# Usage:
# su
# ./build_rpm.sh
#
# You will first have to run
# make_all_with_vtk.sh
# or
# make_all_no_vtk.sh
#
# Attention:
# If you have an older version of rpm you must substitute
# rpmbuild -ba ProcessView-xx.spec # by
# rpm      -ba ProcessView-xx.spec
#
# If you want to build an RPM without VTK
# make_all_no_vtk.sh
# remove "Requires:  vtkxxx" from ProcessView-xx.spec
# su
# ./build_rpm.sh
################################################
if [ -d /usr/src/packages/SOURCES ]; then
  echo "SuSE"
  cd ..
  tar -zcvf /usr/src/packages/SOURCES/ProcessView-29.tar.gz ProcessView-29
  cd ProcessView-29
  which rpmbuild
  if [ $? = 0 ];
  then
    rpmbuild -ba ProcessView-29.spec
  else
    rpm -ba ProcessView-29.spec
  fi
  echo "The package is located at:"
  echo "/usr/src/packages/RPMS/i586/"
  exit
fi
if [ -d /usr/src/redhat/SOURCES ]; then
  echo "RedHat"
  cd ..
  tar -zcvf /usr/src/redhat/SOURCES/ProcessView-29.tar.gz ProcessView-29
  cd ProcessView-29
  which rpmbuild
  if [ $? = 0 ];
  then
    rpmbuild -ba ProcessView-29.spec
  else
    rpm -ba ProcessView-29.spec
  fi
  echo "The package is located at:"
  echo "/usr/src/redhat/RPMS/i586/"
  exit
fi
echo "Do not know where to build rpm"
