#include <stdio.h>
#include "scene.cpp"

FILE *fp;

void MyMyMaterial(GLenum mode,GLfloat *f,GLfloat alpha)
{
 GLfloat d[4];
 d[0]=f[0];
 d[1]=f[1];
 d[2]=f[2];
 d[3]=alpha;
 //glMaterialfv (GL_FRONT_AND_BACK,mode,d);
 fprintf(fp,"glMaterialfv(%d,%d,%f,%f,%f,%f);\n",GL_FRONT_AND_BACK,mode,d[0],d[1],d[2],d[3]);
}
/*
 *  SelectMaterial uses OpenGL commands to define facet colors.
 *
 *  Returns:
 *    Nothing
 */

void MySelectMaterial(int i)
{
  //
  // Define the reflective properties of the 3D Object faces.
  //
  //glEnd();
  fprintf(fp,"glEnd();\n");
  GLfloat alpha=materials[i].alpha;
  MyMyMaterial (GL_AMBIENT, materials[i].ambient,alpha);
  MyMyMaterial (GL_DIFFUSE, materials[i].diffuse,alpha);
  MyMyMaterial (GL_SPECULAR, materials[i].specular,alpha);
  MyMyMaterial (GL_EMISSION, materials[i].emission,alpha);
  //glMaterialf (GL_FRONT_AND_BACK,GL_SHININESS,materials[i].phExp);
  fprintf(fp,"glMaterialf(%d,%d,%f);\n",GL_FRONT_AND_BACK,GL_SHININESS,materials[i].phExp);
  //glBegin(GL_TRIANGLES);
  fprintf(fp,"glBegin(%d);\n",GL_TRIANGLES);
};

GLint MyGen3DObjectList()
{
 int i;
 int j;

  //GLint lid=glGenLists(1);
	int mcount=0;
	int mindex=0;
  //  glNewList(lid, GL_COMPILE);

    //glBegin (GL_TRIANGLES);
    fprintf(fp,"glBegin(%d);\n",GL_TRIANGLES);;
      for(i=0;i<sizeof(face_indicies)/sizeof(face_indicies[0]);i++)
       {
      if(!mcount)
       {
        MySelectMaterial(material_ref[mindex][0]);
        mcount=material_ref[mindex][1];
        mindex++;
       }
       mcount--;
       for(j=0;j<3;j++)
        {
          int vi=face_indicies[i][j];
          int ni=face_indicies[i][j+3];//Normal index
          int ti=face_indicies[i][j+6];//Texture index
           //glNormal3f (normals[ni][0],normals[ni][1],normals[ni][2]);
           //glTexCoord2f(textures[ti][0],textures[ti][1]);
           //glVertex3f (vertices[vi][0],vertices[vi][1],vertices[vi][2]);
           fprintf(fp,"glNormal3f(%f,%f,%f);\n",normals[ni][0],normals[ni][1],normals[ni][2]);
           fprintf(fp,"glTexCoord2f(%f,%f);\n",textures[ti][0],textures[ti][1]);
           fprintf(fp,"glVertex3f(%f,%f,%f);\n",vertices[vi][0],vertices[vi][1],vertices[vi][2]);
        }
       }
    //glEnd ();
    fprintf(fp,"glEnd();\n");

   //glEndList();
   return 0;
};

int main()
{
  fp = fopen("scene.gl","w");
  if(fp==NULL)
  {
    printf("could not write scene.gl\n");
    return 0;
  }

  MyGen3DObjectList();

  fclose(fp);
  return 0;
}