/*
This file was produced by 3D Exploration Plugin: CPP Export filter.

3D Exploration

Copyright (c) 1999-2000 X Dimension Software

WWW         http://www.xdsoft.com/explorer/
eMail       info@xdsoft.com
*/
#include <windows.h>
#include <GL/gl.h>
#include <GL/glu.h>


struct sample_MATERIAL{
 GLfloat ambient[3];
 GLfloat diffuse[3];
 GLfloat specular[3];
 GLfloat emission[3];
 GLfloat alpha;
 GLfloat phExp;
 int   texture;
};

static sample_MATERIAL materials [1] = {
 {{0.117647f,0.117647f,0.117647f},	{0.980392f,0.0f,0.0f},	{0.752941f,0.752941f,0.752941f},	{0.0f,0.0f,0.0f},	1.0f,8.0f,-1} //ACAD #1 Color
};

// 120 Verticies
// 0 Texture Coordinates
// 83 Normals
// 204 Triangles

static BYTE face_indicies[204][9] = {
// *model space
	{0,1,2 ,0,1,2 ,0,0,0}, {3,2,4 ,3,2,4 ,0,0,0}, {5,4,1 ,5,4,1 ,0,0,0},
	{2,1,4 ,2,1,4 ,0,0,0}, {0,2,6 ,0,2,6 ,0,0,0}, {7,6,8 ,7,6,8 ,0,0,0},
	{3,8,2 ,3,8,2 ,0,0,0}, {6,2,8 ,6,2,8 ,0,0,0}, {7,8,9 ,7,8,9 ,0,0,0},
	{10,9,11 ,10,9,11 ,0,0,0}, {3,11,8 ,3,11,8 ,0,0,0}, {9,8,11 ,9,8,11 ,0,0,0},
	{3,12,11 ,3,12,11 ,0,0,0}, {10,11,13 ,10,11,13 ,0,0,0}, {14,13,12 ,14,13,12 ,0,0,0},
	{11,12,13 ,11,12,13 ,0,0,0}, {3,4,12 ,3,4,12 ,0,0,0}, {14,12,15 ,14,12,15 ,0,0,0},
	{5,15,4 ,5,15,4 ,0,0,0}, {12,4,15 ,12,4,15 ,0,0,0}, {14,15,16 ,14,15,16 ,0,0,0},
	{17,16,18 ,17,16,18 ,0,0,0}, {5,18,15 ,5,18,15 ,0,0,0}, {16,15,18 ,16,15,18 ,0,0,0},
	{14,16,19 ,14,16,19 ,0,0,0}, {20,19,21 ,20,19,21 ,0,0,0}, {17,21,16 ,17,21,16 ,0,0,0},
	{19,16,21 ,19,16,21 ,0,0,0}, {10,13,22 ,10,13,22 ,0,0,0}, {20,22,19 ,20,22,19 ,0,0,0},
	{14,19,13 ,14,19,13 ,0,0,0}, {22,13,19 ,22,13,19 ,0,0,0}, {10,22,23 ,10,22,23 ,0,0,0},
	{24,23,25 ,24,23,25 ,0,0,0}, {20,25,22 ,20,25,22 ,0,0,0}, {23,22,25 ,23,22,25 ,0,0,0},
	{24,25,26 ,24,25,26 ,0,0,0}, {27,26,28 ,27,26,28 ,0,0,0}, {20,28,25 ,20,28,25 ,0,0,0},
	{26,25,28 ,26,25,28 ,0,0,0}, {27,28,29 ,27,28,29 ,0,0,0}, {17,29,21 ,17,29,21 ,0,0,0},
	{20,21,28 ,20,21,28 ,0,0,0}, {29,28,21 ,29,28,21 ,0,0,0}, {27,29,30 ,27,29,30 ,0,0,0},
	{31,30,32 ,31,30,32 ,0,0,0}, {17,32,29 ,17,32,29 ,0,0,0}, {30,29,32 ,30,29,32 ,0,0,0},
	{27,30,33 ,27,30,33 ,0,0,0}, {34,33,35 ,34,33,35 ,0,0,0}, {31,35,30 ,31,35,30 ,0,0,0},
	{33,30,35 ,33,30,35 ,0,0,0}, {34,35,36 ,34,35,36 ,0,0,0}, {0,36,37 ,0,36,37 ,0,0,0},
	{31,37,35 ,31,37,35 ,0,0,0}, {36,35,37 ,36,35,37 ,0,0,0}, {0,37,1 ,0,37,1 ,0,0,0},
	{5,1,38 ,5,1,38 ,0,0,0}, {31,38,37 ,31,38,37 ,0,0,0}, {1,37,38 ,1,37,38 ,0,0,0},
	{31,32,38 ,31,32,38 ,0,0,0}, {5,38,18 ,5,38,18 ,0,0,0}, {17,18,32 ,17,18,32 ,0,0,0},
	{38,32,18 ,38,32,18 ,0,0,0}, {7,39,6 ,7,39,6 ,0,0,0}, {0,6,36 ,0,6,36 ,0,0,0},
	{34,36,39 ,34,36,39 ,0,0,0}, {6,39,36 ,6,39,36 ,0,0,0}, {7,40,39 ,7,40,39 ,0,0,0},
	{34,39,41 ,34,39,41 ,0,0,0}, {24,41,40 ,24,41,40 ,0,0,0}, {39,40,41 ,39,40,41 ,0,0,0},
	{7,9,40 ,7,9,40 ,0,0,0}, {24,40,23 ,24,40,23 ,0,0,0}, {10,23,9 ,10,23,9 ,0,0,0},
	{40,9,23 ,40,9,23 ,0,0,0}, {27,33,26 ,27,33,26 ,0,0,0}, {24,26,41 ,24,26,41 ,0,0,0},
	{34,41,33 ,34,41,33 ,0,0,0}, {26,33,41 ,26,33,41 ,0,0,0}, {42,43,44 ,0,42,43 ,0,0,0},
	{45,44,46 ,44,43,4 ,0,0,0}, {47,46,43 ,45,4,42 ,0,0,0}, {44,43,46 ,43,42,4 ,0,0,0},
	{42,44,48 ,0,43,46 ,0,0,0}, {49,48,50 ,47,46,48 ,0,0,0}, {45,50,44 ,44,48,43 ,0,0,0},
	{48,44,50 ,46,43,48 ,0,0,0}, {49,50,51 ,47,48,49 ,0,0,0}, {52,51,53 ,50,49,51 ,0,0,0},
	{45,53,50 ,44,51,48 ,0,0,0}, {51,50,53 ,49,48,51 ,0,0,0}, {45,54,53 ,44,52,51 ,0,0,0},
	{52,53,55 ,50,51,53 ,0,0,0}, {56,55,54 ,54,53,52 ,0,0,0}, {53,54,55 ,51,52,53 ,0,0,0},
	{45,46,54 ,44,4,52 ,0,0,0}, {56,54,57 ,54,52,55 ,0,0,0}, {47,57,46 ,45,55,4 ,0,0,0},
	{54,46,57 ,52,4,55 ,0,0,0}, {56,57,58 ,54,55,56 ,0,0,0}, {59,58,60 ,17,56,57 ,0,0,0},
	{47,60,57 ,45,57,55 ,0,0,0}, {58,57,60 ,56,55,57 ,0,0,0}, {56,58,61 ,54,56,58 ,0,0,0},
	{62,61,63 ,59,58,60 ,0,0,0}, {59,63,58 ,17,60,56 ,0,0,0}, {61,58,63 ,58,56,60 ,0,0,0},
	{52,55,64 ,50,53,61 ,0,0,0}, {62,64,61 ,59,61,58 ,0,0,0}, {56,61,55 ,54,58,53 ,0,0,0},
	{64,55,61 ,61,53,58 ,0,0,0}, {52,64,65 ,50,61,62 ,0,0,0}, {66,65,67 ,63,62,64 ,0,0,0},
	{62,67,64 ,59,64,61 ,0,0,0}, {65,64,67 ,62,61,64 ,0,0,0}, {66,67,68 ,63,64,65 ,0,0,0},
	{69,68,70 ,66,65,67 ,0,0,0}, {62,70,67 ,59,67,64 ,0,0,0}, {68,67,70 ,65,64,67 ,0,0,0},
	{69,70,71 ,66,67,68 ,0,0,0}, {59,71,63 ,17,68,60 ,0,0,0}, {62,63,70 ,59,60,67 ,0,0,0},
	{71,70,63 ,68,67,60 ,0,0,0}, {69,71,72 ,66,68,69 ,0,0,0}, {73,72,74 ,31,69,32 ,0,0,0},
	{59,74,71 ,17,32,68 ,0,0,0}, {72,71,74 ,69,68,32 ,0,0,0}, {69,72,75 ,66,69,70 ,0,0,0},
	{76,75,77 ,71,70,72 ,0,0,0}, {73,77,72 ,31,72,69 ,0,0,0}, {75,72,77 ,70,69,72 ,0,0,0},
	{76,77,78 ,71,72,73 ,0,0,0}, {42,78,79 ,0,73,74 ,0,0,0}, {73,79,77 ,31,74,72 ,0,0,0},
	{78,77,79 ,73,72,74 ,0,0,0}, {42,79,43 ,0,74,42 ,0,0,0}, {47,43,80 ,45,42,75 ,0,0,0},
	{73,80,79 ,31,75,74 ,0,0,0}, {43,79,80 ,42,74,75 ,0,0,0}, {73,74,80 ,31,32,75 ,0,0,0},
	{47,80,60 ,45,75,57 ,0,0,0}, {59,60,74 ,17,57,32 ,0,0,0}, {80,74,60 ,75,32,57 ,0,0,0},
	{49,81,48 ,47,76,46 ,0,0,0}, {42,48,78 ,0,46,73 ,0,0,0}, {76,78,81 ,71,73,76 ,0,0,0},
	{48,81,78 ,46,76,73 ,0,0,0}, {49,82,81 ,47,77,76 ,0,0,0}, {76,81,83 ,71,76,78 ,0,0,0},
	{66,83,82 ,63,78,77 ,0,0,0}, {81,82,83 ,76,77,78 ,0,0,0}, {49,51,82 ,47,49,77 ,0,0,0},
	{66,82,65 ,63,77,62 ,0,0,0}, {52,65,51 ,50,62,49 ,0,0,0}, {82,51,65 ,77,49,62 ,0,0,0},
	{69,75,68 ,66,70,65 ,0,0,0}, {66,68,83 ,63,65,78 ,0,0,0}, {76,83,75 ,71,78,70 ,0,0,0},
	{68,75,83 ,65,70,78 ,0,0,0}, {84,85,86 ,42,42,42 ,0,0,0}, {85,87,86 ,42,42,42 ,0,0,0},
	{86,87,88 ,79,79,79 ,0,0,0}, {87,89,88 ,79,79,79 ,0,0,0}, {88,89,90 ,64,64,64 ,0,0,0},
	{89,91,90 ,64,64,64 ,0,0,0}, {90,91,84 ,80,80,80 ,0,0,0}, {91,85,84 ,80,80,80 ,0,0,0},
	{90,84,88 ,81,81,81 ,0,0,0}, {84,86,88 ,81,81,81 ,0,0,0}, {85,91,87 ,82,82,82 ,0,0,0},
	{91,89,87 ,82,82,82 ,0,0,0}, {92,93,94 ,42,42,42 ,0,0,0}, {93,95,94 ,42,42,42 ,0,0,0},
	{94,95,92 ,64,64,64 ,0,0,0}, {95,93,92 ,64,64,64 ,0,0,0}, {99,96,98 ,81,81,81 ,0,0,0},
	{96,97,98 ,81,81,81 ,0,0,0}, {96,99,97 ,82,82,82 ,0,0,0}, {99,98,97 ,82,82,82 ,0,0,0},
	{100,101,102 ,42,42,42 ,0,0,0}, {101,103,102 ,42,42,42 ,0,0,0},
	{102,103,100 ,64,64,64 ,0,0,0}, {103,101,100 ,64,64,64 ,0,0,0},
	{104,105,106 ,42,42,42 ,0,0,0}, {105,107,106 ,42,42,42 ,0,0,0},
	{106,107,108 ,79,79,79 ,0,0,0}, {107,109,108 ,79,79,79 ,0,0,0},
	{108,109,110 ,64,64,64 ,0,0,0}, {109,111,110 ,64,64,64 ,0,0,0},
	{110,111,104 ,80,80,80 ,0,0,0}, {111,105,104 ,80,80,80 ,0,0,0},
	{110,104,108 ,81,81,81 ,0,0,0}, {104,106,108 ,81,81,81 ,0,0,0},
	{105,111,107 ,82,82,82 ,0,0,0}, {111,109,107 ,82,82,82 ,0,0,0},
	{115,112,114 ,81,81,81 ,0,0,0}, {112,113,114 ,81,81,81 ,0,0,0},
	{112,115,113 ,82,82,82 ,0,0,0}, {115,114,113 ,82,82,82 ,0,0,0},
	{116,117,118 ,42,42,42 ,0,0,0}, {117,119,118 ,42,42,42 ,0,0,0},
	{118,119,116 ,64,64,64 ,0,0,0}, {119,117,116 ,64,64,64 ,0,0,0}
};
static GLfloat vertices [120][3] = {
{-0.16025f,-0.0641711f,0.0814818f},{0.0f,-0.0641711f,0.127005f},{-0.0941923f,0.0882353f,0.0687913f},
{0.0f,0.195118f,-0.0175579f},{0.0941923f,0.0882353f,0.0687913f},{0.16025f,-0.0641711f,0.0814818f},
{-0.246599f,0.0300212f,-0.0254011f},{-0.259289f,0.0960785f,-0.177807f},{-0.152406f,0.182428f,-0.0836151f},
{-0.152406f,0.182428f,-0.272f},{0.0f,0.195118f,-0.338057f},{0.0f,0.240642f,-0.177807f},
{0.152406f,0.182428f,-0.0836151f},{0.152406f,0.182428f,-0.272f},{0.259289f,0.0960785f,-0.177807f},
{0.246599f,0.0300212f,-0.0254011f},{0.304813f,-0.0641711f,-0.177807f},{0.259289f,-0.224421f,-0.177807f},
{0.246599f,-0.158363f,-0.0254011f},{0.246599f,0.0300212f,-0.330214f},{0.16025f,-0.0641711f,-0.437097f},
{0.246599f,-0.158363f,-0.330214f},{0.0941923f,0.0882353f,-0.424406f},{-0.0941923f,0.0882353f,-0.424406f},
{-0.16025f,-0.0641711f,-0.437097f},{0.0f,-0.0641711f,-0.48262f},{-0.0941923f,-0.216578f,-0.424406f},
{0.0f,-0.32346f,-0.338057f},{0.0941923f,-0.216578f,-0.424406f},{0.152406f,-0.31077f,-0.272f},
{0.0f,-0.368984f,-0.177807f},{0.0f,-0.32346f,-0.0175579f},{0.152406f,-0.31077f,-0.0836151f},
{-0.152406f,-0.31077f,-0.272f},{-0.259289f,-0.224421f,-0.177807f},{-0.152406f,-0.31077f,-0.0836151f},
{-0.246599f,-0.158363f,-0.0254011f},{-0.0941923f,-0.216578f,0.0687913f},{0.0941923f,-0.216578f,0.0687913f},
{-0.304813f,-0.0641711f,-0.177807f},{-0.246599f,0.0300212f,-0.330214f},{-0.246599f,-0.158363f,-0.330214f},
{-0.170089f,0.176471f,0.434301f},{0.0f,0.176471f,0.48262f},{-0.0999761f,0.338235f,0.420832f},
{0.0f,0.451681f,0.32918f},{0.0999761f,0.338235f,0.420832f},{0.170089f,0.176471f,0.434301f},
{-0.261741f,0.276447f,0.320856f},{-0.275211f,0.34656f,0.159091f},{-0.161765f,0.438211f,0.259067f},
{-0.161765f,0.438211f,0.0591148f},{0.0f,0.451681f,-0.0109986f},{0.0f,0.5f,0.159091f},
{0.161765f,0.438211f,0.259067f},{0.161765f,0.438211f,0.0591148f},{0.275211f,0.34656f,0.159091f},
{0.261741f,0.276447f,0.320856f},{0.323529f,0.176471f,0.159091f},{0.275211f,0.00638111f,0.159091f},
{0.261741f,0.0764945f,0.320856f},{0.261741f,0.276447f,-0.0026738f},{0.170089f,0.176471f,-0.11612f},
{0.261741f,0.0764945f,-0.0026738f},{0.0999761f,0.338235f,-0.10265f},{-0.0999761f,0.338235f,-0.10265f},
{-0.170089f,0.176471f,-0.11612f},{0.0f,0.176471f,-0.164439f},{-0.0999761f,0.0147059f,-0.10265f},
{0.0f,-0.09874f,-0.0109986f},{0.0999761f,0.0147059f,-0.10265f},{0.161765f,-0.0852702f,0.0591148f},
{0.0f,-0.147059f,0.159091f},{0.0f,-0.09874f,0.32918f},{0.161765f,-0.0852702f,0.259067f},
{-0.161765f,-0.0852702f,0.0591148f},{-0.275211f,0.00638111f,0.159091f},{-0.161765f,-0.0852702f,0.259067f},
{-0.261741f,0.0764945f,0.320856f},{-0.0999761f,0.0147059f,0.420832f},{0.0999761f,0.0147059f,0.420832f},
{-0.323529f,0.176471f,0.159091f},{-0.261741f,0.276447f,-0.0026738f},{-0.261741f,0.0764945f,-0.0026738f},
{-0.25f,-0.0187166f,0.442513f},{-0.25f,-0.5f,0.442513f},{0.25f,-0.0187166f,0.442513f},
{0.25f,-0.5f,0.442513f},{0.25f,-0.0187166f,-0.0574866f},{0.25f,-0.5f,-0.0574866f},
{-0.25f,-0.0187166f,-0.0574866f},{-0.25f,-0.5f,-0.0574866f},{-0.0040107f,-0.101604f,-0.19385f},
{-0.0040107f,-0.109626f,-0.19385f},{0.0040107f,-0.101604f,-0.19385f},{0.0040107f,-0.109626f,-0.19385f},
{-0.0013369f,-0.136364f,-0.199198f},{0.0013369f,-0.136364f,-0.199198f},{0.0013369f,-0.136364f,-0.201872f},
{-0.0013369f,-0.136364f,-0.201872f},{-0.0026738f,-0.0614973f,-0.180481f},{-0.0026738f,-0.0668449f,-0.180481f},
{0.0026738f,-0.0614973f,-0.180481f},{0.0026738f,-0.0668449f,-0.180481f},{-0.00668449f,-0.0508021f,-0.175134f},
{-0.00668449f,-0.0641711f,-0.175134f},{0.00668449f,-0.0508021f,-0.175134f},{0.00668449f,-0.0641711f,-0.175134f},
{0.00668449f,-0.0508021f,-0.180481f},{0.00668449f,-0.0641711f,-0.180481f},{-0.00668449f,-0.0508021f,-0.180481f},
{-0.00668449f,-0.0641711f,-0.180481f},{-0.0013369f,-0.0534759f,-0.215241f},{0.0013369f,-0.0534759f,-0.215241f},
{0.0013369f,-0.0534759f,-0.217914f},{-0.0013369f,-0.0534759f,-0.217914f},{-0.0013369f,-0.106952f,-0.266043f},
{-0.0013369f,-0.109626f,-0.266043f},{0.0013369f,-0.106952f,-0.266043f},{0.0013369f,-0.109626f,-0.266043f}
};
static GLfloat normals [83][3] = {
{-0.525731f,3.15862e-09f,0.850651f},{0.0f,5.28182e-09f,1.0f},{-0.309017f,0.5f,0.809017f},
{0.0f,0.850651f,0.525731f},{0.309017f,0.5f,0.809017f},{0.525731f,6.31725e-09f,0.850651f},
{-0.809017f,0.309017f,0.5f},{-0.850651f,0.525731f,0.0f},{-0.5f,0.809017f,0.309017f},
{-0.5f,0.809017f,-0.309017f},{0.0f,0.850651f,-0.525731f},{-5.28182e-09f,1.0f,1.05636e-08f},
{0.5f,0.809017f,0.309017f},{0.5f,0.809017f,-0.309017f},{0.850651f,0.525731f,0.0f},
{0.809017f,0.309017f,0.5f},{1.0f,-1.05636e-08f,1.05636e-08f},{0.850651f,-0.525731f,0.0f},
{0.809017f,-0.309017f,0.5f},{0.809017f,0.309017f,-0.5f},{0.525731f,6.31725e-09f,-0.850651f},
{0.809017f,-0.309017f,-0.5f},{0.309017f,0.5f,-0.809017f},{-0.309017f,0.5f,-0.809017f},
{-0.525731f,0.0f,-0.850651f},{0.0f,5.28182e-09f,-1.0f},{-0.309017f,-0.5f,-0.809017f},
{6.31725e-09f,-0.850651f,-0.525731f},{0.309017f,-0.5f,-0.809017f},{0.5f,-0.809017f,-0.309017f},
{5.28182e-09f,-1.0f,1.05636e-08f},{0.0f,-0.850651f,0.525731f},{0.5f,-0.809017f,0.309017f},
{-0.5f,-0.809017f,-0.309017f},{-0.850651f,-0.525731f,-6.31725e-09f},{-0.5f,-0.809017f,0.309017f},
{-0.809017f,-0.309017f,0.5f},{-0.309017f,-0.5f,0.809017f},{0.309017f,-0.5f,0.809017f},
{-1.0f,-1.05636e-08f,1.05636e-08f},{-0.809017f,0.309017f,-0.5f},{-0.809017f,-0.309017f,-0.5f},
{0.0f,0.0f,1.0f},{-0.309017f,0.5f,0.809017f},{-6.31725e-09f,0.850651f,0.525731f},
{0.525731f,0.0f,0.850651f},{-0.809017f,0.309017f,0.5f},{-0.850651f,0.525731f,1.26345e-08f},
{-0.5f,0.809017f,0.309017f},{-0.5f,0.809017f,-0.309017f},{0.0f,0.850651f,-0.525731f},
{0.0f,1.0f,-1.05636e-08f},{0.5f,0.809017f,0.309017f},{0.5f,0.809017f,-0.309017f},
{0.850651f,0.525731f,1.26345e-08f},{0.809017f,0.309017f,0.5f},{1.0f,0.0f,5.28182e-09f},
{0.809017f,-0.309017f,0.5f},{0.809017f,0.309017f,-0.5f},{0.525731f,0.0f,-0.850651f},
{0.809017f,-0.309017f,-0.5f},{0.309017f,0.5f,-0.809017f},{-0.309017f,0.5f,-0.809017f},
{-0.525731f,0.0f,-0.850651f},{0.0f,0.0f,-1.0f},{-0.309017f,-0.5f,-0.809017f},
{0.0f,-0.850651f,-0.525731f},{0.309017f,-0.5f,-0.809017f},{0.5f,-0.809017f,-0.309017f},
{-5.28182e-09f,-1.0f,-1.05636e-08f},{-0.5f,-0.809017f,-0.309017f},{-0.850651f,-0.525731f,0.0f},
{-0.5f,-0.809017f,0.309017f},{-0.809017f,-0.309017f,0.5f},{-0.309017f,-0.5f,0.809017f},
{0.309017f,-0.5f,0.809017f},{-1.0f,0.0f,5.28182e-09f},{-0.809017f,0.309017f,-0.5f},
{-0.809017f,-0.309017f,-0.5f},{1.0f,0.0f,0.0f},{-1.0f,0.0f,0.0f},
{0.0f,1.0f,0.0f},{0.0f,-1.0f,0.0f}
};
GLfloat textures[1][2]={{0.0f,0.0f}};
/*Material indicies*/
/*{material index,face count}*/
static int material_ref [1][2] = {
{0,204}
};
void MyMaterial(GLenum mode,GLfloat *f,GLfloat alpha)
{
 GLfloat d[4];
 d[0]=f[0];
 d[1]=f[1];
 d[2]=f[2];
 d[3]=alpha;
 glMaterialfv (GL_FRONT_AND_BACK,mode,d);
}
/*
 *  SelectMaterial uses OpenGL commands to define facet colors.
 *
 *  Returns:
 *    Nothing
 */

void SelectMaterial(int i)
{
  //
  // Define the reflective properties of the 3D Object faces.
  //
  glEnd();
  GLfloat alpha=materials[i].alpha;
  MyMaterial (GL_AMBIENT, materials[i].ambient,alpha);
  MyMaterial (GL_DIFFUSE, materials[i].diffuse,alpha);
  MyMaterial (GL_SPECULAR, materials[i].specular,alpha);
  MyMaterial (GL_EMISSION, materials[i].emission,alpha);
  glMaterialf (GL_FRONT_AND_BACK,GL_SHININESS,materials[i].phExp);
  glBegin(GL_TRIANGLES);

};

GLint Gen3DObjectList()
{
 int i;
 int j;

 GLint lid=glGenLists(1);
	int mcount=0;
	int mindex=0;
   glNewList(lid, GL_COMPILE);

    glBegin (GL_TRIANGLES);
      for(i=0;i<sizeof(face_indicies)/sizeof(face_indicies[0]);i++)
       {
      if(!mcount)
       {
        SelectMaterial(material_ref[mindex][0]);
        mcount=material_ref[mindex][1];
        mindex++;
       }
       mcount--;
       for(j=0;j<3;j++)
        {
          int vi=face_indicies[i][j];
          int ni=face_indicies[i][j+3];//Normal index
          int ti=face_indicies[i][j+6];//Texture index
           glNormal3f (normals[ni][0],normals[ni][1],normals[ni][2]);
           glTexCoord2f(textures[ti][0],textures[ti][1]);
           glVertex3f (vertices[vi][0],vertices[vi][1],vertices[vi][2]);
        }
       }
    glEnd ();

   glEndList();
   return lid;
};
