/*
convert the export file from 3dexplore to unix format
Rainer Lehrig 2000
*/
#include <stdio.h>
#include <string.h>

void filter(FILE *fin, FILE *fout)
{
char line[1024];

  while(fgets(line,sizeof(line)-1,fin) != NULL)
  {
    if(strstr(line,"windows.h") != NULL)
    {
      fprintf(fout,"typedef unsigned char BYTE;\n");
    }
    else if(strstr(line,"<GL\\gl.h>") != NULL)
    {
      fprintf(fout,"#include <GL/gl.h>\n");
    }
    else if(strstr(line,"<GL\\glu.h>") != NULL)
    {
      fprintf(fout,"#include <GL/glu.h>\n");
    }
    else
    {
      fprintf(fout,line);
    }
  }
}

int main(int ac, char **av)
{
  FILE *fin,*fout;

  if(ac != 3)
  {
    printf("usage: tounix inputfile outputfile");
    return 0;
  }

  fin = fopen(av[1],"r");
  if(fin == NULL)
  {
    printf("could not read %s\n",av[1]);
    return 0;
  }
  fout = fopen(av[2],"w");
  if(fin == NULL)
  {
    printf("could not write %s\n",av[2]);
    fclose(fin);
    return 0;
  }

  filter(fin,fout);

  fclose(fin);
  fclose(fout);
  return 0;
}