/*
Named object: "GeoSphere01"
Tri-mesh, Vertices: 42 Faces: 80
Vertex List:
Vertex 0:  X:-14.983335    Y:19.750000    Z:17.993547
*/

#include <stdio.h>
#include <string.h>

static void filter(FILE *fin, FILE *fout)
{
char  line[1024],*cptr;
float x,y,z;

  while(fgets(line,sizeof(line)-1,fin) != NULL)
  {
    if(strncmp(line,"Named object",12) == 0)
    {
    }
    else if(strncmp(line,"Tri-mesh,",9) == 0)
    {
    }
    else if(strncmp(line,"Vertex List:",12) == 0)
    {
    }
    else if(strncmp(line,"Vertex",6) == 0)
    {
      cptr = strstr(line,"X:");
      sscanf(cptr,"X:%f",&x);
      cptr = strstr(line,"Y:");
      sscanf(cptr,"Y:%f",&y);
      cptr = strstr(line,"Z:");
      sscanf(cptr,"Z:%f",&z);
      fprintf(fout,"glVertex3f(%f,%f,%f);\n",x,y,z);
    }
    else
    {
      printf("not handled: %s",line);
    }
  }
}

int main(int ac, char **av)
{
FILE *fin,*fout;

  if(ac != 3)
  {
    printf("usage: asc2gl input.asc output.gl\n");
    return 0;
  }

  fin = fopen(av[1],"r");
  if(fin == NULL)
  {
    printf("could not open %s for reading\n",av[1]);
    return 0;
  }
  fout = fopen(av[2],"w");
  if(fout == NULL)
  {
    fclose(fin);
    printf("could not open %s for writing\n",av[2]);
    return 0;
  }

  filter(fin,fout);

  fclose(fin);
  fclose(fout);
  return 0;
}

