#include <kio/slavebase.h>
#include <kinstance.h>
#include <kdebug.h>
#include <stdlib.h>
#include <qtextstream.h>

class PvProtocol : public KIO::SlaveBase
{
public:
    PvProtocol( const QCString &pool, const QCString &app)
        : SlaveBase( "pv", pool, app ) {}
    virtual void get( const KURL& url );
};

extern "C" {
    int kdemain( int, char **argv )
    {
        KInstance instance( "kio_pv" );
        PvProtocol slave(argv[2], argv[3]);
        slave.dispatchLoop();
        return 0;
    }
}

void PvProtocol::get( const KURL& url )
{
    // tell the mimetype
    mimeType("uri/pv");

    QString name = url.path();
    if (name.isEmpty() || name == "/")
        name = "C't Readers";
    else
        name = name.mid(1); // strip leading /

    QCString output;
    output.sprintf("<HTML>\n"
                   "<BODY>pv %s</BODY>\n"
                   "</HTML>\n", name.latin1());

    data(output);
    finished();
}
