
#include "processview.h"
#include "pvbrowser_part.h"

#include <kinstance.h>
#include <kaction.h>
#include <kstdaction.h>
#include <kfiledialog.h>
#include <kglobal.h>
#include <klocale.h>

#include <qfile.h>
#include <qtextstream.h>
#include <qmultilineedit.h>

pvbrowserPart::pvbrowserPart( QWidget *parentWidget, const char *widgetName,
                                  QObject *parent, const char *name )
    : KParts::ReadOnlyPart(parent, name)
{
    // we need an instance
    setInstance( pvbrowserPartFactory::instance() );
    // this should be your custom internal widget
    m_widget = new ProcessView(parentWidget, widgetName, 0);
    m_widget->setFocusPolicy(QWidget::StrongFocus);

    // notify the part that this is our internal widget
    setWidget(m_widget);

    // create our actions
    KStdAction::open(this, SLOT(fileOpen()), actionCollection());

    // set our XML-UI resource file
    //setXMLFile("pvbrowser_part.rc");
}

pvbrowserPart::~pvbrowserPart()
{
}

bool pvbrowserPart::openFile()
{
    QString url = m_url.url();
    //printf("openFile url=%s\n",(const char *) url);
    if(!url.isNull()) m_widget->slotRecentUrls(url);
    return true;
}

void pvbrowserPart::fileOpen()
{
    // this slot is called whenever the File->Open menu is selected,
    // the Open shortcut is pressed (usually CTRL+O) or the Open toolbar
    // button is clicked
    QString file_name = KFileDialog::getOpenFileName();
    if (file_name.isEmpty() == false)
    {
        m_widget->slotRecentUrls(file_name);
    }
}

// It's usually safe to leave the factory code alone.. with the
// notable exception of the KAboutData data
#include <kaboutdata.h>
#include <klocale.h>

KInstance*  pvbrowserPartFactory::s_instance = 0L;
KAboutData* pvbrowserPartFactory::s_about = 0L;

pvbrowserPartFactory::pvbrowserPartFactory()
    : KParts::Factory()
{
}

pvbrowserPartFactory::~pvbrowserPartFactory()
{
    delete s_instance;
    delete s_about;

    s_instance = 0L;
}

KParts::Part* pvbrowserPartFactory::createPartObject( QWidget *parentWidget, const char *widgetName,
                                                        QObject *parent, const char *name,
                                                        const char *classname, const QStringList &args )
{
    // Create an instance of our Part
    pvbrowserPart* obj = new pvbrowserPart( parentWidget, widgetName, parent, name );

    // See if we are to be read-write or not
    if (QCString(classname) == "KParts::ReadOnlyPart")
    {
      //obj->setReadWrite(false);
    }
    if(args.isEmpty()) return obj; // stupid workaround for unused parameter
    return obj;
}

KInstance* pvbrowserPartFactory::instance()
{
    if( !s_instance )
    {
        s_about = new KAboutData("pvbrowserpart", I18N_NOOP("pvbrowserPart"), "2.8");
        s_about->addAuthor("Rainer Lehrig", 0, "lehrig@t-online.de");
        s_instance = new KInstance(s_about);
    }
    return s_instance;
}

extern "C"
{
    void* init_libpvbrowserpart()
    {
  KGlobal::locale()->insertCatalogue("pvbrowser");
        return new pvbrowserPartFactory;
    }
};

//#include "pvbrowser_part.moc"
