
#ifndef _PVBROWSERPART_H_
#define _PVBROWSERPART_H_

#include <kparts/part.h>
#include <kparts/factory.h>

class QWidget;
class QPainter;
class KURL;
class QMultiLineEdit;
class ProcessView;

/**
 * This is a "Part".  It that does all the real work in a KPart
 * application.
 *
 * @short Main Part
 * @author Rainer Lehrig <lehrig@t-online.de>
 * @version 2.8
 */
class pvbrowserPart : public KParts::ReadOnlyPart
{
    Q_OBJECT
public:
    /**
     * Default constructor
     */
    pvbrowserPart(QWidget *parentWidget, const char *widgetName,
                    QObject *parent, const char *name);

    /**
     * Destructor
     */
    virtual ~pvbrowserPart();

protected:
    /**
     * This must be implemented by each part
     */
    virtual bool openFile();

protected slots:
    void fileOpen();

private:
    ProcessView *m_widget;
};

class KInstance;
class KAboutData;

class pvbrowserPartFactory : public KParts::Factory
{
    Q_OBJECT
public:
    pvbrowserPartFactory();
    virtual ~pvbrowserPartFactory();
    virtual KParts::Part* createPartObject( QWidget *parentWidget, const char *widgetName,
                                            QObject *parent, const char *name,
                                            const char *classname, const QStringList &args );
    static KInstance* instance();
 
private:
    static KInstance* s_instance;
    static KAboutData* s_about;
};

#endif // _PVBROWSERPART_H_
