#!/usr/bin/perl
### Demo ProcessViewServer in Perl #############################################
$sleep      = 500;  # Cycle time for updates in milliseconds
$port       = 5050; # Only relevant for multithreaded server
$use_thread = 0;    # 0|1 0=INETD 1=FORK
chdir("/home/lehrig/cc/priv/cvs/ProcessView/language_bindings/perl/id");
################################################################################
use pv;
$p        = pv::new_PARAM();
$ret      = pv::pvInitInternal($p);
$p::sleep = $sleep;
$p::port  = $port;
### Import all your masks ######################################################
use periodic;

### pvMain #####################################################################
sub pvMain
{
  my ($pv, $p) = @_;
  ### Define all your masks ####################################################
  $mask_periodic = periodic->new();
  $ret = pv::pvSetCaption($p,"pvsdemo");
  $ret = pv::pvResize($p,0,1280,1024);
  ### Show the masks ###########################################################
  $ret = 1;
  while(1)
  {
    if($ret == 1)
    {
      $ret = $mask_periodic->show($pv,$p)
    }
    else
    {
      last;
    }
  }
  #  ### Cleanup ##################################################################
  #  del mask_periodic
  return 0;
}

### Wait for clients ###########################################################
if($use_thread == 1)
{
  while(1)
  {
    $s = pv::pvAccept($p);
    if($s == -1)
    {
      last;
    }
    $p::s = $s;
    $childpid = fork();
    if($childpid == 0)
    {
      pvMain($pv,$p);
      last;
    }
  }
}
else
{
  pvMain($pv,$p);
}
pv::delete_PARAM($p);
################################################################################
