#!/usr/bin/tclsh
### Demo ProcessViewServer in Tcl ##############################################
# Cycle time for updates in milliseconds
set sleep 500
# Only relevant for multithreaded server
set port  5050
# 0=INETD 1=FORK 2=DEBUG
set use_thread 0
cd "/home/lehrig/cc/priv/cvs/ProcessView/language_bindings/tcl/id"
################################################################################
load libpv.so
set p [ new_PARAM ]
set ret [ pvInitInternal $p ]
$p configure -sleep $sleep
$p configure -port  $port
### pvMain #####################################################################
proc pvMainScript { p } {
  ### Define all your masks ####################################################
  pvSetCaption $p "pvsdemo"
  pvResize $p 0 1280 1024
  ### Show the masks ###########################################################
  set ret 1
  while { 1 } {
    if { $ret == 1 } {
      set ret [ source periodic.tcl ]
    }
    else {
      break
    }
  }
  return ret
}
### Wait for clients ###########################################################
if { $use_thread == 2 } {
  while { 1 } {
    set s [ pvAccept $p ]
    if { $s == -1 } {
      break
    }
    $p configure -s $s
    pvMainScript $p
    break
  }
} else {
  pvMainScript $p
}
################################################################################
