#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <dirent.h>
#define MAXLINE 4096

static char qt_lib[]          = "/usr/lib/libqt-mt.so.3";
static char tcl_lib[MAXLINE]  = "";
static char tk_lib[MAXLINE]   = "";
static char tcl_lib_with_version[MAXLINE]  = "";
static char tk_lib_with_version[MAXLINE]   = "";
static char vtk_lib[]         = "/usr/local/lib/vtk/libvtkRendering.so /usr/local/lib/vtk/libvtkjpeg.so /usr/local/lib/vtk/libvtkpng.so /usr/local/lib/vtk/libvtkGraphics.so /usr/local/lib/vtk/libvtkzlib.so /usr/local/lib/vtk/libvtkIO.so /usr/local/lib/vtk/libvtkImaging.so /usr/local/lib/vtk/libvtkFiltering.so /usr/local/lib/vtk/libvtkCommonTCL.so /usr/local/lib/vtk/libvtkFilteringTCL.so /usr/local/lib/vtk/libvtkGraphicsTCL.so /usr/local/lib/vtk/libvtkIOTCL.so /usr/local/lib/vtk/libvtkImagingTCL.so /usr/local/lib/vtk/libvtkRenderingTCL.so /usr/local/lib/vtk/libvtkPatentedTCL.so /usr/local/lib/vtk/libvtkHybridTCL.so /usr/local/lib/vtk/libvtkParallelTCL.so /usr/local/lib/vtk/libvtkCommon.so";
static char processview_obj[] = "main.o MyWidgets.moc.o gldecode.o pvglwidget.o viewdata.o MyWidgets.o qdrawwidget.moc.o vtkQGLRenderWindow.o QDrawWidget.o processview.moc.o qimagewidget.moc.o vtkQGLWidget.moc.o QImageWidget.o processview.o tcputil.o vtkQGLWidget.o dlgopt.moc.o pvVtkTclWidget.moc.o tkAppInit.o dlgopt.o pvVtkTclWidget.o view.moc.o dlgoptdata.o pvglwidget.moc.o view.o";
static char processviewserver_obj[] = "main.o Mask1.o Mask3.o modal1.o glencode.o maskvtk.o pvbImage.o wthread.o Mask2.o Mask4.o periodic.o util.o";
static char ui2pvc_obj[]      = "main.o generator.o";
static char pvmviewer_obj[]   = "main.o QDrawWidget.o  pvmviewer.moc.o  qdrawwidget.moc.o pvmviewer.o tcputil.o";

static int has_version(const char *name)
{
  int i;
  int len = strlen(name);
  for(i=0; i<len; i++)
  {
    if(isdigit(name[i])) return 1;
  }
  return 0;
}

static int get_tcl_lib()
{
  char name[MAXLINE];
  struct dirent *entry;
  DIR *dir = opendir("/usr/lib");
  while(1)
  {
    entry = readdir(dir);
    if(entry == NULL)
    {
      if(strlen(tcl_lib) <= 0)
      {
        printf("could not find /usr/lib/libtcl*.so\n");
        exit(-1);
      }
      else return 0;
    }
    if(strncmp(entry->d_name,"libtcl",6) == 0 && strstr(entry->d_name,".so") != NULL)
    {
      strcpy(name,entry->d_name);
      strcpy(tcl_lib,"/usr/lib/");
      strcat(tcl_lib,name);
    }
  }
  closedir(dir);
  return 0;
}

static int get_tk_lib()
{
  char name[MAXLINE];
  struct dirent *entry;
  DIR *dir = opendir("/usr/lib");
  while(1)
  {
    entry = readdir(dir);
    if(entry == NULL)
    {
      if(strlen(tk_lib) <= 0)
      {
        printf("could not find /usr/lib/libtk*.so\n");
        exit(-1);
      }
      else return 0;
    }
    if(strncmp(entry->d_name,"libtk",5) == 0 && strstr(entry->d_name,".so") != NULL)
    {
      strcpy(name,entry->d_name);
      strcpy(tk_lib,"/usr/lib/");
      strcat(tk_lib,name);
    }
  }
  closedir(dir);
  return 0;
}

int main()
{
char command[MAXLINE];

  get_tcl_lib();
  get_tk_lib();

  printf("Link: processview/processview/processview\n");
  strcpy(command,"cd processview/processview; gcc -o processview ");
  strcat(command,processview_obj);
  strcat(command," ");
  strcat(command,qt_lib);
  strcat(command," ");
  strcat(command,tcl_lib);
  strcat(command," ");
  strcat(command,tk_lib);
  strcat(command," ");
  strcat(command,vtk_lib);
  system(command);

  printf("Link: processviewserver/processviewserver/processviewserver\n");
  strcpy(command,"cd processviewserver/processviewserver; gcc -o processviewserver ");
  strcat(command," ");
  strcat(command,processviewserver_obj);
  strcat(command," /usr/lib/libpthread.so /usr/lib/libm.so");
  system(command);

  printf("Link: pvmviewer/pvmviewer/pvmviewer\n");
  strcpy(command,"cd pvmviewer/pvmviewer; gcc -o pvmviewer ");
  strcat(command,pvmviewer_obj);
  strcat(command," ");
  strcat(command,qt_lib);
  system(command);

  printf("Link: ui2pvc/ui2pvc/ui2pvc\n");
  strcpy(command,"cd ui2pvc/ui2pvc; gcc -o ui2pvc ");
  strcat(command,ui2pvc_obj);
  strcat(command," ");
  strcat(command,qt_lib);
  system(command);

  printf("Compile and Link: gl/asc2gl\n");
  strcpy(command,"cd gl; gcc asc2gl.c -o asc2gl");
  system(command);

  return 0;
}
