#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <dirent.h>
#define MAXLINE 4096

static char tcl_lib[MAXLINE]               = "";
static char tcl_lib_with_version[MAXLINE]  = "";
static char tk_lib[MAXLINE]                = "";
static char tk_lib_with_version[MAXLINE]   = "";

static int has_version(const char *name)
{
  int i;
  int len = strlen(name);
  for(i=0; i<len; i++)
  {
    if(isdigit(name[i])) return 1;
  }
  return 0;
}

static int get_tcl_lib()
{
  char name[MAXLINE];
  struct dirent *entry;
  DIR *dir = opendir("/usr/lib");
  while(1)
  {
    entry = readdir(dir);
    if(entry == NULL) break;
    if(strncmp(entry->d_name,"libtcl",6) == 0 && strstr(entry->d_name,".so") != NULL)
    {
      strcpy(name,entry->d_name);
      if(has_version(name))
      {
        strcpy(tcl_lib_with_version,"/usr/lib/");
        strcat(tcl_lib_with_version,name);
      }
    }
    if(strncmp(entry->d_name,"libpvtcl",8) == 0 && strstr(entry->d_name,".so") != NULL)
    {
      strcpy(name,entry->d_name);
      strcpy(tcl_lib,"/usr/lib/");
      strcat(tcl_lib,name);
    }
  }
  closedir(dir);
  return 0;
}

static int get_tk_lib()
{
  char name[MAXLINE];
  struct dirent *entry;
  DIR *dir = opendir("/usr/lib");
  while(1)
  {
    entry = readdir(dir);
    if(entry == NULL) break;
    if(strncmp(entry->d_name,"libtk",5) == 0 && strstr(entry->d_name,".so") != NULL)
    {
      strcpy(name,entry->d_name);
      if(has_version(name))
      {
        strcpy(tk_lib_with_version,"/usr/lib/");
        strcat(tk_lib_with_version,name);
      }
    }
    if(strncmp(entry->d_name,"libpvtk",7) == 0 && strstr(entry->d_name,".so") != NULL)
    {
      strcpy(name,entry->d_name);
      strcpy(tk_lib,"/usr/lib/");
      strcat(tk_lib,name);
    }
  }
  closedir(dir);
  return 0;
}

int main()
{
char command[MAXLINE];

  get_tcl_lib();
  get_tk_lib();

  if(strlen(tcl_lib) <= 0 && strlen(tcl_lib_with_version) > 0)
  {
    strcpy(command,"ln -s ");
    strcat(command,tcl_lib_with_version);
    strcat(command," /usr/lib/libpvtcl.so");
    printf("Setting link: %s\n",command);
    system(command);
  }
  else if(strlen(tcl_lib) > 0)
  {
    printf("already available: /usr/lib/libpvtcl.so\n");
  }
  else
  {
    printf("could not find: /usr/lib/libtcl*.so\n");
    return 1;
  }

  if(strlen(tk_lib) <= 0 && strlen(tk_lib_with_version) > 0)
  {
    strcpy(command,"ln -s ");
    strcat(command,tk_lib_with_version);
    strcat(command," /usr/lib/libpvtk.so");
    printf("Setting link: %s\n",command);
    system(command);
  }
  else if(strlen(tcl_lib) > 0)
  {
    printf("already available: /usr/lib/libpvtk.so\n");
  }
  else
  {
    printf("could not find: /usr/lib/libtk*.so\n");
    return 1;
  }

  return 0;
}
