#include <stdio.h>
#include <string.h>
#include <stdlib.h>

char line[256*256];
const char *input,*output;

int qmake(int ac, const char **av)
{
  int i;
  int ret = 0;
  input = output = NULL;
  for(i=1; i<ac; i++)
  {
    if(strcmp(av[i],"-o") == 0)
    {
      i++;
      if(i <= ac) output = av[i];
    }
    else if(strncmp(av[i],"-",1) != 0)
    {
      if(i <= ac) input = av[i];
    }
  }
  if(input == NULL || output == NULL)
  {
    printf("usage:\n");
    printf("pvsmake input.pro -o output\n");
    exit(0);
  }

  sprintf(line,"qmake %s -o %s.qmake",input,output);
  ret = system(line);
  return ret;
}

int main(int ac, const char **av)
{
  FILE *fp,*fpout;

  qmake(ac,av);
  sprintf(line,"%s.qmake",output);
  fp = fopen(line,"r");
  if(fp == NULL)
  {
    printf("could not open %s\n",line);
    return 0;
  }
  fpout = fopen(output,"w");
  if(fpout == NULL)
  {
    printf("could not write %s\n",output);
    fclose(fp);
    return 0;
  }

  while(fgets(line,sizeof(line)-1,fp) != NULL)
  {
    if(strncmp(line,".SUFFIXES:",10) == 0)
    {
      fprintf(fpout,".SUFFIXES: .c .o .cpp .cc .cxx .C .ui\n\n");
      fprintf(fpout,".ui.cpp:\n");
      fprintf(fpout,"\tui2pvc $< $@\n\n");
      fprintf(fpout,".ui.c:\n");
      fprintf(fpout,"\tui2pvc $< $@\n");
    }
    else if(strstr(line,"mkspecs/default/qmake.conf") != NULL)
    {
      fprintf(fpout,"%s: %s\n",output,input);
      fprintf(fpout,"\tpvsmake %s -o %s\n",input,output);
      fgets(line,sizeof(line)-1,fp);
      fgets(line,sizeof(line)-1,fp);
      fgets(line,sizeof(line)-1,fp);
    }
    else
    {
      fprintf(fpout,"%s",line);
    }
  }
  fclose(fp);

  return 0;
}
