#!/bin/bash
#######################################################################
# Make "Process View Browser"        Rainer Lehrig lehrig@t-online.de #
#######################################################################

if [ "x$QTDIR" = "x" ];
then
  echo "###############################################################"
  echo "# You have to install the Qt development package and set QTDIR#"
  echo "# example: export QTDIR=/usr/lib/qt2                          #"
  echo "# After you have done this run this script again              #"
  echo "###############################################################"
  exit
else
  echo Qt seems to be installed
fi

#######################################################################
which qmake
if [ $? = 0 ];
then
  echo "qmake is working"
else
  echo "###############################################################"
  echo "# Your qmake is not working or not installed                  #"
  echo "# check $QTDIR/bin/qmake                                      #"
  echo "# eventually you have to set a link to it                     #"
  echo "###############################################################"
  exit
fi

#######################################################################

if [ -x /usr/lib/libglut.so ]
then
  echo OpenGL seems to be installed
else
  echo "###############################################################"
  echo "# Please install the OpenGL development package first         #"
  echo "# After you have done this run this script again              #"
  echo "###############################################################"
  exit
fi

#######################################################################
# now we make all components                                          #
################################################################
#######

cd qwt
qmake qwt.pro -o qwt.mak
gmake -f qwt.mak
qmake qwtstatic.pro -o qwtstatic.mak
gmake -f qwtstatic.mak
cd designer
qmake qwtplugin.pro -o qwtplugin.mak
gmake -f qwtplugin.mak
cd ..
cd ..
cd pvbuilder
gmake
cd ..
cd ui2pvc/ui2pvc
qmake ui2pvc.pro -o Makefile
gmake
cd ../..
cd processviewserver
cd processviewserver
./makelibs.sh
qmake processviewserver.pro -o Makefile
gmake
cd ../..
cd pvmviewer
cd pvmviewer
qmake pvmviewer.pro -o Makefile
gmake
cd ../..
cd gl
gcc asc2gl.c -o asc2gl
cd ..
cd linuxtools
gcc pvsmake.c -o pvsmake
cd ..
cd kpart
qmake pvbrowser_part.pro -o Makefile
gmake
cd kio
qmake kio_pv.pro -o Makefile
gmake
cd ../..
cd processview
cd processview
qmake processviewNoVtk.pro -o Makefile
gmake
if [ $? != 0 ];
then
  source error.sh
fi
cd ../..

echo "################################################################"
echo "# Finished:                                                    #"
echo "################################################################"
