#!/bin/bash
#######################################################################
# Make "Process View Browser"        Rainer Lehrig lehrig@t-online.de #
#######################################################################

if [ "x$QTDIR" = "x" ];
then
  echo "###############################################################"
  echo "# You have to install the Qt development package and set QTDIR#"
  echo "# example: export QTDIR=/usr/lib/qt3                          #"
  echo "# After you have done this run this script again              #"
  echo "###############################################################"
  exit
else
  echo Qt seems to be installed
fi

#######################################################################
which qmake
if [ $? = 0 ];
then
  echo "qmake is working"
else
  echo "###############################################################"
  echo "# Your qmake is not working or not installed                  #"
  echo "# check $QTDIR/bin/qmake                                      #"
  echo "# eventually you have to set a link to it                     #"
  echo "###############################################################"
  exit
fi

#######################################################################

if [ -e /usr/include/GL/gl.h ]
then
  echo OpenGL seems to be installed
else
  echo "###############################################################"
  echo "# Please install the OpenGL development package first         #"
  echo "# After you have done this run this script again              #"
  echo "###############################################################"
  exit
fi

#######################################################################

if [ -e /usr/include/GL/glu.h ]
then
  echo Glu seems to be installed
else
  echo "###############################################################"
  echo "# Please install the OpenGL Glu development package first     #"
  echo "# After you have done this run this script again              #"
  echo "###############################################################"
  exit
fi

#######################################################################

if [ -x /usr/local/include/vtk ]
then
  echo VTK seems to be installed
else
  echo "###############################################################"
  echo "# Please install the VTK development package first            #"
  echo "# see: http://www.kitware.com/vtk/  CMake and VTK CVS Version #"
  echo "# After you have done this run this script again              #"
  echo "###############################################################"
  exit
fi

#######################################################################

if [ -e /usr/include/strstream.h ]
then
  echo deprecated headers seem to be installed
else
  echo "###############################################################"
  echo "# We have to copy the depecated header strstream.h            #"
  echo "###############################################################"
  su -c "cp strstream.h /usr/include/"
fi

#######################################################################
# now we make all components                                          #
#######################################################################
cd link
gcc set_tcl_lib.c -o set_tcl_lib
cd ..
echo "Now we have to set a link to your Tcl/Tk library"
echo "Enter your SuperUser password"
su -c ./link/set_tcl_lib

cd qwt
qmake qwt.pro -o qwt.mak
gmake -f qwt.mak
qmake qwtstatic.pro -o qwtstatic.mak
gmake -f qwtstatic.mak
cd designer
qmake qwtplugin.pro -o qwtplugin.mak
gmake -f qwtplugin.mak
cd ..
cd ..
cd pvbuilder
gmake
cd ..
cd ui2pvc/ui2pvc
qmake ui2pvc.pro -o Makefile
gmake
cd ../..
cd processviewserver
cd processviewserver
./makelibs.sh
qmake processviewserver.pro -o Makefile
gmake
cd ../..
cd pvmviewer
cd pvmviewer
qmake pvmviewer.pro -o Makefile
gmake
cd ../..
cd gl
gcc asc2gl.c -o asc2gl
cd ..
cd linuxtools
gcc pvsmake.c -o pvsmake
cd ..
cd kpart
qmake pvbrowser_part.pro -o Makefile
gmake
cd kio
qmake kio_pv.pro -o Makefile
gmake
cd ../..
cd processview
cd processview
qmake processviewWithVtk.pro -o Makefile
gmake
if [ $? != 0 ];
then
  source error.sh
fi
cd ../..

echo "################################################################"
echo "# Finished:                                                    #"
echo "################################################################"
