/***************************************************************************
                          pvbrowserplugin.h  -  description
                             -------------------
    begin                : Sun Aug 07 07:41:57 CET 2005
    copyright            : (C) 2000-2005 by Rainer Lehrig
    email                : lehrig@t-online.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef PVBROWSER_PLUGIN_H
#define PVBROWSER_PLUGIN_H

#include "qnp.h"
#include "processview.h"
#include <qapplication.h>
#include <qmessagebox.h>

class pvbrowser : public QNPWidget
{
public:
    ProcessView *child;
    pvbrowser()
    {
        // Some widget that is normally used as a top-level widget
        child = new ProcessView(this,0,0);

        // Use the background color of the web page
        child->setBackgroundColor( backgroundColor() );

        // Fill the plugin widget
        child->setGeometry( 0, 0, width(), height() );

        //QMessageBox::information(0, "nsplugin", "plugin started");
        //child->slotRecentUrls("pv://localhost:5052");
    }

    ~pvbrowser()
    {
        if(child != NULL) delete child;
    }

    void resizeEvent(QResizeEvent*)
    {
        // Fill the plugin widget
        child->resize(size());
    }
};

class pvbrowserInstance : public QNPInstance 
{
    Q_OBJECT
public:
    pvbrowser *browser;

    QNPWidget* newWindow()
    {
        browser = new pvbrowser;
        return browser;
    }

    void print(QPainter* p)
    {
        p->drawText(0,0,"Hello");
    }

    bool newStreamCreated(QNPStream *stream, StreamMode &smode)
    {
        smode = QNPInstance::Seek;
        // connect to url
        //browser->child->slotRecentUrls(stream->url());
        browser->child->slotRecentUrls("pv://localhost");
        if(stream == NULL) return true;
        return true;
    }
/*
    virtual int writeReady(QNPStream *stream)
    {
        //browser->child->update();
        qApp->processEvents();
        if(stream == NULL) return 1;
        return 2;
    }

    virtual int write(QNPStream *stream, int offset, int len, void *buffer)
    {
        //browser->child->update();
        qApp->processEvents();
        if(stream == NULL) return len;
        if(offset == 0)    return len;
        if(buffer == NULL) return len;
        return len;
    }
*/
};

class pvbrowserPlugin : public QNPlugin 
{
public:
    QNPInstance* newInstance()
    {
        return new pvbrowserInstance;
    }

    const char* getMIMEDescription() const
    {
        return "message/pv:pv:PV Protocol;"
               "message/pvssh:pvssh:PVSSH Protocol";
    }

    const char * getPluginNameString() const
    {
        return "PVBrowser Plugin";
    }

    const char * getPluginDescriptionString() const
    {
        return "Process visualization hmi and scada as easy as browsing the internet";
    }

};

#endif
