/***************************************************************************
                          MyWidgets.cpp  -  description
                             -------------------
    begin                : Mon Dec 11 2000
    copyright            : (C) 2000 by Rainer Lehrig
    email                : lehrig@t-online.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include <stdio.h>
#include <ctype.h>
#include "MyWidgets.h"
#include "resource.h"
#include "qtabbar.h"
#include "qpainter.h"
#include "qmessagebox.h"
#include "qfiledialog.h"
#include "tcputil.h"
#include "logo1.xpm"

////////////////////////////////////////////////////////////////////////////////
MyDialog::MyDialog(int *sock, int ident, QWidget * parent, const char *name, bool modal, WFlags f)
         :QDialog(parent,name,modal,f)
{
  s  = sock;
  id = ident;
  setIcon(logo1);
}

MyDialog::~MyDialog()
{
}

void MyDialog::terminate()
{
  accept();
}

////////////////////////////////////////////////////////////////////////////////
MyQWidget::MyQWidget(int *sock, int ident, QWidget * parent, const char * name)
          :QWidget(parent,name)
{
  s = sock;
  id = ident;
}

MyQWidget::~MyQWidget()
{
}

void MyQWidget::mousePressEvent(QMouseEvent *e)
{
  if(e->button() == RightButton)
  {
    char buf[80];

    sprintf(buf,"QMouseRight(%d)\n",id);
    tcp_send(s,buf,strlen(buf));
  }
}

////////////////////////////////////////////////////////////////////////////////
MyQPushButton::MyQPushButton(int *sock, int ident, QWidget * parent, const char * name)
              :QPushButton(parent,name)
{
  s = sock;
  id = ident;
  connect(this, SIGNAL(pressed()),  SLOT(slotPressed()));
  connect(this, SIGNAL(released()), SLOT(slotReleased()));
  connect(this, SIGNAL(clicked()),  SLOT(slotClicked()));
}

MyQPushButton::~MyQPushButton()
{
}

void MyQPushButton::slotClicked()
{
char buf[80];

  sprintf(buf,"QPushButton(%d)\n",id);
  tcp_send(s,buf,strlen(buf));
}

void MyQPushButton::slotPressed()
{
char buf[80];

  sprintf(buf,"QPushButtonPressed(%d)\n",id);
  tcp_send(s,buf,strlen(buf));
}

void MyQPushButton::slotReleased()
{
char buf[80];

  sprintf(buf,"QPushButtonReleased(%d)\n",id);
  tcp_send(s,buf,strlen(buf));
}

////////////////////////////////////////////////////////////////////////////////
MyLineEdit::MyLineEdit(QTextCodec *_codec, int *sock, int ident, QWidget * parent, const char * name)
           :QLineEdit(parent,name)
{
  s = sock;
  id = ident;
  codec = _codec;
  connect(this, SIGNAL(textChanged(const QString &)), SLOT(slotTextChanged(const QString &)));
  connect(this, SIGNAL(returnPressed()), SLOT(slotReturnPressed()));
}

MyLineEdit::~MyLineEdit()
{
}

void MyLineEdit::slotTextChanged(const QString &txt)
{
  char buf[MAX_PRINTF_LENGTH];

  if(txt.length()+40 > MAX_PRINTF_LENGTH) return;
  if(codec == NULL) sprintf(buf,"text(%d,\"%s\")\n", id, (const char *) txt);
  else              sprintf(buf,"text(%d,\"%s\")\n", id, (const char *) codec->fromUnicode(txt));
  tcp_send(s,buf,strlen(buf));
}

void MyLineEdit::slotReturnPressed()
{
  char buf[MAX_PRINTF_LENGTH];

  sprintf(buf,"QPushButton(%d,\"%s\")\n",id,(const char *) text());
  tcp_send(s,buf,strlen(buf));
}

////////////////////////////////////////////////////////////////////////////////
MyComboBox::MyComboBox(QTextCodec *_codec, int *sock, int ident, QWidget * parent, const char * name)
           :QComboBox(parent,name)
{
  s = sock;
  id = ident;
  codec = _codec;
  connect(this, SIGNAL(activated(const QString &)), SLOT(slotActivated(const QString &)));
}

MyComboBox::~MyComboBox()
{
}

void MyComboBox::slotActivated(const QString &txt)
{
  char buf[MAX_PRINTF_LENGTH];

  if(txt.length()+40 > MAX_PRINTF_LENGTH) return;
  if(codec == NULL) sprintf(buf,"text(%d,\"%s\")\n", id, (const char *) txt);
  else              sprintf(buf,"text(%d,\"%s\")\n", id, (const char *) codec->fromUnicode(txt));
  tcp_send(s,buf,strlen(buf));
}

void MyComboBox::removeItemByName(QString name)
{
  int i = 0;
  while(i < count())
  {
    if(text(i) == name) removeItem(i);
    i++;
  }
}

////////////////////////////////////////////////////////////////////////////////
MySlider::MySlider(int *sock, int ident, int minValue, int maxValue, int pageStep, int value, Orientation orientation, QWidget * parent, const char * name)
         :QSlider(minValue,maxValue,pageStep,value,orientation,parent,name)
{
  s = sock;
  id = ident;
  connect(this, SIGNAL(valueChanged(int)), SLOT(slotValueChanged(int)));
}

MySlider::~MySlider()
{
}

void MySlider::slotValueChanged(int value)
{
char buf[80];

  sprintf(buf,"slider(%d,%d)\n",id,value);
  tcp_send(s,buf,strlen(buf));
}

////////////////////////////////////////////////////////////////////////////////
MyCheckBox::MyCheckBox(int *sock, int ident, QWidget * parent, const char * name)
           :QCheckBox(parent,name)
{
  s = sock;
  id = ident;
  connect(this, SIGNAL(clicked()), SLOT(slotClicked()));
}

MyCheckBox::~MyCheckBox()
{
}

void MyCheckBox::slotClicked()
{
char buf[80];

  if(isChecked()) sprintf(buf,"check(%d,1)\n",id);
  else            sprintf(buf,"check(%d,0)\n",id);
  tcp_send(s,buf,strlen(buf));
}

////////////////////////////////////////////////////////////////////////////////
MyRadioButton::MyRadioButton(int *sock, int ident, QWidget * parent, const char * name)
              :QRadioButton(parent,name)
{
  s = sock;
  id = ident;
  connect(this, SIGNAL(toggled(bool)), SLOT(slotToggled(bool)));
}

MyRadioButton::~MyRadioButton()
{
}

void MyRadioButton::slotToggled(bool on)
{
char buf[80];

  if(on) sprintf(buf,"radio(%d,1)\n",id);
  else   sprintf(buf,"radio(%d,0)\n",id);
  tcp_send(s,buf,strlen(buf));
}

////////////////////////////////////////////////////////////////////////////////
MyButtonGroup::MyButtonGroup(int *sock, int ident, int columns, Orientation o, QString title, QWidget * parent, const char * name)
              :QButtonGroup(columns,o,title,parent,name)
{
  s = sock;
  id = ident;
}

MyButtonGroup::~MyButtonGroup()
{
}

void MyButtonGroup::mousePressEvent(QMouseEvent *e)
{
  if(e->button() == RightButton)
  {
    char buf[80];

    sprintf(buf,"QMouseRight(%d)\n",id);
    tcp_send(s,buf,strlen(buf));
  }
}

////////////////////////////////////////////////////////////////////////////////
MyFrame::MyFrame(int *sock, int ident, int shape, int shadow, int line_width, int margin,
                 QWidget * parent, const char * name, WFlags f)
        :QFrame(parent,name,f)
{
  s = sock;
  id = ident;
  setFrameShape  ((QFrame::Shape)  shape);
  setFrameShadow ((QFrame::Shadow) shadow);
  setLineWidth   (line_width);
  setMargin      (margin);
}

MyFrame::~MyFrame()
{
}

void MyFrame::mousePressEvent(QMouseEvent *e)
{
  if(e->button() == RightButton)
  {
    char buf[80];

    sprintf(buf,"QMouseRight(%d)\n",id);
    tcp_send(s,buf,strlen(buf));
  }
}

////////////////////////////////////////////////////////////////////////////////
MyQTabWidget::MyQTabWidget(int *sock, int ident, QWidget *parent, const char *name, WFlags f)
             :QTabWidget(parent,name,f)
{
  id = ident;
  s  = sock;
  connect(this, SIGNAL(currentChanged(QWidget *)), SLOT(slotCurrentChanged(QWidget *)));
}

MyQTabWidget::~MyQTabWidget()
{
}

void MyQTabWidget::slotCurrentChanged(QWidget *w)
{
char buf[80];

#if QT_VERSION > 220
  sprintf(buf,"tab(%d,%d)\n",id,currentPageIndex());
#else
  sprintf(buf,"tab(%d,%d)\n",id,tabBar()->currentTab());
#endif
  tcp_send(s,buf,strlen(buf));
  if(w == NULL) return;
}

void MyQTabWidget::mousePressEvent(QMouseEvent *e)
{
  if(e->button() == RightButton)
  {
    char buf[80];

    sprintf(buf,"QMouseRight(%d)\n",id);
    tcp_send(s,buf,strlen(buf));
  }
}

////////////////////////////////////////////////////////////////////////////////
#if QT_VERSION >=0x030201
MyQToolBox::MyQToolBox(int *sock, int ident, QWidget *parent, const char *name, WFlags f)
             :QToolBox(parent,name,f)
{
  id = ident;
  s  = sock;
  connect(this, SIGNAL(currentChanged(int)), SLOT(slotCurrentChanged(int)));
}

MyQToolBox::~MyQToolBox()
{
}

void MyQToolBox::slotCurrentChanged(int index)
{
char buf[80];

  sprintf(buf,"tab(%d,%d)\n",id,index);
  tcp_send(s,buf,strlen(buf));
}

void MyQToolBox::mousePressEvent(QMouseEvent *e)
{
  if(e->button() == RightButton)
  {
    char buf[80];

    sprintf(buf,"QMouseRight(%d)\n",id);
    tcp_send(s,buf,strlen(buf));
  }
}
#endif
////////////////////////////////////////////////////////////////////////////////
MyGroupBox::MyGroupBox(int *sock, int ident, int columns, Orientation o, QString title, QWidget * parent, const char * name)
           :QGroupBox(columns,o,title,parent,name)
{
  s = sock;
  id = ident;
}

MyGroupBox::~MyGroupBox()
{
}

void MyGroupBox::mousePressEvent(QMouseEvent *e)
{
  if(e->button() == RightButton)
  {
    char buf[80];

    sprintf(buf,"QMouseRight(%d)\n",id);
    tcp_send(s,buf,strlen(buf));
  }
}

////////////////////////////////////////////////////////////////////////////////
MyListBox::MyListBox(int *sock, int ident, QWidget * parent, const char * name, WFlags f)
          :QListBox(parent,name,f)
{
  s = sock;
  id = ident;
  connect(this, SIGNAL(clicked(QListBoxItem *)), SLOT(slotClicked(QListBoxItem *)));
  connect(this, SIGNAL(currentChanged(QListBoxItem *)), SLOT(slotCurrentChanged(QListBoxItem *)));
  connect(this, SIGNAL(selectionChanged()), SLOT(slotSendSelected()));
}

MyListBox::~MyListBox()
{
}

void MyListBox::insertItem(QPixmap &pixmap, const QString &text, int index)
{
  if(pixmap.isNull()) QListBox::insertItem(text,index);
  else                QListBox::insertItem(pixmap,text,index);
}

void MyListBox::changeItem(QPixmap &pixmap, const QString & text, int index)
{
  if(pixmap.isNull()) QListBox::changeItem(text,index);
  else                QListBox::changeItem(pixmap,text,index);
}

void MyListBox::removeItem(int index)
{
  QListBox::removeItem(index);
}

void MyListBox::removeItemByName(QString name)
{
  while(1)
  {
    QListBoxItem *item = findItem(name);
    if(item != NULL) removeItem(index(item));
    if(item == NULL) return;
  }
}

void MyListBox::clear()
{
  QListBox::clear();
}

void MyListBox::slotClicked(QListBoxItem *item)
{
char buf[80];

  if(item == NULL) return;
  sprintf(buf,"QListBox(%d,\"%s\")\n",id,(const char *) item->text());
  tcp_send(s,buf,strlen(buf));
}
    
void MyListBox::slotCurrentChanged(QListBoxItem *item)
{
char buf[80];

  if(item == NULL) return;
  sprintf(buf,"QListBox(%d,\"%s\")\n",id,(const char *) item->text());
  tcp_send(s,buf,strlen(buf));
}

void MyListBox::slotSendSelected()
{
char buf[MAX_PRINTF_LENGTH];
int i,cnt;

  cnt = count();
  for(i=0; i<cnt; i++)
  {
    if(isSelected(i))
    {
      sprintf(buf,"selected(%d,%d,\"%s\")\n",id,i,(const char *) text(i));
      tcp_send(s,buf,strlen(buf));
    }
  }
  sprintf(buf,"selected(%d,-1,\"(null)\")\n",id);
  tcp_send(s,buf,strlen(buf));
}

////////////////////////////////////////////////////////////////////////////////
#if QT_VERSION > 220

MyTable::MyTable(int *sock, int ident, int numRows, int numColumns, QWidget *parent, const char *name)
        :QTable(numRows,numColumns,parent,name)
{
  s = sock;
  id = ident;
  wrap = 0;
  connect(horizontalHeader(), SIGNAL(clicked(int)), SLOT(slotColClicked(int)));
  connect(verticalHeader()  , SIGNAL(clicked(int)), SLOT(slotRowClicked(int)));
  connect(this, SIGNAL(clicked(int,int,int,const QPoint &)), SLOT(slotClicked(int,int,int,const QPoint &)));
  connect(this, SIGNAL(currentChanged(int,int)), SLOT(slotCurrentChanged(int,int)));
  connect(this, SIGNAL(valueChanged(int,int)), SLOT(slotValueChanged(int,int)));
  connect(this, SIGNAL(pressed(int,int,int,const QPoint &)), SLOT(slotPressed(int,int,int,const QPoint &)));
}

MyTable::~MyTable()
{
}

void MyTable::paintCell(QPainter *p, int row, int col, const QRect &cr, bool selected, const QColorGroup &cg)
{
  QString celltext = text(row,col);
  int r,g,b;

  if(celltext.startsWith("color("))
  {
    QRect crect;
    crect = cellRect(row,col);
    p->setClipRect(crect, QPainter::CoordPainter);
    if(selected == false)
    {
      sscanf(celltext,"color(%d,%d,%d",&r,&g,&b);
      p->fillRect(crect,QBrush(QColor(r,g,b)));
      p->drawText(crect,Qt::AlignRight | Qt::AlignVCenter,
                  celltext.mid(1+celltext.find(')')));
    }
    else
    {
      sscanf(celltext,"color(%d,%d,%d",&r,&g,&b);
      p->fillRect(crect,QBrush(cg.highlight()));
      p->drawText(crect,Qt::AlignRight | Qt::AlignVCenter,
                  celltext.mid(1+celltext.find(')')));
    }
    p->setClipping(FALSE);
  }
  else
  {
    QTable::paintCell(p,row,col,cr,selected,cg);
  }
}

QWidget *MyTable::beginEdit(int row, int col, bool replace)
{
  QString celltext = text(row,col);
  if(celltext.startsWith("color("))
  {
    cellbuf = celltext.left(1+celltext.find(')'));
    setText(row,col,celltext.mid(1+celltext.find(')')));
    return QTable::beginEdit(row,col,replace);
  }
  else
  {
    return QTable::beginEdit(row,col,replace);
  }
}

void MyTable::endEdit(int row, int col, bool accept, bool replace)
{
  if(cellbuf == "")
  {
    QTable::endEdit(row,col,accept,replace);
  }
  else
  {
    QTable::endEdit(row,col,accept,replace);
    QString buf = text(row,col);
    setText(row,col,cellbuf+buf);
    cellbuf = "";
  }
}

void MyTable::setTableCheckBox(int row, int col, int state, QString text)
{
  QCheckTableItem *item = new QCheckTableItem(this, text);
  item->setChecked(state);
  setItem(row,col,item);
  //printf("CheckBox(%d,%d,%d,%s)\n",row,col,state,text);
}

void MyTable::setTableComboBox(int row, int col, int editable, const char *menu)
{
  char buf[800];
  int  i,ifirst;
  QStringList list;
  ifirst = 0;
  for(i=0;; i++)
  {
    if(menu[i] == ',' || menu[i] == '\0')
    {
      if(i == ifirst && i == 0)
      {
      }
      else if(menu[i] != '\0' && menu[i+1] == ',')
      {
        if(i > 0 && menu[i-1] != ',')
        {
          strncpy(buf,&menu[ifirst],i-ifirst);
          buf[i-ifirst] = '\0';
          list.append(buf);
        }
      }
      else
      {
        if(i > 0 && menu[i-1] != ',')
        {
          strncpy(buf,&menu[ifirst],i-ifirst);
          buf[i-ifirst] = '\0';
          list.append(buf);
        }
      }
      ifirst = i+1;
    }
    if(menu[i] == '\0') break;
  }

  setItem(row,col, new QComboTableItem(this, list, editable));
  //printf("ComboBox(%d,%d,%d,%s)\n",row,col,editable,text);
}

void MyTable::slotRowClicked(int section)
{
char buf[80];

  sprintf(buf,"QTable(%d,%d,%d,%d)\n",id,section,-1,1);
  tcp_send(s,buf,strlen(buf));
}

void MyTable::slotColClicked(int section)
{
char buf[80];

  sprintf(buf,"QTable(%d,%d,%d,%d)\n",id,-1,section,1);
  tcp_send(s,buf,strlen(buf));
}

void MyTable::slotClicked(int row, int col, int button, const QPoint &mousePos)
{
char buf[80];

  sprintf(buf,"QTable(%d,%d,%d,%d)\n",id,row,col,button);
  tcp_send(s,buf,strlen(buf));
  if(mousePos.isNull()) return;
}
   
void MyTable::slotCurrentChanged( int row, int col)
{
char buf[80];
  
  sprintf(buf,"QTable(%d,%d,%d,0)\n",id,row,col);
  tcp_send(s,buf,strlen(buf));
}
   
void MyTable::slotValueChanged(int row, int col)
{
  char buf[80];
  QString txt;
  QString celltext = text(row,col);
  if(celltext.startsWith("color("))
  {
    txt = celltext.mid(1+celltext.find(')'));
  }
  else
  {
    txt = text(row,col);
  }

  if(item(row,col)->rtti() == 2) //CheckTableItem
  {
    QCheckTableItem *tableitem = (QCheckTableItem *) item(row,col);
    QString sbuf = txt;
    if(tableitem->isChecked()) txt = "1," + sbuf;
    else                       txt = "0," + sbuf;
  }
  sprintf(buf,"QTableValue(%d,%d,%d,\"%s\")\n",id,row,col,(const char *) txt);
  tcp_send(s,buf,strlen(buf));
}

void MyTable::slotPressed(int row, int col, int button, const QPoint &mousePos)
{
  char buf[80];

  if(button == 3)
  {
    sprintf(buf,"QMouseRight(%d)\n",id);
    tcp_send(s,buf,strlen(buf));
  }
  if(row == col) return;
  if(mousePos.x() == 0) return;
}

void MyTable::saveTextfile()
{
  QFileDialog dlg;
  QString name,cell;
  FILE *fp;
  int x,y,ret;

  name = dlg.getSaveFileName(QString::null,"*.csv");
  if(name.isEmpty()) return;
  fp = fopen(name,"r");
  if(fp != NULL)
  {
    fclose(fp);
    ret = QMessageBox::warning(this,"Save Table","File already exists: Overwrite ?",QMessageBox::Yes,QMessageBox::No,0);
    if(ret == QMessageBox::No) return;
  }
  fp = fopen(name,"w");
  if(fp == NULL)
  {
    QMessageBox::warning(this,"Save Table","could not write file",QMessageBox::Ok,0,0);
    return;
  }
  for(y=-1; y<numRows(); y++)
  {
    if(y == -1)        cell = "";
    else               cell = horizontalHeader()->label(y);
    if(cell.isEmpty()) cell = "";
    else        fprintf(fp,"%s",(const char *) cell);
    for(x=0; x<numCols(); x++)
    {
      if(y == -1)        cell = verticalHeader()->label(x);
      else               cell = text(y,x);
      if(cell.isEmpty()) cell = "";
      fprintf(fp,"\t%s",(const char *) cell);
    }
    fprintf(fp,"\n");
  }
  fclose(fp);
}
#endif


////////////////////////////////////////////////////////////////////////////////
MySpinBox::MySpinBox(int *sock, int ident, int minValue, int maxValue, int step, QWidget *parent, const char *name)
          :QSpinBox(minValue,maxValue,step,parent,name)
{
  s = sock;
  id = ident;
  connect(this, SIGNAL(valueChanged(int)), SLOT(slotValueChanged(int)));
}

MySpinBox::~MySpinBox()
{
}

void MySpinBox::slotValueChanged(int value)
{
char buf[80];

  sprintf(buf,"slider(%d,%d)\n",id,value);
  tcp_send(s,buf,strlen(buf));
}

////////////////////////////////////////////////////////////////////////////////
MyDial::MyDial(int *sock, int ident, int minValue, int maxValue, int pageStep, int value, QWidget *parent, const char *name)
       :QDial(minValue,maxValue,pageStep,value,parent,name)
{
  s = sock;
  id = ident;
  connect(this, SIGNAL(valueChanged(int)), SLOT(slotValueChanged(int)));
}

MyDial::~MyDial()
{
}

void MyDial::setValue(int value)
{
  QDial::setValue(value);
}

void MyDial::slotValueChanged(int value)
{
char buf[80];

  sprintf(buf,"slider(%d,%d)\n",id,value);
  tcp_send(s,buf,strlen(buf));
}

////////////////////////////////////////////////////////////////////////////////
MyProgressBar::MyProgressBar(int *sock, int ident, int totalSteps, QWidget *parent, const char *name)
              :QProgressBar(totalSteps,parent,name)
{
  s = sock;
  id = ident;
}

MyProgressBar::~MyProgressBar()
{
}

void MyProgressBar::setValue(int value)
{
  setProgress(value);
}

////////////////////////////////////////////////////////////////////////////////
#if QT_VERSION > 300
MyMultiLineEdit::MyMultiLineEdit(int *sock, int ident, int editable, int maxLines, QWidget *parent, const char *name)
                :QTextEdit(parent,name)
#else
MyMultiLineEdit::MyMultiLineEdit(int *sock, int ident, int editable, int maxLines, QWidget *parent, const char *name)
                :QMultiLineEdit(parent,name)
#endif
{
  s = sock;
  id = ident;
  maxlines = maxLines;
  //setMaxLines(maxLines);
  if     (editable == 0) setReadOnly(true);
  else if(editable == 1) setReadOnly(false);
#if QT_VERSION > 300
  setWordWrap(QTextEdit::NoWrap);
#endif
}

MyMultiLineEdit::~MyMultiLineEdit()
{
}

void MyMultiLineEdit::setText(const QString &text)
{
#if QT_VERSION > 300
  if(maxlines != -1)
  {
    if(lines() >= maxlines)
    {
      removeParagraph(0);
    }
  }
  append(text);
  setCursorPosition(lines()-1,paragraphLength(lines()-1));
#else
  if(maxlines != -1)
  {
    if(numLines() >= maxlines) removeLine(0);
  }
  append(text);
  setCursorPosition(numLines(),0);
#endif
}

void MyMultiLineEdit::slotSendToClipboard()
{
  char buf[80];

#if QT_VERSION > 300
  sprintf(buf,"@clipboard(%d,%d)\n", id,length()+lines());
  tcp_send(s,buf,strlen(buf));
  tcp_send(s,text(),length()+lines());
#else
  sprintf(buf,"@clipboard(%d,%d)\n", id,length()+numLines());
  tcp_send(s,buf,strlen(buf));
  tcp_send(s,text(),length()+numLines());
#endif
}

////////////////////////////////////////////////////////////////////////////////
MyTextBrowser::MyTextBrowser(QTextCodec *_codec, int *sock, int ident, QWidget *parent, const char *name)
              :QTextBrowser(parent,name)
{
  s = sock;
  id = ident;
  codec = _codec;
  connect(this, SIGNAL(linkClicked(const QString &)), SLOT(slotLinkClicked(const QString &)));
}

MyTextBrowser::~MyTextBrowser()
{
}

void MyTextBrowser::moveContent(int pos)
{
  if     (pos == 0) home();
  else if(pos == 1) backward();
  else if(pos == 2) forward();
}

void MyTextBrowser::slotLinkClicked(const QString &txt)
{
  char buf[MAX_PRINTF_LENGTH];

  if(txt.length()+40 > MAX_PRINTF_LENGTH) return;
  if(codec == NULL) sprintf(buf,"text(%d,\"%s\")\n", id, (const char *) txt);
  else              sprintf(buf,"text(%d,\"%s\")\n", id, (const char *) codec->fromUnicode(txt));
  tcp_send(s,buf,strlen(buf));
}

////////////////////////////////////////////////////////////////////////////////
static int starts_with(const char *path1, const char *path2)
{
  int i;
  for(i=0; path1[i] != '\0'; i++)
  {
    if(path2[i] == '\0')
    {
      if(path1[i] == '/') return 1;
      else                return 0;
    }
    if(path1[i] != path2[i]) return 0;
  }
  if(path2[i] != '/' && path2[i] != '\0') return 0; // RL 15.10.2004
  return 1;
}

const char *root_path(const char *path, int num_slash)
{
  static char buf[1024];
  int i,cnt;

  i   = 0;
  cnt = -1;
  while(i < (int) sizeof(buf))
  {
    if(path[i] == '/') cnt++;
    if(cnt == num_slash) break;
    if(path[i] == '\0')  break;
    buf[i] = path[i];
    i++;
  }
  buf[i] = '\0';
  return buf;
}

MyListView::MyListView(int *sock, int ident, QWidget *parent, const char *name)
           :QListView(parent,name)
{
  s = sock;
  id = ident;
  setSorting(-1);
  connect(this, SIGNAL(clicked(QListViewItem *)), SLOT(slotClicked(QListViewItem *)));
  connect(this, SIGNAL(selectionChanged()), SLOT(slotSendSelected()));
  connect(this, SIGNAL(rightButtonPressed(QListViewItem *, const QPoint &, int)), SLOT(slotRightButtonPressed(QListViewItem *, const QPoint &, int)));
}

MyListView::~MyListView()
{
}

void MyListView::nameVersionSetListViewText(const char *path, int column, QString &text, MyListViewItem *parent, const char *relpath, int num_slash)
{
  MyListViewItem *item;
  char *cptr;

  if(parent == NULL) item = (MyListViewItem *) firstChild();
  else               item = (MyListViewItem *) parent->firstChild();
  while(item != NULL)
  {
    if(strcmp(path,item->path) == 0) { item->setText(column,text); return; }      // update existing item
    if(starts_with(path,item->path))
    {
      cptr = strchr(&relpath[1],'/');
      if(cptr == NULL) return;
      nameVersionSetListViewText(path,column,text,item,cptr,num_slash+1);         // recurse
      return;
    }
    item = (MyListViewItem *) item->nextSibling();
  }
  if(num_slash == 1)   item = new MyListViewItem(this);                           // add root path
  else                 item = new MyListViewItem(parent);                         // add root path
  item->path = root_path(path,num_slash);
  if(num_slash == 1)   insertItem(item);                                          // insert new item
  else                 parent->insertItem(item);
  if(item->path == path) { item->setText(column,text); return; }
  cptr = strchr(&relpath[1],'/');
  if(cptr == NULL) return;
  nameVersionSetListViewText(path,column,text,item,cptr,num_slash+1);             // recurse
  return;
}

void MyListView::nameVersionSetListViewPixmap(const char *path, int column, QPixmap &pixmap, MyListViewItem *parent, const char *relpath, int num_slash)
{
  MyListViewItem *item;
  char *cptr;

  if(parent == NULL) item = (MyListViewItem *) firstChild();
  else               item = (MyListViewItem *) parent->firstChild();
  while(item != NULL)
  {
    if(strcmp(path,item->path) == 0) { item->setPixmap(column,pixmap); return; }  // update existing item
    if(starts_with(path,item->path))
    {
      cptr = strchr(&relpath[1],'/');
      if(cptr == NULL) return;
      nameVersionSetListViewPixmap(path,column,pixmap,item,cptr,num_slash+1);     // recurse
      return;
    }
    item = (MyListViewItem *) item->nextSibling();
  }
  if(num_slash == 1)   item = new MyListViewItem(this);                           // add root path
  else                 item = new MyListViewItem(parent);                         // add root path
  item->path = root_path(path,num_slash);
  if(num_slash == 1)   insertItem(item);                                          // insert new item
  else                 parent->insertItem(item);
  if(item->path == path) { item->setPixmap(column,pixmap); return; }
  cptr = strchr(&relpath[1],'/');
  if(cptr == NULL) return;
  nameVersionSetListViewPixmap(path,column,pixmap,item,cptr,num_slash+1);         // recurse
  return;
}

void MyListView::setListViewText(const char *path, int column, QString &text)
{
  if(path[0] != '/') return;
  triggerUpdate();
  nameVersionSetListViewText(path,column,text,NULL,path,1);
}

void MyListView::setListViewPixmap(const char *path, int column, QPixmap &pixmap)
{
  if(path[0] != '/') return;
  triggerUpdate();
  nameVersionSetListViewPixmap(path,column,pixmap,NULL,path,1);
}

int MyListView::deleteListViewItem(const char *path, MyListViewItem *item)
{
  MyListViewItem *child;
  int ret;

  while(item != NULL)
  {
    if(strcmp(item->path,path) == 0)
    {
      delete item;
      return 1;
    }
    child = (MyListViewItem *) item->firstChild();
    if(child != NULL)
    {
      ret = deleteListViewItem(path,child);
      if(ret != 0) return ret;
    }
    item = (MyListViewItem *) item->nextSibling();
  }
  return 0;
}

int MyListView::ensureVisible(const char *path, MyListViewItem *item)
{
  MyListViewItem *child;
  int ret;

  while(item != NULL)
  {
    if(strcmp(item->path,path) == 0)
    {
      ensureItemVisible(item);
      return 1;
    }
    child = (MyListViewItem *) item->firstChild();
    if(child != NULL)
    {
      ret = ensureVisible(path,child);
      if(ret != 0) return ret;
    }
    item = (MyListViewItem *) item->nextSibling();
  }
  return 0;
}

int MyListView::setItemOpen(const char *path, int open, MyListViewItem *item)
{
  MyListViewItem *child;
  int ret;

  while(item != NULL)
  {
    if(strcmp(item->path,path) == 0)
    {
      setOpen(item,open);
      return 1;
    }
    child = (MyListViewItem *) item->firstChild();
    if(child != NULL)
    {
      ret = setItemOpen(path,open,child);
      if(ret != 0) return ret;
    }
    item = (MyListViewItem *) item->nextSibling();
  }
  return 0;
}

void MyListView::slotClicked(QListViewItem *item)
{
char buf[MAX_PRINTF_LENGTH];
MyListViewItem *myitem = (MyListViewItem *) item;
int  col;

  if(item == NULL) return;
  col = columns();
  while( col > 0)
  {
    col--;
    //sprintf(buf,"text(%d,\"%s\")\n", id, (const char *) item->text(col));
    sprintf(buf,"selected(%d,%d,\"%s\")\n", id, col, (const char *) item->text(col));
    tcp_send(s,buf,strlen(buf));
  }
  sprintf(buf,"selected(%d,-1,\"%s\")\n", id, (const char *) myitem->path);
  tcp_send(s,buf,strlen(buf));
}

void MyListView::slotSendSelected()
{
char buf[MAX_PRINTF_LENGTH];

  doSendSelected(firstChild());
  sprintf(buf,"selected(%d,-2,\"(null)\")\n",id);
  tcp_send(s,buf,strlen(buf));
}

void MyListView::doSendSelected(QListViewItem *item)
{
char buf[MAX_PRINTF_LENGTH];

int column;

  while(item != NULL)
  {
    if(item->isSelected())
    {
      column = columns();
      while( column > 0)
      {
        column--;
        sprintf(buf,"selected(%d,%d,\"%s\")\n", id, column, (const char *) item->text(column));
        tcp_send(s,buf,strlen(buf));
      }
      MyListViewItem *myitem = (MyListViewItem *) item;
      sprintf(buf,"selected(%d,-1,\"%s\")\n", id, (const char *) myitem->path);
      tcp_send(s,buf,strlen(buf));
    }
    if(item->firstChild() != NULL) doSendSelected(item->firstChild());
    item = item->nextSibling();
  }
}

void MyListView::slotRightButtonPressed(QListViewItem *item, const QPoint &p, int i)
{
  char buf[80];

  if(item == NULL)
  {
    sprintf(buf,"QMouseRight(%d,\"%d,\")\n",id,i);
  }
  else
  {
    MyListViewItem *myitem = (MyListViewItem *) item;
    sprintf(buf,"QMouseRight(%d,\"%d,%s\")\n",id,i,(const char *) myitem->path);
  }
  tcp_send(s,buf,strlen(buf));
  if(item == NULL) return;
  if(i == 0) return;
  if(p.x() == 0) return;
}

////////////////////////////////////////////////////////////////////////////////
MyIconView::MyIconView(QTextCodec *_codec, int *sock, int ident, QWidget *parent, const char *name)
           :QIconView(parent,name)
{
  s = sock;
  id = ident;
  codec = _codec;
  connect(this, SIGNAL(clicked(QIconViewItem *)), SLOT(slotClicked(QIconViewItem *)));
}

MyIconView::~MyIconView()
{
}

void MyIconView::setIconViewItem(QString &text, QPixmap &pixmap)
{
  insertItem(new QIconViewItem(this,text,pixmap));
}

void MyIconView::deleteIconViewItem(QString &text)
{
  if(text.isEmpty()) return;
  return;
/*
  QIconViewItem *item = firstItem();
  while(1)
  {
    if(item == NULL) return;
    if(item->text() == text)
    {
      delete item;
      return;
    }
    item = item->nextItem();
  }
*/
}

void MyIconView::slotClicked(QIconViewItem *item)
{
char buf[MAX_PRINTF_LENGTH];

  if(item == NULL) return;
  if(item->text().length()+40 > MAX_PRINTF_LENGTH) return;
  if(codec == NULL) sprintf(buf,"text(%d,\"%s\")\n", id, (const char *) item->text());
  else              sprintf(buf,"text(%d,\"%s\")\n", id, (const char *) codec->fromUnicode(item->text()));
  tcp_send(s,buf,strlen(buf));
}

// --- QWT --------------------------------------------------------------
MyQwtScale::MyQwtScale(int *sock, int ident, int position, QWidget *parent, const char *name)
           :QwtScale((QwtScale::Position)position,parent,name)
{
  s = sock;
  id = ident;
}

MyQwtScale::~MyQwtScale()
{
}

MyQwtThermo::MyQwtThermo(int *sock, int ident, QWidget *parent, const char *name)
            :QwtThermo(parent,name)
{
  s = sock;
  id = ident;
}

MyQwtThermo::~MyQwtThermo()
{
}

MyQwtKnob::MyQwtKnob(int *sock, int ident, QWidget *parent, const char *name)
          :QwtKnob(parent,name)
{
  s = sock;
  id = ident;
  connect(this, SIGNAL(valueChanged(double)), SLOT(slotValueChanged(double)));
}

MyQwtKnob::~MyQwtKnob()
{
}

void MyQwtKnob::slotValueChanged(double value)
{
char buf[80];

  sprintf(buf,"slider(%d,%lf)\n",id,value);
  tcp_send(s,buf,strlen(buf));
}

MyQwtCounter::MyQwtCounter(int *sock, int ident, QWidget *parent, const char *name)
             :QwtCounter(parent,name)
{
  s = sock;
  id = ident;
  connect(this, SIGNAL(valueChanged(double)), SLOT(slotValueChanged(double)));
}

MyQwtCounter::~MyQwtCounter()
{
}

void MyQwtCounter::slotValueChanged(double value)
{
char buf[80];

  sprintf(buf,"slider(%d,%lf)\n",id,value);
  tcp_send(s,buf,strlen(buf));
}

MyQwtWheel::MyQwtWheel(int *sock, int ident, QWidget *parent, const char *name)
           :QwtWheel(parent,name)
{
  s = sock;
  id = ident;
  connect(this, SIGNAL(valueChanged(double)), SLOT(slotValueChanged(double)));
}

MyQwtWheel::~MyQwtWheel()
{
}

void MyQwtWheel::slotValueChanged(double value)
{
char buf[80];

  sprintf(buf,"slider(%d,%lf)\n",id,value);
  tcp_send(s,buf,strlen(buf));
}

MyQwtSlider::MyQwtSlider(int *sock, int ident, QWidget *parent, const char *name)
            :QwtSlider(parent,name)
{
  s = sock;
  id = ident;
  connect(this, SIGNAL(valueChanged(double)), SLOT(slotValueChanged(double)));
}

MyQwtSlider::~MyQwtSlider()
{
}

void MyQwtSlider::slotValueChanged(double value)
{
char buf[80];

  sprintf(buf,"slider(%d,%lf)\n",id,value);
  tcp_send(s,buf,strlen(buf));
}

MyQwtCompass::MyQwtCompass(int *sock, int ident, QWidget *parent, const char *name)
             :QwtCompass(parent,name)
{
  s = sock;
  id = ident;
  connect(this, SIGNAL(valueChanged(double)), SLOT(slotValueChanged(double)));
}

MyQwtCompass::~MyQwtCompass()
{
}

void MyQwtCompass::slotValueChanged(double value)
{
char buf[80];

  sprintf(buf,"slider(%d,%lf)\n",id,value);
  tcp_send(s,buf,strlen(buf));
}

//------------------------------------------------------------------------------------

MyQDateEdit::MyQDateEdit(int *sock, int ident, QWidget *parent, const char *name)
            :QDateEdit(parent,name)
{
  s = sock;
  id = ident;
  connect(this, SIGNAL(valueChanged(const QDate &)), SLOT(slotValueChanged(const QDate &)));
}

MyQDateEdit::~MyQDateEdit()
{
}

void MyQDateEdit::slotValueChanged(const QDate &date)
{
char buf[80];

  sprintf(buf,"text(%d,\"%d:%d:%d\")\n", id, date.year(), date.month(), date.day());
  if(date.isValid()) tcp_send(s,buf,strlen(buf));
}

MyQTimeEdit::MyQTimeEdit(int *sock, int ident, QWidget *parent, const char *name)
            :QTimeEdit(parent,name)
{
  s = sock;
  id = ident;
  connect(this, SIGNAL(valueChanged(const QTime &)), SLOT(slotValueChanged(const QTime &)));
}

MyQTimeEdit::~MyQTimeEdit()
{
}

void MyQTimeEdit::slotValueChanged(const QTime &time)
{
char buf[80];

  sprintf(buf,"text(%d,\"%d.%d.%d.%d\")\n", id, time.hour(), time.minute(), time.second(), time.msec());
  if(time.isValid()) tcp_send(s,buf,strlen(buf));
}

MyQDateTimeEdit::MyQDateTimeEdit(int *sock, int ident, QWidget *parent, const char *name)
                :QDateTimeEdit(parent,name)
{
  s = sock;
  id = ident;
  connect(this, SIGNAL(valueChanged(const QDateTime &)), SLOT(slotValueChanged(const QDateTime &)));
}

MyQDateTimeEdit::~MyQDateTimeEdit()
{
}

void MyQDateTimeEdit::slotValueChanged(const QDateTime &date_time)
{
char buf[200];

  sprintf(buf,"text(%d,\"%d:%d:%d-%d.%d.%d.%d\")\n", id, date_time.date().year(),
                                                         date_time.date().month(),
                                                         date_time.date().day(),
                                                         date_time.time().hour(),
                                                         date_time.time().minute(),
                                                         date_time.time().second(),
                                                         date_time.time().msec());
  if(date_time.isValid()) tcp_send(s,buf,strlen(buf));
}
