/***************************************************************************
                          MyWidgets.h  -  description
                             -------------------
    begin                : Mon Dec 11 2000
    copyright            : (C) 2000 by Rainer Lehrig
    email                : lehrig@t-online.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef _MY_WIDGETS_H_
#define _MY_WIDGETS_H_

#include <qwidget.h>
#include <qpushbutton.h>
#include <qlineedit.h>
#include <qcombobox.h>
#include <qslider.h>
#include <qcheckbox.h>
#include <qradiobutton.h>
#include <qbuttongroup.h>
#include <qframe.h>
#include <qtabwidget.h>
#if QT_VERSION >=0x030201
#include <qtoolbox.h>
#endif
#include <qgroupbox.h>
#include <qlistbox.h>
#if QT_VERSION > 220
#include <qtable.h>
#endif
#include <qspinbox.h>
#include <qdial.h>
#include <qprogressbar.h>
#include <qpixmap.h>
#if QT_VERSION > 300
#include <qtextedit.h>
#else
#include <qmultilineedit.h>
#endif
#include <qtextbrowser.h>
#include <qlistview.h>
#include <qiconview.h>
#include <qdialog.h>
#include <qtextcodec.h>

// --- QWT ---
#include "qwt_scale.h"
#include "qwt_thermo.h"
#include "qwt_knob.h"
#include "qwt_counter.h"
#include "qwt_wheel.h"
#include "qwt_slider.h"
#include "qwt_compass.h"
#include "qwt_compass_rose.h"
#include "qwt_dial_needle.h"

#include <qdatetimeedit.h>

class MyDialog : public QDialog
{
    Q_OBJECT
public:
    MyDialog(int *sock, int ident, QWidget * parent=0, const char *name=0, bool modal=TRUE, WFlags f=0);
    ~MyDialog();
    void terminate();
private:
    int *s,id;
};

class MyQWidget : public QWidget
{
    Q_OBJECT
public:
    MyQWidget(int *sock, int ident, QWidget * parent, const char * name=0 );
    ~MyQWidget();

public slots:

protected:
    virtual void mousePressEvent(QMouseEvent *e);

private:

    int *s,id;
};

class MyQPushButton : public QPushButton
{
    Q_OBJECT
public:
    MyQPushButton(int *sock, int ident, QWidget * parent, const char * name=0 );
    ~MyQPushButton();

public slots:
    void slotClicked();
    void slotPressed();
    void slotReleased();

private:
    int *s,id;
};

class MyLineEdit : public QLineEdit
{
    Q_OBJECT
public:
    MyLineEdit(QTextCodec *_codec, int *sock, int ident, QWidget * parent, const char * name=0 );
    ~MyLineEdit();

public slots:
    void slotTextChanged(const QString &txt);
    void slotReturnPressed();

private:
    int *s,id;
    QTextCodec *codec;
};

class MyComboBox : public QComboBox
{
    Q_OBJECT
public:
    MyComboBox(QTextCodec *_codec, int *sock, int ident, QWidget * parent, const char * name=0 );
    ~MyComboBox();
    void removeItemByName(QString name);

public slots:
    void slotActivated(const QString &txt);

private:
    int *s,id;
    QTextCodec *codec;
};

class MySlider : public QSlider
{
    Q_OBJECT
public:
    MySlider(int *sock, int ident, int minValue, int maxValue, int pageStep, int value, Orientation, QWidget * parent, const char * name=0 );
    ~MySlider();

public slots:
    void slotValueChanged(int value);

private:
    int *s,id;
};

class MyCheckBox : public QCheckBox
{
    Q_OBJECT
public:
    MyCheckBox(int *sock, int ident, QWidget * parent, const char * name=0 );
    ~MyCheckBox();

public slots:
    void slotClicked();

private:
    int *s,id;
};

class MyRadioButton : public QRadioButton
{
    Q_OBJECT
public:
    MyRadioButton(int *sock, int ident, QWidget * parent, const char * name=0 );
    ~MyRadioButton();

public slots:
    void slotToggled(bool on);

private:
    int *s,id;
};

class MyButtonGroup : public QButtonGroup
{
    Q_OBJECT
public:
    MyButtonGroup(int *sock, int ident, int columns, Orientation o, QString title, QWidget * parent=0, const char * name=0 );
    ~MyButtonGroup();

protected:
    virtual void mousePressEvent(QMouseEvent *e);

private:
    int *s,id;
};

class MyFrame : public QFrame
{
    Q_OBJECT
public:
    MyFrame(int *sock, int ident, int shape, int shadow, int line_width, int margin,
            QWidget * parent=0, const char * name=0, WFlags f=0);
    ~MyFrame();

protected:
    virtual void mousePressEvent(QMouseEvent *e);

private:
    int *s,id;
};

class MyQTabWidget : public QTabWidget
{
    Q_OBJECT
public:
    MyQTabWidget(int *sock, int ident, QWidget * parent=0, const char * name=0, WFlags f=0);
    ~MyQTabWidget();

public slots:
    void slotCurrentChanged(QWidget *w);

protected:
    virtual void mousePressEvent(QMouseEvent *e);

private:
    int *s,id;
};

#if QT_VERSION >=0x030201
class MyQToolBox : public QToolBox
{
    Q_OBJECT
public:
    MyQToolBox(int *sock, int ident, QWidget * parent=0, const char * name=0, WFlags f=0);
    ~MyQToolBox();

public slots:
    void slotCurrentChanged(int index);

protected:
    virtual void mousePressEvent(QMouseEvent *e);

private:
    int *s,id;
};
#endif

class MyGroupBox : public QGroupBox
{
    Q_OBJECT
public:
    MyGroupBox(int *sock, int ident, int columns, Orientation o, QString title, QWidget * parent=0, const char * name=0 );
    ~MyGroupBox();

protected:
    virtual void mousePressEvent(QMouseEvent *e);

private:
    int *s,id;
};

class MyListBox : public QListBox
{
    Q_OBJECT
public:
    MyListBox(int *sock, int ident, QWidget * parent=0, const char * name=0, WFlags f=0);
    ~MyListBox();
    virtual void insertItem(QPixmap &pixmap, const QString &text, int index=-1);
    virtual void changeItem(QPixmap &pixmap, const QString &text, int index);
    virtual void removeItem(int index);
    virtual void removeItemByName(QString name);
    virtual void clear();

public slots:
    void slotClicked(QListBoxItem *item);
    void slotCurrentChanged(QListBoxItem *item);
    void slotSendSelected();

private:
    int *s,id;
};

#if QT_VERSION > 220
class MyTable : public QTable
{
    Q_OBJECT
public:
    MyTable(int *sock, int ident, int numRows, int numColumns, QWidget *parent=0, const char *name=0);
    ~MyTable();
    //virtualvoidsetText(introw, intcol, constQString&text)
    //virtual	void	setPixmap(int row, int col, QPixmap &pm);
    //void updateCell ( int row, int col )
    //virtualvoidsetColumnWidth(intcol, intw)
    virtual void paintCell(QPainter *p, int row, int col, const QRect &cr, bool selected, const QColorGroup &cg);
    virtual QWidget *beginEdit(int row, int col, bool replace);
    virtual void endEdit(int row, int col, bool accept, bool replace);
    void setTableCheckBox(int row, int col, int state, QString text);
    void setTableComboBox(int row, int col, int editable, const char *text);
    void saveTextfile();
    int wrap;

public slots:
   void slotRowClicked(int section);
   void slotColClicked(int section);
   void slotClicked( int row, int col, int button, const QPoint & mousePos);
   void slotCurrentChanged( int row, int col);
   void slotValueChanged(int row, int col);
   void slotPressed(int row, int col, int button, const QPoint &mousePos);
private:
    int *s,id;
    QString cellbuf;
};
#endif

class MySpinBox : public QSpinBox
{
    Q_OBJECT
public:
    MySpinBox(int *sock, int ident, int minValue, int maxValue, int step=1, QWidget *parent=0, const char *name=0);
    ~MySpinBox();
    // virtual void setValue(int)

public slots:
   void slotValueChanged(int value);

private:
    int *s,id;
};

class MyDial : public QDial
{

    Q_OBJECT
public:
    MyDial(int *sock, int ident, int minValue, int maxValue, int pageStep, int value, QWidget *parent=0, const char *name=0);
    ~MyDial();
    virtual void setValue(int);

public slots:
   void slotValueChanged(int value);

private:
    int *s,id;
};

class MyProgressBar : public QProgressBar
{
    Q_OBJECT
public:
    MyProgressBar(int *sock, int ident, int totalSteps, QWidget *parent=0, const char *name=0);
    ~MyProgressBar();
    virtual void setValue(int);

private:
    int *s,id;
};

class MyMultiLineEdit : public QTextEdit
{
    Q_OBJECT
public:
    MyMultiLineEdit(int *sock, int ident, int editable, int maxLines, QWidget * parent=0, const char * name=0);
    ~MyMultiLineEdit();
    virtual void setText(const QString &text);

public slots:
    void slotSendToClipboard();

private:
    int *s,id,maxlines;
};

class MyTextBrowser : public QTextBrowser
{
    Q_OBJECT
public:
    MyTextBrowser(QTextCodec *_codec, int *sock, int ident, QWidget * parent=0, const char * name=0);
    ~MyTextBrowser();
    void moveContent(int pos);

public slots:
    void slotLinkClicked(const QString &txt);

private:
    int *s,id;
    QTextCodec *codec;
};

class MyListViewItem;

class MyListView : public QListView
{
    Q_OBJECT
public:
    MyListView(int *sock, int ident, QWidget * parent=0, const char * name=0);
    ~MyListView();
    void setListViewText(const char *path, int column, QString &text);
    void setListViewPixmap(const char *path, int column, QPixmap &pixmap);
    int  deleteListViewItem(const char *path, MyListViewItem *item);
    void doSendSelected(QListViewItem *item);
    int  ensureVisible(const char *path, MyListViewItem *item);
    int  setItemOpen(const char *path, int open, MyListViewItem *item);

public slots:
    void slotClicked(QListViewItem *item);
    void slotSendSelected();
    void slotRightButtonPressed(QListViewItem *, const QPoint &, int i);

private:
    void nameVersionSetListViewText(const char *path, int column, QString &text, MyListViewItem *item, const char *relpath, int num_slash);
    void nameVersionSetListViewPixmap(const char *path, int column, QPixmap &pixmap, MyListViewItem *item, const char *relpath, int num_slash);
    int *s,id;
};

class MyListViewItem : public QListViewItem
{
public:
  QString path;
  MyListViewItem ( MyListView *parent ) :
    QListViewItem(parent) {};
  MyListViewItem ( MyListViewItem *parent ) :
    QListViewItem (parent) {};
  MyListViewItem ( MyListView *parent, MyListViewItem *after ) :
    QListViewItem (parent,after) {};
  MyListViewItem ( MyListViewItem *parent, MyListViewItem *after ) :
    QListViewItem ( parent, after) {};
  MyListViewItem ( MyListView *parent, QString label1, QString label2 = QString::null, QString label3 = QString::null, QString label4 = QString::null, QString label5 = QString::null, QString label6 = QString::null, QString label7 = QString::null, QString label8 = QString::null ) :
    QListViewItem (parent, label1, label2, label3, label4, label5, label6, label7, label8) {};
  MyListViewItem ( MyListViewItem *parent, QString label1, QString label2 = QString::null, QString label3 = QString::null, QString label4 = QString::null, QString label5 = QString::null, QString label6 = QString::null, QString label7 = QString::null, QString label8 = QString::null ) :
    QListViewItem (parent, label1, label2, label3, label4, label5, label6, label7, label8) {};
  MyListViewItem ( MyListView *parent, MyListViewItem *after, QString label1, QString label2 = QString::null, QString label3 = QString::null, QString label4 = QString::null, QString label5 = QString::null, QString label6 = QString::null, QString label7 = QString::null, QString label8 = QString::null ) :
    QListViewItem ( parent, after, label1, label2, label3, label4, label5, label6, label7, label8) {};
  MyListViewItem ( MyListViewItem *parent, MyListViewItem *after, QString label1, QString label2 = QString::null, QString label3 = QString::null, QString label4 = QString::null, QString label5 = QString::null, QString label6 = QString::null, QString label7 = QString::null, QString label8 = QString::null ) :
    QListViewItem ( parent, after, label1, label2, label3, label4, label5, label6, label7, label8) {};
  virtual ~MyListViewItem() {};
};

class MyIconView : public QIconView
{
    Q_OBJECT
public:
    MyIconView(QTextCodec *_codec, int *sock, int ident, QWidget * parent=0, const char * name=0);
    ~MyIconView();
    virtual void setIconViewItem(QString &text, QPixmap &pixmap);
    virtual void deleteIconViewItem(QString &text);

public slots:
    void slotClicked(QIconViewItem *item);

private:
    int *s,id;
    QTextCodec *codec;
};

// --- QWT -----------------------------------------------------------------------------
class MyQwtScale : public QwtScale
{
    Q_OBJECT
public:
    MyQwtScale(int *sock, int ident, int position=0, QWidget *parent=0, const char *name=0);
    ~MyQwtScale();

private:
    int *s,id;
};

class MyQwtThermo : public QwtThermo
{
    Q_OBJECT
public:
    MyQwtThermo(int *sock, int ident, QWidget *parent=0, const char *name=0);
    ~MyQwtThermo();

private:
    int *s,id;
};

class MyQwtKnob : public QwtKnob
{
    Q_OBJECT
public:
    MyQwtKnob(int *sock, int ident, QWidget *parent=0, const char *name=0);
    ~MyQwtKnob();

public slots:
   void slotValueChanged(double value);

private:
    int *s,id;
};

class MyQwtCounter : public QwtCounter
{
    Q_OBJECT
public:
    MyQwtCounter(int *sock, int ident, QWidget *parent=0, const char *name=0);
    ~MyQwtCounter();

public slots:
   void slotValueChanged(double value);

private:
    int *s,id;
};

class MyQwtWheel : public QwtWheel
{
    Q_OBJECT
public:
    MyQwtWheel(int *sock, int ident, QWidget *parent=0, const char *name=0);
    ~MyQwtWheel();

public slots:
   void slotValueChanged(double value);

private:
    int *s,id;
};

class MyQwtSlider : public QwtSlider
{
    Q_OBJECT
public:
    MyQwtSlider(int *sock, int ident, QWidget *parent=0, const char *name=0);
    ~MyQwtSlider();

public slots:
   void slotValueChanged(double value);

private:
    int *s,id;
};

class MyQwtCompass : public QwtCompass
{
    Q_OBJECT
public:
    MyQwtCompass(int *sock, int ident, QWidget *parent=0, const char *name=0);
    ~MyQwtCompass();

public slots:
   void slotValueChanged(double value);

private:
    int *s,id;
};

class MyQDateEdit : public QDateEdit
{
    Q_OBJECT
public:
    MyQDateEdit(int *sock, int ident, QWidget *parent=0, const char *name=0);
    ~MyQDateEdit();

public slots:
   void slotValueChanged(const QDate &date);

private:
    int *s,id;
};

class MyQTimeEdit : public QTimeEdit
{
    Q_OBJECT
public:
    MyQTimeEdit(int *sock, int ident, QWidget *parent=0, const char *name=0);
    ~MyQTimeEdit();

public slots:
   void slotValueChanged(const QTime &time);

private:
    int *s,id;
};

class MyQDateTimeEdit : public QDateTimeEdit
{
    Q_OBJECT
public:
    MyQDateTimeEdit(int *sock, int ident, QWidget *parent=0, const char *name=0);
    ~MyQDateTimeEdit();

public slots:
   void slotValueChanged(const QDateTime &date_time);

private:
    int *s,id;
};

#endif
