/***************************************************************************
                          dlgopt.cpp  -  description
                             -------------------
    begin                : Tue Nov 21 2000
    copyright            : (C) 2000 by Rainer Lehrig
    email                : lehrig@t-online.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include <qlayout.h>
#include <qfile.h>
#include <stdio.h>
#include "dlgopt.h"

DlgOpt::DlgOpt(QWidget *parent, const char *name, QTextCodec *_codec) : QDialog(parent,name,true){
	initDialog();

  filename = "";
  codec = _codec;

  QObject::connect(QPushButton_ok,    SIGNAL(clicked()),this,SLOT(okClicked()));
  QObject::connect(QPushButton_cancel,SIGNAL(clicked()),this,SLOT(reject()));

  /* add layout begin */
  QVBoxLayout *vlayout = new QVBoxLayout(this);
  QHBoxLayout *hlayout = new QHBoxLayout();
#if QT_VERSION > 220
  QMultiLineEdit_1->setWordWrap(QTextEdit::NoWrap);
#endif  
  vlayout->addWidget(QMultiLineEdit_1);
  vlayout->addLayout(hlayout);
  hlayout->addSpacing(10);
  hlayout->addSpacing(200);
  hlayout->addWidget(QPushButton_cancel);
  hlayout->addSpacing(10);
  hlayout->addWidget(QPushButton_ok);
  hlayout->addSpacing(200);
  vlayout->activate();
  /* add layout begin */
}

DlgOpt::~DlgOpt(){
}

void DlgOpt::setFilename(const char *file)
{
  QString line;
  QFile qf(file);
  filename = file;
  if(!filename.isEmpty())
  {
    if(qf.open(IO_ReadOnly))
    {
      QMultiLineEdit_1->clear();
      QTextStream ts( &qf );
      ts.setEncoding(QTextStream::UnicodeUTF8);
      QMultiLineEdit_1->setText( ts.read() );
      //while(qf.readLine(line, 4096) > 0)
      //{
      //  if(codec != NULL) line = codec->toUnicode(line);
      //  QMultiLineEdit_1->append(line);
      //}
      qf.close();
    }
  }
}

void DlgOpt::okClicked()
{
  QString text;
  QFile qf(filename);
  if(qf.open(IO_WriteOnly))
  {
    QTextStream t( &qf );
    t.setEncoding(QTextStream::UnicodeUTF8);
    t << QMultiLineEdit_1->text();
    qf.close();
    //text = QMultiLineEdit_1->text();
    //if(codec != NULL) text = codec->fromUnicode(text);
    //qf.writeBlock(text,text.length());
    //qf.close();
  }
  accept();
}
