/***************************************************************************
                          main.cpp  -  description
                             -------------------
    begin                : Sam Nov 11 07:41:57 CET 2000
    copyright            : (C) 2000 by Rainer Lehrig
    email                : lehrig@t-online.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifdef _WIN32
#include <windows.h>
#endif
#include <stdlib.h>
#include <string.h>
#include <qapplication.h>
#include <qfont.h>
#include <qwindowsstyle.h>
#ifndef __VMS
//#include <qmotifplusstyle.h>
#include <qmotifstyle.h>
#endif
#include <qdialog.h>
#include <qlabel.h>
#include "qimagewidget.h"

#include "processview.h"
#ifndef IS_KPART
#include "logo1.xpm"
#endif
#include "splash.xpm"

/* windows stuff */
#ifdef _WIN32
#if QT_VERSION >= 0x030100
extern Q_EXPORT bool qt_win_use_simple_timers;
#endif
#endif

static int wsa()
{
#ifdef _WIN32
  WORD    wVersionRequested;
  WSADATA wsadata;
  int     err;

  wVersionRequested = MAKEWORD(1,1);
  err = WSAStartup(wVersionRequested, &wsadata);
  if(err != 0)
  {
    printf("Startup error=%d on windows\n",err);
    exit(0);
  }

#if QT_VERSION >= 0x030100
  qt_win_use_simple_timers = FALSE;
#endif

#endif
  return 0;
}

void perhapsShowUsage(int argc, char *argv[])
{
  int  i;
  char *arg;

  arg = argv[1];
  for(i=1; i<argc; i++)
  {
    if(strncmp(arg,"-h",2) == 0)
    {
      printf("%s       (C) Dr. Rainer Lehrig lehrig@t-online.de\n",PROCESS_VIEW_BROWSER);
      printf("usage:   processview <-localini> <-font=name<:size>> <host<:port></mask>> -disable -geometry=x:y:w:h\n");
      printf("example: processview\n");
      printf("example: processview localhost\n");
      printf("example: processview localhost:5050\n");
      printf("example: processview -font=courier localhost\n");
      printf("example: processview -font=arial:14 localhost:5050 -disable\n");
      printf("example  processview -geometry=0:0:640:480\n");
      exit(0);
    }
    arg++;
  }
}

void perhapsSetFont(QApplication &a, int argc, char *argv[])
{
  int  i,fsize;
  char *cptr,font[1024],*arg;

  for(i=1; i<argc; i++)
  {
    arg = argv[i];
    if(strncmp(arg,"-font=",6) == 0)
    {
      arg += 6;
      strcpy(font,arg);
      fsize = 12;
      cptr = strchr(font,':');
      if(cptr != NULL)
      {
        *cptr = '\0';
        cptr++;
        sscanf(cptr,"%d",&fsize);
      }
      a.setFont(QFont(font, fsize));
      return;
    }
  }
}

void perhapsSetGeometry(QApplication &a, int argc, char *argv[])
{
  char *arg;
  int i,x,y,w,h;

  for(i=1; i<argc; i++)
  {
    arg = argv[i];
    if(strncmp(arg,"-geometry=",10) == 0)
    {
      x = y = 0;
      w = 640;
      h = 480;
      sscanf(arg,"-geometry=%d:%d:%d:%d",&x,&y,&w,&h);
      a.mainWidget()->setGeometry(x,y,w,h);
      return;
    }
    arg++;
  }  
}

void ProcessView::initSplash()
{
  splashTimer = NULL;
  splashDlg = new QDialog(0, "splashDialog", FALSE, QDialog::WStyle_Customize | QDialog::WStyle_NoBorder | QDialog::WStyle_StaysOnTop);
  QWidget *screen = QApplication::desktop();
  QPixmap splashImage(splash);
  QLabel *splashLabel = new QLabel(splashDlg, "splashLabel");
  splashLabel->setPixmap(splashImage);
  splashDlg->setGeometry((screen->width()  - splashImage.width()) /2,
                         (screen->height() - splashImage.height())/2,
                          splashImage.width()+4, splashImage.height()+4);
  splashLabel->setGeometry(2, 2, splashImage.width(), splashImage.height());
  splashDlg->show();
}

void ProcessView::stopSplash()
{
  splashTimer = new QTimer();
  QObject::connect( splashTimer, SIGNAL(timeout()), this, SLOT(timeoutSplash()) );
  splashTimer->start( 3000, TRUE ); // 3 seconds single-shot timer
}

void ProcessView::timeoutSplash()
{
  if(splashDlg   != NULL) delete splashDlg;
  if(splashTimer != NULL) delete splashTimer;
  splashDlg   = NULL;
  splashTimer = NULL;

  if(initShowMaximized == 1)
  {
    //printf("showMaximized\n");
    //showNormal();
    showMaximized();
  }

  if(initFullScreen == 1)
  {
    //printf("showFullScreen\n");
    showNormal();
    showFullScreen();
  }
}

#ifndef IS_KPART
int main(int argc, char *argv[])
{
  if(argc > 0) argv[0] = PROCESS_VIEW_BROWSER;
  perhapsShowUsage(argc,argv);
  wsa();
  QApplication a(argc, argv);
  /* uncomment the following line, if you want a Windows 95 look*/
  //a.setStyle(new QWindowsStyle);
  //a.setStyle(new QMotifPlusStyle);
  //a.setStyle(new QMotifStyle);

  perhapsSetFont(a,argc,argv);

  ProcessView *processview=new ProcessView();
  a.setMainWidget(processview);

  processview->setIcon(logo1);
  //processview->setMinimumSize(1280/16,1024/16);
  //processview->setMaximumSize(6400,4800);
  processview->resize(800,600);
  processview->view->resize(800,600);
  processview->setCaption(PROCESS_VIEW_BROWSER);
  processview->show();
  processview->stopSplash();
  perhapsSetGeometry(a,argc,argv);

  return a.exec();
}
#else
void compiler_warning()
{
  wsa();
}
#endif
