/***************************************************************************
                          processview.cpp  -  description
                             -------------------
    begin                : Sat Nov 11 07:41:57 CET 2000
    copyright            : (C) 2000 by Rainer Lehrig
    email                : lehrig@t-online.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include <stdlib.h>
#include "processview.h"
#include "qmovie.h"
#include <qsocket.h>
#include <qmessagebox.h>
#include <qinputdialog.h>
#include <qevent.h>
#include <qsizepolicy.h> 
#include <qlayout.h>
#include <qsound.h>
#if QT_VERSION > 220
//#include <qmotifplusstyle.h>
#include <qmotifstyle.h>
#endif
#ifdef _WIN32
#include <io.h>
#include <direct.h>
#else
#include <sys/types.h>
#include <netinet/in.h>
#include <unistd.h>
#endif
#include <sys/stat.h>
#include <fcntl.h>
#include "tcputil.h"
//#include "filesave.xpm"
//#include "fileopen.xpm"
//#include "filenew.xpm"
#include "filelog.xpm"
#include "fileprint.xpm"
#include "bmplog.xpm"
#include "screensave.xpm"
#include "editcopy.xpm"
#include "logo1.xpm"
#include "exit.xpm"
#include "help.xpm"
#include "reconnect.xpm"
#include "run.xpm"
#include "options.xpm"
#include "fullscreen.xpm"
#include <qlineedit.h>

#ifdef unix
#include <utime.h>
#endif

#ifdef _WIN32
#include <sys/utime.h>
#endif

#ifndef _WIN32
#define closesocket close
#endif

#define LEFT_PRINT_MARGIN  10
#define UPPER_PRINT_MARGIN 70

#define MAX_PHRASE 80
static QString l_file               = "&File";
static QString l_options            = "&Options";
static QString l_new_processview    = "&New Window";
static QString l_reconnect          = "&Reconnect";
static QString l_save_as_bmp        = "&Save as BMP ...";
static QString l_log_as_bmp         = "Log Metafiles as &BMP ...";
static QString l_log_as_pvm         = "Log Metafiles as P&VM ...";
static QString l_print              = "&Print";
static QString l_exit               = "E&xit";
static QString l_edit               = "&Edit";
static QString l_copy               = "&Copy";
static QString l_view               = "&View";
static QString l_toolbar            = "Tool&bar";
static QString l_statusbar          = "&Statusbar";
static QString l_toggle_full_screen = "Toggle&FullScreen";
static QString l_help               = "&Help";
static QString l_booklet            = "&Booklet ...";
static QString l_manual             = "&Manual ...";
static QString l_about              = "&About ...";
static QString l_recent_urls        = "Recent URLs";

static QString l_status_connection_lost   = "Connection to server lost, CTRL-R for reconnect";
static QString l_status_connected         = "Connected to server";
static QString l_status_could_not_connect = "Could not connect to server, CTRL-R for reconnect";

static QString l_status_options     = "Views/changes ProcessViewBrowser options";
static QString l_status_new_processview = "Opens a new ProcessViewBrowser window";
static QString l_status_save_as_bmp = "Saves the actual screen as BMP file";
static QString l_status_log_as_bmp  = "Log QDrawWidgets as BMP file";
static QString l_status_log_as_pvm  = "Log QDrawWidgets as PVM file";
static QString l_status_print       = "Prints the actual screen";
static QString l_status_exit        = "Closes ProcessViewBrowser";
static QString l_status_copy        = "Copies the screen to clipboard";
static QString l_status_toolbar     = "Enables/disables the toolbar";
static QString l_status_statusbar   = "Enables/disables the statusbar";
static QString l_status_toggle_full_screen = "FullScreenMode On/Off";
static QString l_status_booklet     = "Shows the ProcessViewServer booklet";
static QString l_status_manual      = "Shows the ProcessViewServer reference manual";
static QString l_status_about       = "Shows the aboutbox";

static QString l_print_header       = "Printed by " PROCESS_VIEW_BROWSER " at: ";

static char caption_processview[]            = "ProcessViewBrowser " VERSION;

static int mysystem(const char *command)
{
#ifdef _WIN32
  int ret;
  STARTUPINFO         si = { sizeof(si)};
  PROCESS_INFORMATION pi;
  char cmd[4096];

  if(strncmp(command,"start",5) == 0 || strncmp(command,"START",5) == 0)
  {
    ExpandEnvironmentStrings(command,cmd,sizeof(cmd)-1);
    ret = system(cmd);
  }
  else
  {
    ExpandEnvironmentStrings(command,cmd,sizeof(cmd)-1);
    ret = (int) CreateProcess( NULL, cmd
                             , NULL, NULL
                             , FALSE, CREATE_NO_WINDOW
                             , NULL, NULL
                             , &si, &pi);
  }
  return ret;
#else
  return system(command);
#endif
}

#ifdef _WIN32
static int get_iexplore(char *buf)
{
  HKEY applications,iexplore,shell,open,command;
  long ret;
  unsigned long size,type;
  char *cptr;

  buf[0] = '\0';

  ret = RegOpenKey(
    HKEY_CLASSES_ROOT,        // handle to open key
    "Applications",           // address of name of subkey to open
    &applications             // address of handle to open key
  );
  if(ret != ERROR_SUCCESS)
  {
    return -1;
  }

  ret = RegOpenKey(
    applications,             // handle to open key
    "iexplore.exe",           // address of name of subkey to open
    &iexplore                 // address of handle to open key
  );
  if(ret != ERROR_SUCCESS)
  {
    RegCloseKey(applications);
    return -1;
  }

  ret = RegOpenKey(
    iexplore,                 // handle to open key
    "shell",                  // address of name of subkey to open
    &shell                    // address of handle to open key
  );
  if(ret != ERROR_SUCCESS)
  {
    RegCloseKey(applications);
    RegCloseKey(iexplore);
    return -1;
  }

  ret = RegOpenKey(
    shell,                    // handle to open key
    "open",                   // address of name of subkey to open
    &open                     // address of handle to open key
  );
  if(ret != ERROR_SUCCESS)
  {
    RegCloseKey(applications);
    RegCloseKey(iexplore);
    RegCloseKey(shell);
    return -1;
  }

  ret = RegOpenKey(
    open,                     // handle to open key
    "command",                // address of name of subkey to open
    &command                  // address of handle to open key
  );
  if(ret != ERROR_SUCCESS)
  {
    RegCloseKey(applications);
    RegCloseKey(iexplore);
    RegCloseKey(shell);
    RegCloseKey(open);
    return -1;
  }

  ret = RegQueryValueEx(
    command,               // handle to key to query
    "",                    // address of name of value to query
    NULL,                  // reserved
    &type,                 // address of buffer for value type
    (unsigned char *) buf, // address of data buffer
    &size                  // address of data buffer size
  );

  RegCloseKey(applications);
  RegCloseKey(iexplore);
  RegCloseKey(shell);
  RegCloseKey(open);
  RegCloseKey(command);

  if(ret != ERROR_SUCCESS) return -1;

  cptr = strstr(buf," %1");
  if(cptr != NULL) *cptr = '\0';

  return 0;
}
#endif

ProcessView::ProcessView(QWidget *parent, const char *name, WFlags f)
            : QMainWindow(parent, name, f)
{
  char buf[MAX_PRINTF_LENGTH];
  int  ac,i,localini;

  mainLayout = NULL;
  hasLayout = 0;
  ssh_command = "ssh -N";
  sshport = 50500;
  exitpassword = 0;
  codec = NULL;
  timet = time(NULL);
  menubar = 1;
  scrollbars = 1;
  autoreconnect = 0;
  disable = 0;
  localini = 0;
  ac = qApp->argc();
  if(ac >= 2)
  {
    for(i=1; i<ac; i++)
    {
      if(strcmp(qApp->argv()[i],"-disable") == 0)
      {
        disable = 1;
      }
      else if(strcmp(qApp->argv()[i],"-localini") == 0)
      {
        localini = 1;
      }
    }
  }
  zoom = zoom_original = 100;
  initFullScreen = initShowMaximized = 0;
  allModal = allBase = NULL;
  allBase = allModal = 0;
  modalDialog = NULL;
#ifndef IS_KPART
  initSplash();
#endif

#ifdef USE_OPEN_GL
  //QGLWidget gl;
  //gl.makeCurrent();
#endif

  itoolbar = istatusbar = 1;
  fullScreen = 0;
  s           = -1;
#ifdef USE_SOCKET_NOTIFIER
  sn          = NULL;
  snerror     = NULL;
#else
  socketTimer = NULL;
#endif
  port        = 5050;
  all         = NULL;
  nmax        = 0;
  path[0]     = '\0';
  inifile     = "";
  passfile    = "";
  currenthost = "";

  QObject::connect(qApp, SIGNAL(aboutToQuit()), this, SLOT(slotFileQuit()));
  setCaption(caption_processview);
  setPath(qApp->argv()[0]);
#ifdef unix
  strcpy(buf,getenv("HOME"));
  inifile  = buf;
  inifile += "/.pvbrz";
  passfile  = buf;
  passfile += "/.pvbrzpass";
#endif
#ifdef __VMS
  inifile  = "sys$login:pvbrz.ini";
  passfile = "sys$login:pvbrzpass.ini";
#endif
#ifdef _WIN32
  ExpandEnvironmentStrings("%USERPROFILE%",buf,sizeof(buf)-1);
  if(strcmp(buf,"%USERPROFILE%") == 0) inifile = "C:";
  else                                 inifile = buf;
  passfile  = inifile;
  passfile += "\\pvbrzpass.ini";
  inifile += "\\pvbrz.ini";
#endif
  if(localini == 1)
  {
    inifile = "pvbrz";
    passfile = "pvbrzpass";
  }  
  customlogo  = "";
  readCustomlogoFromIniFile();

  ///////////////////////////////////////////////////////////////////
  // call inits to invoke all other construction parts
  getLanguage();
  initMenuBar();
  initToolBar();
  initStatusBar();
  initDoc();
  initView();

  readIniFile();
  
  ac = qApp->argc();
  if(ac >= 2)
  {
    for(i=1; i<ac; i++)
    {
      if(strncmp(qApp->argv()[i],"-",1) != 0)
      {
        inihost = qApp->argv()[i];
        break;
      }
    }
  }
  if(s == -1 && !inihost.isEmpty())
  {
    currenthost = inihost;
    isReconnect = 0;
#ifndef IS_KPART
    slotUrl();
#endif
  }

  setIcon(logo1);

  qApp->installEventFilter(this);

  // setup watchdog
  timer = new QTimer();
  QObject::connect(timer, SIGNAL(timeout()), this, SLOT(timeOut()));
  timer->start(1000*10);
}

void ProcessView::newProcessView()
{
#ifdef unix
  int ret;
  if(newwindow.isEmpty()) ret = system("processview &");
  else                    ret = system(newwindow + " &");
  if(ret < 0) return;
#endif

#ifdef __VMS
  if(newwindow.isEmpty()) system("spawn/nowait processview");
  else                    system("spawn/nowait " + newwindow);
#endif

#ifdef _WIN32
  if(newwindow.isEmpty()) mysystem("processview");
  else                    mysystem(newwindow);
#endif
}

void ProcessView::selectSocket()
{
  struct timeval timout;
  fd_set rset;
  int    ret,maxfdp1;

  if(s == -1)
  {
    s = -1;
#ifndef USE_SOCKET_NOTIFIER
    if(socketTimer != NULL)
    {
      socketTimer->stop();
      QObject::disconnect(socketTimer);
      delete socketTimer;
    }
    socketTimer = NULL;
#endif
    return;
  }

  // setup sockets to read
  maxfdp1 = s+1;
  FD_ZERO(&rset);
  FD_SET (s,&rset);
  timout.tv_sec  = 0;
  timout.tv_usec = 50;

  ret = ::select(maxfdp1,&rset,NULL,NULL,&timout);
  if(ret == 0)
  {
    return; // timeout
  }
  else if(ret < 0)
  { // error
    ::closesocket(s);
    s = -1;
#ifndef USE_SOCKET_NOTIFIER
    if(socketTimer != NULL)
    {
      socketTimer->stop();
      QObject::disconnect(socketTimer);
      delete socketTimer;
    }
    socketTimer = NULL;
#endif
    statusBar()->setPaletteBackgroundColor(QColor(255,0,0));
    statusBar()->message(l_status_connection_lost);
    all[0]->w->setDisabled(1);
    qApp->beep();
    return;
  }
  dataReceived();
}

void ProcessView::timeOut()
{
  if(s != -1)
  {
    char buf[20];
    sprintf(buf,"@hello=%s\n",VERSION);
    if(tcp_send(&s,buf,strlen(buf)) == -1)
    { // connection lost
      tcp_close(&s);
      s = -1;
#ifdef USE_SOCKET_NOTIFIER
      if(sn != NULL)
      {
        delete sn;
        sn = NULL;
      }
      if(snerror != NULL)
      {
        delete snerror;
        snerror = NULL;
      }
#else
      socketTimer->stop();
      QObject::disconnect(socketTimer);
      delete socketTimer;
      socketTimer = NULL;
#endif
      statusBar()->setPaletteBackgroundColor(QColor(255,0,0));
      statusBar()->message(l_status_connection_lost);
      all[0]->w->setDisabled(1);
      qApp->beep();
    }
  }
  else if(s == -1)
  {
    if(autoreconnect == 1) 
    {
     isReconnect = 1;
     slotUrl();
    }  
  }
}

ProcessView::~ProcessView()
{
  if(all != NULL) free(all);
  if(s != -1) tcp_close(&s);
  s = -1;
}

void ProcessView::initMenuBar()
{
  QPixmap logo1Icon,customIcon;

  ///////////////////////////////////////////////////////////////////
  // MENUBAR
  ///////////////////////////////////////////////////////////////////
  // menuBar entry fileMenu
  fileMenu=new QPopupMenu();
  //fileMenu->insertItem("&New", this, SLOT(slotFileNew()), CTRL+Key_N, ID_FILE_NEW);
  //fileMenu->insertItem("&Open...", this, SLOT(slotFileOpen()), CTRL+Key_O, ID_FILE_OPEN);
  //fileMenu->insertSeparator();
  //fileMenu->insertItem("&Save", this, SLOT(slotFileSave()), CTRL+Key_S, ID_FILE_SAVE);
  //fileMenu->insertItem("&Close", this, SLOT(slotFileClose()), CTRL+Key_W, ID_FILE_CLOSE);
  if(disable == 0)
  {
    QPixmap options_pixmap = QPixmap(options_xpm);
    fileMenu->insertItem(options_pixmap,l_options, this, SLOT(slotFileOpt()), CTRL+Key_O, ID_FILE_OPT);
    fileMenu->insertSeparator();
    QPixmap run_pixmap = QPixmap(run_xpm);
    fileMenu->insertItem(run_pixmap,l_new_processview, this, SLOT(newProcessView()), CTRL+Key_N, ID_FILE_NEW);
  }
  QPixmap reconnect_pixmap = QPixmap(reconnect_xpm);
  fileMenu->insertItem(reconnect_pixmap,l_reconnect, this, SLOT(slotUrl()), CTRL+Key_R, ID_FILE_RECONNECT);
  fileMenu->insertSeparator();
  QPixmap screensave_pixmap = QPixmap(screensave_xpm);
  fileMenu->insertItem(screensave_pixmap,l_save_as_bmp, this, SLOT(slotFileSaveAs()),  CTRL+Key_S, ID_FILE_SAVE_AS);
  QPixmap bmplog_pixmap = QPixmap(bmplog_xpm);
  fileMenu->insertItem(bmplog_pixmap,l_log_as_bmp, this, SLOT(slotMetaFileBmp()), CTRL+Key_B, ID_FILE_METAFILE_BMP);
  QPixmap filelog_pixmap = QPixmap(filelog_xpm);
  fileMenu->insertItem(filelog_pixmap,l_log_as_pvm, this, SLOT(slotMetaFileLog()), CTRL+Key_V, ID_FILE_METAFILE_LOG);
  QPixmap fileprint_pixmap = QPixmap(fileprint_xpm);
  fileMenu->insertItem(fileprint_pixmap,l_print, this, SLOT(slotFilePrint()), CTRL+Key_P, ID_FILE_PRINT);
  fileMenu->insertSeparator();
  QPixmap exit_pixmap = QPixmap(exit_xpm);
  fileMenu->insertItem(exit_pixmap,l_exit, this, SLOT(slotFileQuit()), CTRL+Key_Q, ID_FILE_QUIT);

  ///////////////////////////////////////////////////////////////////
  // menuBar entry editMenu
  editMenu=new QPopupMenu();

  //editMenu->insertItem("Cu&t", this, SLOT(slotEditCut()), CTRL+Key_X, ID_EDIT_CUT);
  QPixmap editcopy_pixmap = QPixmap(editcopy_xpm);
  editMenu->insertItem(editcopy_pixmap,l_copy, this, SLOT(slotEditCopy()), CTRL+Key_K, ID_EDIT_COPY);
  //editMenu->insertItem("&Paste", this, SLOT(slotEditPaste()), CTRL+Key_V, ID_EDIT_PASTE);

  ///////////////////////////////////////////////////////////////////
  // menuBar entry viewMenu
  if(disable == 0)
  {
    viewMenu=new QPopupMenu();
    viewMenu->setCheckable(true);
    viewMenu->insertItem(l_toolbar, this, SLOT(slotViewToolBar()), 0, ID_VIEW_TOOLBAR);
    viewMenu->insertItem(l_statusbar, this, SLOT(slotViewStatusBar()), 0, ID_VIEW_STATUSBAR);
    QPixmap fullscreen_pixmap = QPixmap(fullscreen_xpm);
    viewMenu->insertItem(fullscreen_pixmap,l_toggle_full_screen, this, SLOT(slotShowFullScreen()), CTRL+Key_F, ID_SHOW_FULL_SCREEN);
    viewMenu->setItemChecked(ID_VIEW_TOOLBAR, true);
    viewMenu->setItemChecked(ID_VIEW_STATUSBAR, true);
  }
  ///////////////////////////////////////////////////////////////////
  // EDIT YOUR APPLICATION SPECIFIC MENUENTRIES HERE
  ///////////////////////////////////////////////////////////////////
  // menuBar entry helpMenu
  helpMenu=new QPopupMenu();
  if(disable == 0)
  {
    QPixmap help_pixmap = QPixmap(help_xpm);
    helpMenu->insertItem(help_pixmap,l_booklet, this, SLOT(slotHelpBooklet()), 0, ID_HELP_BOOKLET);
    helpMenu->insertItem(help_pixmap,l_manual, this, SLOT(slotHelpManual()), 0, ID_HELP_MANUAL);
  }
  QPixmap logo1_pixmap = QPixmap(logo1);
  helpMenu->insertItem(logo1_pixmap,l_about, this, SLOT(slotHelpAbout()), 0, ID_HELP_ABOUT);

  ///////////////////////////////////////////////////////////////////
  // MENUBAR CONFIGURATION
  // set menuBar() the current menuBar

#if QT_VERSION > 220
  //menuBar()->setStyle(new QMotifPlusStyle);
  menuBar()->setStyle(new QMotifStyle);
#endif

  menuBar()->insertItem(l_file, fileMenu);
  menuBar()->insertItem(l_edit, editMenu);
  if(disable == 0) menuBar()->insertItem(l_view, viewMenu);

  QWidget *spacer = new QWidget();
  menuBar()->insertItem(spacer);
  menuBar()->insertSeparator();

  customIcon = QPixmap(customlogo);
  if(!customIcon.isNull())
  {
    menuBar()->insertItem(customIcon);
  }

  logo1Icon = QPixmap(logo1);
  menuBar()->insertItem(logo1Icon);
  menuBar()->insertItem(l_help, helpMenu);

  ///////////////////////////////////////////////////////////////////
  // CONNECT THE SUBMENU SLOTS WITH SIGNALS

  connect(fileMenu, SIGNAL(highlighted(int)), SLOT(statusCallback(int)));
  connect(editMenu, SIGNAL(highlighted(int)), SLOT(statusCallback(int)));
  if(disable == 0) connect(viewMenu, SIGNAL(highlighted(int)), SLOT(statusCallback(int)));
  connect(helpMenu, SIGNAL(highlighted(int)), SLOT(statusCallback(int)));
}

int ProcessView::hostSuppliedInCommandline()
{
  int ac,i;

  ac = qApp->argc();
  for(i=1; i<ac; i++)
  {
    if(strncmp(qApp->argv()[i],"-",1) != 0) return 1;
  }
  return 0;
}

void ProcessView::initToolBar()
{
  ///////////////////////////////////////////////////////////////////
  // TOOLBAR
  //QPixmap openIcon, saveIcon, newIcon;
  QPixmap logIcon, printIcon, copyIcon, bmplogIcon, screensaveIcon;

  fileToolbar = new QToolBar(this, "file operations");
 
  //newIcon = QPixmap(filenew);

  //QToolButton *fileNew = new QToolButton(newIcon, "New File", 0, this,
  //                                       SLOT(slotFileNew()), fileToolbar);

  //openIcon = QPixmap(fileopen);
  //QToolButton *fileOpen = new QToolButton(openIcon, "Open File", 0, this,

  //                                        SLOT(slotFileOpen()), fileToolbar);

  //saveIcon = QPixmap(filesave);
  //QToolButton *fileSave = new QToolButton(saveIcon, "Save File", 0, this,
  //                                        SLOT(slotFileSave()), fileToolbar);
  
  screensaveIcon = QPixmap(screensave_xpm);
  QToolButton *fileLogScreen = new QToolButton(screensaveIcon, "Snapshot screen as BMP file to disk", 0, this,
                                          SLOT(slotFileSaveAs()), fileToolbar);
  logIcon = QPixmap(filelog_xpm);
  QToolButton *fileLog = new QToolButton(logIcon, "Log Metafiles as PVM to disk", 0, this,
                                          SLOT(slotMetaFileLog()), fileToolbar);
  bmplogIcon = QPixmap(bmplog_xpm);
  QToolButton *fileLogBmp = new QToolButton(bmplogIcon, "Log QDrawWidgets as BMP to disk", 0, this,
                                          SLOT(slotMetaFileBmp()), fileToolbar);
  printIcon = QPixmap(fileprint_xpm);
  QToolButton *filePrint = new QToolButton(printIcon, "Print contents", 0, this,
                                          SLOT(slotFilePrint()), fileToolbar);
  copyIcon = QPixmap(editcopy_xpm);
  QToolButton *editCopy = new QToolButton(copyIcon, "Copy contents to clipboard", 0, this,
                                          SLOT(slotEditCopy()), fileToolbar);

  fileToolbar->addSeparator();

  if(hostSuppliedInCommandline())
  {
    recent_urls = new QComboBox(0,l_recent_urls);
    recent_urls->hide();
  }
  else
  {
    QLabel *lab = new QLabel(fileToolbar);
    lab->resize(200,20);
    lab->setText(l_recent_urls);

    recent_urls = new QComboBox(fileToolbar,l_recent_urls);
    recent_urls->resize(200,20);
    recent_urls->setMinimumWidth(400);
    recent_urls->setMaximumWidth(1280);
    recent_urls->setSizePolicy(QSizePolicy::Expanding, QSizePolicy::Fixed);

    recent_urls->setEditable(true);
    recent_urls->setInsertionPolicy(QComboBox::NoInsertion);
    connect(recent_urls, SIGNAL(activated(const QString &)), SLOT(slotRecentUrls(const QString &)));
    fileToolbar->addSeparator();
  }

  QWhatsThis::whatsThisButton(fileToolbar);
  //QWhatsThis::add(fileNew,"Click this button to create a new file.\n\n"
  //                "You can also select the New command from the File menu.");

  //QWhatsThis::add(fileOpen,"Click this button to open a new file.\n\n"

  //                "You can also select the Open command from the File menu.");
  //QWhatsThis::add(fileSave,"Click this button to save the file you are "
  //                "editing. You will be prompted for a file name.\n\n"
  //                "You can also select the Save command from the File menu.");
  QWhatsThis::add(fileLogBmp,"Click this button to log the contents of the QDrawWidget's you are "
                  "seeing as BMP files. You will be prompted for a directory name.\n\n"
                  "You can also select the Log Metafiles as BMP command from the File menu.");
  QWhatsThis::add(fileLogScreen,"Click this button to log the contents of the screen you are "
                  "seeing as BMP file. You will be prompted for a file name.\n\n"
                  "You can also select the Save as BMP command from the File menu.");
  QWhatsThis::add(fileLog,"Click this button to log the contents of the QDrawWidget's you are "
                  "seeing as PVM files. You will be prompted for a directory name.\n\n"
                  "You can also select the Log Metafiles as PVM command from the File menu.");

  QWhatsThis::add(filePrint,"Click this button to print the contents of the screen you are "
                  "seeing. You will be prompted for a printer name.\n\n"
                  "You can also select the Print command from the File menu.");
  QWhatsThis::add(editCopy,"Click this button to copy the screen you are "
                  "seeing to the clipboard.\n\n"
                  "You can also select the Copy command from the Edit menu.");
  QWhatsThis::add(recent_urls,"Select the recent nodes you have visited or input your host\n"
                  "Syntax:\npv://hostname:port\npvssh://user@hostname:host:port\n"
      "example:\npv://localhost:5050\npvssh://user@hostname:visuhost:5050");
}

void ProcessView::initStatusBar()
{
  ///////////////////////////////////////////////////////////////////
  //STATUSBAR
  statusBar()->unsetPalette();
  statusBar()->message(IDS_STATUS_DEFAULT, 2000);
}

void ProcessView::initDoc()
{
   // doc=new ProcessViewDoc();
}

void ProcessView::initView()
{
  ////////////////////////////////////////////////////////////////////
  // set the main widget here

  view = new MyQWidget(&s,0,this,"ViewMain");
  scroll = new QScrollView(this);
  scroll->addChild(view);
  //scroll->viewport()->setPaletteBackgroundColor(paletteBackgroundColor());
  //scroll->viewport()->setPaletteForegroundColor(paletteBackgroundColor());
  setCentralWidget(scroll);
}

bool ProcessView::queryExit()
{
  int exit=QMessageBox::information(this, "Quit...",
                                    "Do your really want to quit?",
                                    QMessageBox::Ok, QMessageBox::Cancel);

  if (exit==1)
  {
  }
  else
  {
  };

  return (exit==1);
}

/////////////////////////////////////////////////////////////////////
// SLOT IMPLEMENTATION
/////////////////////////////////////////////////////////////////////
QImage *ProcessView::readBmpFromSocket(int w, int h, char **d)
{
  char *data,text[MAX_PRINTF_LENGTH];
  int y,ret,r,g,b,ii,icol;
  QImage *temp;
  QRgb rgb[4*256];

  if(w == -1 && h == -1) // load bmp from file (e.g. PHP server)
  {
    data = NULL;
    temp = new QImage();
    temp->load("temp.bmp");
    QRgb col;
    for(icol=0; icol < temp->numColors(); icol++)
    {
      col = temp->color(icol);
      if(qRed(col) == 1 && qGreen(col) == 1 && qBlue(col) == 1)
      {
        col = qRgba(1,1,1,0); // transparent color
        temp->setColor(icol, col);
      }
    }
    temp->setAlphaBuffer(true);
    return temp;
  }

  data = new char[w*h];

  if(data==NULL) qFatal("out of memory -> exit");
  for(y=0; y<h; y++) // get image
  {
    ret = tcp_rec_binary(&s, data+(y*w), w);
    if(ret == -1) { delete data; return NULL; }
  }

  for(icol=0; 1; icol++) // get color table
  {
#ifdef _WIN32
retry:
#endif
    ret = tcp_rec(&s, text, sizeof(text)-1);
    if(ret == -1) { delete data; return NULL; };
#ifdef _WIN32
    if(ret == -2) goto retry;
#endif
    if(strncmp(text,"end",3) == 0) break;
    sscanf(text,"qRgb(%d,%d,%d,%d)",&ii,&r,&g,&b);
    if(r==1 && g==1 && b==1) rgb[icol] = qRgba(r,g,b,0);
    else                     rgb[icol] = qRgba(r,g,b,255);
  }

  temp = new QImage((uchar *) data,w,h,8,rgb,icol,QImage::IgnoreEndian);
  *d = data;
  temp->setAlphaBuffer(true);
  return temp;
}

void ProcessView::slotMetaFileLog()
{
QString dir;

  QFileDialog *dlg = new QFileDialog();
  dir = dlg->getExistingDirectory();
  if(!dir.isEmpty())
  {
    for(int i=1; i<nmax; i++)
    {
      if(all[i]->type == TQDraw)
      {
        char filename[MAX_PRINTF_LENGTH],buf[80];
        sprintf(buf,"pvMetaFile%d.pvm",i);
        strcpy(filename,(const char *) dir); strcat(filename,buf);
        QDrawWidget *ptr = (QDrawWidget *) all[i]->w;
        ptr->logToFile(filename);

      }
    }
  }
}

void ProcessView::slotMetaFileBmp()
{
QString dir;

  QFileDialog *dlg = new QFileDialog();
  dir = dlg->getExistingDirectory();
  if(!dir.isEmpty())
  {
    for(int i=1; i<nmax; i++)
    {
      if(all[i]->type == TQDraw)
      {
        char filename[MAX_PRINTF_LENGTH],buf[80];
        sprintf(buf,"pvMetaFile%d.bmp",i);
        strcpy(filename,(const char *) dir); strcat(filename,buf);
        QDrawWidget *ptr = (QDrawWidget *) all[i]->w;
        ptr->logBmpToFile(filename);
      }
    }
  }
}

void ProcessView::slotFileOpt()
{
int ret,cnt,i;

  DlgOpt *dlg = new DlgOpt(this,0,codec);
  dlg->setCaption("ProcessViewBrowser Options");
  dlg->setFilename(inifile);
  ret = dlg->exec();
  if(ret == QDialog::Accepted)
  {
    cnt = recent_urls->count();
    for(i=0; i<cnt; i++)
    {
      recent_urls->removeItem(0);
    }
    readIniFile();
    getLanguage();
  }
  delete dlg;
}

void ProcessView::slotFileSaveAs()
{
  int x0,y0,width,height;

  if(all == NULL) return;
  qApp->processEvents(1000);  // let the menu bar hide itself
  QWidget *w = all[0]->w;

  w->raise();

  if(scroll != NULL)
  {
    x0     = scroll->contentsX();
    y0     = scroll->contentsY();
    width  = scroll->visibleWidth();
    height = scroll->visibleHeight();
  }
  else
  {
    x0     = view->x();
    y0     = view->y();
    width  = view->width();
    height = view->height();
  }
  if(width  > w->width())  width  = w->width();
  if(height > w->height()) height = w->height();

  QPixmap pm(QPixmap::grabWindow(w->winId(),x0,
                                            y0,
                                            width,
                                            height));

  QString fn = QFileDialog::getSaveFileName(0, "*.bmp", this);
  if(!fn.isEmpty())
  {
    pm.save(fn,"BMP");
  }
  else
  {
    statusBar()->unsetPalette();
    statusBar()->message("Saving aborted", 2000);
  }
}

void ProcessView::slotFilePrint()
{
  int x0,y0,width,height;
  double scale;

  scale = 1.0;
  if(nmax > 0)
  {
    qApp->processEvents(1000);  // let the menu bar hide itself
    QWidget *w = all[0]->w;
    w->raise();

    if(scroll != NULL)
    {
      x0     = scroll->contentsX();
      y0     = scroll->contentsY();
      width  = scroll->visibleWidth();
      height = scroll->visibleHeight();
    }
    else
    {
      x0     = view->x();
      y0     = view->y();
      width  = view->width();
      height = view->height();
    }
    if(width  > w->width())  width  = w->width();
    if(height > w->height()) height = w->height();

    QPixmap pm(QPixmap::grabWindow(w->winId(),x0,
                                              y0,
                                              width,
                                              height));

    //QPixmap pm(QPixmap::grabWidget(all[0]->w));
    QPrinter printer;
    printer.setOrientation(QPrinter::Landscape);
    printer.setColorMode(QPrinter::Color);
    if(printer.setup(this))
    {
      QPainter painter;
      painter.begin(&printer);
#ifndef _WIN32
      if(printer.orientation() == QPrinter::Landscape)
      {
        painter.rotate(-90.0f);
        painter.translate(-painter.viewport().width(),0.0f);
      }
#endif
      if(strlen(l_print_header) > 0)
      {
        QString date_time;
        date_time  = l_print_header;
#if QT_VERSION > 220
        date_time += QDateTime::currentDateTime().toString(Qt::TextDate);
#else
        date_time += QDateTime::currentDateTime().toString();
#endif
        painter.drawText(LEFT_PRINT_MARGIN,UPPER_PRINT_MARGIN-30,1280,100,ExpandTabs | DontClip, date_time);
      }
      if((width + (LEFT_PRINT_MARGIN*2)) > painter.viewport().width())
      {
        // width                scale
        // ------------------ = -----
        // viewport().width()     1

        scale = (width - LEFT_PRINT_MARGIN*2) / painter.viewport().width();
        painter.scale(scale,scale);
      }
      painter.drawPixmap(LEFT_PRINT_MARGIN*((int) scale),UPPER_PRINT_MARGIN*((int) scale),pm);
      painter.end();
    }
  }
}

const char *pvpass(const char *p)
{
  static char ret[4*16+8];
  char buf[80];
  int  i,val;

  ret[0] = '\0';
  for(i=0; p[i] != '\0' && i<=16; i++)
  {
    val = p[i] * 16;
    sprintf(buf,"%04X",val);
    strcat(ret,buf);
  }

  return ret;
}

bool ProcessView::eventFilter(QObject *o, QEvent *e)
{
  if(e->type() == QEvent::Close && o == this) 
  {
    // special processing
    slotFileQuit();
    return TRUE; // eat event
  } 
  else 
  {
    // standard event processing
    return FALSE;
  }
}

void ProcessView::slotFileQuit()
{
  ///////////////////////////////////////////////////////////////////
  // exits the Application
  static int first = 1;
  char *cptr;

  if(exitpassword == 1 && first == 1)
  {
    bool ok;
    QString pass = QInputDialog::getText("pvbrowser","Exit Password ?",QLineEdit::Password,QString::null,&ok,this);
    if( ok && !pass.isEmpty() ) 
    {
      // user entered something and pressed OK
      FILE *fp;
      fp = fopen(passfile,"r");
      if(fp == NULL)
      {
        fp = fopen(passfile,"w");
        if(fp != NULL)
        {
          fprintf(fp,"%s\n",pvpass(pass));
          fclose(fp);
        }
      }
      else
      {
        char buf[1024];
        cptr = fgets(buf,sizeof(buf)-1,fp);
        fclose(fp);
        if(cptr == NULL) return;
        if(strncmp(buf,pvpass(pass),strlen(buf)-1) != 0)
        {
          QMessageBox::information(this,"pvbrowser","Wrong Password",1);
          return;
        }
      }
    }
    else return;
  }
  first = 0;
  if(s != -1) tcp_close(&s);
  s = -1;
#ifndef IS_KPART
  qApp->quit();
#endif
#ifdef _WIN32
  exit(0);
#endif
}

void ProcessView::slotEditCopy()
{
  int x0,y0,width,height;
  if(nmax > 0)
  {
    qApp->processEvents(1000);  // let the menu bar hide itself
    QWidget *w = all[0]->w;
    w->raise();
    
    if(scroll != NULL)
    {
      x0     = scroll->contentsX();
      y0     = scroll->contentsY();
      width  = scroll->visibleWidth();
      height = scroll->visibleHeight();
    }
    else
    {
      x0     = view->x();
      y0     = view->y();
      width  = view->width();
      height = view->height();
    }
    if(width  > w->width())  width  = w->width();
    if(height > w->height()) height = w->height();
        
    QPixmap pm(QPixmap::grabWindow(w->winId(),x0,
                                              y0,
                                              width,
                                              height));
    
    //QPixmap pm(QPixmap::grabWidget(all[0]->w));
    QApplication::clipboard()->setPixmap(pm);
  }
}

void ProcessView::slotViewToolBar()
{
  ///////////////////////////////////////////////////////////////////
  // turn Toolbar on or off
  
  if (fileToolbar->isVisible())
  {
    fileToolbar->hide();
    if(disable == 0) viewMenu->setItemChecked(ID_VIEW_TOOLBAR, false);
  }
  else
  {
    fileToolbar->show();
    if(disable == 0) viewMenu->setItemChecked(ID_VIEW_TOOLBAR, true);
  };
}

void ProcessView::slotViewStatusBar()
{
  ///////////////////////////////////////////////////////////////////
  //turn Statusbar on or off
  
  if (statusBar()->isVisible())
  {
    statusBar()->hide();
    if(disable == 0) viewMenu->setItemChecked(ID_VIEW_STATUSBAR, false);
  }
  else
  {
    statusBar()->show();
    if(disable == 0) viewMenu->setItemChecked(ID_VIEW_STATUSBAR, true);
  }
}

void ProcessView::slotShowFullScreen()
{
  if(fullScreen == 0)
  {
    showFullScreen();
    fullScreen = 1;
  }
  else
  {
    showNormal();
    fullScreen = 0;
    setIcon(logo1);
  }
}


void ProcessView::slotHelpAbout()
{
  QMessageBox::about(this,"About...",
                     IDS_APP_ABOUT );
}

void ProcessView::slotHelpBooklet()
{
  mysystem(booklet);
}

void ProcessView::slotHelpManual()
{
  mysystem(help);
}

void ProcessView::slotStatusHelpMsg(const QString &text)
{
  ///////////////////////////////////////////////////////////////////
  // change status message of whole statusbar temporary (text, msec)
  statusBar()->unsetPalette();
  statusBar()->message(text, 2000);
}

void ProcessView::statusCallback(int id_)
{
  switch (id_)
  {
    case ID_FILE_NEW:
         slotStatusHelpMsg(l_status_new_processview);
         break;

    case ID_FILE_SAVE:
         slotStatusHelpMsg(l_status_save_as_bmp);
         break;

    case ID_FILE_SAVE_AS:
         slotStatusHelpMsg(l_status_save_as_bmp);
         break;

    case ID_FILE_PRINT:
         slotStatusHelpMsg(l_status_print);
         break;

    case ID_FILE_QUIT:
         slotStatusHelpMsg(l_status_exit);
         break;

    case ID_FILE_METAFILE_BMP:
         slotStatusHelpMsg(l_status_log_as_bmp);
         break;

    case ID_FILE_METAFILE_LOG:
         slotStatusHelpMsg(l_status_log_as_pvm);
         break;

    case ID_FILE_OPT:
         slotStatusHelpMsg(l_status_options);
         break;

    case ID_EDIT_COPY:
         slotStatusHelpMsg(l_status_copy);
         break;

    case ID_VIEW_TOOLBAR:
         slotStatusHelpMsg(l_status_toolbar);
         break;

    case ID_VIEW_STATUSBAR:
         slotStatusHelpMsg(l_status_statusbar);
         break;

    case ID_SHOW_FULL_SCREEN:
         slotStatusHelpMsg(l_status_toggle_full_screen);
         break;
                            
    case ID_HELP_BOOKLET:
         slotStatusHelpMsg(l_status_booklet);
         break;

    case ID_HELP_MANUAL:
         slotStatusHelpMsg(l_status_manual);
         break;

    case ID_HELP_ABOUT:
         slotStatusHelpMsg(l_status_about);
         break;
  }
}

void ProcessView::slotUrl()
{
char buf[MAX_PRINTF_LENGTH],host[MAX_PRINTF_LENGTH],sshstring[MAX_PRINTF_LENGTH],*cptr;
QString qbuf;
int  iport,i,ssh;

  ssh = 0;
  sshstring[0] = '\0';
  currenthost.truncate(sizeof(buf) - 80);
  strcpy(buf,currenthost);
  do // eliminate windows slosh'es
  {
    cptr = strchr(buf,'\\');
    if(cptr != NULL) *cptr = '/';
  }
  while(cptr != NULL);
  if(buf[strlen(buf)-1] == '/') buf[strlen(buf)-1] = '\0';
  
  if     (strncmp(buf,"ssh://",6) == 0 || strncmp(buf,"pvssh://",8) == 0)
  {
    char ssh_user_host[MAX_PRINTF_LENGTH];
    char ssh_host[MAX_PRINTF_LENGTH];
    int  ssh_port;
    ssh = 1;
    strcpy(sshstring,buf);
    sprintf(host,"localhost:%d",sshport); // we connect locally
    strcpy(ssh_host,"localhost");
    ssh_port = port;
    cptr = &buf[6]; 
    if(buf[0] == 'p') cptr = &buf[8];
    i = 0;
    while(*cptr != ':' && *cptr != '\0') ssh_user_host[i++] = *cptr++;
    ssh_user_host[i] = '\0';
    if(*cptr == ':')
    {
      cptr++;
      if(isalpha(*cptr) || strchr(cptr,'.') != NULL)
      {
        i = 0;
        while(*cptr != ':' && *cptr != '\0') ssh_host[i++] = *cptr++;
        ssh_host[i] = '\0';
  cptr++;
      }
      if(*cptr != '\0') sscanf(cptr,"%d",&ssh_port);  
    }
    if(isReconnect == 0)
    {
      QString qbuf;
#ifdef unix    
      qbuf.sprintf("xterm -e %s -L %d:%s:%d %s &",(const char *) ssh_command,sshport,ssh_host,ssh_port,ssh_user_host);
#endif
#ifdef _WIN32
      qbuf.sprintf("%s -ssh -L %d:%s:%d %s",(const char *) ssh_command,sshport,ssh_host,ssh_port,ssh_user_host);
#endif  
      mysystem(qbuf);
    }
  }
  else if(strncmp(buf,"pv://" ,5) == 0) strcpy(host,&buf[5]);
  else                                  strcpy(host,buf);

  if(host[0] == '\0') return;

  if(s != -1) tcp_close(&s);
  strcpy(buf,host);
  iport = port;
  cptr = strchr(buf,':'); // if special port is given
  if(cptr != NULL)
  {
    *cptr++ = '\0';
    sscanf(cptr,"%d",&iport);
  }
  if(s != -1) tcp_close(&s);
  cptr = strstr(buf,"/");
  if(cptr != NULL) *cptr = '\0';
#if QT_VERSION > 220
  QApplication::setOverrideCursor( Qt::WaitCursor );
  s = tcp_con(buf,iport);
  QApplication::restoreOverrideCursor();
#else
  s = tcp_con(buf,iport);
#endif

  cptr = strstr(host,"/"); // send initial mask
  if(cptr == NULL)
  {
    sprintf(buf,"initial(0,\"\") version=%s\n",VERSION);
    tcp_send(&s,buf,strlen(buf));
  }
  else
  {
    cptr++;
    sprintf(buf,"initial(0,\"%s\") version=%s\n",cptr,VERSION);
    tcp_send(&s,buf,strlen(buf));
  }

  if(s != -1)
  {
#ifdef USE_SOCKET_NOTIFIER
    if(sn != NULL)
    {
      delete sn;
      sn = NULL;
    }
    if(snerror != NULL)
    {
      delete snerror;
      snerror = NULL;
    }

    sn = new QSocketNotifier(s, QSocketNotifier::Read);
    QObject::connect(sn, SIGNAL(activated(int)), this, SLOT(dataReceived(int)));
    snerror = new QSocketNotifier(s, QSocketNotifier::Exception);
    QObject::connect(snerror, SIGNAL(activated(int)), this, SLOT(dataError(int)));
#else
    socketTimer = new QTimer(this);
    QObject::connect(socketTimer, SIGNAL(timeout()), this, SLOT(selectSocket()));
    socketTimer->start(0);
#endif
    zoom = zoom_original;
    
    if     (ssh == 0) qbuf = l_status_connected + " " + host;
    else if(ssh == 1) qbuf = l_status_connected + " " + sshstring;
    statusBar()->unsetPalette();
    statusBar()->message(qbuf);
    if     (ssh == 0) add_host(host);
    else if(ssh == 1) add_host(sshstring);
    setCaption(caption_processview);
  }
  else
  {
    if     (ssh == 0) qbuf = l_status_could_not_connect + " " + host;
    else if(ssh == 1) qbuf = l_status_could_not_connect + " " + sshstring;
    statusBar()->setPaletteBackgroundColor(QColor(255,0,0));
    statusBar()->message(qbuf);
    qApp->beep();
  }
}

void ProcessView::dataReceived()
{
int  ret;
char buf[MAX_PRINTF_LENGTH] = "";

  //printf("dataReceived:");
  ret = tcp_rec(&s, buf, sizeof(buf)-1);
  //printf("%s\n",buf);

  if(ret == -1)
  {
    tcp_close(&s);
    s = -1;
#ifdef USE_SOCKET_NOTIFIER
    if(sn != NULL)
    {
      delete sn;
      sn = NULL;
    }
    if(snerror != NULL)
    {
      delete snerror;
      snerror = NULL;
    }
#else
    socketTimer->stop();
    QObject::disconnect(socketTimer);
    delete socketTimer;
    socketTimer = NULL;
#endif
    statusBar()->setPaletteBackgroundColor(QColor(255,0,0));
    statusBar()->message(l_status_connection_lost);
    all[0]->w->setDisabled(1);
    qApp->beep();
  }
  else
  {
    //printf("%s",buf);
    interpret(buf);
  }
}

void ProcessView::dataError()
{
  if(s != -1)
  {
    tcp_close(&s);
    s = -1;
#ifdef USE_SOCKET_NOTIFIER
    if(sn != NULL)
    {
      delete sn;
      sn = NULL;
    }
    if(snerror != NULL)
    {
      delete snerror;
      snerror = NULL;
    }
#else
    socketTimer->stop();
    QObject::disconnect(socketTimer);
    delete socketTimer;
    socketTimer = NULL;
#endif
    statusBar()->setPaletteBackgroundColor(QColor(255,0,0));
    statusBar()->message(l_status_connection_lost);
    all[0]->w->setDisabled(1);
    qApp->beep();
  }
}

void ProcessView::slotRecentUrls(const QString &urltext)
{
  currenthost = urltext;
  isReconnect = 0;
  slotUrl();
}

void ProcessView::setPath(const char *p)
{
  char *cptr;

  strcpy(path,p);
#ifdef unix
  cptr = strrchr(path,'/');
#endif
#ifdef __VMS
  cptr = strrchr(path,']');
#endif
#ifdef _WIN32
  cptr = strrchr(path,'\\');
#endif
  if(cptr != NULL)
  {
    cptr++;
    while(*cptr != '\0') *cptr++ = '\0';
  }
  else
  {
    cptr = &path[0];
    while(*cptr != '\0') *cptr++ = '\0';
  }
}

void ProcessView::readCustomlogoFromIniFile()
{
FILE *fp;
char buf[MAX_PRINTF_LENGTH],buf2[MAX_PRINTF_LENGTH];

  fp = fopen(inifile,"r");
  if(fp != NULL)
  {
    while( fgets(buf,sizeof(buf)-1,fp) != NULL )
    {
      if(strncmp(buf,"customlogo=",11) == 0)
      {
        sscanf(buf,"customlogo=%s",buf2);
#ifdef _WIN32
        ExpandEnvironmentStrings(buf2,buf,sizeof(buf)-1);
        strcpy(buf2,buf);
#endif
        customlogo = buf2;
      }
      else if(strncmp(buf,"scrollbars=",11) == 0)
      {
        sscanf(buf,"scrollbars=%d",&scrollbars);
      }
      else if(strncmp(buf,"codec=",6) == 0)
      {
        char *cptr;
        cptr = strchr(buf,'#');
        if(cptr != NULL)
        {
          cptr--;
          *cptr = '\0';
        } 
        sscanf(buf,"codec=%s",buf);
        //if(codec != NULL) delete codec;
        codec = QTextCodec::codecForName(buf);
        QTextCodec::setCodecForTr( QTextCodec::codecForName(buf) ); //rl new
      }
    }
    fclose(fp);
  }
}

void ProcessView::readIniFile()
{
FILE *fp;
char buf[MAX_PRINTF_LENGTH],buf2[MAX_PRINTF_LENGTH];
int cnt,i;

  cnt = recent_urls->count();
  for(i=0; i<cnt; i++)
  {
    recent_urls->removeItem(0);
  }

  newwindow = "";
  itoolbar = istatusbar = 1;
  while(1)
  {
    fp = fopen(inifile,"r");
    if(fp != NULL)
    {
      while( fgets(buf,sizeof(buf)-1,fp) != NULL )
      {
        if(strncmp(buf,"port=",5) == 0)
        {
          sscanf(buf,"port=%d",&port);
        }
        else if(strncmp(buf,"sshport=",8) == 0)
        {
          sscanf(buf,"sshport=%d",&sshport);
        }
        else if(strncmp(buf,"zoom=",5) == 0)
        {
          sscanf(buf,"zoom=%d",&zoom);
          zoom_original = zoom;
        }
        else if(strncmp(buf,"autoreconnect=",14) == 0)
        {
          sscanf(buf,"autoreconnect=%d",&autoreconnect);
        }
        else if(strncmp(buf,"scrollbars=",11) == 0)
        {
          sscanf(buf,"scrollbars=%d",&scrollbars);
        }
        else if(strncmp(buf,"booklet=",8) == 0)
        {
          strcpy(buf2,&buf[8]);
          booklet = buf2;
        }
        else if(strncmp(buf,"help=",5) == 0)
        {
          strcpy(buf2,&buf[5]);
          help = buf2;
        }
        else if(strncmp(buf,"temp=",5) == 0)
        {
          int ret;
          sscanf(buf,"temp=%s",buf2);
#ifdef _WIN32
          ExpandEnvironmentStrings(buf2,buf,sizeof(buf)-1);
          strcpy(buf2,buf);
#endif
          ret = chdir(buf2);
          if(ret < 0) return;
#ifdef unix
          strcat(buf2,"/");
#endif
#ifdef _WIN32
          strcat(buf2,"\\");
#endif
          temp = buf2;
        }
        else if(strncmp(buf,"toolbar=",8) == 0)
        {
          sscanf(buf,"toolbar=%d",&itoolbar);
#ifdef IS_KPART
          itoolbar = 0;
#endif
          if(itoolbar == 0)
          {
            fileToolbar->hide();
            if(disable == 0) viewMenu->setItemChecked(ID_VIEW_TOOLBAR, false);
          }
          else
          {
            fileToolbar->show();
            if(disable == 0) viewMenu->setItemChecked(ID_VIEW_TOOLBAR, true);
          }
        }
        else if(strncmp(buf,"statusbar=",10) == 0)
        {
          sscanf(buf,"statusbar=%d",&istatusbar);
#ifdef IS_KPART
          istatusbar = 0;
#endif
          if(istatusbar == 0)
          {
            statusBar()->hide();
            if(disable == 0) viewMenu->setItemChecked(ID_VIEW_STATUSBAR, false);
          }
          else
          {
            statusBar()->show();
            if(disable == 0) viewMenu->setItemChecked(ID_VIEW_STATUSBAR, true);
          }
        }
        else if(strncmp(buf,"menubar=",8) == 0)
        {
          sscanf(buf,"menubar=%d",&menubar);
#ifdef IS_KPART
          menubar = 0;
#endif
          if(menubar == 0) menuBar()->hide();
          else             menuBar()->show();
        }
        else if(strncmp(buf,"initialhost=",12) == 0)
        {
          sscanf(buf,"initialhost=%s",buf2);
          inihost = buf2;
        }
        else if(strncmp(buf,"host=",5) == 0)
        {
          sscanf(buf,"host=%s",buf);
          recent_urls->insertItem(buf);
        }
        else if(strncmp(buf,"full_screen=",12) == 0)
        {
          int oldFullScreen = fullScreen;
          sscanf(buf,"full_screen=%d",&fullScreen);
          if(fullScreen == 1)
          {
            initFullScreen = 1;
            showFullScreen();
          }
          else if(oldFullScreen == 1)
          {
            showNormal();
          }
        }
        else if(strncmp(buf,"maximized=",10) == 0)
        {
          int val;
          sscanf(buf,"maximized=%d",&val);
          if(val == 1)
          {
            initShowMaximized = 1;
            showMaximized();
          }
        }
  else if(strncmp(buf,"exitpassword=",13) == 0)
  {
    sscanf(buf,"exitpassword=%d",&exitpassword);
  }
  else if(strncmp(buf,"newwindow=",10) == 0)
  {
    sscanf(buf,"newwindow=%s",buf);
    newwindow = buf;
  }
  else if(strncmp(buf,"ssh=",4) == 0)
  {
    sscanf(buf,"ssh=%s",buf);
    ssh_command = buf;
  }
      }
      fclose(fp);
      if(temp.isEmpty())
      {
        QMessageBox::information( this, "ProcessViewBrowser - new option",
                     "Please insert\ntemp=your_path\nin File->Options and restart the program" );
      }
      return;
    }
    else // write a default initialisation file
    {
      fp = fopen(inifile,"w");
      if(fp != NULL)
      {
        fprintf(fp,"###############################################\n");
        fprintf(fp,"# This is the default initialization file for\n");
        fprintf(fp,"# ProcessViewBrowser\n");
        fprintf(fp,"###############################################\n");
        fprintf(fp,"port=5050          # default port\n");
        fprintf(fp,"sshport=50500      # local port for ssh connections\n");
        fprintf(fp,"zoom=100           # zoom factor in percent\n");
        fprintf(fp,"autoreconnect=0    # 0|1\n");
  fprintf(fp,"exitpassword=0     # 0|1\n");
        fprintf(fp,"menubar=1          # 0|1\n");
        fprintf(fp,"toolbar=1          # 0|1\n");
        fprintf(fp,"statusbar=1        # 0|1\n");
        fprintf(fp,"scrollbars=1       # 0|1\n");
        fprintf(fp,"full_screen=0      # 0|1\n");
        fprintf(fp,"maximized=0        # 0|1\n");
  fprintf(fp,"# temporary directory\n");
#ifdef unix
        fprintf(fp,"temp=/tmp\n");
#endif
#ifdef _WIN32
        fprintf(fp,"temp=%%PVBDIR%%\\..\\temp\n");
#endif
#ifdef __VMS
        fprintf(fp,"temp=sys$login:\n");
#endif
  fprintf(fp,"# help functions\n");
#ifdef unix
        fprintf(fp,"booklet=konqueror /usr/share/doc/packages/ProcessView/booklet/index.html &\n");
#endif
#ifdef _WIN32
        if(get_iexplore(buf) == -1)
        {
          fprintf(fp,"booklet=\"c:\\programme\\internet explorer\\iexplore.exe\" %%PVBDIR%%\\..\\doc\\booklet\\index.html\n");
        }
        else
        {
          fprintf(fp,"booklet=%s %%PVBDIR%%\\..\\doc\\booklet\\index.html\n",buf);
        }
#endif
#ifdef __VMS
        fprintf(fp,"help=netscape [ProcessView.processview.processview.docs.booklet]index.html\n");
#endif
#ifdef unix
        fprintf(fp,"help=konqueror /usr/share/doc/packages/ProcessView/en/index.html &\n");
#endif
#ifdef _WIN32
        if(get_iexplore(buf) == -1)
        {
          fprintf(fp,"help=\"c:\\programme\\internet explorer\\iexplore.exe\" %%PVBDIR%%\\..\\doc\\index.html\n");
        }
        else
        {
          fprintf(fp,"help=%s %%PVBDIR%%\\..\\doc\\index.html\n",buf);
        }
#endif
#ifdef __VMS
        fprintf(fp,"help=netscape [ProcessView.processview.processview.docs.en]index.html\n");
#endif
  fprintf(fp,"# your custom logo\n");
#ifdef unix
        fprintf(fp,"customlogo=/usr/share/doc/packages/ProcessView/custom.bmp\n");
#endif
#ifdef _WIN32
        fprintf(fp,"customlogo=%%PVBDIR%%\\custom.bmp\n");
#endif
#ifdef __VMS
        fprintf(fp,"customlogo=[ProcessView.processview.processview]custom.bmp\n");
#endif
        fprintf(fp,"# howto start \"New Window\", can be commented out\n");
        fprintf(fp,"#newwindow=pvbrowser\n");
        fprintf(fp,"# windows users may put their putty.exe here\n");
        fprintf(fp,"ssh=ssh\n");
        fprintf(fp,"# we will automatically connect to this node\n");
        fprintf(fp,"initialhost=pv://localhost\n");

        fprintf(fp,"##################################################################\n");
        fprintf(fp,"#\n");
        fprintf(fp,"# Language settings for ProcessViewBrowser\n");
        fprintf(fp,"# you may input your own language (I only know german and english)\n");
        fprintf(fp,"# example: comment out: language = german\n");
        fprintf(fp,"#          comment in:  #language = default\n");
        fprintf(fp,"#          restart ProcessViewBrowser\n");
        fprintf(fp,"##################################################################\n");
        fprintf(fp,"language = default\n");
        fprintf(fp,"#language = german\n");
        fprintf(fp,"#language = french\n");
        fprintf(fp,"#language = spanish\n");
        fprintf(fp,"#language = italian\n");
        fprintf(fp,"#---------------------------------------\n");
        fprintf(fp,"german {\n");
        fprintf(fp,"-file               = &Datei\n");
        fprintf(fp,"-options            = &Optionen\n");
        fprintf(fp,"-new_window         = &Neues Fenster\n");
        fprintf(fp,"-reconnect          = &Reconnect\n");
        fprintf(fp,"-save_as_bmp        = &Speichere als BMP ...\n");
        fprintf(fp,"-log_as_bmp         = Logge Metafiles als &BMP ...\n");
        fprintf(fp,"-log_as_pvm         = Logge Metafiles als P&VM ...\n");
        fprintf(fp,"-print              = &Drucken\n");
        fprintf(fp,"-exit               = Schli&essen\n");
        fprintf(fp,"-edit               = &Bearbeiten\n");
        fprintf(fp,"-copy               = &Kopieren\n");
        fprintf(fp,"-view               = &Ansicht\n");
        fprintf(fp,"-toolbar            = &Werkzeugleiste\n");
        fprintf(fp,"-statusbar          = &Statuszeile\n");
        fprintf(fp,"-toggle_full_screen = Vollbildmodus (an/aus)\n");
        fprintf(fp,"-help               = &Hilfe\n");
        fprintf(fp,"-booklet            = &Kurzbeschreibung ...\n");
        fprintf(fp,"-manual             = &Dokumentation ...\n");
        fprintf(fp,"-about              = &About ...\n");
        fprintf(fp,"-recent_urls        = Letzte URLs\n");
        fprintf(fp,"-status_connection_lost   = Verbindung zu Server verloren, CTRL-R fuer erneute Verbindung\n");
        fprintf(fp,"-status_connected         = Verbunden mit Server\n");
        fprintf(fp,"-status_could_not_connect = Konnte nicht mit Server verbinden, CTRL-R fuer erneute Verbindung\n");
        fprintf(fp,"-status_options     = Ansehen/�dern der ProcessViewBrowser Optionen\n");
        fprintf(fp,"-status_new_window  = �fnet ein neues ProcessViewBrowser Fenster\n");
        fprintf(fp,"-status_save_as_bmp = Speichert den aktuellen Bildschirm als BMP Datei\n");
        fprintf(fp,"-status_log_as_bmp  = Logge QDrawWidgets als BMP Datei\n");
        fprintf(fp,"-status_log_as_pvm  = Logge QDrawWidgets als PVM Datei\n");
        fprintf(fp,"-status_print       = Druckt den aktuellen Bildschirm\n");
        fprintf(fp,"-status_exit        = Schliesst ProcessViewBrowser\n");
        fprintf(fp,"-status_copy        = Kopiere den aktuellen Bildschirm in die Zwischenablage\n");
        fprintf(fp,"-status_toolbar     = Werkzeugleiste (an/aus)\n");
        fprintf(fp,"-status_statusbar   = Statuszeile (an/aus)\n");
        fprintf(fp,"-status_toggle_full_screen = Vollbildmodus (an/aus)\n");
        fprintf(fp,"-status_booklet     = ProcessViewServer Kurzbeschreibung anzeigen\n");
        fprintf(fp,"-status_manual      = ProcessViewServer Dokumentation anzeigen\n");
        fprintf(fp,"-status_about       = Aboutbox anzeigen\n");
        fprintf(fp,"-print_header       = Gedruckt von ProcessViewBrowser am: \n");
        fprintf(fp,"}\n");
        fprintf(fp,"#---------------------------------------\n");
        fprintf(fp,"# Ne pas oublier de dï¿½ommanter ISO-8859-1\n");
        fprintf(fp,"french {\n");
        fprintf(fp,"-file               = Fichier\n");
        fprintf(fp,"-options            = Option\n");
        fprintf(fp,"-new_window         = Nouvelle Fenï¿½re\n");
        fprintf(fp,"-reconnect          = Reconnection\n");
        fprintf(fp,"-save_as_bmp        = Sauvegarder en BMP ...\n");
        fprintf(fp,"-log_as_bmp         = Enregistrer en BMP ...\n");
        fprintf(fp,"-log_as_pvm         = Enregistrer en PVM ...\n");
        fprintf(fp,"-print              = Imprimer\n");
        fprintf(fp,"-exit               = Sortir\n");
        fprintf(fp,"-edit               = ï¿½iter\n");
        fprintf(fp,"-copy               = Copier\n");
        fprintf(fp,"-view               = Voir\n");
        fprintf(fp,"-toolbar            = Bare d'outil\n");
        fprintf(fp,"-statusbar          = Bare d'ï¿½at\n");
        fprintf(fp,"-toggle_full_screen = Permuter la grandeur de fenï¿½re\n");
        fprintf(fp,"-help               = Aide\n");
        fprintf(fp,"-booklet            = Livret\n");
        fprintf(fp,"-manual             = Manuel\n");
        fprintf(fp,"-about              = ï¿½propos\n");
        fprintf(fp,"-recent_urls        = Dernier sites visitï¿½n");
        fprintf(fp,"-status_connection_lost   = ï¿½at: Connexion perdu, Faire CTRL-R pour reconnecter en local\n");
        fprintf(fp,"-status_connected         = ï¿½at: Connectï¿½n");
        fprintf(fp,"-status_could_not_connect = ï¿½at: Ne peut pas connecter, faire CTRL-R pour reconnecter local\n");
        fprintf(fp,"-status_options     = ï¿½at: Options\n");
        fprintf(fp,"-status_new_window  = ï¿½at: Nouvelle fenï¿½re\n");
        fprintf(fp,"-status_save_as_bmp = ï¿½at: Sauvegardï¿½en BMP\n");
        fprintf(fp,"-status_log_as_bmp  = ï¿½at: QDrawWidgets est enregistrï¿½en BMP\n");
        fprintf(fp,"-status_log_as_pvm  = ï¿½at: QDrawWidgets est enregsitrï¿½en PVM\n");
        fprintf(fp,"-status_print       = ï¿½at: Imprimï¿½n");
        fprintf(fp,"-status_exit        = ï¿½at: Sortie de ProcessViewBrowser\n");
        fprintf(fp,"-status_copy        = ï¿½at: Copiï¿½n");
        fprintf(fp,"-status_toolbar     = ï¿½at: Bare d'outil\n");
        fprintf(fp,"-status_statusbar   = ï¿½at: bare d'ï¿½at\n");
        fprintf(fp,"-status_toggle_full_screen = ï¿½at: Permutï¿½en mode pleinne ï¿½ran\n");
        fprintf(fp,"-status_booklet     = ï¿½at: Livret sur ProcessViewServer\n");
        fprintf(fp,"-status_manual      = ï¿½at: Documentation complï¿½e de ProcessViewServer\n");
        fprintf(fp,"-status_about       = ï¿½at: ï¿½propos\n");
        fprintf(fp,"-print_header       = Imprimer l'entï¿½e. \n");
        fprintf(fp,"}\n");
        fprintf(fp,"#---------------------------------------\n");
        fprintf(fp,"spanish {\n");
        fprintf(fp,"-file               = &Fichero\n");
        fprintf(fp,"-options            = &Opciones\n");
        fprintf(fp,"-new_window         = &Nueva Ventana\n");
        fprintf(fp,"-reconnect          = &Reconectar\n");
        fprintf(fp,"-save_as_bmp        = &Guardar como BMP...\n");
        fprintf(fp,"-log_as_bmp         = Log Metafiles como &BMP...\n");
        fprintf(fp,"-log_as_pvm         = Log Metafiles como P&VM...\n");
        fprintf(fp,"-print              = &Imprimir\n");
        fprintf(fp,"-exit               = &Salir\n");
        fprintf(fp,"-edit               = &Editar\n");
        fprintf(fp,"-copy               = &Copiar\n");
        fprintf(fp,"-view               = &Ver\n");
        fprintf(fp,"-toolbar            = &Barra Herramientas\n");
        fprintf(fp,"-statusbar          = &Barra Estado\n");
        fprintf(fp,"-toggle_full_screen = Pantalla Completa (On/Off)\n");
        fprintf(fp,"-help               = &Ayuda\n");
        fprintf(fp,"-booklet            = &Manuales\n");
        fprintf(fp,"-manual             = &Documentación...\n");
        fprintf(fp,"-about              = &Acerca de...\n");
        fprintf(fp,"-recent_urls        = URLs Recientes\n");
        fprintf(fp,"-status_connection_lost   = Conexión al Servidor perdida, CTRL-R para reconecta\n");
        fprintf(fp,"-status_connected         = Conectado al Servidor\n");
        fprintf(fp,"-status_reconnect   = Reconectar al Servidor\n");
        fprintf(fp,"-status_could_not_connect = No se pudo conectar al Servidor, CTRL-R para reconectar\n");
        fprintf(fp,"-status_options     = Ver/Cambiar las Opciones ProcessViewBrowser\n");
        fprintf(fp,"-status_new_window  = Abrir nueva ventana de ProcessViewBrowser\n");
        fprintf(fp,"-status_save_as_bmp = Guardar pantalla actual como fichero BMP\n");
        fprintf(fp,"-status_log_as_bmp  = Logge QDrawWidgets como fichero BMP\n");
        fprintf(fp,"-status_log_as_pvm  = Logge QDrawWidgets como fichero PVM\n");
        fprintf(fp,"-status_print       = Imprimir la pantalla actual\n");
        fprintf(fp,"-status_exit        = Salir de ProcessViewBrowser\n");
        fprintf(fp,"-status_copy        = Copiar la pantalla al Portapapeles\n");
        fprintf(fp,"-status_toolbar     = Barra de Herramientas (On/Off)\n");
        fprintf(fp,"-status_statusbar   = Barra de Estado (On/Off)\n");
        fprintf(fp,"-status_toggle_full_screen = Pantalla Completa (On/Off)\n");
        fprintf(fp,"-status_booklet     = Mostrar ProcessViewServer Manual\n");
        fprintf(fp,"-status_manual      = Mostrar ProcessViewServer Documentación\n");
        fprintf(fp,"-status_about       = Acerca de...\n");
        fprintf(fp,"-print_header       = Impreso desde ProcessViewBrowser\n");
        fprintf(fp,"}\n");
        fprintf(fp,"#---------------------------------------\n");
        fprintf(fp,"Italian {\n");
        fprintf(fp,"-file               = &Dati\n");
        fprintf(fp,"}\n");
        fprintf(fp,"# other languages\n");
        fprintf(fp,"# You may select a codec or none. Please comment out your codec.\n");
        fprintf(fp,"#codec=Latin1\n"); 
        fprintf(fp,"#codec=Big5 ## Chinese\n"); 
        fprintf(fp,"#codec=Big5-HKSCS ## Chinese\n"); 
        fprintf(fp,"#codec=eucJP ## Japanese\n"); 
        fprintf(fp,"#codec=eucKR ## Korean\n"); 
        fprintf(fp,"#codec=GB2312 ## Chinese\n"); 
        fprintf(fp,"#codec=GBK ## Chinese\n"); 
        fprintf(fp,"#codec=GB18030 ## Chinese\n"); 
        fprintf(fp,"#codec=JIS7 ## Japanese\n"); 
        fprintf(fp,"#codec=Shift-JIS ## Japanese\n"); 
        fprintf(fp,"#codec=TSCII ## Tamil\n"); 
        fprintf(fp,"codec=utf8 ## Unicode, 8-bit\n"); 
        fprintf(fp,"#codec=utf16 ## Unicode\n"); 
        fprintf(fp,"#codec=KOI8-R ## Russian\n"); 
        fprintf(fp,"#codec=KOI8-U ## Ukrainian\n"); 
        fprintf(fp,"#codec=ISO8859-1 ## Western\n"); 
        fprintf(fp,"#codec=ISO8859-2 ## Central European\n"); 
        fprintf(fp,"#codec=ISO8859-3 ## Central European\n"); 
        fprintf(fp,"#codec=ISO8859-4 ## Baltic\n"); 
        fprintf(fp,"#codec=ISO8859-5 ## Cyrillic\n"); 
        fprintf(fp,"#codec=ISO8859-6 ## Arabic\n"); 
        fprintf(fp,"#codec=ISO8859-7 ## Greek\n"); 
        fprintf(fp,"#codec=ISO8859-8 ## Hebrew, visually ordered\n"); 
        fprintf(fp,"#codec=ISO8859-8-i ## Hebrew, logically ordered\n"); 
        fprintf(fp,"#codec=ISO8859-9 ## Turkish\n"); 
        fprintf(fp,"#codec=ISO8859-10\n"); 
        fprintf(fp,"#codec=ISO8859-13\n"); 
        fprintf(fp,"#codec=ISO8859-14\n"); 
        fprintf(fp,"#codec=ISO8859-15 ## Western\n"); 
        fprintf(fp,"#codec=IBM 850\n"); 
        fprintf(fp,"#codec=IBM 866\n"); 
        fprintf(fp,"#codec=CP874\n"); 
        fprintf(fp,"#codec=CP1250 ## Central European\n"); 
        fprintf(fp,"#codec=CP1251 ## Cyrillic\n"); 
        fprintf(fp,"#codec=CP1252 ## Western\n"); 
        fprintf(fp,"#codec=CP1253 ## Greek\n"); 
        fprintf(fp,"#codec=CP1254 ## Turkish\n"); 
        fprintf(fp,"#codec=CP1255 ## Hebrew\n"); 
        fprintf(fp,"#codec=CP1256 ## Arabic\n"); 
        fprintf(fp,"#codec=CP1257 ## Baltic\n"); 
        fprintf(fp,"#codec=CP1258\n"); 
        fprintf(fp,"#codec=Apple Roman\n"); 
        fprintf(fp,"#codec=TIS-620 ## Thai\n");   
        fprintf(fp,"##################################################################\n");
        fprintf(fp,"#\n");
        fprintf(fp,"# End of Language settings for ProcessViewBrowser\n");
        fprintf(fp,"#\n");
        fprintf(fp,"##################################################################\n");

        fprintf(fp,"#\n");
        fprintf(fp,"# This is the list of recent nodes you have visited\n");
        fprintf(fp,"host=pv://localhost\n");
        fclose(fp);
      }
      else
      {
        QMessageBox::warning( this, "ProcessViewBrowser",
        "Could not write initialisation file", "Ok", 0, 0, 0, 1);
        return;
      }
    }
  }
}

void ProcessView::getLanguageParam(QString &line, QString &qphrase)
{
  QString phrase;
  int i;
  
  i = line.find("=");
  if(i < 0) return;
  i++;
  while(line[i] == ' ' || line[i] == '\t') i++;
  
  phrase = line.right(line.length()-i);
  if(codec == NULL) qphrase = phrase;
  else              qphrase = tr(phrase);
  //rl else              qphrase = codec->toUnicode(phrase);
}

int ProcessView::getLanguage()
{
  char line[4096],our_language[80],language_in_inifile[80],*cptr;
  QString qline;
  QFile qf(inifile);  
  int  i;
    
  our_language[0] = '\0';
  strcpy(language_in_inifile,"####");
  if(qf.open(IO_ReadOnly))
  {
    while(qf.readLine(qline,sizeof(line)-1) > 0)
    {
      strcpy(line,qline);
      if(strncmp(line,"language",8) == 0 && strstr(line,"=") != NULL)
      {
        cptr = strstr(line,"=");
        cptr++;
        while(*cptr == ' ' || *cptr == '\t')  cptr++;
        i = 0;
        while(*cptr != ' ' && *cptr != '\t' && *cptr != '\n' && *cptr != '\0')
        {
          our_language[i]   = *cptr;
          our_language[i+1] = '\0';
          cptr++;
          i++;
        }
      }
      if(strstr(line,"{") != NULL && strncmp(our_language,line,strlen(our_language)) == 0)
      {
        for(i=0; line[i] != ' ' && line[i] != '\t' && line[i] != '\0'; i++)
        {
          language_in_inifile[i] = line[i];
        }
        language_in_inifile[i] = '\0';
      }   
      if(strcmp(our_language,language_in_inifile) == 0)
      {
        if(strstr(line,"}") != NULL)
        {
          strcpy(language_in_inifile,"####");
          return 0;
        }
        if     (strncmp(line,"-print_header",13) == 0)       getLanguageParam(qline,l_print_header);

        else if(strncmp(line,"-file",5) == 0)                getLanguageParam(qline,l_file);
        else if(strncmp(line,"-options",8) == 0)             getLanguageParam(qline,l_options);
        else if(strncmp(line,"-new_window",11) == 0)         getLanguageParam(qline,l_new_processview);
        else if(strncmp(line,"-reconnect",10) == 0)          getLanguageParam(qline,l_reconnect);
        else if(strncmp(line,"-save_as_bmp",12) == 0)        getLanguageParam(qline,l_save_as_bmp);
        else if(strncmp(line,"-log_as_bmp",11) == 0)         getLanguageParam(qline,l_log_as_bmp);
        else if(strncmp(line,"-log_as_pvm",11) == 0)         getLanguageParam(qline,l_log_as_pvm);
        else if(strncmp(line,"-print",6) == 0)               getLanguageParam(qline,l_print);
        else if(strncmp(line,"-exit",5) == 0)                getLanguageParam(qline,l_exit);
        else if(strncmp(line,"-edit",5) == 0)                getLanguageParam(qline,l_edit);
        else if(strncmp(line,"-copy",5) == 0)                getLanguageParam(qline,l_copy);
        else if(strncmp(line,"-view",5) == 0)                getLanguageParam(qline,l_view);
        else if(strncmp(line,"-toolbar",8) == 0)             getLanguageParam(qline,l_toolbar);
        else if(strncmp(line,"-statusbar",10) == 0)          getLanguageParam(qline,l_statusbar);
        else if(strncmp(line,"-toggle_full_screen",19) == 0) getLanguageParam(qline,l_toggle_full_screen);
        else if(strncmp(line,"-help",5) == 0)                getLanguageParam(qline,l_help);
        else if(strncmp(line,"-booklet",8) == 0)             getLanguageParam(qline,l_booklet);
        else if(strncmp(line,"-manual",7) == 0)              getLanguageParam(qline,l_manual);
        else if(strncmp(line,"-about",6) == 0)               getLanguageParam(qline,l_about);
        else if(strncmp(line,"-recent_urls",12) == 0)        getLanguageParam(qline,l_recent_urls);

        else if(strncmp(line,"-status_connection_lost",23) == 0)    getLanguageParam(qline,l_status_connection_lost);
        else if(strncmp(line,"-status_connected",17) == 0)          getLanguageParam(qline,l_status_connected);
        else if(strncmp(line,"-status_could_not_connect",25) == 0)  getLanguageParam(qline,l_status_could_not_connect);

        else if(strncmp(line,"-status_options",15) == 0)     getLanguageParam(qline,l_status_options);
        else if(strncmp(line,"-status_new_window",18) == 0)  getLanguageParam(qline,l_status_new_processview);
        else if(strncmp(line,"-status_save_as",15) == 0)     getLanguageParam(qline,l_status_save_as_bmp);
        else if(strncmp(line,"-status_log_as_bmp",18) == 0)  getLanguageParam(qline,l_status_log_as_bmp);
        else if(strncmp(line,"-status_log_as_pvm",18) == 0)  getLanguageParam(qline,l_status_log_as_pvm);
        else if(strncmp(line,"-status_print",13) == 0)       getLanguageParam(qline,l_status_print);
        else if(strncmp(line,"-status_exit",12) == 0)        getLanguageParam(qline,l_status_exit);
        else if(strncmp(line,"-status_copy",12) == 0)        getLanguageParam(qline,l_status_copy);
        else if(strncmp(line,"-status_toolbar",15) == 0)     getLanguageParam(qline,l_status_toolbar);
        else if(strncmp(line,"-status_statusbar",17) == 0)   getLanguageParam(qline,l_status_statusbar);
        else if(strncmp(line,"-status_toggle_full_screen",26) == 0) getLanguageParam(qline,l_status_toggle_full_screen);
        else if(strncmp(line,"-status_booklet",15) == 0)     getLanguageParam(qline,l_status_booklet);
        else if(strncmp(line,"-status_manual",14) == 0)      getLanguageParam(qline,l_status_manual);
        else if(strncmp(line,"-status_about",13) == 0)       getLanguageParam(qline,l_status_about);
      }
    }
    qf.close();
  }
  return 0;
}

void ProcessView::add_host(const char *host)
{
  int cnt,i,found;
  char buf[MAX_PRINTF_LENGTH];

  buf[0] = '\0';
  //printf("host=%s\n",host);
  if     (strncmp(host,"pvssh://",8) == 0) ;
  else if(strncmp(host,"ssh://"  ,6) != 0) strcpy(buf,"pv://"); 
  strcat(buf,host);
  cnt = recent_urls->count();
  found = 0;

  for(i=0; i<cnt; i++)
  {
    if(strcmp(buf,recent_urls->text(i)) == 0)
    {
      recent_urls->setCurrentItem(i);
      found = 1;
      break;
    }
  }
  if(found == 0)
  {

    recent_urls->insertItem(buf);
    appendIniFile(buf);
  }
}

void ProcessView::appendIniFile(const char *host)
{
FILE *fp;

  fp = fopen(inifile,"a");
  if(fp != NULL)
  {
    fprintf(fp,"host=%s\n",host);
  }
  fclose(fp);
}

void ProcessView::downloadFile(const char *file)
{
  struct utimbuf utb;
  int   ret;
  short len;
  char  buf[4096];
  QString filename = temp + file;

  unlink(filename);
#ifdef unix
  int fhdl = ::open(filename, O_CREAT | O_WRONLY, S_IRUSR | S_IWUSR | S_IRGRP);
#endif
#ifdef _WIN32
  int fhdl = ::open(filename, _O_CREAT | _O_WRONLY | _O_BINARY, _S_IREAD | _S_IWRITE);
#endif
#ifdef __VMS
  int fhdl = ::open(filename, O_CREAT | O_WRONLY, 0);
#endif
  if(fhdl <= 0)
  {
    QMessageBox::warning(this, "ProcessViewBrowser",
                 "Could not open: " + filename);
    return;
  }

  QApplication::setOverrideCursor( Qt::WaitCursor );
  while(1)
  {
    ret = tcp_rec_binary(&s, (char *) &len, 2);
    if(ret == -1) break;
    len = ntohs(len);
    if(len <= 0)  break;
    if(len > (short) sizeof(buf))
    {
      QMessageBox::warning(this, "ProcessViewBrowser",
                 "buffer too small in downloadFile: " + filename);
      break;
    }
    ret = tcp_rec_binary(&s, buf, len);
    if(ret == -1) break;
    ret = ::write(fhdl,buf,ret);
    if(ret == -1) break;
  }
#ifndef _WIN32
  ::fsync(fhdl);
#endif
  ::close(fhdl);
  //time_t timet; // remote file time for caching
  utb.actime  = timet;
  utb.modtime = timet;
  utime(file,&utb); // set file modification time
  QApplication::restoreOverrideCursor();
}


int ProcessView::get_text(const char *c, QString &txt)
{
  char mytext[MAX_PRINTF_LENGTH+16],*t;
  int i;
  
  t = &mytext[0];
  *t = '\0';
  while(*c != '\0' && *c != '"') c++; // search for first "
  if(*c == '\0')
  {
    char *cptr;
    if(tcp_rec(&s,t,MAX_PRINTF_LENGTH-1) < 0) return -1;
    cptr = strchr(t,'\n');
    if(cptr != NULL) *cptr = '\0';
    if(codec != NULL)
    {
      txt = tr(mytext);
      //rl txt = codec->toUnicode(mytext,strlen(mytext));
      //txt = QString::fromUtf8(mytext); //rl new
    }
    else
    {
      txt = mytext;
    }
    return 0;
  }
  c++;
  i = 0;
  while(*c != '\0') // until terminating " is seen
  {
    if(i >= MAX_PRINTF_LENGTH)
    {
      *t = '\0';
      return 1;
    }
    i++;
    if(*c == '\\')
    {
      c++;
      if     (*c == '"')  *t++ = '"';
      else if(*c == '\n') *t++ = '\n';
      else if(*c == '\t') *t++ = '\t';
      else if(*c == '\\') *t++ = '\\';
      else if(*c == '\0') break;
      c++;
    }
    else if(*c == '"')
    {
      *t = '\0';
      break;
    }
    else
    {
      *t++ = *c++;
    }
  }
  *t = '\0';
    
  if(codec != NULL)
  {
    txt = tr(mytext);
    //rl txt = codec->toUnicode(mytext,strlen(mytext));
    //txt = QString::fromUtf8(mytext); //rl new
  }
  else
  {
    txt = mytext;
  }
  return 0;
}

void ProcessView::popupMenu(int id_return, const char *menu)
{
  char buf[800];
  int  i,ifirst,ret;
  QPopupMenu popupMenu;

  ifirst = 0;
  for(i=0;; i++)
  {
    if(menu[i] == ',' || menu[i] == '\0')
    {
      if(i == ifirst && i == 0)
      {
        popupMenu.insertSeparator();
      }
      else if(menu[i] != '\0' && menu[i+1] == ',')
      {
        if(i > 0 && menu[i-1] != ',')
        {
          strncpy(buf,&menu[ifirst],i-ifirst);
          buf[i-ifirst] = '\0';
          popupMenu.insertItem(buf);
        }
        popupMenu.insertSeparator();
      }
      else
      {
        if(i > 0 && menu[i-1] != ',')
        {
          strncpy(buf,&menu[ifirst],i-ifirst);
          buf[i-ifirst] = '\0';
          popupMenu.insertItem(buf);
        }  
      }
      ifirst = i+1;
    }
    if(menu[i] == '\0') break;
  }
  
  ret = popupMenu.exec(QCursor::pos());
  if(ret != -1)
  {
    //sprintf(buf,"text(%d,\"%s\")\n", id_return, (const char *) popupMenu.text(ret));
    if(codec == NULL) sprintf(buf,"text(%d,\"%s\")\n", id_return, (const char *) popupMenu.text(ret));
    else              sprintf(buf,"text(%d,\"%s\")\n", id_return, (const char *) codec->fromUnicode(popupMenu.text(ret)));
  }
  else
  {
    sprintf(buf,"text(%d,\"\")\n", id_return);
  }
  tcp_send(&s,buf,strlen(buf));
}

void ProcessView::keyPressEvent(QKeyEvent *e)
{
  int modifier,key;

  key = e->key();
  modifier = 0;
  if     (e->state() == Qt::ShiftButton)
  {
    modifier = 4;
  }
  else if(e->state() == Qt::ControlButton)
  {
    modifier = 3;
  }
  else if(e->state() == Qt::AltButton)
  {
    modifier = 2;
  }
  else if(key >= Qt::Key_Escape && key <= Qt::Key_Direction_R)
  {
    if(key != Qt::Key_Left && key != Qt::Key_Up && key != Qt::Key_Right && key != Qt::Key_Down)
    {
      modifier = 1;
    }
  }
  if(modifier != 0)
  {
    char buf[80];
    //printf("key modifier=%d key=%d ascii=%s\n",modifier,e->key(),(const char *) e->text());
    sprintf(buf,"key(%d,%d,\"%s\")\n",modifier,key,(const char *) e->text());
    tcp_send(&s,buf,strlen(buf));
  }
  QMainWindow::keyPressEvent(e);
}

void ProcessView::interpret(const char *command)
{
  switch(command[0])
  {
    case 'a':
      interpreta(command);
      break;
    case 'b':
      interpretb(command);
      break;
    case 'c':
      interpretc(command);
      break;
    case 'd':
      interpretd(command);
      break;
    case 'e':
      interprete(command);
      break;
    case 'f':
      interpretf(command);
      break;
    case 'g':
      interpretg(command);
      break;
    case 'h':
      interpreth(command);
      break;
    case 'i':
      interpreti(command);
      break;
    case 'm':
      interpretm(command);
      break;
    case 'p':
      interpretp(command);
      break;
    case 'r':
      interpretr(command);
      break;
    case 's':
      interprets(command);
      break;
    case 't':
      interprett(command);
      break;
    case 'v':
      interpretv(command);
      break;
    case 'q':
      interpretq(command);
      break;
    case 'Q':
      interpretQ(command);
      break;
    default:
      break;
  }
}

void ProcessView::interpreta(const char *command)
{
  if(strncmp(command,"addTab(",7) == 0)
  {
    int child;
    sscanf(command,"addTab(%d,%d,",&i,&child);
    get_text(command,text);
    if(all[i]->type == TQTabWidget)
    {
      MyQTabWidget *ptr = (MyQTabWidget *) all[i]->w;
      ptr->addTab(all[child]->w, text);
    }
#if QT_VERSION >=0x030201
    else if(all[i]->type == TQToolBox)
    {
      MyQToolBox *ptr = (MyQToolBox *) all[i]->w;
      ptr->addItem(all[child]->w, text);
    }
#endif
  }
  else if(strncmp(command,"addColumn(",10) == 0)
  {
    int size;
    sscanf(command,"addColumn(%d,%d,",&i,&size);
    get_text(command,text);
    if(all[i]->type == TQListView)
    {
      MyListView *ptr = (MyListView *) all[i]->w;
      ptr->addColumn(text, size);
    }
  }
  else if(strncmp(command,"addStretch(",11) == 0)
  {
    int param;
    sscanf(command,"addStretch(%d,%d,",&i,&param);
    if(i == 0)
    {
      if(mainLayoutType == TQVbox) ((QVBoxLayout *) mainLayout)->addStretch(param);
      if(mainLayoutType == TQHbox) ((QHBoxLayout *) mainLayout)->addStretch(param);
      //if(mainLayoutType == TQGrid) ((QGridLayout *) mainLayout)->addStretch(param);
    }
    else
    {
      if(all[i]->type == TQVbox) ((QVBoxLayout *) all[i]->w)->addStretch(param);
      if(all[i]->type == TQHbox) ((QHBoxLayout *) all[i]->w)->addStretch(param);
      //if(all[i]->type == TQGrid) ((QGridLayout *) all[i]->w)->addStretch(param);
    }
  }
  else if(strncmp(command,"addWidgetOrLayout(",18) == 0)
  {
    int item,type,row,col;
    QWidget *w;
    sscanf(command,"addWidgetOrLayout(%d,%d,%d,%d",&i,&item,&row,&col);
    if(i == 0) w = mainLayout;
    else       w = all[i]->w;
    if(i == 0) type = mainLayoutType;
    else       type = all[i]->type;
    if(type == TQVbox)
    {
      QVBoxLayout *ptr = (QVBoxLayout *) w;
      if     (all[item]->type == TQVbox) ptr->addLayout((QVBoxLayout *) all[item]->w);
      else if(all[item]->type == TQHbox) ptr->addLayout((QHBoxLayout *) all[item]->w);
      else if(all[item]->type == TQGrid) ptr->addLayout((QGridLayout *) all[item]->w);
      else                               ptr->addWidget(all[item]->w);
    }
    if(type == TQHbox)
    {
      QHBoxLayout *ptr = (QHBoxLayout *) w;
      if     (all[item]->type == TQVbox) ptr->addLayout((QVBoxLayout *) all[item]->w);
      else if(all[item]->type == TQHbox) ptr->addLayout((QHBoxLayout *) all[item]->w);
      else if(all[item]->type == TQGrid) ptr->addLayout((QGridLayout *) all[item]->w);
      else                               ptr->addWidget(all[item]->w);
    }
    if(type == TQGrid)
    {
      QGridLayout *ptr = (QGridLayout *) w;
      if     (all[item]->type == TQVbox) ptr->addLayout((QVBoxLayout *) all[item]->w,row,col);
      else if(all[item]->type == TQHbox) ptr->addLayout((QHBoxLayout *) all[item]->w,row,col);
      else if(all[item]->type == TQGrid) ptr->addLayout((QGridLayout *) all[item]->w,row,col);
      else                               ptr->addWidget(all[item]->w,row,col);
    }
  }
}

void ProcessView::interpretb(const char *command)
{
  if(strncmp(command,"beep(",5) == 0)
  {
    qApp->beep();
  }
}

void ProcessView::interpretc(const char *command)
{
  if(strncmp(command,"clear(",6) == 0)
  {
    sscanf(command,"clear(%d",&i);
    if(all[i]->type == TQListBox)
    {
      MyListBox *ptr = (MyListBox *) all[i]->w;
      ptr->clear();
    }
    else if(all[i]->type == TQMultiLineEdit)
    {
      MyMultiLineEdit *ptr = (MyMultiLineEdit *) all[i]->w;
      ptr->clear();
    }
    else if(all[i]->type == TQListView)
    {
      MyListView *ptr = (MyListView *) all[i]->w;
      ptr->clear();
    }
    else if(all[i]->type == TQIconView)
    {
      MyIconView *ptr = (MyIconView *) all[i]->w;
      ptr->clear();
    }
    else if(all[i]->type == TQComboBox)
    {
      MyComboBox *ptr = (MyComboBox *) all[i]->w;
      ptr->clear();
    }
  }
  else if(strncmp(command,"changeItem(",11) == 0)
  {
    int index,pixmap;
    char *data,text2[80];
    sscanf(command,"changeItem(%d,%d,%d,",&i,&index,&pixmap);
    get_text(command,text);
    if(all[i]->type == TQListBox)
    {
      MyListBox *ptr = (MyListBox *) all[i]->w;
      QPixmap pm;
      if(pixmap==0) ptr->changeItem(pm,text,index);
      else
      {
        tcp_rec(&s,text2,sizeof(text2));
        sscanf(text2,"(%d,%d)",&w,&h);
        QImage *temp = readBmpFromSocket(w,h,&data);
        if(temp != NULL)
        {
          pm = *temp;
          pm.setMask(pm.createHeuristicMask());
          ptr->changeItem(pm,text,index);
          if(data != NULL) delete data;
          if(temp != NULL) delete temp;
        }
      }
    }
    else
    {
      if(pixmap==0) ;
      else
      {
        tcp_rec(&s,text2,sizeof(text2));
        sscanf(text2,"(%d,%d)",&w,&h);
        QImage *temp = readBmpFromSocket(w,h,&data);
        if(temp != NULL) delete temp;
      }
    }
  }
}

void ProcessView::interpretd(const char *command)
{
  if(strncmp(command,"displayNum(",11) == 0)
  {
    sscanf(command,"displayNum(%d,%d)",&i,&n);
    if(all[i]->type == TQLCDNumber)
    {
      QLCDNumber *ptr = (QLCDNumber *) all[i]->w;
      ptr->display(n);
    }
  }
  else if(strncmp(command,"displayFloat(",13) == 0)
  {
    float val;
    sscanf(command,"displayFloat(%d,%f)",&i,&val);

    if(all[i]->type == TQLCDNumber)
    {
      QLCDNumber *ptr = (QLCDNumber *) all[i]->w;
      ptr->display((double) val);
    }
  }
  else if(strncmp(command,"displayStr(",11) == 0)
  {
    sscanf(command,"displayStr(%d,",&i);
    get_text(command,text);

    if(all[i]->type == TQLCDNumber)
    {
      QLCDNumber *ptr = (QLCDNumber *) all[i]->w;
      ptr->display(text);
    }
  }
  else if(strncmp(command,"downloadFile(",13) == 0)
  {
    get_text(command,text);
    downloadFile(text);
  }
}

void ProcessView::interprete(const char *command)
{
  if(strncmp(command,"endDefinition",13) == 0) // endDefinition of new MainWidget
  {
    if(allBase == NULL)
    {
      w = view->width();
      h = view->height();
      if(scroll != NULL)
      {
        scroll->hide();
        delete scroll;
      }
      view = v;
      if(hasLayout == 0)
      {
        scroll = new QScrollView(this);
        scroll->addChild(view);
        if(scrollbars == 0) 
        {
          scroll->setResizePolicy(QScrollView::AutoOneFit);
          scroll->setVScrollBarMode(QScrollView::AlwaysOff);
          scroll->setHScrollBarMode(QScrollView::AlwaysOff);
        }
        setCentralWidget(scroll);
        view->resize(w,h);
        scroll->resizeContents(w,h);
#ifdef _WIN32
        scroll->resize(w,h);
#endif
        scroll->show();
      }
      else
      {
        scroll = NULL;
        view->resize(w,h);
        setCentralWidget(view);
        view->show();
      }
    }
    else
    {
      modalDialog->setCaption(caption());
      modalDialog->show();
      modalDialog->exec();
      if(modalDialog != NULL)
      {
        char buf[80];
        delete modalDialog;
        if(all != NULL) free(all);
        modalDialog = NULL;
        if(allBase != NULL) all = allBase;
        allBase = allModal = NULL;
        nmax = nmaxBase;
        sprintf(buf,"QPushButton(0)\n");
        tcp_send(&s,buf,strlen(buf));
      }
    }
  }
#if QT_VERSION > 220
  else if(strncmp(command,"ensureCellVisible(",18) == 0)
  {
    int row,col;
    sscanf(command,"ensureCellVisible(%d,%d,%d)",&i,&row,&col);
    if(i < 0) return;
    if(i >= nmax) return;
    if(all[i]->type == TQTable)
    {
      MyTable *p = (MyTable *) all[i]->w;
      p->ensureCellVisible(row,col);
    }
  }
#endif
  else if(strncmp(command,"ensureListVisible(",18) == 0)
  {
    sscanf(command,"ensureListVisible(%d",&i);
    if(i < 0) return;
    if(i >= nmax) return;
    if(all[i]->type == TQListView)
    {
      get_text(command,text);
      MyListView *l = (MyListView *) all[i]->w;
      l->ensureVisible(text, (MyListViewItem *) l->firstChild());
    }
  }
}

void ProcessView::interpretf(const char *command)
{
  if(strncmp(command,"fileCache(",10) == 0) // cache downloaded files
  {
    struct stat statbuf;
    struct tm remote;
    int ret;
    char buf[80];

    memset(&remote,sizeof(remote),0);
    sscanf(command,"fileCache(%d,%d,%d,%d,%d,%d,%d,%d,%d"
      ,&remote.tm_sec
      ,&remote.tm_min
      ,&remote.tm_hour
      ,&remote.tm_mon
      ,&remote.tm_year
      ,&remote.tm_mday
      ,&remote.tm_wday
      ,&remote.tm_yday
      ,&remote.tm_isdst);
    get_text(command,text);
    timet = mktime(&remote);
    ret = stat(text,&statbuf);
    if(ret < 0) // file does not exist
    {
      strcpy(buf,"cache(0)\n");   // file was not cached
      tcp_send(&s,buf,strlen(buf));
    }
    else if(memcmp(&statbuf.st_mtime, &timet,sizeof(time_t)) == 0)
    {
      strcpy(buf,"cache(1)\n"); // file was cached
      tcp_send(&s,buf,strlen(buf));
    }
    else
    {
      strcpy(buf,"cache(0)\n"); // file time is different (not cached)
      tcp_send(&s,buf,strlen(buf));
    }
  }
  else if(strncmp(command,"fileDialog(",11) == 0) // Open, Save, FindDirectory
  {
    QString result;
    int id_return,type;
    sscanf(command,"fileDialog(%d,%d",&id_return,&type);
    if     (type==0) result = QFileDialog::getOpenFileName();
    else if(type==1) result = QFileDialog::getSaveFileName();
    else if(type==2) result = QFileDialog::getExistingDirectory();
    text.sprintf("text(%d,\"%s\")\n", id_return, (const char *) result);
    tcp_send(&s,text,strlen(text));
  }
}

void ProcessView::interpretg(const char *command)
{
  if(strncmp(command,"gbeginDraw(",11) == 0) // start drawing
  {
    sscanf(command,"gbeginDraw(%d)",&i);
    if(all[i]->type == TQDraw)
    {
      QDrawWidget *p = (QDrawWidget *) all[i]->w;
      p->showFromSocket(&s);
    }
  }
  else if(strncmp(command,"gCopyToClipboard(",17) == 0)
  {
    sscanf(command,"gCopyToClipboard(%d)",&i);
    if(i < 0) return;
    if(i >= nmax) return;
    qApp->processEvents(1000);  // let the menu bar hide itself
    if(all[i]->type == TQDraw)
    {
      QDrawWidget *p = (QDrawWidget *) all[i]->w;
      p->copyToClipboard();
    }
    else
    {
      QWidget *w = all[i]->w;
      QPixmap pm(QPixmap::grabWindow(w->winId(),0,0,w->width(),w->height()));
      QApplication::clipboard()->setPixmap(pm);
    }
  }
  else if(strncmp(command,"gSetZoomX(",10) == 0)
  {
    float zx;
    sscanf(command,"gSetZoomX(%d,%f)",&i,&zx);
    if(all[i]->type == TQDraw)
    {
      QDrawWidget *p = (QDrawWidget *) all[i]->w;
      p->setZoomX(zx);
    }
  }
  else if(strncmp(command,"gSetZoomY(",10) == 0)
  {
    float zy;
    sscanf(command,"gSetZoomY(%d,%f)",&i,&zy);
    if(all[i]->type == TQDraw)
    {
      QDrawWidget *p = (QDrawWidget *) all[i]->w;
      p->setZoomY(zy);
    }
  }
  else if(strncmp(command,"gSave(",6) == 0)
  {
    sscanf(command,"gSave(%d,",&i);
    get_text(command,text);
    if(all[i]->type == TQDraw)
    {
      QDrawWidget *p = (QDrawWidget *) all[i]->w;
      p->logToFile(text);
    }
  }
  else if(strncmp(command,"gSaveAsBmp(",11) == 0)
  {
    sscanf(command,"gSaveAsBmp(%d,",&i);
    get_text(command,text);
    if(i < 0) return;
    if(i >= nmax) return;
    qApp->processEvents(1000);  // let the menu bar hide itself
    if(all[i]->type == TQDraw)
    {
      QDrawWidget *p = (QDrawWidget *) all[i]->w;
      p->logBmpToFile(text);
    }
    else
    {
      QWidget *w = (QDrawWidget *) all[i]->w;
      QPixmap pm(QPixmap::grabWindow(w->winId(),0,0,w->width(),w->height()));
      pm.save(text,"BMP");
    }
  }
}

void ProcessView::interpreth(const char *command)
{
  if(strncmp(command,"hide(",5) == 0) // hide the widget
  {
    sscanf(command,"hide(%d)",&i);
    if(i < 0) return;
    if(i >= nmax) return;
    all[i]->w->hide();
  }
  else if(strncmp(command,"hyperlink(",10) == 0) // follow a hyperlink to a different computer
  {
    get_text(command,text);
    slotRecentUrls(text);
  }
}

void ProcessView::interpreti(const char *command)
{
  if(strncmp(command,"insertCols(",11) == 0)
  {
    int col = 0;
    int count = 0;
    sscanf(command,"insertCols(%d,%d,%d",&i,&col,&count);
    if(all[i]->type == TQTable)
    {
      MyTable *ptr = (MyTable *) all[i]->w;
      ptr->insertColumns(col,count);
    }
  }
  else if(strncmp(command,"insertItem(",11) == 0)
  {
    int index,pixmap;
    char *data,text2[80];
    sscanf(command,"insertItem(%d,%d,%d,",&i,&index,&pixmap);
    get_text(command,text);
    if(all[i]->type == TQListBox)
    {
      MyListBox *ptr = (MyListBox *) all[i]->w;
      QPixmap pm;
      if(pixmap==0) ptr->insertItem(pm,text,index);
      else
      {
        tcp_rec(&s,text2,sizeof(text2));
        sscanf(text2,"(%d,%d)",&w,&h);
        QImage *temp = readBmpFromSocket(w,h,&data);
        if(temp != NULL)
        {
          pm = *temp;
          pm.setMask(pm.createHeuristicMask());
          ptr->insertItem(pm,text,index);
          if(data != NULL) delete data;
          if(temp != NULL) delete temp;
        }
      }
    }
    else if(all[i]->type == TQComboBox)
    {
      MyComboBox *ptr = (MyComboBox *) all[i]->w;
      QPixmap pm;
      if(pixmap==0) ptr->insertItem(text,index);
      else
      {
        tcp_rec(&s,text2,sizeof(text2));
        sscanf(text2,"(%d,%d)",&w,&h);
        QImage *temp = readBmpFromSocket(w,h,&data);
        if(temp != NULL)
        {
          pm = *temp;
          pm.setMask(pm.createHeuristicMask());
          ptr->insertItem(pm,text,index);
          if(data != NULL) delete data;
          if(temp != NULL) delete temp;
        }
      }
    }
    else
    {
      if(pixmap==0) ;
      else
      {
        tcp_rec(&s,text2,sizeof(text2));
        sscanf(text2,"(%d,%d)",&w,&h);
        QImage *temp = readBmpFromSocket(w,h,&data);
        if(temp != NULL) delete temp;
      }
    }
  }
  else if(strncmp(command,"insertRows(",11) == 0)
  {
    int row = 0;
    int count = 0;
    sscanf(command,"insertRows(%d,%d,%d",&i,&row,&count);
    if(all[i]->type == TQTable)
    {
      MyTable *ptr = (MyTable *) all[i]->w;
      ptr->insertRows(row,count);
    }
  }
  else if(strncmp(command,"inputDialog(",12) == 0)
  {
    char *cptr;
    char default_text[MAX_PRINTF_LENGTH] = "";
    bool ok;
    int  id_return;
    sscanf(command,"inputDialog(%d,",&id_return);
    get_text(command,text);
    while(1)
    {
      cptr = strchr(text,12); // search for FF
      if(cptr != NULL) *cptr = '\n';
      else             break;
    }
    tcp_rec(&s,default_text,sizeof(default_text));
    cptr = strchr(default_text,'\n');
    if(cptr != NULL) *cptr = '\0';
#if QT_VERSION >= 300
    QString result = QInputDialog::getText("ProcessViewBrowser",text,QLineEdit::Normal,default_text,&ok,this);
#else
    QString result = QInputDialog::getText("ProcessViewBrowser",text,default_text,&ok,this);
#endif
    if(ok && result.length() > 0)
    {
      result.truncate(MAX_PRINTF_LENGTH-80);
      text.sprintf("text(%d,\"%s\")\n", id_return, (const char *) result);
      tcp_send(&s,text,strlen(text));
    }
    else
    {
      text.sprintf("text(%d,\"\")\n", id_return);
      tcp_send(&s,text,strlen(text));
    }
  }
}

void ProcessView::interpretm(const char *command)
{
  if(strncmp(command,"move(",5) == 0) // move the widget
  {
    sscanf(command,"move(%d,%d,%d)",&i,&x,&y);
    if(zoom != 100)
    {
      x = (x*zoom)/100;
      y = (y*zoom)/100;
    }
    if(i < 0) return;
    if(i >= nmax) return;
    all[i]->w->move(x,y);
  }
  else if(strncmp(command,"messageBox(",11) == 0) // open a messageBox()
  {
    char buf[80],*cptr;
    int ret,type,b0,b1,b2,id_return;
    sscanf(command,"messageBox(%d,%d,%d,%d,%d,",&id_return,&type,&b0,&b1,&b2);
    get_text(command,text);
    while(1)
    {
      cptr = strchr(text,12); // search for FF
      if(cptr != NULL) *cptr = '\n';
      else             break;
    }
    ret = -1;
    if(type==0) ret = QMessageBox::information(this,"ProcessViewBrowser",text,b0,b1,b2);
    if(type==1) ret = QMessageBox::warning    (this,"ProcessViewBrowser",text,b0,b1,b2);
    if(type==2) ret = QMessageBox::critical   (this,"ProcessViewBrowser",text,b0,b1,b2);
    sprintf(buf,"slider(%d,%d)\n",id_return,ret);
    tcp_send(&s,buf,strlen(buf));
  }
  else if(strncmp(command,"moveContent(",12) == 0) // move in QTextBrowser
  {
    int pos;
    sscanf(command,"moveContent(%d,%d",&i,&pos);
    if(i < 0) return;
    if(i >= nmax) return;
    if(all[i]->type == TQTextBrowser)
    {
      MyTextBrowser *ptr = (MyTextBrowser *) all[i]->w;
      ptr->moveContent(pos);
    }
  }
  else if(strncmp(command,"modalInit(",10) == 0) // init modalDialog
  {
    int width, height;
    sscanf(command,"modalInit(%d,%d",&width,&height);
    allBase = all;
    nmaxBase = nmax;
    modalDialog = new MyDialog(&s,0,this);
    modalDialog->resize((width*zoom)/100,(height*zoom)/100);
    modalDialog->setFixedSize((width*zoom)/100,(height*zoom)/100);
  }
  else if(strncmp(command,"modalTerminate(",15) == 0) // termnate modalDialog
  {
    if(modalDialog != NULL)
    {
      modalDialog->terminate();
    }
  }
  else if(strncmp(command,"modalBase(",10) == 0) // switch all to baseDialog
  {
    if(allBase != NULL)
    {
      all = allBase;
      nmax = nmaxBase;
    }  
  }
  else if(strncmp(command,"modalModal(",11) == 0) // switch all to modalDialog
  {
    if(allModal != NULL)
    {
      all = allModal;
      nmax = nmaxModal;
    }  
  }
  else if(strncmp(command,"movie(",6) == 0) // control movie within QLabel
  {
    int func,param;
    sscanf(command,"movie(%d,%d,%d",&i,&func,&param);
    if(i < 0) return;
    if(i >= nmax) return;
    if(all[i]->type == TQLabel)
    {
      QLabel *ptr = (QLabel *) all[i]->w;
      switch(func)
      {
        case 0: // pvSetMovie
          get_text(command,text);
          if(param == 0) ptr->setBackgroundMode(Qt::NoBackground);
    if(param == 1) ptr->setBackgroundMode(Qt::PaletteBackground);
          ptr->setAutoResize(true);
          {
            QMovie movie(text); 
            ptr->setMovie(movie);
          }  
          break;
        case 1: // pvMovieControl
          if(param == -2) ptr->movie()->restart();
          if(param == -1) ptr->movie()->unpause();
          if(param ==  0) ptr->movie()->pause();
          if(param >   0) ptr->movie()->step(param);          
          break;
        case 2: // pvMovieSpeed
          ptr->movie()->setSpeed(param);
          break;
        default:
          break;  
      }
    }
  }
}

void ProcessView::interpretp(const char *command)
{
  if(strncmp(command,"print(",6) == 0) // print the widget
  {
    sscanf(command,"print(%d)",&i);
    if(i < 0) return;
    if(i >= nmax) return;
    qApp->processEvents(1000);  // let the menu bar hide itself
    if(all[i]->type == TQDraw)
    {
      QDrawWidget *ptr = (QDrawWidget *) all[i]->w;
      ptr->print();
    }
    else
    {
      QPrinter printer;
      printer.setOrientation(QPrinter::Landscape);
      printer.setColorMode(QPrinter::Color);
      QWidget *w = all[i]->w;
      QPixmap pm(QPixmap::grabWindow(w->winId(),0,0,w->width(),w->height()));
      if(printer.setup(this))
      {
        QPainter painter;
        painter.begin(&printer);
#ifndef _WIN32
        if(printer.orientation() == QPrinter::Landscape)
        {
          painter.rotate(-90.0f);
          painter.translate(-painter.viewport().width(),0.0f);
        }
#endif
        if(strlen(l_print_header) > 0)
        {
          QString date_time;
          date_time  = l_print_header;
#if QT_VERSION > 220
          date_time += QDateTime::currentDateTime().toString(Qt::TextDate);
#else
          date_time += QDateTime::currentDateTime().toString();
#endif
          painter.drawText(LEFT_PRINT_MARGIN,UPPER_PRINT_MARGIN - 30,1280,100,ExpandTabs | DontClip, date_time);
        }
        painter.drawPixmap(LEFT_PRINT_MARGIN,UPPER_PRINT_MARGIN,pm);
        painter.end();
      }
    }
  }
#ifdef USE_OPEN_GL
  else if(strncmp(command,"pvGlUpdate(",11) == 0) // update OpenGL widget
  {
    PvGLWidget *ptr;
    sscanf(command,"pvGlUpdate(%d)",&i);

    if(all[i]->type == TQGl)
    {
      ptr = (PvGLWidget *) all[i]->w;
      ptr->updateGL();
    }
  }
  else if(strncmp(command,"pvGlBegin(",10) == 0) // begin OpenGL commands
  {
    GLenum mode;
    PvGLWidget *ptr;

    sscanf(command,"pvGlBegin(%d,%d)",&i,(int *) &mode);
    if(all[i]->type == TQGl)
    {
      ptr = (PvGLWidget *) all[i]->w;
      ptr->makeCurrent();
      ptr->gl_interpret();
    }
  }
#endif
  else if(strncmp(command,"playSound(",10) == 0) // play a (WAV) sound
  {
    get_text(command,text);
    printf("playSound(\"%s\")\n",(const char *) text);
    if(QSound::isAvailable())
    {
      QSound::play(text);
    }
    else
    {
      printf("sound not available on this platform\n");
      printf("On Microsoft Windows the underlying multimedia system is used; only WAVE format sound files are supported.\n");
      printf("On X11 the Network Audio System is used if available, otherwise all operations work silently. NAS supports WAVE and AU files.\n");
      printf("On Macintosh, ironically, we use QT (QuickTime) for sound, this means all QuickTime formats are supported by Qt/Mac.\n");
      printf("On Qt/Embedded, a built-in mixing sound server is used, which accesses /dev/dsp directly. Only the WAVE format is supported.\n");
      qApp->beep();
    }
  }
  else if(strncmp(command,"popupMenu(",10) == 0) // open a popupMenu()
  {
    int id_return;
    sscanf(command,"popupMenu(%d",&id_return);
    get_text(command,text);
    popupMenu(id_return,text);
  }
}

void ProcessView::interpretr(const char *command)
{
  if(strncmp(command,"removeCol(",10) == 0)
  {
    int col = 0;
    sscanf(command,"removeCol(%d,%d",&i,&col);
    if(all[i]->type == TQTable)
    {
      MyTable *ptr = (MyTable *) all[i]->w;
      ptr->removeColumn(col);
    }
  }
  else if(strncmp(command,"removeRow(",10) == 0)
  {
    int row = 0;
    sscanf(command,"removeRow(%d,%d",&i,&row);
    if(all[i]->type == TQTable)
    {
      MyTable *ptr = (MyTable *) all[i]->w;
      ptr->removeRow(row);
    }
  }
  else if(strncmp(command,"resize(",7) == 0) // resize the widget
  {
    sscanf(command,"resize(%d,%d,%d)",&i,&w,&h);
    if(zoom != 100)
    {
      w = (w*zoom)/100;
      h = (h*zoom)/100;
      if(w < 1) w = 1;
      if(h < 1) h = 1;
    }
    if(i == 0)
    {
      view->resize(w,h);
      if(scroll != NULL)
      {
        scroll->resize(w,h);
        scroll->resizeContents(w,h);
      }
    }
    if(i < 0) return;
    if(i >= nmax) return;
    if(all[i]->type == TQDraw)
    {
      QDrawWidget *iw = (QDrawWidget *) all[i]->w;
      iw->resize(w,h);
      if(zoom != 100)
      {
        float fzoom = ((float)zoom)/100.0f;
        iw->setZoomX(fzoom);
        iw->setZoomY(fzoom);
      }
    }
    else if(all[i]->type == TQLCDNumber)
    {
      QLCDNumber *iw = (QLCDNumber *) all[i]->w;
      iw->resize(w,h);
    }
    else
    {
      all[i]->w->resize(w,h);
    }
  }
  else if(strncmp(command,"removeItem(",11) == 0)
  {
    int index;
    sscanf(command,"removeItem(%d,%d",&i,&index);
    if(all[i]->type == TQListBox)
    {
      MyListBox *ptr = (MyListBox *) all[i]->w;
      ptr->removeItem(index);
    }
    else if(all[i]->type == TQComboBox)
    {
      MyComboBox *ptr = (MyComboBox *) all[i]->w;
      ptr->removeItem(index);
    }
  }
  else if(strncmp(command,"removeItemByName(",17) == 0)
  {
    sscanf(command,"removeItemByName(%d",&i);
    get_text(command,text);
    if(all[i]->type == TQListBox)
    {
      MyListBox *ptr = (MyListBox *) all[i]->w;
      ptr->removeItemByName(text);
    }
    else if(all[i]->type == TQComboBox)
    {
      MyComboBox *ptr = (MyComboBox *) all[i]->w;
      ptr->removeItemByName(text);
    }
  }
  else if(strncmp(command,"removeListViewItem(",19) == 0)
  {
    sscanf(command,"removeListViewItem(%d",&i);
    get_text(command,text);
    if(all[i]->type == TQListView)
    {
      MyListView *ptr = (MyListView *) all[i]->w;
      ptr->deleteListViewItem(text, (MyListViewItem *) ptr->firstChild());
    }
  }
  else if(strncmp(command,"removeIconViewItem(",19) == 0)
  {
    sscanf(command,"removeIconViewItem(%d",&i);
    get_text(command,text);
    if(all[i]->type == TQIconView)
    {
      MyIconView *ptr = (MyIconView *) all[i]->w;
      ptr->deleteIconViewItem(text);
    }
  }
}

void ProcessView::interprets(const char *command)
{
  if(strncmp(command,"set",3) == 0)
  {
    switch(command[3])
    {
      case 'A':
        if(strncmp(command,"setAlignment(",13) == 0) // set text alignment
        {
          int alignment;  
          sscanf(command,"setAlignment(%d,%d",&i,&alignment);
          if(i < 0) return;
          if(i >= nmax) return;
          if(all[i]->type == TQLabel)
          {
            QLabel *ptr = (QLabel *) all[i]->w;
            ptr->setAlignment(alignment);
          }
          else if(all[i]->type == TQLineEdit)
          {
            QLineEdit *ptr = (QLineEdit *) all[i]->w;
            ptr->setAlignment(alignment);
          }
        }
        break;
      case 'B':
        if(strncmp(command,"setBackgroundColor(",19) == 0) // set background color
        {
          sscanf(command,"setBackgroundColor(%d,%d,%d,%d)",&i,&r,&g,&b);
          if(i < 0) return;
          if(i >= nmax) return;
          if(all[i]->type == TQLabel)
          {
      if(r==-1 && g==-1 && b==-1) all[i]->w->unsetPalette();
            else                        all[i]->w->setBackgroundColor(QColor(r,g,b));
          }
          else if(all[i]->type == TQPushButton)
          {
            QPushButton *but = (QPushButton *) all[i]->w;
            QPixmap pm = QPixmap(but->width()/2,but->height());
            pm.fill(QColor(r,g,b));
            but->setPixmap(pm);
          }
          else if(all[i]->type == TQDraw)
          {
            QDrawWidget *ptr = (QDrawWidget *) all[i]->w;
      if(r==-1 && g==-1 && b==-1) all[i]->w->unsetPalette();
            else                        ptr->setBackgroundColor(r,g,b);
          }
          else if(all[i]->type == TQImage)
          {
            QImageWidget *ptr = (QImageWidget *) all[i]->w;
      if(r==-1 && g==-1 && b==-1) all[i]->w->unsetPalette();
            else                        ptr->setBackgroundColor(QColor(r,g,b));
          }
        }
        break;
      case 'C':
        if(strncmp(command,"setChecked(",11) == 0) // set button state
        {
          int state;
          sscanf(command,"setChecked(%d,%d)",&i,&state);
          if(i < 0) return;
          if(i >= nmax) return;
          if(all[i]->type == TQRadio)
          {
            MyRadioButton *but = (MyRadioButton *) all[i]->w;
            if(state == 1) but->setChecked(true);
            else           but->setChecked(false);
          }
          else if(all[i]->type == TQCheck)
          {
            MyCheckBox *but = (MyCheckBox *) all[i]->w;
            if(state == 1) but->setChecked(true);
            else           but->setChecked(false);
          }
        }
        else if(strncmp(command,"setCurrentItem(",15) == 0) // set current item for comboBox
        {
          int index;
          sscanf(command,"setCurrentItem(%d,%d",&i,&index);
          if(i < 0) return;
          if(i >= nmax) return;
          if(all[i]->type == TQComboBox)
          {
            MyComboBox *t = (MyComboBox *) all[i]->w;
            t->setCurrentItem(index);
          }
        }
#if QT_VERSION > 220
        else if(strncmp(command,"setColumnWidth(",15) == 0) // set column with of the table
        {
          int column, width;
          sscanf(command,"setColumnWidth(%d,%d,%d",&i,&column,&width);
          if(i < 0) return;
          if(i >= nmax) return;
          if(all[i]->type == TQTable)
          {
            MyTable *t = (MyTable *) all[i]->w;
            if(column >= 0)
            {
              t->setColumnWidth(column,width);
            }
            else
            {
              t->setLeftMargin(width);
            }
          }
        }
#endif
        break;
      case 'D':
        if(strncmp(command,"setDate(",8) == 0) // set date
        {
          int year, month, day;
          sscanf(command,"setDate(%d,%d,%d,%d)",&i,&year,&month,&day);
          if(i < 0) return;
          if(i >= nmax) return;
          if(all[i]->type == TQDateEdit)
          {
            QDateEdit *e = (QDateEdit *) all[i]->w;
            e->setDate(QDate(year,month,day));
          }
          else if(all[i]->type == TQDateTimeEdit)
          {
            QDateTimeEdit *e = (QDateTimeEdit *) all[i]->w;
            e->dateEdit()->setDate(QDate(year,month,day));
          }
        }
        else if(strncmp(command,"setDateOrder(",13) == 0) // set date order
        {
          int order;
          sscanf(command,"setDateOrder(%d,%d)",&i,&order);
          if(i < 0) return;
          if(i >= nmax) return;
          if(all[i]->type == TQDateEdit)
          {
            QDateEdit *e = (QDateEdit *) all[i]->w;
            e->setOrder((QDateEdit::Order) order);
          }
          else if(all[i]->type == TQDateTimeEdit)
          {
            QDateTimeEdit *e = (QDateTimeEdit *) all[i]->w;
            e->dateEdit()->setOrder((QDateEdit::Order) order);
          }
        }
        break;
      case 'E':
        if(strncmp(command,"setEchoMode(",12) == 0) // set echo mode in QLineEdit
        {
          int mode;
          sscanf(command,"setEchoMode(%d,%d",&i,&mode);
          if(i < 0) return;
          if(i >= nmax) return;
          if(all[i]->type == TQLineEdit)
          {
            MyLineEdit *le = (MyLineEdit *) all[i]->w;
            if     (mode == 0) le->setEchoMode(QLineEdit::NoEcho);
            else if(mode == 2) le->setEchoMode(QLineEdit::Password);
            else               le->setEchoMode(QLineEdit::Normal);
          }
        }
        else if(strncmp(command,"setEditable(",12) == 0) // set editable in QLineEdit, QMultiLineEdit
        {
          int mode;
          sscanf(command,"setEditable(%d,%d",&i,&mode);
          if(i < 0) return;
          if(i >= nmax) return;
          if(all[i]->type == TQLineEdit)
          {
            MyLineEdit *le = (MyLineEdit *) all[i]->w;
            if     (mode == 0) le->setReadOnly(true);
            else if(mode == 1) le->setReadOnly(false);
          }
          else if(all[i]->type == TQMultiLineEdit)
          {
            MyMultiLineEdit *le = (MyMultiLineEdit *) all[i]->w;
            if     (mode == 0) le->setReadOnly(true);
            else if(mode == 1) le->setReadOnly(false);
          }
#if QT_VERSION > 220
          else if(all[i]->type == TQTable)
          {
            QTable *t = (QTable *) all[i]->w;
            if     (mode == 0) t->setReadOnly(true);
            else if(mode == 1) t->setReadOnly(false);
          }
#endif
        }
        else if(strncmp(command,"setEnabled(",11) == 0) // set enabled all widgets
        {
          int mode;
          sscanf(command,"setEnabled(%d,%d",&i,&mode);
          if(i < 0) return;
          if(i >= nmax) return;
          all[i]->w->setEnabled(mode);
        }
        break;
      case 'F':
        if(strncmp(command,"setFont(",8) == 0) // set font
        {
          int pointsize,bold,italic,underline,strikeout;
          sscanf(command,"setFont(%d,%d,%d,%d,%d,%d",&i,&pointsize,&bold,&italic,&underline,&strikeout);
          get_text(command,text); // text = family of font

          if(i < 0) return;
          if(i >= nmax) return;
          if(zoom != 100)
          {
            pointsize = (pointsize*zoom)/100;
          }

          QFont font(text, pointsize);
          if(bold      == 0) font.setBold(false);
          if(italic    == 0) font.setItalic(false);
          if(underline == 0) font.setUnderline(false);
          if(strikeout == 0) font.setStrikeOut(false);
          if(bold      == 1) font.setBold(true);
          if(italic    == 1) font.setItalic(true);
          if(underline == 1) font.setUnderline(true);
          if(strikeout == 1) font.setStrikeOut(true);
          if(all[i]->type == TQMultiLineEdit)
          {
#if QT_VERSION > 220
            MyMultiLineEdit *me = (MyMultiLineEdit *) all[i]->w;
            me->setCurrentFont(font);
#endif
          }
          else
          {
            QWidget *w = (QWidget *) all[i]->w;
            w->setFont(font);
          }
        }
        else if(strncmp(command,"setFontColor(",13) == 0) // set font color
        {
          int r,g,b;
          sscanf(command,"setFontColor(%d,%d,%d,%d",&i,&r,&g,&b);
          if(i < 0) return;
          if(i >= nmax) return;
#if QT_VERSION > 220
          if(all[i]->type == TQMultiLineEdit)
          {
            MyMultiLineEdit *me = (MyMultiLineEdit *) all[i]->w;
            me->setColor(QColor(r,g,b));
          }
#endif
        }
        break;
      case 'G':
        if(strncmp(command,"setGeometry(",12) == 0) // set widget geometry
        {
          sscanf(command,"setGeometry(%d,%d,%d,%d,%d)",&i,&x,&y,&w,&h);
          if(zoom != 100)
          {
            x = (x*zoom)/100;
            y = (y*zoom)/100;
            w = (w*zoom)/100;
            h = (h*zoom)/100;
            if(w < 1) w = 1;
            if(h < 1) h = 1;
          }
          if(i == 0)
          {
            view->resize(w,h);
            if(scroll != NULL)
            {
              scroll->resize(w,h);
              scroll->resizeContents(w,h);
            }
          }
          if(i < 0) return;
          if(i >= nmax) return;
          if(all[i]->type == TQImage)
          {
            QImageWidget *iw = (QImageWidget *) all[i]->w;
            iw->setGeometry(x,y,w,h);
          }
          else if(all[i]->type == TQDraw)
          {
            QDrawWidget *iw = (QDrawWidget *) all[i]->w;
            iw->setGeometry(x,y,w,h);
            iw->resize(w,h);
            if(zoom != 100)
            {
              float fzoom = ((float)zoom)/100.0f;
              iw->setZoomX(fzoom);
              iw->setZoomY(fzoom);
            }
          }
          else if(all[i]->type == TQLCDNumber)
          {
            QLCDNumber *iw = (QLCDNumber *) all[i]->w;
            iw->setGeometry(x,y,w,h);
          }
#ifdef USE_OPEN_GL
          else if(all[i]->type == TQGl)
          {
            PvGLWidget *iw = (PvGLWidget *) all[i]->w;
            iw->setGeometry(x,y,w,h);
          }
#endif
#ifdef USE_VTK
          else if(all[i]->type == TQVtk)
          {
            pvVtkTclWidget *iw = (pvVtkTclWidget *) all[i]->w;
            iw->setGeometry(x,y,w,h);
          }
#endif
          else if(all[i]->type == TQwtPlotWidget)
          {
            QwtPlotWidget *iw = (QwtPlotWidget *) all[i]->w;
            iw->setGeometry(x,y,w,h);
          }
          else if(all[i]->type == TQwtScale)
          {
            QwtScale *iw = (QwtScale *) all[i]->w;
            iw->setGeometry(x,y,w,h);
          }
          else if(all[i]->type == TQwtThermo)
          {
            QwtThermo *iw = (QwtThermo *) all[i]->w;
            iw->setGeometry(x,y,w,h);
          }
          else if(all[i]->type == TQwtKnob)
          {
            QwtKnob *iw = (QwtKnob *) all[i]->w;
            iw->setGeometry(x,y,w,h);
          }
          else if(all[i]->type == TQwtCounter)
          {
            QwtCounter *iw = (QwtCounter *) all[i]->w;
            iw->setGeometry(x,y,w,h);
          }
          else if(all[i]->type == TQwtWheel)
          {
            QwtWheel *iw = (QwtWheel *) all[i]->w;
            iw->setGeometry(x,y,w,h);
          }
          else if(all[i]->type == TQwtSlider)
          {
            QwtSlider *iw = (QwtSlider *) all[i]->w;
            iw->setGeometry(x,y,w,h);
          }
          else if(all[i]->type == TQwtCompass)
          {
            QwtCompass *iw = (QwtCompass *) all[i]->w;
            iw->setGeometry(x,y,w,h);
          }
          else
          {
            if(all[i]->w != NULL) all[i]->w->setGeometry(x,y,w,h);
          }
        }
        break;
      case 'H':
        break;
      case 'I':
        if(strncmp(command,"setIconViewItem(",16) == 0) // set text and pixmap in QIconView
        {
          QPixmap pm;
          char *data;

          sscanf(command,"setIconViewItem(%d,%d,%d,",&i,&w,&h);
          get_text(command,text);
          if(i < 0) return;
          if(i >= nmax) return;
          if(all[i]->type == TQIconView)
          {
            MyIconView *iv = (MyIconView*) all[i]->w;
            if(w==0 && h==0) iv->setIconViewItem(text,pm);
            else
            {
              QImage *temp = readBmpFromSocket(w,h,&data);
              if(temp != NULL)
              {
                pm = *temp;
                pm.setMask(pm.createHeuristicMask());
              }
              iv->setIconViewItem(text,pm);
              if(data != NULL) delete data;
              if(temp != NULL) delete temp;
            }
          }
          else
          {
            if(w==0 && h==0) ;
            else
            {
              QImage *temp = readBmpFromSocket(w,h,&data);
              if(temp != NULL) delete temp;
            }
          }
        }
        else if(strncmp(command,"setImage(",9) == 0) // set new image in existing image
        {
          sscanf(command,"setImage(%d,",&i);
          get_text(command,text); // text = filename of image
          if(i < 0) return;
          if(i >= nmax) return;
          if(all[i]->type == TQImage)
          {
            QString filename;
            filename = temp + text;
            QImageWidget *iw = (QImageWidget *) all[i]->w;
            iw->setImage(filename);
          }
        }
        break;
      case 'J':
        break;
      case 'K':
        break;
      case 'L':
        if(strncmp(command,"setListViewPixmap(",18) == 0) // set pixmap in list view
        {
          QPixmap pm;
          char *data;
          int column;
          sscanf(command,"setListViewPixmap(%d,%d,%d,%d,",&i,&w,&h,&column);
          get_text(command,text);
          if(i < 0) return;
          if(i >= nmax) return;
          if(all[i]->type == TQListView)
          {
            MyListView *lv = (MyListView*) all[i]->w;
            if(w==0 && h==0) lv->setListViewPixmap(text,column,pm);
            else
            {
              QImage *temp = NULL;
              temp = readBmpFromSocket(w,h,&data);
              if(temp != NULL)
              {
                pm = *temp;
                pm.setMask(pm.createHeuristicMask());
              }
              lv->setListViewPixmap(text,column,pm);
              if(data != NULL) delete data;
              if(temp != NULL) delete temp;
            }
          }
          else
          {
            if(w==0 && h==0) ;
            else
            {
              QImage *temp = NULL;
              temp= readBmpFromSocket(w,h,&data);
              if(temp != NULL) delete temp;
            }
          }
        }
        else if(strncmp(command,"setListViewText(",16) == 0) // set text in QListView
        {
          int column;
          QString path;
    char text2[MAX_PRINTF_LENGTH];
          sscanf(command,"setListViewText(%d,%d",&i,&column);
          get_text(command,path);
          tcp_rec(&s,text2,sizeof(text2));
          get_text(text2,text);
          if(i < 0) return;
          if(i >= nmax) return;
          if(all[i]->type == TQListView)
          {
            MyListView *lv = (MyListView*) all[i]->w;
            lv->setListViewText(path,column,text);
          }
        }
        break;
      case 'M':
        if(strncmp(command,"setMinimumSize(",15) == 0) // set minimum w,h
        {
          sscanf(command,"setMinimumSize(%d,%d,%d)",&i,&w,&h);
          if(i < 0) return;
          if(i >= nmax) return;
          all[i]->w->setMinimumSize(w,h);
        }
        else if(strncmp(command,"setMaximumSize(",15) == 0) // set maximum w,h
        {
          sscanf(command,"setMaximumSize(%d,%d,%d)",&i,&w,&h);
          if(i < 0) return;
          if(i >= nmax) return;
          all[i]->w->setMaximumSize(w,h);
        }
        else if(strncmp(command,"setMultiSelection(",18) == 0) // set selection mode in QListView
        {
          int mode;
          sscanf(command,"setMultiSelection(%d,%d",&i,&mode);
          if(i < 0) return;
          if(i >= nmax) return;
          if(all[i]->type == TQListView)
          {
            MyListView *lv = (MyListView *) all[i]->w;
            lv->setMultiSelection(mode);
          }
          else if(all[i]->type == TQListBox)
          {
            MyListBox *lb = (MyListBox *) all[i]->w;
            if      (mode == 1) lb->setSelectionMode(QListBox::Multi);
            else if (mode == 2) lb->setSelectionMode(QListBox::NoSelection);
            else                lb->setSelectionMode(QListBox::Single);
          }
        }
        else if(strncmp(command,"setMinDate(",11) == 0) // set min date
        {
          int year, month, day;
          sscanf(command,"setMinDate(%d,%d,%d,%d)",&i,&year,&month,&day);
          if(i < 0) return;
          if(i >= nmax) return;
          if(all[i]->type == TQDateEdit)
          {
            QDateEdit *e = (QDateEdit *) all[i]->w;
            e->setMinValue(QDate(year,month,day));
          }
          else if(all[i]->type == TQDateTimeEdit)
          {
            QDateTimeEdit *e = (QDateTimeEdit *) all[i]->w;
            e->dateEdit()->setMinValue(QDate(year,month,day));
          }
        }
        else if(strncmp(command,"setMaxDate(",11) == 0) // set max date
        {
          int year, month, day;
          sscanf(command,"setMaxDate(%d,%d,%d,%d)",&i,&year,&month,&day);
          if(i < 0) return;
          if(i >= nmax) return;
          if(all[i]->type == TQDateEdit)
          {
            QDateEdit *e = (QDateEdit *) all[i]->w;
            e->setMaxValue(QDate(year,month,day));
          }
          else if(all[i]->type == TQDateTimeEdit)
          {
            QDateTimeEdit *e = (QDateTimeEdit *) all[i]->w;
            e->dateEdit()->setMaxValue(QDate(year,month,day));
          }
        }
        else if(strncmp(command,"setMinTime(",11) == 0) // set min time
        {
          int hour, minute, second, msec;
          sscanf(command,"setMinTime(%d,%d,%d,%d,%d)",&i,&hour,&minute,&second,&msec);
          if(i < 0) return;
          if(i >= nmax) return;
          if(all[i]->type == TQTimeEdit)
          {
            QTimeEdit *e = (QTimeEdit *) all[i]->w;
            e->setMinValue(QTime(hour,minute,second,msec));
          }
          else if(all[i]->type == TQDateTimeEdit)
          {
            QDateTimeEdit *e = (QDateTimeEdit *) all[i]->w;
            e->timeEdit()->setMinValue(QTime(hour,minute,second,msec));
          }
        }
        else if(strncmp(command,"setMaxTime(",11) == 0) // set max time
        {
          int hour, minute, second, msec;
          sscanf(command,"setMaxTime(%d,%d,%d,%d,%d)",&i,&hour,&minute,&second,&msec);
          if(i < 0) return;
          if(i >= nmax) return;
          if(all[i]->type == TQTimeEdit)
          {
            QTimeEdit *e = (QTimeEdit *) all[i]->w;
            e->setMaxValue(QTime(hour,minute,second,msec));
          }
          else if(all[i]->type == TQDateTimeEdit)
          {
            QDateTimeEdit *e = (QDateTimeEdit *) all[i]->w;
            e->timeEdit()->setMaxValue(QTime(hour,minute,second,msec));
          }
        }
        break;
      case 'N':
        if(strncmp(command,"setNumRows(",11) == 0) // set table num rows
        {
#if QT_VERSION > 220
          int num;
          sscanf(command,"setNumRows(%d,%d",&i,&num);
          if(i < 0) return;
          if(i >= nmax) return;
          if(all[i]->type == TQTable)
          {
            MyTable *t = (MyTable *) all[i]->w;
            t->setNumRows(num);
          }
#endif
        }
        else if(strncmp(command,"setNumCols(",11) == 0) // set table num cols
        {
#if QT_VERSION > 220
          int num;
          sscanf(command,"setNumCols(%d,%d",&i,&num);
          if(i < 0) return;
          if(i >= nmax) return;
          if(all[i]->type == TQTable)
          {
            MyTable *t = (MyTable *) all[i]->w;
            t->setNumCols(num);
          }
#endif
        }
        break;
      case 'O':
        if(strncmp(command,"setOpen(",8) == 0)
        {
          int open;
          sscanf(command,"setOpen(%d,%d",&i,&open);
          if(i < 0) return;
          if(i >= nmax) return;
          if(all[i]->type == TQListView)
          {
            get_text(command,text);
            MyListView *l = (MyListView *) all[i]->w;
            l->setItemOpen(text,open, (MyListViewItem *) l->firstChild());
          }
        }
        break;
      case 'P':
        if(strncmp(command,"setPixmap(",10) == 0) // set pixmap
        {
          QPixmap pm;
          char *data;
          sscanf(command,"setPixmap(%d,%d,%d)",&i,&w,&h);
          if(i < 0) return;
          if(i >= nmax) return;
          if(all[i]->type == TQPushButton)
          {
            QPushButton *b = (QPushButton*) all[i]->w;
            if(w==0 && h==0) b->setPixmap(pm);
            else
            {
              QImage *temp = readBmpFromSocket(w,h,&data);
              if(temp != NULL)
              {
                pm = *temp;
                pm.setMask(pm.createHeuristicMask());
              }
              b->setPixmap(pm);
              if(data != NULL) delete data;
              if(temp != NULL) delete temp;
            }
          }
          else
          {
            if(w==0 && h==0) ;
            else
            {
              QImage *temp = readBmpFromSocket(w,h,&data);
              if(temp != NULL) delete temp;
            }
          }
        }
        else if(strncmp(command,"setPaletteBackgroundColor(",26) == 0) // set background color
        {
#if QT_VERSION > 230
          sscanf(command,"setPaletteBackgroundColor(%d,%d,%d,%d)",&i,&r,&g,&b);
          if(i < 0) return;
          if(i >= nmax) return;
    if(r==-1 && g==-1 && b==-1) all[i]->w->unsetPalette();
          else                        all[i]->w->setPaletteBackgroundColor(QColor(r,g,b));
#endif
        }
        else if(strncmp(command,"setPaletteForegroundColor(",26) == 0) // set background color
        {
#if QT_VERSION > 230
          sscanf(command,"setPaletteForegroundColor(%d,%d,%d,%d)",&i,&r,&g,&b);
          if(i < 0) return;
          if(i >= nmax) return;
    if(r==-1 && g==-1 && b==-1) all[i]->w->unsetPalette();
          else                        all[i]->w->setPaletteForegroundColor(QColor(r,g,b));
#endif
        }
        break;
      case 'Q':
        break;
      case 'R':
        break;
      case 'S':
        if(strncmp(command,"setSource(",10) == 0) // set source of QTextBrowser
        {
          sscanf(command,"setSource(%d",&i);
          get_text(command,text); // text = html filename
          if(i < 0) return;
          if(i >= nmax) return;
          if(all[i]->type == TQTextBrowser)
          {
            MyTextBrowser *t = (MyTextBrowser *) all[i]->w;
            t->setSource(temp + text);
          }
        }
        else if(strncmp(command,"setSorting(",11) == 0) // set sorting of ListView
        {
          int col,mode;
          sscanf(command,"setSorting(%d,%d,%d",&i,&col,&mode);
          if(i < 0) return;
          if(i >= nmax) return;
          if(all[i]->type == TQListView)
          {
            MyListView *lv = (MyListView *) all[i]->w;
            lv->setSorting(col,mode);
          }
        }
        else if(strncmp(command,"setStyle(",9) == 0) // set style of QLabel QFrame
        {
          int shape,shadow,line_width,margin;
          sscanf(command,"setStyle(%d,%d,%d,%d,%d",&i,&shape,&shadow,&line_width,&margin);
          if(i < 0) return;
          if(i >= nmax) return;
          if(all[i]->type == TQLabel)
          {
            QLabel *ptr = (QLabel *) all[i]->w;
            if(shape      != -1) ptr->setFrameShape((QFrame::Shape) shape);
            if(shadow     != -1) ptr->setFrameShadow((QFrame::Shadow) shadow);
            if(line_width != -1) ptr->setLineWidth(line_width);
            if(margin     != -1) ptr->setMargin(margin);
          }
          else if(all[i]->type == TQLineEdit)
          {
            MyLineEdit *ptr = (MyLineEdit *) all[i]->w;
            if(shape      != -1) ptr->setFrameShape((QFrame::Shape) shape);
            if(shadow     != -1) ptr->setFrameShadow((QFrame::Shadow) shadow);
            if(line_width != -1) ptr->setLineWidth(line_width);
            if(margin     != -1) ptr->setMargin(margin);
          }
          else if(all[i]->type == TQFrame)
          {
            MyFrame *ptr = (MyFrame *) all[i]->w;
            if(shape      != -1) ptr->setFrameShape((QFrame::Shape) shape);
            if(shadow     != -1) ptr->setFrameShadow((QFrame::Shadow) shadow);
            if(line_width != -1) ptr->setLineWidth(line_width);
            if(margin     != -1) ptr->setMargin(margin);
          }
          else if(all[i]->type == TQGroupBox)
          {
            MyGroupBox *ptr = (MyGroupBox *) all[i]->w;
            if(shape      != -1) ptr->setFrameShape((QFrame::Shape) shape);
            if(shadow     != -1) ptr->setFrameShadow((QFrame::Shadow) shadow);
            if(line_width != -1) ptr->setLineWidth(line_width);
            if(margin     != -1) ptr->setMargin(margin);
          }
          else if(all[i]->type == TQLCDNumber)
          {
            QLCDNumber *ptr = (QLCDNumber *) all[i]->w;
            if(shape      != -1) ptr->setFrameShape((QFrame::Shape) shape);
            if(shadow     != -1) ptr->setFrameShadow((QFrame::Shadow) shadow);
            if(line_width != -1) ptr->setLineWidth(line_width);
            if(margin     != -1) ptr->setMargin(margin);
          }
          else if(all[i]->type == TQProgressBar)
          {
            MyProgressBar *ptr = (MyProgressBar *) all[i]->w;
            if(shape      != -1) ptr->setFrameShape((QFrame::Shape) shape);
            if(shadow     != -1) ptr->setFrameShadow((QFrame::Shadow) shadow);
            if(line_width != -1) ptr->setLineWidth(line_width);
            if(margin     != -1) ptr->setMargin(margin);
          }
          else if(all[i]->type == TQToolBox)
          {
            MyQToolBox *ptr = (MyQToolBox *) all[i]->w;
            if(shape      != -1) ptr->setFrameShape((QFrame::Shape) shape);
            if(shadow     != -1) ptr->setFrameShadow((QFrame::Shadow) shadow);
            if(line_width != -1) ptr->setLineWidth(line_width);
            if(margin     != -1) ptr->setMargin(margin);
          }
        }
        break;
      case 'T':
        if(strncmp(command,"setText(",8) == 0) // set widget text
        {
          sscanf(command,"setText(%d,",&i);
          if(i >= nmax && i > 0) return;
          get_text(command,text);
          if(strncmp(text,"alloc(",6) == 0) // allocate big buffer for big text
          {
            int len,ret;
            char *buf;
            sscanf(text,"alloc(%d,",&len);
            //printf("alloc(%d)\n",len);
            buf = new char[len+1];
            ret = tcp_rec_binary(&s, buf, len);
            buf[len] = '\0';
            text = buf;
            buf[len] = '\0';
            delete [] buf;
          }
          if(i <= 0)
          {
            text = text.left(40);
            text.append(" - ");
            text.append(caption_processview);
            setCaption(text);
          }
          else if(all[i]->type == TQPushButton)
          {
            QPushButton *b = (QPushButton*) all[i]->w;
            b->setText(text);
          }
          else if(all[i]->type == TQLabel)
          {
            QLabel *l = (QLabel*) all[i]->w;
            l->setText(text);
          }
          else if(all[i]->type == TQLineEdit)
          {
            MyLineEdit *e = (MyLineEdit*) all[i]->w;
            e->setText(text);
          }
          else if(all[i]->type == TQMultiLineEdit)
          {
            MyMultiLineEdit *e = (MyMultiLineEdit*) all[i]->w;
            e->setText(text);
          }
          else if(all[i]->type == TQComboBox)
          {
            MyComboBox *c = (MyComboBox*) all[i]->w;
            c->insertItem(text);
          }
          else if(all[i]->type == TQRadio)
          {
            MyRadioButton *c = (MyRadioButton*) all[i]->w;
            c->setText(text);
          }
          else if(all[i]->type == TQCheck)
          {
            MyCheckBox *c = (MyCheckBox *) all[i]->w;
            c->setText(text);
          }
          else if(all[i]->type == TQTextBrowser)
          {
            MyTextBrowser *c = (MyTextBrowser *) all[i]->w;
            // mur was here: make cursor not jumping
            int x = c->contentsX();
            int y = c->contentsY();
            c->setText(text);
            c->setContentsPos(x,y);
          }
        }
#if QT_VERSION > 220
        else if(strncmp(command,"setTableText(",13) == 0) // set text in table
        {
          sscanf(command,"setTableText(%d,%d,%d,",&i,&x,&y);
          get_text(command,text);
          if(i < 0) return;
          if(i >= nmax) return;
          else if(all[i]->type == TQTable)
          {
            MyTable *t = (MyTable *) all[i]->w;
            if(x >= 0 && y >=0)
            {
              QTableItem *item;
              t->setText(x,y,text);
              if(t->wrap)
              {
                item = t->item(x,y);
                if(item != NULL)
                {
                  item->setWordWrap(true);
                  t->adjustRow(x);
                }
              }
            }
            else if(x<0 && y >= 0)
            {
              t->horizontalHeader()->setLabel(y,text);
            }
            else if(y<0 && x >= 0)
            {
              t->verticalHeader()->setLabel(x,text);
            }
          }
        }
        else if(strncmp(command,"setTablePixmap(",15) == 0) // set pixmap in table
        {
          char *data,text2[80];
          sscanf(command,"setTablePixmap(%d,%d,%d",&i,&x,&y);
          if(i < 0) return;
          if(i >= nmax) return;
          else if(all[i]->type == TQTable)
          {
            MyTable *t = (MyTable *) all[i]->w;
            QPixmap pm;
            tcp_rec(&s,text2,sizeof(text2));
            sscanf(text2,"(%d,%d)",&w,&h);
            if(w==0 && h==0) t->setPixmap(y,x,pm);
            else
            {
              QImage *temp = readBmpFromSocket(w,h,&data);
              if(temp != NULL)
              {
                pm = *temp;
                pm.setMask(pm.createHeuristicMask());
              }
              t->setPixmap(y,x,pm);
              if(data != NULL) delete data;
              if(temp != NULL) delete temp;
            }
          }
          else
          {
            tcp_rec(&s,text2,sizeof(text2));
            sscanf(text2,"(%d,%d)",&w,&h);
            if(w==0 && h==0) ;
            else
            {
              QImage *temp = readBmpFromSocket(w,h,&data);
              if(temp != NULL) delete temp;
            }
          }
        }
        else if(strncmp(command,"setTableCheckBox(",17) == 0) // set checkbox in table
        {
          int state;
          sscanf(command,"setTableCheckBox(%d,%d,%d,%d,",&i,&x,&y,&state);
          get_text(command,text);
          if(i < 0) return;
          if(i >= nmax) return;
          if(all[i]->type == TQTable)
          {
            MyTable *t = (MyTable *) all[i]->w;
            t->setTableCheckBox(x,y,state,text);
          }
        }
        else if(strncmp(command,"setTableComboBox(",17) == 0) // set combobox in table
        {
          int editable;
          sscanf(command,"setTableComboBox(%d,%d,%d,%d,",&i,&x,&y,&editable);
          get_text(command,text);
          if(i < 0) return;
          if(i >= nmax) return;
          if(all[i]->type == TQTable)
          {
            MyTable *t = (MyTable *) all[i]->w;
            t->setTableComboBox(x,y,editable,text);
          }
        }
#endif
        else if(strncmp(command,"setTabPosition(",15) == 0) // set tab position Top|Bottom
        {
          int pos;
          sscanf(command,"setTabPosition(%d,%d",&i,&pos);
          if(i < 0) return;
          if(i >= nmax) return;
          if(all[i]->type == TQTabWidget)
          {
            MyQTabWidget *tab = (MyQTabWidget *) all[i]->w;
            if     (pos == 0) tab->setTabPosition(QTabWidget::Top);
            else if(pos == 1) tab->setTabPosition(QTabWidget::Bottom);
          }
        }
        else if(strncmp(command,"setTime(",8) == 0) // set time
        {
          int hour, minute, second, msec;
          sscanf(command,"setTime(%d,%d,%d,%d,%d)",&i,&hour,&minute,&second,&msec);
          if(i < 0) return;
          if(i >= nmax) return;
          if(all[i]->type == TQTimeEdit)
          {
            QTimeEdit *e = (QTimeEdit *) all[i]->w;
            e->setTime(QTime(hour,minute,second,msec));
          }
          else if(all[i]->type == TQDateTimeEdit)
          {
            QDateTimeEdit *e = (QDateTimeEdit *) all[i]->w;
            e->timeEdit()->setTime(QTime(hour,minute,second,msec));
          }
        }
        else if(strncmp(command,"setTimeEditDisplay(",19) == 0) // set time edit display
        {
          int hour, minute, second, ampm, mask;
          sscanf(command,"setTimeEditDisplay(%d,%d,%d,%d,%d)",&i,&hour,&minute,&second,&ampm);
          if(i < 0) return;
          if(i >= nmax) return;
          mask = 0;
          if(hour   == 1) mask |= QTimeEdit::Hours;
          if(minute == 1) mask |= QTimeEdit::Minutes;
          if(second == 1) mask |= QTimeEdit::Seconds;
          if(ampm   == 1) mask |= QTimeEdit::AMPM;
          if(all[i]->type == TQTimeEdit)
          {
            QTimeEdit *e = (QTimeEdit *) all[i]->w;
            e->setDisplay(mask);
          }
          else if(all[i]->type == TQDateTimeEdit)
          {
            QDateTimeEdit *e = (QDateTimeEdit *) all[i]->w;
            e->timeEdit()->setDisplay(mask);
          }
        }
        break;
      case 'U':
        break;
      case 'V':
        if(strncmp(command,"setValue(",9) == 0) // set value
        {
          int value;
          sscanf(command,"setValue(%d,%d",&i,&value);
          if(i < 0) return;
          if(i >= nmax) return;
          if(all[i]->type == TQSpinBox)
          {
            MySpinBox *b = (MySpinBox*) all[i]->w;
            b->setValue(value);
          }
          else if(all[i]->type == TQDial)
          {
            MyDial *b = (MyDial*) all[i]->w;
            b->setValue(value);
          }
          else if(all[i]->type == TQProgressBar)
          {
            MyProgressBar *b = (MyProgressBar*) all[i]->w;
            b->setValue(value);
          }
          else if(all[i]->type == TQSlider)
          {
            MySlider *b = (MySlider*) all[i]->w;
            b->setValue(value);
          }
          else if(all[i]->type == TQTabWidget)
          {
            MyQTabWidget *b = (MyQTabWidget*) all[i]->w;
            b->setCurrentPage(value);
          }
        }
        break;
      case 'W':
        break;
      case 'X':
        break;
      case 'Y':
        break;
      case 'Z':
        break;
      default:
        break;
    }
  }
  else if(strncmp(command,"selection(",10) == 0) // request selection in QListView
  {
    sscanf(command,"selection(%d",&i);
    if(i < 0) return;
    if(i >= nmax) return;
    if(all[i]->type == TQListView)
    {
      MyListView *lv = (MyListView *) all[i]->w;
      lv->slotSendSelected();
    }
    else if(all[i]->type == TQListBox)
    {
      MyListBox *lb = (MyListBox *) all[i]->w;
      lb->slotSendSelected();
    }
  }
  else if(strncmp(command,"show(",5) == 0) // show the widget
  {
    sscanf(command,"show(%d)",&i);
    if(i < 0) return;
    if(i >= nmax) return;
    all[i]->w->show();
  }
  else if(strncmp(command,"startDefinition(",16) == 0) // startDefinition of new MainWidget
  {
    char *ptr;
    mainLayout = NULL;
    hasLayout = 0;
    if(allBase == NULL)
    {
      for(i=0; i<nmax; i++) QToolTip::remove(all[i]->w);
    }
    sscanf(command,"startDefinition(%d)",&n);
    if(allBase == NULL)
    {
      if(all != NULL) free(all);
      v = new MyQWidget(&s,0,this);
    }
    ptr = (char *) malloc(n*sizeof(ptr) + n*sizeof(ALL));

    if(ptr==NULL) qFatal("out of memory -> exit");
    all = (ALL **) ptr;
    ptr += n*sizeof(ptr);
    for(i=0; i<n; i++) all[i] = (ALL *) (ptr + i*sizeof(ALL));
    if(allBase == NULL)
    {
      all[0]->w = v;
    }
    else
    {
      all[0]->w = modalDialog;
    }

    nmax = n;
    for(i=1; i<n; i++)
    {
      all[i]->w = (QWidget *) NULL;
      all[i]->type = -1;
    }
    if(allBase != NULL)
    {
      allModal = all;
      nmaxModal = nmax;
    }
  }
#if QT_VERSION > 220
  else if(strncmp(command,"save(",5) == 0) // save table as TAB separated text file
  {
    sscanf(command,"save(%d)",&i);
    if(i < 0) return;
    if(i >= nmax) return;
    if(all[i]->type == TQTable)
    {
      MyTable *table = (MyTable *) all[i]->w;
      table->saveTextfile();
    }
  }
#endif
  else if(strncmp(command,"screenHint(",11) == 0) // adjust zoom factor
  {
    int w,h,dw;
    sscanf(command,"screenHint(%d,%d)",&w,&h);
    dw = QApplication::desktop()->width();
    // dh = QApplication::desktop()->height();
    // dw = (zoom / 100) w;
    // ( dw / w ) * 100 = zoom;
    if(w>0 && dw>0) zoom = (dw *100) / w;
  }
  else if(strncmp(command,"statusMessage(",14) == 0) // output status message
  {
    int r,g,b;
    sscanf(command,"statusMessage(%d,%d,%d",&r,&g,&b);
    get_text(command,text);
    if(r < 0) statusBar()->unsetPalette();
    else      statusBar()->setPaletteBackgroundColor(QColor(r,g,b));
    statusBar()->message(text);
  }
}

void ProcessView::interprett(const char *command)
{
  if(strncmp(command,"text(",5) == 0)
  {
    char buf[MAX_PRINTF_LENGTH];
    sscanf(command,"text(%d)",&i);
    buf[0] = '\0';
    if(all[i]->type == TQLabel)
    {
      QLabel *w = (QLabel *) all[i]->w;
      if(codec == NULL) sprintf(buf,"text(%d,\"%s\")\n", i, (const char *) w->text());
      else              sprintf(buf,"text(%d,\"%s\")\n", i, (const char *) codec->fromUnicode(w->text()));
      if(buf[0] != '\0') tcp_send(&s,buf,strlen(buf));
    }
    else if(all[i]->type == TQPushButton)
    {
      MyQPushButton *w = (MyQPushButton *) all[i]->w;
      if(codec == NULL) sprintf(buf,"text(%d,\"%s\")\n", i, (const char *) w->text());
      else              sprintf(buf,"text(%d,\"%s\")\n", i, (const char *) codec->fromUnicode(w->text()));
      if(buf[0] != '\0') tcp_send(&s,buf,strlen(buf));
    }
    else if(all[i]->type == TQLineEdit)
    {
      MyLineEdit *w = (MyLineEdit *) all[i]->w;
      if(codec == NULL) sprintf(buf,"text(%d,\"%s\")\n", i, (const char *) w->text());
      else              sprintf(buf,"text(%d,\"%s\")\n", i, (const char *) codec->fromUnicode(w->text()));
      if(buf[0] != '\0') tcp_send(&s,buf,strlen(buf));
    }
    else if(all[i]->type == TQComboBox)
    {
      MyComboBox *w = (MyComboBox *) all[i]->w;
      if(codec == NULL) sprintf(buf,"text(%d,\"%s\")\n", i, (const char *) w->currentText());
      else              sprintf(buf,"text(%d,\"%s\")\n", i, (const char *) codec->fromUnicode(w->currentText()));
      //sprintf(buf,"text(%d,\"%s\")\n", i, (const char *) w->currentText());
      if(buf[0] != '\0') tcp_send(&s,buf,strlen(buf));
    }
    else if(all[i]->type == TQMultiLineEdit)
    {
      MyMultiLineEdit *w = (MyMultiLineEdit *) all[i]->w;
      w->slotSendToClipboard();
    }
  }
  else if(strncmp(command,"tableSetEnabled(",16) == 0)
  {
    int x,y,enabled;
    sscanf(command,"tableSetEnabled(%d,%d,%d,%d)",&i,&x,&y,&enabled);
    if(i < 0) return;
    if(i >= nmax) return;
    if(all[i]->type == TQTable)
    {
      QTable *t;
      QTableItem *item;
      t = (QTable *) all[i]->w;
      item = t->item(y,x);
      if(item == 0) 
      {
        t->setText(y,x,"");
        item = t->item(y,x);
      }
      if(item != 0) item->setEnabled(enabled);
    }
  }
  else if(strncmp(command,"tableSetHeaderResizeEnabled(",28) == 0)
  {
    int horizontal,enabled,section;
    sscanf(command,"tableSetHeaderResizeEnabled(%d,%d,%d,%d)",&i,&horizontal,&enabled,&section);
    if(i < 0) return;
    if(i >= nmax) return;
    if(all[i]->type == TQTable)
    {
      QTable *t;
      t = (QTable *) all[i]->w;
      if(horizontal == 1)
      {
        t->horizontalHeader()->setResizeEnabled(enabled,section);
      }
      else
      {
        t->verticalHeader()->setResizeEnabled(enabled,section);
      }
    }
  }
  else if(strncmp(command,"tableWrap(",10) == 0)
  {
    int wrap;
    sscanf(command,"tableWrap(%d,%d",&i,&wrap);
    if(i < 0) return;
    if(i >= nmax) return;
    if(all[i]->type == TQTable)
    {
      MyTable *t = (MyTable *) all[i]->w;
      t->wrap = wrap;
    }
  }
  else if(strncmp(command,"tabOrder(",9) == 0)
  {
    int id1,id2;
    sscanf(command,"tabOrder(%d,%d",&id1,&id2);
    if(id1 >= 0 && id2 >= 0)
    {
      if(id1 < nmax && id2 < nmax)
      {
        QWidget::setTabOrder(all[id1]->w, all[id2]->w);
      }
    }
  }
}

void ProcessView::interpretv(const char *command)
{
#ifdef USE_VTK
  if(strncmp(command,"vtkTcl(",7) == 0) // interpret a VTK Tcl command
  {
    char text[MAX_PRINTF_LENGTH];
    sscanf(command,"vtkTcl(%d)",&i);
    tcp_rec(&s,text,sizeof(text));
    if(i < 0) return;
    if(i >= nmax) return;
    if(all[i]->type == TQVtk)
    {
      pvVtkTclWidget *w = (pvVtkTclWidget *) all[i]->w;
      w->interpret(text);
      if(strstr(text,"renderer") != NULL && strstr(text,"Render") != NULL ) w->updateGL();
    }
  }
  else if(strncmp(command,"vtkTclScript(",13) == 0) // interpret a VTK Tcl file
  {
    sscanf(command,"vtkTclScript(%d,",&i);
    get_text(command,text);
    if(i < 0) return;
    if(i >= nmax) return;
    if(all[i]->type == TQVtk)
    {
      pvVtkTclWidget *w = (pvVtkTclWidget *) all[i]->w;
      w->interpretFile(text);
    }
  }
#endif
  if(command == NULL) return;
}

void ProcessView::interpretq(const char *command)
{
  if(strncmp(command,"qpw(",4) == 0)
  {
    int ret;
    char qwtcommand[1024];
    sscanf(command,"qpw(%d)",&i);
    if(i < 0) return;
    if(i >= nmax) return;
    QwtPlotWidget *pw = (QwtPlotWidget *) all[i]->w;
    ret = tcp_rec(&s, qwtcommand, sizeof(qwtcommand)-1);
    if(ret == -1) return;
    if(all[i]->type != TQwtPlotWidget) return;
    if(strncmp(qwtcommand,"setCurveData(",13) == 0)
    {
      int cnt,c,count;
      char param[256];
      sscanf(qwtcommand,"setCurveData(%d,%d",&c,&count);
      if(count <= 0) return;
      double *x = new double[count];
      double *y = new double[count];
      for(cnt=0; cnt<count; cnt++)
      {
        ret = tcp_rec(&s, param, sizeof(param)-1);
        if(ret == -1)
        {
          delete [] x;
          delete [] y;
          return;
        }
        sscanf(param,"%lf %lf",&x[cnt],&y[cnt]);
      }
      pw->interpret(qwtcommand,x,y);
      delete [] x;
      delete [] y;
    }
    else
    {
      pw->interpret(qwtcommand);
    }
  }
  else if(strncmp(command,"qwt(",4) == 0) // Commands for the QwtWidgets
  {
    int ret;
    char qwtcommand[1024];
    sscanf(command,"qwt(%d)",&i);
    ret = tcp_rec(&s, qwtcommand, sizeof(qwtcommand)-1);
    if(ret == -1) return;
    if(i < 0) return;
    if(i >= nmax) return;
    if(all[i]->type == TQwtScale)
    {
      // QwtScale
      QwtScale *wi = (QwtScale *) all[i]->w;
      if(strncmp(qwtcommand,"setTitle(",9) == 0)
      {
        get_text(qwtcommand,text);
        wi->setTitle(text);
      }
      else if(strncmp(qwtcommand,"setTitleColor(",14) == 0)
      {
        int r,g,b;
        sscanf(qwtcommand,"setTitleColor(%d,%d,%d",&r,&g,&b);
        wi->setTitleColor(QColor(r,g,b));
      }
      else if(strncmp(qwtcommand,"setTitleFont(",13) == 0)
      {
        int pointsize,bold,italic,underline,strikeout;
        sscanf(qwtcommand,"setTitleFont(%d,%d,%d,%d,%d",&pointsize,&bold,&italic,&underline,&strikeout);
        get_text(qwtcommand,text); // text = family of font
        QFont font(text, pointsize);
        if(bold      == 1) font.setBold(true);
        if(italic    == 1) font.setItalic(true);
        if(underline == 1) font.setUnderline(true);
        if(strikeout == 1) font.setStrikeOut(true);
        wi->setTitleFont(font);
      }
      else if(strncmp(qwtcommand,"setTitleAlignment(",18) == 0)
      {
        int flags;
        sscanf(qwtcommand,"setTitleAlignment(%d",&flags);
        wi->setTitleAlignment(flags);
      }
      else if(strncmp(qwtcommand,"setBorderDist(",14) == 0)
      {
        int start,end;
        sscanf(qwtcommand,"setBorderDist(%d,%d",&start,&end);
        wi->setBorderDist(start,end);
      }
      else if(strncmp(qwtcommand,"setBaselineDist(",16) == 0)
      {
        int bd;
        sscanf(qwtcommand,"setBaselineDist(%d",&bd);
        wi->setBaselineDist(bd);
      }
      else if(strncmp(qwtcommand,"setScaleDiv(",12) == 0)
      {
        double lBound, hBound, step;
        int maxMaj, maxMin, log, ascend;
        QwtScaleDiv sd;
        sscanf(qwtcommand,"setScaleDiv(%lf,%lf,%d,%d,%d,%lf,%d",
                           &lBound,&hBound,&maxMaj,&maxMin,&log,&step,&ascend);
        sd.rebuild(lBound,hBound,maxMaj,maxMin,log,step,ascend);
        wi->setScaleDiv(sd);
      }
      else if(strncmp(qwtcommand,"setScaleDraw(",13) == 0)
      {
        //setScaleDraw(QwtScaleDraw *);
      }
      else if(strncmp(qwtcommand,"setLabelFormat(",15) == 0)
      {
        int f,prec,fieldWidth;
        sscanf(qwtcommand,"setLabelFormat(%d,%d,%d",&f,&prec,&fieldWidth);
        wi->setLabelFormat(f,prec,fieldWidth);
      }
      else if(strncmp(qwtcommand,"setLabelAlignment(",18) == 0)
      {
        int align;
        sscanf(qwtcommand,"setLabelAlignment(%d",&align);
        wi->setLabelAlignment(align);
      }
      else if(strncmp(qwtcommand,"setLabelRotation(",17) == 0)
      {
        double rotation;
        sscanf(qwtcommand,"setLabelRotation(%lf",&rotation);
        wi->setLabelRotation(rotation);
      }
      else if(strncmp(qwtcommand,"setPosition(",12) == 0)
      {
        int pos;
        sscanf(qwtcommand,"setPosition(%d",&pos);
        wi->setPosition((QwtScale::Position) pos);
      }
    }
    else if(all[i]->type == TQwtThermo)
    {
      // QwtThermo
      QwtThermo *wi = (QwtThermo *) all[i]->w;
      if(strncmp(qwtcommand,"setScale(",9) == 0)
      {
        double min,max,step;
        int logarithmic;
        sscanf(qwtcommand,"setScale(%lf,%lf,%lf,%d",&min,&max,&step,&logarithmic);
        wi->setScale(min,max,step,logarithmic);
      }
      else if(strncmp(qwtcommand,"setOrientation(",15) == 0)
      {
        int ori,pos;
        sscanf(qwtcommand,"setOrientation(%d,%d",&ori,&pos);
        wi->setOrientation((Qt::Orientation) ori, (QwtThermo::ScalePos) pos);
      }
      else if(strncmp(qwtcommand,"setBorderWidth(",15) == 0)
      {
        int w;
        sscanf(qwtcommand,"setBorderWidth(%d",&w);
        wi->setBorderWidth(w);
      }
      else if(strncmp(qwtcommand,"setFillColor(",13) == 0)
      {
        int r,g,b;
        sscanf(qwtcommand,"setFillColor(%d,%d,%d",&r,&g,&b);
        wi->setFillColor(QColor(r,g,b));
      }
      else if(strncmp(qwtcommand,"setAlarmColor(",14) == 0)
      {
        int r,g,b;
        sscanf(qwtcommand,"setAlarmColor(%d,%d,%d",&r,&g,&b);
        wi->setAlarmColor(QColor(r,g,b));
      }
      else if(strncmp(qwtcommand,"setAlarmLevel(",14) == 0)
      {
        double v;
        sscanf(qwtcommand,"setAlarmLevel(%lf",&v);
        wi->setAlarmLevel(v);
      }
      else if(strncmp(qwtcommand,"setAlarmEnabled(",16) == 0)
      {
        int tf;
        sscanf(qwtcommand,"setAlarmEnabled(%d",&tf);
        wi->setAlarmEnabled(tf);
      }
      else if(strncmp(qwtcommand,"setPipeWidth(",13) == 0)
      {
        int w;
        sscanf(qwtcommand,"setPipeWidth(%d",&w);
        wi->setPipeWidth(w);
      }
      else if(strncmp(qwtcommand,"setRange(",9) == 0)
      {
        double vmin,vmax;
        sscanf(qwtcommand,"setRange(%lf,%lf",&vmin,&vmax);
        wi->setRange(vmin,vmax);
      }
      else if(strncmp(qwtcommand,"setMargin(",10) == 0)
      {
        int m;
        sscanf(qwtcommand,"setMargin(%d",&m);
        wi->setMargin(m);
      }
      else if(strncmp(qwtcommand,"setValue(",9) == 0)
      {
        double val;
        sscanf(qwtcommand,"setValue(%lf",&val);
        wi->setValue(val);
      }
    }
    else if(all[i]->type == TQwtKnob)
    {
      // QwtKnob
      QwtKnob *wi = (QwtKnob *) all[i]->w;
      if(strncmp(qwtcommand,"setScale(",9) == 0)
      {
        double min,max,step;
        int logarithmic;
        sscanf(qwtcommand,"setScale(%lf,%lf,%lf,%d",&min,&max,&step,&logarithmic);
        wi->setScale(min,max,step,logarithmic);
      }
      else if(strncmp(qwtcommand,"setMass(",8) == 0)
      {
        float mass;
        sscanf(qwtcommand,"setMass(%f",&mass);
        wi->setMass(w);
      }
      else if(strncmp(qwtcommand,"setOrientation(",15) == 0)
      {
        int o;
        sscanf(qwtcommand,"setOrientation(%d",&o);
        wi->setOrientation((Qt::Orientation) o);
      }
      else if(strncmp(qwtcommand,"setReadOnly(",12) == 0)
      {
        int w;
        sscanf(qwtcommand,"setReadOnly(%d",&w);
        wi->setReadOnly(w);
      }
      else if(strncmp(qwtcommand,"setKnobWidth(",13) == 0)
      {
        int w;
        sscanf(qwtcommand,"setKnobWidth(%d",&w);
        wi->setKnobWidth(w);
      }
      else if(strncmp(qwtcommand,"setTotalAngle(",14) == 0)
      {
        double angle;
        sscanf(qwtcommand,"setTotalAngle(%lf",&angle);
        wi->setTotalAngle(angle);
      }
      else if(strncmp(qwtcommand,"setBorderWidth(",15) == 0)
      {
        int bw;
        sscanf(qwtcommand,"setBorderWidth(%d",&bw);
        wi->setBorderWidth(bw);
      }
      else if(strncmp(qwtcommand,"setSymbol(",10) == 0)
      {
        int s;
        sscanf(qwtcommand,"setSymbol(%d",&s);
        wi->setSymbol((QwtKnob::Symbol) s);
      }
      else if(strncmp(qwtcommand,"setValue(",9) == 0)
      {
        double val;
        sscanf(qwtcommand,"setValue(%lf",&val);
        wi->setValue(val);
      }
    }
    else if(all[i]->type == TQwtCounter)
    {
      // QwtCounter
      QwtCounter *wi = (QwtCounter *) all[i]->w;
      if(strncmp(qwtcommand,"setStep(",8) == 0)
      {
        double s;
        sscanf(qwtcommand,"setStep(%lf",&s);
        wi->setStep(s);
      }
      else if(strncmp(qwtcommand,"setMinValue(",12) == 0)
      {
        double m;
        sscanf(qwtcommand,"setMinValue(%lf",&m);
        wi->setMinValue(m);
      }
      else if(strncmp(qwtcommand,"setMaxValue(",12) == 0)
      {
        double m;
        sscanf(qwtcommand,"setMaxValue(%lf",&m);
        wi->setMaxValue(m);
      }
      else if(strncmp(qwtcommand,"setStepButton1(",15) == 0)
      {
        int n;
        sscanf(qwtcommand,"setStepButton1(%d",&n);
        wi->setStepButton1(n);
      }
      else if(strncmp(qwtcommand,"setStepButton2(",15) == 0)
      {
        int n;
        sscanf(qwtcommand,"setStepButton2(%d",&n);
        wi->setStepButton2(n);
      }
      else if(strncmp(qwtcommand,"setStepButton3(",15) == 0)
      {
        int n;
        sscanf(qwtcommand,"setStepButton3(%d",&n);
        wi->setStepButton3(n);
      }
      else if(strncmp(qwtcommand,"setNumButtons(",14) == 0)
      {
        int n;
        sscanf(qwtcommand,"setNumButtons(%d",&n);
        wi->setNumButtons(n);
      }
      else if(strncmp(qwtcommand,"setIncSteps(",12) == 0)
      {
        int btn,n;
        sscanf(qwtcommand,"setIncSteps(%d,%d",&btn,&n);
        wi->setIncSteps((QwtCounter::Button) btn, n);
      }
      else if(strncmp(qwtcommand,"setValue(",9) == 0)
      {
        double val;
        sscanf(qwtcommand,"setValue(%lf",&val);
        wi->setValue(val);
      }
    }
    else if(all[i]->type == TQwtWheel)
    {
      // QwtWheel
      QwtWheel *wi = (QwtWheel *) all[i]->w;
      if(strncmp(qwtcommand,"setMass(",8) == 0)
      {
        float mass;
        sscanf(qwtcommand,"setMass(%f",&mass);
        wi->setMass(w);
      }
      else if(strncmp(qwtcommand,"setOrientation(",15) == 0)
      {
        int o;
        sscanf(qwtcommand,"setOrientation(%d",&o);
        wi->setOrientation((Qt::Orientation) o);
      }
      else if(strncmp(qwtcommand,"setReadOnly(",12) == 0)
      {
        int w;
        sscanf(qwtcommand,"setReadOnly(%d",&w);
        wi->setReadOnly(w);
      }
      else if(strncmp(qwtcommand,"setOrientation(",15) == 0)
      {
        int o;
        sscanf(qwtcommand,"setOrientation(%d",&o);
        wi->setOrientation((Qt::Orientation) o);
      }
      else if(strncmp(qwtcommand,"setTotalAngle(",14) == 0)
      {
        double angle;
        sscanf(qwtcommand,"setTotalAngle(%lf",&angle);
        wi->setTotalAngle(angle);
      }
      else if(strncmp(qwtcommand,"setTickCnt(",11) == 0)
      {
        int cnt;
        sscanf(qwtcommand,"setTickCnt(%d",&cnt);
        wi->setTickCnt(cnt);
      }
      else if(strncmp(qwtcommand,"setViewAngle(",13) == 0)
      {
        double angle;
        sscanf(qwtcommand,"setViewAngle(%lf",&angle);
        wi->setViewAngle(angle);
      }
      else if(strncmp(qwtcommand,"setInternalBorder(",18) == 0)
      {
        int width;
        sscanf(qwtcommand,"setInternalBorder(%d",&width);
        wi->setInternalBorder(width);
      }
      else if(strncmp(qwtcommand,"setMass(",8) == 0)
      {
        double val;
        sscanf(qwtcommand,"setMass(%lf",&val);
        wi->setMass(val);
      }
      else if(strncmp(qwtcommand,"setWheelWidth(",14) == 0)
      {
        int width;
        sscanf(qwtcommand,"setWheelWidth(%d",&width);
        wi->setWheelWidth(width);
      }
      else if(strncmp(qwtcommand,"setValue(",9) == 0)
      {
        double val;
        sscanf(qwtcommand,"setValue(%lf",&val);
        wi->setValue(val);
      }
    }
    else if(all[i]->type == TQwtSlider)
    {
      // QwtSlider
      QwtSlider *wi = (QwtSlider *) all[i]->w;
      if(strncmp(qwtcommand,"setScale(",9) == 0)
      {
        double min,max,step;
        int logarithmic;
        sscanf(qwtcommand,"setScale(%lf,%lf,%lf,%d",&min,&max,&step,&logarithmic);
        wi->setScale(min,max,step,logarithmic);
      }
      else if(strncmp(qwtcommand,"setMass(",8) == 0)
      {
        float mass;
        sscanf(qwtcommand,"setMass(%f",&mass);
        wi->setMass(w);
      }
      else if(strncmp(qwtcommand,"setOrientation(",15) == 0)
      {
        int o;
        sscanf(qwtcommand,"setOrientation(%d",&o);
        wi->setOrientation((Qt::Orientation) o);
      }
      else if(strncmp(qwtcommand,"setReadOnly(",12) == 0)
      {
        int w;
        sscanf(qwtcommand,"setReadOnly(%d",&w);
        wi->setReadOnly(w);
      }
      else if(strncmp(qwtcommand,"setOrientation(",15) == 0)
      {
        int o;
        sscanf(qwtcommand,"setOrientation(%d",&o);
        wi->setOrientation((Qt::Orientation) o);
      }
      else if(strncmp(qwtcommand,"setBgStyle(",11) == 0)
      {
        int st;
        sscanf(qwtcommand,"setBgStyle(%d",&st);
        wi->setBgStyle((QwtSlider::BGSTYLE) st);
      }
      else if(strncmp(qwtcommand,"setScalePos(",12) == 0)
      {
        int st;
        sscanf(qwtcommand,"setScalePos(%d",&st);
        wi->setScalePos((QwtSlider::ScalePos) st);
      }
      else if(strncmp(qwtcommand,"setThumbLength(",15) == 0)
      {
        int l;
        sscanf(qwtcommand,"setThumbLength(%d",&l);
        wi->setThumbLength(l);
      }
      else if(strncmp(qwtcommand,"setThumbWidth(",14) == 0)
      {
        int w;
        sscanf(qwtcommand,"setThumbWidth(%d",&w);
        wi->setThumbWidth(w);
      }
      else if(strncmp(qwtcommand,"setBorderWidth(",15) == 0)
      {
        int bw;
        sscanf(qwtcommand,"setBorderWidth(%d",&bw);
        wi->setBorderWidth(bw);
      }
      else if(strncmp(qwtcommand,"setMargins(",11) == 0)
      {
        int x,y;
        sscanf(qwtcommand,"setMargins(%d,%d",&x,&y);
        wi->setMargins(x,y);
      }
      else if(strncmp(qwtcommand,"setValue(",9) == 0)
      {
        double val;
        sscanf(qwtcommand,"setValue(%lf",&val);
        wi->setValue(val);
      }
    }
    else if(all[i]->type == TQwtCompass)
    {
      // QwtCompass
      QwtCompass *wi = (QwtCompass *) all[i]->w;
      if(strncmp(qwtcommand,"setMass(",8) == 0)
      {
        float mass;
        sscanf(qwtcommand,"setMass(%f",&mass);
        wi->setMass(w);
      }
      else if(strncmp(qwtcommand,"setOrientation(",15) == 0)
      {
        int o;
        sscanf(qwtcommand,"setOrientation(%d",&o);
        wi->setOrientation((Qt::Orientation) o);
      }
      else if(strncmp(qwtcommand,"setReadOnly(",12) == 0)
      {
        int w;
        sscanf(qwtcommand,"setReadOnly(%d",&w);
        wi->setReadOnly(w);
      }
      else if(strncmp(qwtcommand,"setSimpleCompassRose(",21) == 0)
      {
        int numThorns,numThornLevels;
        double width;
        sscanf(qwtcommand,"setSimpleCompassRose(%d,%d,%lf",&numThorns,&numThornLevels,&width);
        QwtSimpleCompassRose *rose = new QwtSimpleCompassRose(numThorns, numThornLevels);
        rose->setWidth(width);
        wi->setRose(rose);
      }
      else if(strncmp(qwtcommand,"setLabelMap(",12) == 0)
      {
        //setLabelMap(const QMap<double, QString> &map);
      }
      else if(strncmp(qwtcommand,"setFrameShadow(",15) == 0)
      {
        int s;
        sscanf(qwtcommand,"setFrameShadow(%d",&s);
        wi->setFrameShadow((QwtDial::Shadow) s);
      }
      else if(strncmp(qwtcommand,"showBackground(",15) == 0)
      {
        int b;
        sscanf(qwtcommand,"showBackground(%d",&b);
        wi->showBackground(b);
      }
      else if(strncmp(qwtcommand,"setLineWidth(",13) == 0)
      {
        int w;
        sscanf(qwtcommand,"setLineWidth(%d",&w);
        wi->setLineWidth(w);
      }
      else if(strncmp(qwtcommand,"setMode(",8) == 0)
      {
        int m;
        sscanf(qwtcommand,"setMode(%d",&m);
        wi->setMode((QwtDial::Mode) m);
      }
      else if(strncmp(qwtcommand,"setWrapping(",12) == 0)
      {
        int w;
        sscanf(qwtcommand,"setWrapping(%d",&w);
        wi->setWrapping(w);
      }
      else if(strncmp(qwtcommand,"setScale(",9) == 0)
      {
        int maxMajIntv,maxMinIntv;
        double step;
        sscanf(qwtcommand,"setScale(%d,%d,%lf",&maxMajIntv,&maxMinIntv,&step);
        wi->setScale(maxMajIntv,maxMinIntv,step);
      }
      else if(strncmp(qwtcommand,"setScaleArc(",12) == 0)
      {
        double min,max;
        sscanf(qwtcommand,"setScaleArc(%lf,%lf",&min,&max);
        wi->setScaleArc(min,max);
      }
      else if(strncmp(qwtcommand,"setOrigin(",10) == 0)
      {
        double o;
        sscanf(qwtcommand,"setOrigin(%lf",&o);
        wi->setOrigin(o);
      }
      else if(strncmp(qwtcommand,"setNeedle(",10) == 0)
      {
        int which,r1,r2,r3,g1,g2,g3,b1,b2,b3;
        sscanf(qwtcommand,"setNeedle(%d,%d,%d,%d,%d,%d,%d,%d,%d,%d",&which,
                                       &r1,&g1,&b1,
                                       &r2,&g2,&b2,
                                       &r3,&g3,&b3);
        if(which==1) wi->setNeedle(new QwtCompassNeedle1(QColor(r1,g1,b1)));
        if(which==2) wi->setNeedle(new QwtCompassNeedle2(QColor(r1,g1,b1),QColor(r2,g2,b2)));
        if(which==3) wi->setNeedle(new QwtCompassNeedle3(QColor(r1,g1,b1),QColor(r2,g2,b2)));
        if(which==4) wi->setNeedle(new QwtCompassNeedle4(QColor(r1,g1,b1),QColor(r2,g2,b2),QColor(r3,g3,b3)));
        if(which==5) wi->setNeedle(new QwtCompassLineNeedle(QColor(r1,g1,b1)));
      }
      else if(strncmp(qwtcommand,"setValue(",9) == 0)
      {
        double val;
        sscanf(qwtcommand,"setValue(%lf",&val);
        wi->setValue(val);
      }
    }
  }
}

void ProcessView::interpretQ(const char *command)
{
  if(strncmp(command,"QWidget(",8) == 0) // create a new QWidget
  {
    sscanf(command,"QWidget(%d,%d)",&i,&p);
    if(i < 0) return;
    if(i >= nmax) return;
    if(p >= nmax) return;
    all[i]->w = new MyQWidget(&s,i,all[p]->w);
    all[i]->type = TQWidget;
  }
  else if(strncmp(command,"QPushButton(",12) == 0) // create a new QPushButton
  {
    sscanf(command,"QPushButton(%d,%d)",&i,&p);
    if(i < 0) return;
    if(i >= nmax) return;
    if(p >= nmax) return;
    all[i]->w = (QWidget *) new MyQPushButton(&s,i,all[p]->w);
    all[i]->type = TQPushButton;
  }
  else if(strncmp(command,"QLabel(",7) == 0) // create a new QLabel
  {
    sscanf(command,"QLabel(%d,%d)",&i,&p);
    if(i < 0) return;
    if(i >= nmax) return;
    if(p >= nmax) return;
    all[i]->w = (QWidget *) new QLabel(all[p]->w);
    all[i]->type = TQLabel;
  }
  else if(strncmp(command,"QLineEdit(",10) == 0) // create a new QLineEdit
  {
    MyLineEdit *ptr;
    sscanf(command,"QLineEdit(%d,%d)",&i,&p);
    if(i < 0) return;
    if(i >= nmax) return;
    if(p >= nmax) return;
    all[i]->w = (QWidget *) new MyLineEdit(codec,&s,i,all[p]->w);
    all[i]->type = TQLineEdit;
    ptr = (MyLineEdit *) all[i]->w;
  }
  else if(strncmp(command,"QComboBox(",10) == 0) // create a new QComboBox
  {
    int editable,policy;
    QComboBox *ptr;
    sscanf(command,"QComboBox(%d,%d,%d,%d)",&i,&p,&editable,&policy);
    if(i < 0) return;
    if(i >= nmax) return;
    if(p >= nmax) return;
    all[i]->w = (QWidget *) new MyComboBox(codec,&s,i,all[p]->w);
    all[i]->type = TQComboBox;

    ptr = (MyComboBox *) all[i]->w;
    if(editable == 1) ptr->setEditable(true);
    if     (policy == 0) ptr->setInsertionPolicy(QComboBox::NoInsertion);
    else if(policy == 1) ptr->setInsertionPolicy(QComboBox::AtTop);
    else if(policy == 2) ptr->setInsertionPolicy(QComboBox::AtCurrent);
    else if(policy == 3) ptr->setInsertionPolicy(QComboBox::AtBottom);
    else if(policy == 4) ptr->setInsertionPolicy(QComboBox::AfterCurrent);
    else if(policy == 5) ptr->setInsertionPolicy(QComboBox::BeforeCurrent);
  }
  else if(strncmp(command,"QLCDNumber(",11) == 0) // create a new QLCDNumber
  {
    uint numDigits,segmentStyle,mode;

    sscanf(command,"QLCDNumber(%d,%d,%d,%d,%d)",&i,&p,&numDigits,&segmentStyle,&mode);
    if(i < 0) return;
    if(i >= nmax) return;
    if(p >= nmax) return;
    all[i]->w = (QWidget *) new QLCDNumber(numDigits,all[p]->w);
    all[i]->type = TQLCDNumber;
    QLCDNumber *ptr = (QLCDNumber *) all[i]->w;
    switch(mode)
    {
      case 0:
        ptr->setMode(QLCDNumber::HEX);
        break;
      case 1:
        ptr->setMode(QLCDNumber::DEC);
        break;
      case 2:
        ptr->setMode(QLCDNumber::OCT);
        break;
      case 3:
        ptr->setMode(QLCDNumber::BIN);
        break;
      default:
        break;
    }
    switch(segmentStyle)
    {
      case 0:
        ptr->setSegmentStyle(QLCDNumber::Outline);
        break;
      case 1:
        ptr->setSegmentStyle(QLCDNumber::Filled);
        break;
      case 2:
        ptr->setSegmentStyle(QLCDNumber::Flat);
        break;
      default:
        break;
    }
  }
  else if(strncmp(command,"QDrawWidget(",12) == 0) // create a new QDrawWidget
  {
    sscanf(command,"QDrawWidget(%d,%d)",&i,&p);
    if(i < 0) return;
    if(i >= nmax) return;
    if(p >= nmax) return;

    all[i]->w = (QWidget *) new QDrawWidget(all[p]->w,0,0,&s,i);
    all[i]->type = TQDraw;
  }
  else if(strncmp(command,"QImage(",7) == 0) // create a new QImage
  {
    int  depth;
    sscanf(command,"QImage(%d,%d,%d,%d,%d",&i,&p,&w,&h,&depth);
    if(i < 0) return;
    if(i >= nmax) return;
    if(p >= nmax) return;
    if(depth == 0) // image format other than 8bpp bmp
    {
      QString filename;
      get_text(command,text); // text = filename of image
      filename = temp + text;
      QImageWidget *imagewidget = new QImageWidget(&s, i, all[p]->w);
      all[i]->w = (QWidget *) imagewidget;
      all[i]->type = TQImage;
      imagewidget->setImage(filename);
      return;
    }
    else if(depth == 8)
    {
      char *data;
      QImage *temp = readBmpFromSocket(w,h,&data);
      if(temp != NULL)
      {
        QImageWidget *imagewidget = new QImageWidget(&s, i, all[p]->w);
        all[i]->w = (QWidget *) imagewidget;
        all[i]->type = TQImage;
        temp->setAlphaBuffer(true);
        imagewidget->setImage(temp);
        if(data != NULL) delete data;
        if(temp != NULL) delete temp;
      }
    }
  }
#ifdef USE_OPEN_GL
  else if(strncmp(command,"QPvGlWidget(",12) == 0) // create a new PvGlWidget
  {
    sscanf(command,"QPvGlWidget(%d,%d)",&i,&p);
    if(i < 0) return;
    if(i >= nmax) return;
    if(p >= nmax) return;
    all[i]->w = (QWidget *) new PvGLWidget(all[p]->w,i,&s);
    all[i]->type = TQGl;
  }
#endif
#ifdef USE_VTK
  else if(strncmp(command,"QVtkTclWidget(",14) == 0) // create a new pvVtkTclWidget
  {
    sscanf(command,"QVtkTclWidget(%d,%d)",&i,&p);
    if(i < 0) return;
    if(i >= nmax) return;
    if(p >= nmax) return;
    all[i]->w = (QWidget *) new pvVtkTclWidget(all[p]->w,"vtkWidget",i,&s);
    all[i]->type = TQVtk;
  }
#endif
  else if(strncmp(command,"QwtPlotWidget(",14) == 0) // create a new QwtPlotWidget
  {
    int nCurves, nMarker;
    sscanf(command,"QwtPlotWidget(%d,%d,%d,%d",&i,&p,&nCurves,&nMarker);
    if(i < 0) return;
    if(i >= nmax) return;
    if(p >= nmax) return;
    all[i]->w = (QWidget *) new QwtPlotWidget(&s,i,all[p]->w,nCurves,nMarker);
    all[i]->type = TQwtPlotWidget;
  }
  else if(strncmp(command,"QwtScale(",9) == 0) // create a new QwtScale
  {
    int pos;
    sscanf(command,"QwtScale(%d,%d,%d",&i,&p,&pos);
    if(i < 0) return;
    if(i >= nmax) return;
    if(p >= nmax) return;
    all[i]->w = (QWidget *) new MyQwtScale(&s,i,(QwtScale::Position) pos, all[p]->w);
    all[i]->type = TQwtScale;
  }
  else if(strncmp(command,"QwtThermo(",10) == 0) // create a new QwtThermo
  {
    sscanf(command,"QwtThermo(%d,%d",&i,&p);
    if(i < 0) return;
    if(i >= nmax) return;
    if(p >= nmax) return;
    all[i]->w = (QWidget *) new MyQwtThermo(&s,i,all[p]->w);
    all[i]->type = TQwtThermo;
  }
  else if(strncmp(command,"QwtKnob(",8) == 0) // create a new QwtKnob
  {
    sscanf(command,"QwtKnob(%d,%d",&i,&p);
    if(i < 0) return;
    if(i >= nmax) return;
    if(p >= nmax) return;
    all[i]->w = (QWidget *) new MyQwtKnob(&s,i,all[p]->w);
    all[i]->type = TQwtKnob;
  }
  else if(strncmp(command,"QwtCounter(",11) == 0) // create a new QwtCounter
  {
    sscanf(command,"QwtCounter(%d,%d",&i,&p);
    if(i < 0) return;
    if(i >= nmax) return;
    if(p >= nmax) return;
    all[i]->w = (QWidget *) new MyQwtCounter(&s,i,all[p]->w);
    all[i]->type = TQwtCounter;
  }
  else if(strncmp(command,"QwtWheel(",9) == 0) // create a new QwtWheel
  {
    sscanf(command,"QwtWheel(%d,%d",&i,&p);
    if(i < 0) return;
    if(i >= nmax) return;
    if(p >= nmax) return;
    all[i]->w = (QWidget *) new MyQwtWheel(&s,i,all[p]->w);
    all[i]->type = TQwtWheel;
  }
  else if(strncmp(command,"QwtSlider(",10) == 0) // create a new QwtSlider
  {
    sscanf(command,"QwtSlider(%d,%d",&i,&p);
    if(i < 0) return;
    if(i >= nmax) return;
    if(p >= nmax) return;
    all[i]->w = (QWidget *) new MyQwtSlider(&s,i,all[p]->w);
    all[i]->type = TQwtSlider;
  }
  else if(strncmp(command,"QwtCompass(",11) == 0) // create a new QwtCompass
  {
    sscanf(command,"QwtCompass(%d,%d",&i,&p);
    if(i < 0) return;
    if(i >= nmax) return;
    if(p >= nmax) return;
    all[i]->w = (QWidget *) new MyQwtCompass(&s,i,all[p]->w);
    all[i]->type = TQwtCompass;
  }
  else if(strncmp(command,"QSlider(",8) == 0) // create a new Slider
  {
    int minValue; int maxValue; int pageStep; int value; int orientation;
    sscanf(command,"QSlider(%d,%d,%d,%d,%d,%d,%d)",&i,&p,&minValue,&maxValue,&pageStep,&value,&orientation);
    if(i < 0) return;
    if(i >= nmax) return;
    if(p >= nmax) return;
    all[i]->w = (QWidget *) new MySlider(&s,i,minValue,maxValue,pageStep,value,(Qt::Orientation) orientation,all[p]->w);
    all[i]->type = TQSlider;
  }
  else if(strncmp(command,"QRadio(",7) == 0) // create a new radio button
  {
    sscanf(command,"QRadio(%d,%d)",&i,&p);
    if(i < 0) return;
    if(i >= nmax) return;
    if(p >= nmax) return;
    all[i]->w = (QWidget *) new MyRadioButton(&s,i,all[p]->w);
    all[i]->type = TQRadio;
  }
  else if(strncmp(command,"QButtonGroup(",13) == 0) // create a new button group
  {
    int columns; int o;
    sscanf(command,"QButtonGroup(%d,%d,%d,%d,",&i,&p,&columns,&o);
    get_text(command,text);
    if(i < 0) return;
    if(i >= nmax) return;
    if(p >= nmax) return;
    all[i]->w = (QWidget *) new MyButtonGroup(&s,i,columns,(Qt::Orientation) o,text,all[p]->w);
    all[i]->type = TQButtonGroup;
  }
  else if(strncmp(command,"QCheckBox(",10) == 0) // create a new check box
  {
    sscanf(command,"QCheckBox(%d,%d)",&i,&p);
    if(i < 0) return;
    if(i >= nmax) return;
    if(p >= nmax) return;
    all[i]->w = (QWidget *) new MyCheckBox(&s,i,all[p]->w);
    all[i]->type = TQCheck;
  }
  else if(strncmp(command,"QFrame(",7) == 0) // create a new frame
  {
    int shape; int shadow; int line_width; int margin;
    sscanf(command,"QFrame(%d,%d,%d,%d,%d,%d)",&i,&p,&shape,&shadow,&line_width,&margin);

    if(i < 0) return;
    if(i >= nmax) return;
    if(p >= nmax) return;
    all[i]->w = (QWidget *) new MyFrame(&s,i,shape,shadow,line_width,margin,all[p]->w);
    all[i]->type = TQFrame;
  }
  else if(strncmp(command,"QTabWidget(",11) == 0) // create a new QTabWidget
  {
    sscanf(command,"QTabWidget(%d,%d)",&i,&p);
    if(i < 0) return;
    if(i >= nmax) return;
    if(p >= nmax) return;
    all[i]->w = (QTabWidget *) new MyQTabWidget(&s,i,all[p]->w);
    all[i]->type = TQTabWidget;
  }
#if QT_VERSION >=0x030201
  else if(strncmp(command,"QToolBox(",9) == 0) // create a new QToolBox
  {
    sscanf(command,"QToolBox(%d,%d)",&i,&p);
    if(i < 0) return;
    if(i >= nmax) return;
    if(p >= nmax) return;
    all[i]->w = (QToolBox *) new MyQToolBox(&s,i,all[p]->w);
    all[i]->type = TQToolBox;
  }
#endif
  else if(strncmp(command,"QGroupBox(",10) == 0) // create a new QGroupBox
  {
    int columns; int o;

    sscanf(command,"QGroupBox(%d,%d,%d,%d,",&i,&p,&columns,&o);
    get_text(command,text);
    if(i < 0) return;
    if(i >= nmax) return;
    if(p >= nmax) return;
    all[i]->w = (QWidget *) new MyGroupBox(&s,i,columns,(Qt::Orientation) o,text,all[p]->w);
    all[i]->type = TQGroupBox;
  }
  else if(strncmp(command,"QListBox(",9) == 0) // create a new QListBox
  {
    sscanf(command,"QListBox(%d,%d",&i,&p);
    if(i < 0) return;
    if(i >= nmax) return;
    if(p >= nmax) return;
    all[i]->w = (QWidget *) new MyListBox(&s,i,all[p]->w);
    all[i]->type = TQListBox;
  }
#if QT_VERSION > 220
  else if(strncmp(command,"QTable(",7) == 0) // create a new QTable
  {
    int row; int col;
    sscanf(command,"QTable(%d,%d,%d,%d",&i,&p,&row,&col);
    if(i < 0) return;
    if(i >= nmax) return;
    if(p >= nmax) return;
    all[i]->w = (QWidget *) new MyTable(&s,i,row,col,all[p]->w);
    all[i]->type = TQTable;
  }
#endif
  else if(strncmp(command,"QSpinBox(",9) == 0) // create a new QSpinBox
  {
    int min; int max; int step;
    sscanf(command,"QSpinBox(%d,%d,%d,%d,%d",&i,&p,&min,&max,&step);
    if(i < 0) return;
    if(i >= nmax) return;
    if(p >= nmax) return;
    all[i]->w = (QWidget *) new MySpinBox(&s,i,min,max,step,all[p]->w);
    all[i]->type = TQSpinBox;
  }
  else if(strncmp(command,"QDial(",6) == 0) // create a new QDial
  {
    int min; int max; int pageStep; int value;

    sscanf(command,"QDial(%d,%d,%d,%d,%d,%d",&i,&p,&min,&max,&pageStep,&value);
    if(i < 0) return;
    if(i >= nmax) return;
    if(p >= nmax) return;
    all[i]->w = (QWidget *) new MyDial(&s,i,min,max,pageStep,value,all[p]->w);
    all[i]->type = TQDial;
  }
  else if(strncmp(command,"QProgressBar(",13) == 0) // create a new QProgressBar
  {
    int totalSteps;
    sscanf(command,"QProgressBar(%d,%d,%d",&i,&p,&totalSteps);
    if(i < 0) return;
    if(i >= nmax) return;
    if(p >= nmax) return;
    all[i]->w = (QWidget *) new MyProgressBar(&s,i,totalSteps,all[p]->w);
    all[i]->type = TQProgressBar;
  }
  else if(strncmp(command,"QMultiLineEdit(",15) == 0) // create a new QMultiLineEdit
  {
    int editable,maxLines;
    sscanf(command,"QMultiLineEdit(%d,%d,%d,%d",&i,&p,&editable,&maxLines);
    if(i < 0) return;
    if(i >= nmax) return;
    if(p >= nmax) return;
    all[i]->w = (QWidget *) new MyMultiLineEdit(&s,i,editable,maxLines,all[p]->w);
    all[i]->type = TQMultiLineEdit;
  }
  else if(strncmp(command,"QTextBrowser(",13) == 0) // create a new QTextBrowser
  {
    sscanf(command,"QTextBrowser(%d,%d",&i,&p);
    if(i < 0) return;
    if(i >= nmax) return;
    if(p >= nmax) return;
    all[i]->w = (QWidget *) new MyTextBrowser(codec,&s,i,all[p]->w);
    all[i]->type = TQTextBrowser;
  }
  else if(strncmp(command,"QListView(",10) == 0) // create a new QListView
  {
    sscanf(command,"QListView(%d,%d",&i,&p);
    if(i < 0) return;
    if(i >= nmax) return;
    if(p >= nmax) return;
    all[i]->w = (QWidget *) new MyListView(&s,i,all[p]->w);
    all[i]->type = TQListView;
  }
  else if(strncmp(command,"QIconView(",10) == 0) // create a new QIconView
  {
    sscanf(command,"QIconView(%d,%d",&i,&p);
    if(i < 0) return;
    if(i >= nmax) return;
    if(p >= nmax) return;
    all[i]->w = (QWidget *) new MyIconView(codec,&s,i,all[p]->w);
    all[i]->type = TQIconView;
  }
  else if(strncmp(command,"QDateEdit(",10) == 0) // create a new QDateEdit
  {
    sscanf(command,"QDateEdit(%d,%d",&i,&p);
    if(i < 0) return;
    if(i >= nmax) return;
    if(p >= nmax) return;
    all[i]->w = (QWidget *) new MyQDateEdit(&s,i,all[p]->w);
    all[i]->type = TQDateEdit;
  }
  else if(strncmp(command,"QTimeEdit(",10) == 0) // create a new QTimeEdit
  {
    sscanf(command,"QTimeEdit(%d,%d",&i,&p);
    if(i < 0) return;
    if(i >= nmax) return;
    if(p >= nmax) return;
    all[i]->w = (QWidget *) new MyQTimeEdit(&s,i,all[p]->w);
    all[i]->type = TQTimeEdit;
  }
  else if(strncmp(command,"QDateTimeEdit(",14) == 0) // create a new QDateTimeEdit
  {
    sscanf(command,"QDateTimeEdit(%d,%d",&i,&p);
    if(i < 0) return;
    if(i >= nmax) return;
    if(p >= nmax) return;
    all[i]->w = (QWidget *) new MyQDateTimeEdit(&s,i,all[p]->w);
    all[i]->type = TQDateTimeEdit;
  }
  else if(strncmp(command,"QToolTip(",9) == 0) // create a new QToolTip
  {
    sscanf(command,"QToolTip(%d",&i);
    if(i < 0) return;
    if(i >= nmax) return;
    get_text(command,text);
    QToolTip::add(all[i]->w,text);
  }
  else if(strncmp(command,"QLayoutVbox(",12) == 0) // vbox layout
  {
    sscanf(command,"QLayoutVbox(%d,%d",&i,&p);
    if(i < 0) return;
    if(i >= nmax) return;
    if(p >= nmax) return;
    if(i == 0)
    {
      mainLayout = (QWidget *) new QVBoxLayout(all[0]->w);
      mainLayoutType = TQVbox;
      ((QVBoxLayout *) mainLayout)->setMargin(11);
      ((QVBoxLayout *) mainLayout)->setSpacing(6);
    }
    else
    {
      all[i]->w = (QWidget *) new QVBoxLayout;
      all[i]->type = TQVbox;
    }
    hasLayout = 1;
  }
  else if(strncmp(command,"QLayoutHbox(",12) == 0) // hbox layout
  {
    sscanf(command,"QLayoutHbox(%d,%d",&i,&p);
    if(i < 0) return;
    if(i >= nmax) return;
    if(p >= nmax) return;
    if(i == 0)
    {
      mainLayout = (QWidget *) new QHBoxLayout(all[0]->w);
      mainLayoutType = TQHbox;
      ((QHBoxLayout *) mainLayout)->setMargin(11);
      ((QHBoxLayout *) mainLayout)->setSpacing(6);
    }
    else
    {
      all[i]->w = (QWidget *) new QHBoxLayout;
      all[i]->type = TQHbox;
    }
    hasLayout = 1;
  }
  else if(strncmp(command,"QLayoutGrid(",12) == 0) // grid layout
  {
    sscanf(command,"QLayoutGrid(%d,%d",&i,&p);
    if(i < 0) return;
    if(i >= nmax) return;
    if(p >= nmax) return;
    if(i == 0)
    {
      mainLayout = (QWidget *) new QGridLayout(all[0]->w);
      mainLayoutType = TQGrid;
      ((QGridLayout *) mainLayout)->setMargin(11);
      ((QGridLayout *) mainLayout)->setSpacing(6);
    }
    else
    {
      all[i]->w = (QWidget *) new QGridLayout;
      all[i]->type = TQGrid;
    }
    hasLayout = 1;
  }

  //if(i>0 && i<nmax)
  //{
  //  all[i]->w->setBackgroundMode(Qt::PaletteBackground);
  //}

  if(zoom != 100)
  {
    QFont font = qApp->font();
    font.setPointSize((font.pointSize()*zoom)/100);
    all[i]->w->setFont(font);
  }
}
