/***************************************************************************
                          processview.h  -  description
                             -------------------
    begin                : Sam Nov 11 07:41:57 CET 2000
    copyright            : (C) 2000 by Rainer Lehrig
    email                : lehrig@t-online.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef PROCESSVIEW_H
#define PROCESSVIEW_H

// include files for QT
#include <qstring.h>
#include <qpopupmenu.h>
#include <qmainwindow.h>
#include <qaccel.h>
#include <qmenubar.h>
#include <qtoolbar.h>
#include <qpixmap.h>
#include <qtoolbutton.h>
#include <qapp.h>
#include <qstatusbar.h>
#include <qwhatsthis.h>
#include <qmsgbox.h>
#include <qfiledialog.h>
#include <qprinter.h>
#include <qpainter.h>
#include <qcombobox.h>
#include <qlabel.h>
#include <qsocketnotifier.h>
#include <qimage.h>
#include <qscrollview.h>
#include <qsize.h>
#include <qclipboard.h>
#include <qdialog.h>
#include <qtimer.h>
#include <qlcdnumber.h>
#include <qtooltip.h>
#include <qtextcodec.h>

// application specific includes
#include "qimagewidget.h"
#include "qdrawwidget.h"
#include "pvglwidget.h"
#include "MyWidgets.h"
#ifndef NO_VTK
#include "pvVtkTclWidget.h"
#endif
#include "qwtplotwidget.h"
#include "dlgopt.h"
#include "resource.h"
#include "view.h"

#ifdef unix
//#define USE_SOCKET_NOTIFIER   // windows has some problems with QSocketNotifier
#endif

enum
{
TQWidget = 0,
TQPushButton,
TQLabel,
TQLineEdit,
TQComboBox,
TQLCDNumber,
TQButtonGroup,
TQRadio,
TQCheck,
TQSlider,
TQFrame,
TQImage,
TQDraw,
TQGl,
TQTabWidget,
TQGroupBox,
TQListBox,
TQTable,
TQSpinBox,
TQDial,
TQProgressBar,
TQMultiLineEdit,
TQTextBrowser,
TQListView,
TQIconView,
TQVtk,
TQwtPlotWidget,
TQwtScale,
TQwtThermo,
TQwtKnob,
TQwtCounter,
TQwtWheel,
TQwtSlider,
TQwtCompass,
TQDateEdit,
TQTimeEdit,
TQDateTimeEdit,
TQToolBox,
TQVbox,
TQHbox,
TQGrid
};

typedef struct
{
  QWidget *w;
  int     type;
}ALL;

/**
  * This Class is the base class for your application. It sets up the main
  * window and providing a menubar, toolbar
  * and statusbar. For the main view, an instance of class ProcessViewView is
  * created which creates your view.
  */
class ProcessView : public QMainWindow
{
  Q_OBJECT
  
  public:
    /** construtor */
    ProcessView(QWidget *parent = 0, const char *name = 0, WFlags f = WType_TopLevel );
    /** destructor */
    ~ProcessView();
    /** initMenuBar creates the menu_bar and inserts the menuitems */
    void initMenuBar();
    /** this creates the toolbars. Change the toobar look and add new toolbars in this
     * function */
    void initToolBar();
    /** setup the statusbar */
    void initStatusBar();
    /** setup the document*/
    void initDoc();
    /** setup the mainview*/
    void initView();
  
    /** overloaded for Message box on last window exit */
    bool queryExit();

    /** set path where program is installed */
    void setPath(const char *p);
    /** read initialization file */
    void readIniFile();
    /** read initialization file */
    void readCustomlogoFromIniFile();
    /** append host to ini file */
    void appendIniFile(const char *host);
    /** add host to recent file list */
    void add_host(const char *host);
    /** test if host was supplied in commandline */
    int  hostSuppliedInCommandline();

    /** stop the splash picture */
    void stopSplash();

    /** the main view window */
    //View *view;
    MyQWidget   *view;
    QScrollView *scroll;
    int s,port,sshport;
    int initFullScreen, initShowMaximized;

  public slots:
  
    /** switch argument for Statusbar help entries on slot selection */
    void statusCallback(int id_);
    /** open a new application window */

    /** set options of ProcessViewBrowser */
    void slotFileOpt();
    /** log pvm metafiles to disk */
    void slotMetaFileLog();
    /** log bmp metafiles to disk */
    void slotMetaFileBmp();
    /** save view as GIF */
    void slotFileSaveAs();
    /** print the view */
    void slotFilePrint();
    /** exits the application */
    void slotFileQuit();
    /** put the marked text/object into the clipboard*/
    void slotEditCopy();
    /** toggle the toolbar*/
    void slotViewToolBar();
    /** toggle the statusbar*/
    void slotViewStatusBar();
    /** toggle full screen */
    void slotShowFullScreen();

    /** show booklet */
    void slotHelpBooklet();
    /** show manual */
    void slotHelpManual();
    /** shows an about dlg*/
    void slotHelpAbout();

    /** change the status message of the whole statusbar temporary */
    void slotStatusHelpMsg(const QString &text);

    void slotRecentUrls(const QString &url);

  protected:
    virtual void keyPressEvent(QKeyEvent *e);
    bool eventFilter( QObject *o, QEvent *e );
    
  private slots:
    void slotUrl();

    /** socket communication */
    void dataReceived();
    void dataError();
    void timeOut();
    void selectSocket();
    void newProcessView();
    
    /** splash picture */
    void timeoutSplash();
  private:
    void interpreta(const char *command);
    void interpretb(const char *command);
    void interpretc(const char *command);
    void interpretd(const char *command);
    void interprete(const char *command);
    void interpretf(const char *command);
    void interpretg(const char *command);
    void interpreth(const char *command);
    void interpreti(const char *command);
    void interpretm(const char *command);
    void interpretp(const char *command);
    void interpretr(const char *command);
    void interprets(const char *command);
    void interprett(const char *command);
    void interpretv(const char *command);
    void interpretq(const char *command);
    void interpretQ(const char *command);
    void getLanguageParam(QString &line, QString &phrase);
    int  getLanguage();
    int  get_text(const char *c, QString &t);
    void popupMenu(int id_return, const char *menu);
    /** read a bitmap file from socket */
    QImage *readBmpFromSocket(int w, int h, char **d);
    /** file_menu contains all items of the menubar entry "File" */
    QPopupMenu *fileMenu;
    /** edit_menu contains all items of the menubar entry "Edit" */
    QPopupMenu *editMenu;
    /** view_menu contains all items of the menubar entry "View" */
    QPopupMenu *viewMenu;
    /** view_menu contains all items of the menubar entry "Help" */
    QPopupMenu *helpMenu;
    /** our toolbar */
    QToolBar *fileToolbar;
    /* recent uls */
    QComboBox *recent_urls;
    /** info about all widgets */
    ALL **all;
    ALL **allBase;
    ALL **allModal;
    QWidget *mainLayout;
    int      mainLayoutType, hasLayout;

    QTimer *timer;
#ifdef USE_SOCKET_NOTIFIER
    QSocketNotifier *sn;
    QSocketNotifier *snerror;
#else
    QTimer *socketTimer;
#endif
    //View *v;
    MyQWidget *v;
    MyDialog *modalDialog;
    int  nmax;
    int  nmaxBase;
    int  nmaxModal;
    char path[1024];
    int  itoolbar, istatusbar;
    QString temp;
    QString inifile;
    QString passfile;
    QString booklet,help;
    QString inihost;
    QString currenthost;
    QString customlogo;
    void interpret(const char *command);
    void downloadFile(const char *file);
    void initSplash();
    QTimer  *splashTimer;
    QDialog *splashDlg;
    int fullScreen;
    int disable;
    int autoreconnect;
    int scrollbars;
    int menubar;
    int exitpassword;
    QTextCodec *codec;
    QString newwindow;
    QString ssh_command;
    int isReconnect;
    // variables for interpretx
    int  i,p,n,x,y,w,h,r,g,b,zoom,zoom_original;
    QString text;
    time_t timet; // remote file time for caching
};

#endif

