/***************************************************************************
                          pvtcl.cpp  -  description
                             -------------------
    begin                : Mon Jun 10 2002
    copyright            : (C) 2002 by Rainer Lehrig
    email                : lehrig@t-online.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "pvVtkTclWidget.h"
#include "tcputil.h"
#include <stdarg.h>

pvVtkTclWidget::pvVtkTclWidget(QWidget *parent, const char *name, int Id, int *sock) : vtkQGLWidget(parent,name)
{
  int error;
  vtkRenderer *temp0;
  
  interp = Tcl_CreateInterp();
  tclcommand = vtkTclCommand::New();
  tclcommand->SetInterp(interp);
  Tcl_AppInit(interp);
  interpret("package require vtk");
  interpret("package require vtkinteraction");
  interpret("package require vtktesting");
  interpret("vtkRenderer renderer4");
  interpret("vtkRenderer renderer3");
  interpret("vtkRenderer renderer2");
  interpret("vtkRenderer renderer");
  // create sandbox
  if(Tcl_DeleteCommand(interp,"eof")       == -1) printf("could not delete Tcl eof\n");
  if(Tcl_DeleteCommand(interp,"fblocked")  == -1) printf("could not delete Tcl fblocked\n");
  if(Tcl_DeleteCommand(interp,"gets")      == -1) printf("could not delete Tcl gets\n");
  if(Tcl_DeleteCommand(interp,"fcopy")     == -1) printf("could not delete Tcl fcopy\n");
  if(Tcl_DeleteCommand(interp,"close")     == -1) printf("could not delete Tcl close\n");
  if(Tcl_DeleteCommand(interp,"read")      == -1) printf("could not delete Tcl read\n");
  if(Tcl_DeleteCommand(interp,"seek")      == -1) printf("could not delete Tcl seek\n");
  if(Tcl_DeleteCommand(interp,"flush")     == -1) printf("could not delete Tcl flush\n");
  if(Tcl_DeleteCommand(interp,"fileevent") == -1) printf("could not delete Tcl fileevent\n");
  if(Tcl_DeleteCommand(interp,"puts")      == -1) printf("could not delete Tcl puts\n");
  if(Tcl_DeleteCommand(interp,"tell")      == -1) printf("could not delete Tcl tell\n");
  if(Tcl_DeleteCommand(interp,"pid")       == -1) printf("could not delete Tcl pid\n");
  
  error = 0;
  temp0 = (vtkRenderer *)(vtkTclGetPointerFromObject("renderer4",(char *) "vtkRenderer",interp,error));
  if(!error)
  {
    this->AddRenderer(temp0);
    Tcl_ResetResult(interp);
  }
  error = 0;
  temp0 = (vtkRenderer *)(vtkTclGetPointerFromObject("renderer3",(char *) "vtkRenderer",interp,error));
  if(!error)
  {
    this->AddRenderer(temp0);
    Tcl_ResetResult(interp);
  }
  error = 0;
  temp0 = (vtkRenderer *)(vtkTclGetPointerFromObject("renderer2",(char *) "vtkRenderer",interp,error));
  if(!error)
  {
    this->AddRenderer(temp0);
    Tcl_ResetResult(interp);
  }
  error = 0;
  temp0 = (vtkRenderer *)(vtkTclGetPointerFromObject("renderer",(char *) "vtkRenderer",interp,error));
  if(!error)
  {
    this->AddRenderer(temp0);
    Tcl_ResetResult(interp);
  }
  id = Id;
  s  = sock;
  glFlush();
  glFinish();
}

pvVtkTclWidget::~pvVtkTclWidget()
{
  interpret("vtkCommand DeleteAllObjects");
  tclcommand->Delete();
  Tcl_DeleteInterp(interp);
#ifndef unix // will be deleted in base class
  RemoveRenderer(renderer);
#endif
}

void pvVtkTclWidget::interpret(const char *format, ...)
{
  int estimated_length, ret;
  va_list ap;

  estimated_length = strlen(format) + 4096;
  char *buf = new char[estimated_length];

  va_start(ap,format);
  ret = vsprintf(buf, format, ap);
  va_end(ap);
  if(ret > 0)
  {
    tclcommand->SetStringCommand(buf);
    tclcommand->Execute(NULL, 0, NULL);
  }

  delete [] buf;
  glFlush();
  glFinish();
}

void pvVtkTclWidget::interpretFile(const char *filename)
{
  char buf[1024];

  strcpy(buf,filename);
  Tcl_EvalFile(interp,buf);
  glFlush();
  glFinish();
}

/*
void pvVtkTclWidget::mousePressEvent(QMouseEvent *e)
{
  if(e->button() == RightButton)
  {
    char buf[80];

    sprintf(buf,"QMouseRight(%d)\n",id);
    tcp_send(s,buf,strlen(buf));
  }
}                 
*/

