/***************************************************************************
                          qwtplotwidget.h  -  description
                             -------------------
    begin                : Mon Mai 26 2003
    copyright            : (C) 2003 by Rainer Lehrig
                         : Angel Maza
    email                : lehrig@t-online.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef QWTPLOTWIDGET_H
#define QWTPLOTWIDGET_H

#include <qwidget.h>
#include <qwt_plot.h>
#include <qdatetime.h>
#include <time.h>

/**
  *@author Rainer Lehrig
  */

class QwtPlotWidget : public QwtPlot
{
  Q_OBJECT
  public:
    QwtPlotWidget(int *sock, int ident, QWidget *parent, int numberCurves=10, int numberMarker=1000);
    ~QwtPlotWidget();
    int interpret(const char *command, double *x=NULL, double *y=NULL);

  private:
    int getText(const char *str, char *text, int maxlength);
    int isCommand(const char *command);
    const char *line;
    int  nMarker;
    int  nCurves;
    long *curves;
    long *marker;
    int *s,id;
  public slots:
    void slotMouseMoved( const QMouseEvent& );
    void slotMousePressed( const QMouseEvent& );
    void slotMouseReleased( const QMouseEvent& );
};

class UserScaleDraw: public QwtScaleDraw
{
public:
  UserScaleDraw(char * text)
  {
    setLabelRotation(-50.0);
    setLabelAlignment(Qt::AlignLeft | Qt::AlignBottom);
    strcpy( out, text );
  }

  virtual QString label(double v) const
  {
    time_t curtime;
//  struct tm *loctime;
//  char time[1024];
    curtime = (int) v;
    QDateTime qdt;
    qdt.setTime_t( curtime );
//  loctime = localtime( &curtime );
//  return qdt.toString( "yyyy-MM-dd \n hh:mm:ss" );
    return qdt.toString( out );
  }
private:
  char out[1024];
};

#endif
