//******************************************************
//
// Filename: vtkQGLRenderWindow.h
//
// Author: Jan Ehrhardt
// Email : ehrhardt@medinf.mu-luebeck.de
//
// Description: von vtkRenderWindow abgeleitete Klasse 
// als Schnittstelle zwischen Qt und VTK
// mit AddRenderer koennen vtkRenderer Objekte in diesem
// fenster gerendert werden,
// derzeit wird aber nur ein Renderer pro Fenster unterstuetzt
//
// Teile des Programms entsprechenden Methoden von
// vtkOpenGLRenderWindow
//              
//******************************************************
// Copyright (C) 1998 Jan Ehrhardt
//
// You can use, copy and distribute this software for all non-commercial purposes,
// provided the copyright notices and this notice are included in all copies and
// distributions.
// You have permission to modify the software, provided that modifications are not 
// distributed outside your site and that existing copyright notices are included in all copies. 
// For commercial purposes and modifications to be included into the software please
// contact the author. 
//
// WE MAKE NO WARRANTY THAT THIS PACKAGE IS FREE OF CONCEPTUAL OR PROGRAMMING ERRORS.
// THE AUTHORS ARE NOT RESPONSIBLE FOR ANY DATA LOSS OR EQUIPMENT DAMAGE RESULTING FROM 
// THE USE OR MISUSE OF THIS SOFTWARE. THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, 
// THERE IS NO KIND OF SUPPORT AND MAINTENANCE.
//
//
//******************************************************
// RCS - Info:
//
// $Id: vtkQGLRenderWindow.h,v 1.1.1.1 2003/07/24 08:16:25 lehrig Exp $
// $Log: vtkQGLRenderWindow.h,v $
// Revision 1.1.1.1  2003/07/24 08:16:25  lehrig
// Version 1.7
//
// Revision 1.1.1.1  2003/02/04 13:46:02  lehrig
// This is ProcessViewBrowser + ProcessViewServer Version 1.5
// Checked in on 04.feb.2003
//
// Revision 1.2  1999/01/25 08:48:46  ehrhardt
// *** empty log message ***
//
// Revision 1.1  1998/10/22 15:16:01  ehrhardt
// Initial revision
//
//

#ifndef _vtkQGLRenderWindow_h_
#define _vtkQGLRenderWindow_h_

#ifdef _WIN32
#define BookVTK40
#endif

#include "vtkRenderWindow.h"
#include "vtkOpenGLRenderWindow.h"

class vtkQGLWidget;

class VTK_EXPORT MyRenderWindow : public vtkOpenGLRenderWindow
{
public:
  virtual void SetDisplayId(void *) {};
  virtual void SetWindowId(void *)  {};
  virtual void SetParentId(void *)  {};
  virtual void *GetGenericDisplayId() { return (void *) NULL; };
  virtual void *GetGenericWindowId() { return (void *) NULL; };
  virtual void *GetGenericParentId() { return (void *) NULL; };
  virtual void *GetGenericContext() { return (void *) NULL; };
  virtual void *GetGenericDrawable() { return (void *) NULL; };    
  virtual void SetWindowInfo(char *) {};
  virtual void SetParentInfo(char *) {};
  virtual void SetNextWindowId(void *) {};
  virtual void SetNextWindowInfo(char *) {};
  virtual void Start() {};
  virtual void Frame() {};
  virtual void MakeCurrent() {};
  virtual void HideCursor() {};
  virtual void ShowCursor() {};
  virtual void SetFullScreen(int) {};
  virtual void WindowRemap() {};
  virtual int  GetEventPending() { return 0; };  
  MyRenderWindow()  {};
  MyRenderWindow(vtkQGLWidget *widget)  {};
  //MyRenderWindow(const MyRenderWindow&) {};
  ~MyRenderWindow() {};
};

class VTK_EXPORT vtkQGLRenderWindow : public MyRenderWindow
{
public:
  vtkQGLRenderWindow(vtkQGLWidget *widget);
  ~vtkQGLRenderWindow();
  static vtkQGLRenderWindow *New(vtkQGLWidget *widget) {return (vtkQGLRenderWindow *) new MyRenderWindow(widget);};
  const char *GetClassName() {return "vtkQGLRenderWindow";};
  void PrintSelf(ostream& os, vtkIndent indent);

  // Initialize the window
  void Initialize();
  int IsInitialized() {return bInitialized;}
  
  void Start(void);
  void Frame(void);

  // Fullscreen mode not supported
  virtual void SetFullScreen(int arg);
  void PrefFullScreen(void);
  
  // sollte nicht verwendet werden, benutze 
  // resize() des vtkQGLWidget
  void SetSize(int,int);
  void SetSize(int s[2]) {SetSize(s[0],s[1]);};
  
  //stereo rendering stuff
  virtual void StereoUpdate();

  // Set/Get the pixel data of an image, transmitted as RGBRGB... 
  virtual unsigned char *GetPixelData(int x,int y,int x2,int y2,int front);
#ifdef BookVTK40
  virtual void SetPixelData(int x,int y,int x2,int y2,unsigned char *,int front);
#else
  virtual int  SetPixelData(int x,int y,int x2,int y2,unsigned char *,int front);
#endif
    
  // Set/Get the pixel data of an image, transmitted as RGBARGBA... 
  virtual float *GetRGBAPixelData(int x,int y,int x2,int y2,int front);
#ifdef BookVTK40
  virtual void SetRGBAPixelData(int x,int y,int x2,int y2,float *,int front,
                                int blend=0);
#else
  virtual int  SetRGBAPixelData(int x,int y,int x2,int y2,float *,int front,
                                int blend=0);
#endif                                
  // Set/Get the zbuffer data from an image
  virtual float *GetZbufferData( int x1, int y1, int x2, int y2 );
#ifdef BookVTK40
  virtual void SetZbufferData( int x1, int y1, int x2, int y2, float *buffer );
#else
  virtual int  SetZbufferData( int x1, int y1, int x2, int y2, float *buffer );
#endif

  void MakeCurrent();

protected:
  int bInitialized;
  vtkQGLWidget *m_qglWidget; // do you need this ?

};

#endif


