//******************************************************
//
// Filename: vtkQGLWidget.h
//
// Author: Jan Ehrhardt 
// Email : ehrhardt@medinf.mu-luebeck.de
//
// Description: Qt-Widget class to incorporate a VTK Renderwindow
//              
//******************************************************
// Copyright (C) 1998 Jan Ehrhardt
//
// This program is free software; you can redistribute it and/or modify it 
// under the terms of the GNU General Public License as published by the 
// Free Software Foundation version 2.. 
//
// This program is distributed in the hope that it will be useful, but 
// WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY 
// or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License 
// for more details. 
// 
//******************************************************
// RCS - Info:
//
// $Id: vtkQGLWidget.h,v 1.1.1.1 2003/07/24 08:16:25 lehrig Exp $
// $Log: vtkQGLWidget.h,v $
// Revision 1.1.1.1  2003/07/24 08:16:25  lehrig
// Version 1.7
//
// Revision 1.1.1.1  2003/02/04 13:46:02  lehrig
// This is ProcessViewBrowser + ProcessViewServer Version 1.5
// Checked in on 04.feb.2003
//
// Revision 1.3  1999/07/09 13:38:00  ehrhardt
// Updated for VTK version 2.3
//
// Revision 1.2  1999/01/25 08:48:46  ehrhardt
// *** empty log message ***
//
// Revision 1.1  1998/10/22 15:16:01  ehrhardt
// Initial revision
//
//

#ifndef _VTKQGLWIDGET_H
#define _VTKQGLWIDGET_H

#include <qgl.h>
#include "vtkQGLRenderWindow.h"
#include "vtkConeSource.h"
#include "vtkPolyDataMapper.h"
#include "vtkRenderer.h"
#include "vtkRendererCollection.h"

// lets define the different types of stereo
#define VTK_STEREO_CRYSTAL_EYES 1
#define VTK_STEREO_RED_BLUE     2
#define VTK_STEREO_INTERLACED   3
#define VTK_STEREO_LEFT         4
#define VTK_STEREO_RIGHT        5

class vtkQGLWidget : public QGLWidget
{
  Q_OBJECT
    
public:
  
  vtkQGLWidget( QWidget* parent, const char* name );
  ~vtkQGLWidget();
  
  // add and remove a renderer
  void AddRenderer(vtkRenderer *ren);
  void RemoveRenderer(vtkRenderer *ren);

  // returns the first added renderer
  // if you havent already added a renderer, a new
  // renderer will be created, added and returned
  vtkRenderer *GetRenderer();

  // get all actual added Renderers
  vtkRendererCollection *GetRenderers() {
    return GetRenderWindow()->GetRenderers();};

  // if a updateGL call occurs while update is blocked
  // updateNeeded flag is set and after the last
  // unblockUpdate is called a Rendering occurs
  void setUpdateNeeded(bool needed) {m_UpdateNeeded = needed;};
  bool updateNeeded(){return m_UpdateNeeded;};

  // block and unblock the Re-Rendering
  // use this to avoid unnecessary Renderings
  // caused by signals connected with updateGL
  // the blockUpdate and unblockUpdate incr or decr
  void blockUpdate();
  void unblockUpdate();
  bool updateBlocked() {return (m_UpdateBlockCount > 0);};

  // control stereo rendering
  int GetStereoRender();
  void SetStereoRender(int);
  void StereoRenderOn()
    {this->SetStereoRender(1);};
  void StereoRenderOff()
    {this->SetStereoRender(0);};
  int GetStereoType();
  void SetStereoType(int);
  void SetStereoTypeToCrystalEyes()
    {this->SetStereoType(VTK_STEREO_CRYSTAL_EYES);};
  void SetStereoTypeToRedBlue()
    {this->SetStereoType(VTK_STEREO_RED_BLUE);};
  void SetStereoTypeToInterlaced()
    {this->SetStereoType(VTK_STEREO_INTERLACED);};
  void SetStereoTypeToLeft()
    {this->SetStereoType(VTK_STEREO_LEFT);};
  void SetStereoTypeToRight()
    {this->SetStereoType(VTK_STEREO_RIGHT);};

virtual void makeCurrent();

public slots:
  void updateGL();

protected:
  vtkRenderWindow *GetRenderWindow() {return m_RenderWindow;};
  // virtual void mousePressEvent(QMouseEvent *e);

  void paintGL();
  void resizeGL( int w, int h );
  //  void resizeEvent(QResizeEvent * );

  vtkRenderer *CreateDefaultRenderer();  


private:
  int m_UpdateBlockCount;
  bool m_UpdateNeeded;
  bool m_bRenWinIsInitialized;

  vtkRenderWindow *m_RenderWindow;
  vtkRenderer *m_Renderer;
};

inline void vtkQGLWidget::updateGL()
{
  if(updateBlocked()) 
    {
      setUpdateNeeded(TRUE);
    }
  else
    {
      QGLWidget::updateGL();
    }
}

#endif // VTKQGLWIDGET_H
