/***************************************************************************
 *   Copyright (C) 2005 by Rainer Lehrig                                   *
 *   lehrig@t-online.de                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "dlgdaemon.h" 
#include <qpushbutton.h>
#include <qtextedit.h>   
#include <qfile.h>
#include <qtextstream.h>
#ifdef _WIN32
#include <process.h>
#endif
    
dlgDaemon::dlgDaemon(int _what,QWidget* parent, const char* name)
          :mkdaemon(parent,name)
{
  what = _what;
  QObject::connect(pushButtonCompile,SIGNAL(clicked()),SLOT(slotCompile()));
  QObject::connect(pushButtonCancel, SIGNAL(clicked()),SLOT(reject()));
  QObject::connect(pushButtonClose,  SIGNAL(clicked()),SLOT(slotClose()));
  switch(what)
  {
    case PPI_DAEMON:
      load("ppidaemon.mkppi");
      break;
    case SIEMENSTCP_DAEMON:
      load("siemensdaemon.mksiemens");
      break;
    case MODBUS_DAEMON:
      load("modbusdaemon.mkmodbus");
      break;
    default:  
      break;
  }
}

dlgDaemon::~dlgDaemon()
{
}

QString dlgDaemon::run()
{
  exec();
  return "";
}

void dlgDaemon::slotCompile()
{
  int ret = 0;
  save();
  generate();
  switch(what)
  {
    case PPI_DAEMON:
#ifdef unix
      ret = system("xterm -e \"g++ ppidaemon.cpp -o ppidaemon -I/usr/local/include/rllib -L/usr/lib/ /usr/lib/librllib.so /usr/lib/libpthread.so;echo compiler_finished;read\"");
#else
      ret = system("pvb_make_ppidaemon.bat");
#endif      
      break;
    case SIEMENSTCP_DAEMON:
#ifdef unix    
      ret = system("xterm -e \"g++ siemensdaemon.cpp -o siemensdaemon -I/usr/local/include/rllib -L/usr/lib/ /usr/lib/librllib.so /usr/lib/libpthread.so;echo compiler_finished;read\"");
#else
      ret = system("pvb_make_siemensdaemon.bat");
#endif
      break;
    case MODBUS_DAEMON:
#ifdef unix
      ret = system("xterm -e \"g++ modbusdaemon.cpp -o modbusdaemon -I/usr/local/include/rllib -L/usr/lib/ /usr/lib/librllib.so /usr/lib/libpthread.so;echo compiler_finished;read\"");
#else
      ret = system("pvb_make_modbusdaemon.bat");
#endif
      break;
    default:
      break;
  }
  if(ret < 0) return;
}

void dlgDaemon::slotClose()
{
  save();
  slotCompile();
  accept();
}

void dlgDaemon::load(QString name)
{
  filename = name;
  e->clear();
  QFile f(filename);
  if(f.open(IO_ReadOnly)) 
  { 
    QTextStream ts( &f );
    e->setText( ts.read() );
  }
  else  
  {
    switch(what)
    {
      case PPI_DAEMON:
        e->append("############################################\n");
        e->append("# Project file for generating ppi daemon   #\n");
        e->append("# mkppi name.mkppi                         #\n");
        e->append("############################################\n");
        e->append("shared_memory=/srv/automation/shm/ppi.shm\n");
        e->append("mailbox=/srv/automation/mbx/ppi.mbx\n");
        e->append("tty=/dev/ttyS0\n");
        e->append("baudrate=9600\n");
        e->append("# daveSpeed9k | daveSpeed19k | daveSpeed187k | daveSpeed500k daveSpeed1500k | daveSpeed45k | daveSpeed93k");
        e->append("dave_speed=daveSpeed187k\n");
        e->append("idletime=50 milliseconds\n");
        e->append("#eventlog host=localhost port=6000\n");
        e->append("# area :=\n");
        e->append("# daveSD\n");
        e->append("# daveInputs\n");
        e->append("# daveOutputs\n");
        e->append("# daveFlags\n");
        e->append("# daveDB         //data blocks\n");
        e->append("# daveDI         //not tested\n");
        e->append("# daveLocal      //not tested\n");
        e->append("# daveV          //don't know what it is\n");
        e->append("# daveCounter    //not tested\n");
        e->append("# daveTimer      //not tested\n");
        e->append("# cycle := area, dbnum, start, len\n");
        e->append("cycle1 slave=2 area=daveDB dbnum=1 start=0  len=64\n");
        e->append("cycle2 slave=2 area=daveDB dbnum=1 start=64 len=64\n");
        break;
      case SIEMENSTCP_DAEMON:
        e->append("################################################\n");
        e->append("# Project file for generating siemens daemon   #\n");
        e->append("# mksiemens name.mksiemens                     #\n");
        e->append("################################################\n");
        e->append("shared_memory=/srv/automation/shm/siemens.shm\n");
        e->append("mailbox=/srv/automation/mbx/siemens.mbx\n");
        e->append("# type := S7_200 | S7_300 | S7_400 | S5\n");
        e->append("slave=0 adr=192.168.1.101 type=S7_200 fetch_write=1\n");
        e->append("slave=1 adr=192.168.1.102 type=S7_200 fetch_write=0\n");
        e->append("idletime=50 milliseconds\n");
        e->append("#eventlog host=localhost port=6000\n");
        e->append("# ORG := ORG_DB | ORG_M | ORG_E | ORG_A | ORG_PEPA | ORG_Z | ORG_T\n");
        e->append("# cycle := slave + org + dbnum + start + len\n");
        e->append("cycle1 slave=0 org=ORG_E  dbnum=0 start=0 len=8\n");
        e->append("cycle2 slave=0 org=ORG_A  dbnum=0 start=0 len=8\n");
        e->append("cycle3 slave=0 org=ORG_DB dbnum=0 start=0 len=32\n");
        break;
      case MODBUS_DAEMON:
        e->append("############################################\n");
        e->append("# Project file for generating modbusdaemon #\n");
        e->append("# mkmodbus name.mkmodbus                   #\n");
        e->append("############################################\n");
        e->append("shared_memory=/srv/automation/shm/modbus.shm\n");
        e->append("mailbox=/srv/automation/mbx/modbus.mbx\n");
        e->append("#communication=serial\n");
        e->append("tty=/dev/ttyS0\n");
        e->append("baudrate=9600\n");
        e->append("communication=socket\n");
        e->append("tcpadr=lehrig2\n");
        e->append("tcpport=5050\n");
        e->append("#eventlog host=localhost port=6000\n");
        e->append("# function := 1=ReadCoilStatus | 2=ReadInputStatus | 3=ReadHoldingRegisters | 4=ReadInputRegisters\n");
        e->append("#             1 coil per bit   | 1 input per bit   | 2 byte per register    | 2byte per register\n");
        e->append("cycle1 slave=1 function=1 start_adr=0 num_register=3\n");
        e->append("cycle2 slave=2 function=2 start_adr=0 num_register=3\n");
        e->append("cycle3 slave=3 function=3 start_adr=0 num_register=3\n");
        e->append("cycle4 slave=4 function=4 start_adr=0 num_register=3\n");
        e->append("cycle5 slave=5 function=2 start_adr=0 num_register=3\n");
        e->append("cycle6 slave=6 function=2 start_adr=0 num_register=3\n");
        e->append("cycle7 slave=7 function=2 start_adr=0 num_register=3\n");
        break;
      default:  
        break;
    }
  } 
  e->setModified( FALSE );  
}

void dlgDaemon::save()
{
  QString text = e->text();
  QFile f(filename);
  if(!f.open(IO_WriteOnly)) return;
  QTextStream t( &f );
  t << text;
  f.close();
  e->setModified( FALSE );
}

int gppi(const char *name);
int gsiemens(const char *name);
int gmodbus(const char *name);

void dlgDaemon::generate()
{
  switch(what)
  {
    case PPI_DAEMON:
      gppi(filename);
      break;
    case SIEMENSTCP_DAEMON:
      gsiemens(filename);
      break;
    case MODBUS_DAEMON:
      gmodbus(filename);
      break;
    default:  
      break;
  }
}
