/***************************************************************************
 *   Copyright (C) 2005 by Rainer Lehrig                                   *
 *   lehrig@t-online.de                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef PVBUILDER_H
#define PVBUILDER_H

#include <qmainwindow.h>
#include "newprj.h"
#include "pasteWidget.h"
#include "syntax.h"
#include "dlghtmluser.h"
#define DO_MAKE                   1
#define DO_MAKE_AND_RUN           2
#define DO_DESIGN_AND_MAKE        3
#define DO_START_SERVER           4
#define DO_START_BROWSER          5
#define DO_INSERT_DESIGN_AND_MAKE 6

#define DATA_AQUISITION_MODBUS      1
#define DATA_AQUISITION_PPI         2
#define DATA_AQUISITION_SIEMENS_TCP 3

class QTextEdit;
class view;
class QListBoxItem;

//##################################################################################
class pvbuilder: public QMainWindow
{
    Q_OBJECT

public:
    pvbuilder();
    ~pvbuilder();

protected:
    void closeEvent( QCloseEvent* );

private slots:
    void newDoc();
    void choose();
    void load( const QString &fileName );
    void save();
    void saveAs();
    void print();

    void slotFind();
    void slotFindNext();
    void slotGotoLine();

    void slotQtDesigner();
    void slotInsertMask();
    void slotMake();
    void slotStartServer();
    void slotStartPvbrowser();

    void slotPPI();
    void slotSiemensTCP();
    void slotModbus();

    void slotUncommentRllib();
    void slotUncommentRllibModbus();
    void slotUncommentRllibSiemensTcp();
    void slotUncommentRllibPpi();
    void slotUncommentRllib(int data_aquisiton);

    void newproject();
    void background();
    void modbus();
    void siemensTCP();
    void siemensPPI();
    void reference();
    void solutions();
    void browse(const char *html);
    void about();
    void aboutQt();

    void slotWidgetname(QListBoxItem *item);

    void slotProject();
    void slotMain();
    void slotHeader();
    void slotMask();
    void slotSlots();

    void slotTop();
    void slotDefineMask();
    void slotShowData();
    void slotEvent();
    void slotComboEvents(int i);

    void slotMaskChanged(int val);
    void slotInsertFunction();    
    void slotWriteStartscript();

public:
    void loadProject(const char *prjfile);
    int  notLoaded();
    void doAction(int what);
    void generate(QString name);
    QString getProject(QString tag);
    void getWidgetNames(const QString &filename);

private:
    QPrinter *printer;
    QTextEdit *e;
    view *v;
    QString filename, name;
    QSyntaxHighlighter *highlighter;
    QString pattern;
    int para;
    int index;
    dlgHtmlUser dlghtml;
};
//##################################################################################
class dlgNewPrj: public newprj
{
    Q_OBJECT

public:  
    dlgNewPrj(QWidget* parent = 0, const char* name = 0);
    ~dlgNewPrj();
    QString run();
public slots:
    void slotDir();
};
//##################################################################################
class dlgPasteWidget: public pasteWidget
{
    Q_OBJECT

public:  
    dlgPasteWidget(const char *_widgetname, QWidget* parent = 0, const char* name = 0);
    ~dlgPasteWidget();
    QString run();
private:
    const char *widgetname;
};
//##################################################################################

#endif
