/***************************************************************************
 *   Copyright (C) 2005 by Rainer Lehrig                                   *
 *   lehrig@t-online.de                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "syntax.h"
#include <ctype.h>
const char *cKeywords[] = {
  "break", "case", "continue", "default", "do", "else", "enum", "extern",
  "for", "goto", "if", /*"interrupt",*/  "return", "sizeof", "struct",
  "switch", "typedef", "union", "while", 0L};

const char *cTypes[] = {
  "auto", "char", "const", "double", "float", "int", "long", "register",
  "short", "signed", "static", "unsigned", "void", "volatile", 0L};

// ISO/IEC 14882:1998 . Sec. 2.11.1 (aka ANSI C++)
// keyword "const" (apart from a type spec.) is also a keyword, so it is named inside this array
// what about typeof?
const char *cppKeywords[] = {
  "asm", "catch", "class", "const_cast", "const", "delete", "dynamic_cast",
  "explicit", "export", "false", "friend", "inline", "namespace", "new",
  "operator", "private", "protected", "public", "reinterpret_cast",
  "static_cast", "template", "this", "throw", "true", "try", "typeid",
  "typename", "using", "virtual",
  // alternative representations  (these words are reserved and shall not be used otherwise)
  //  ISO/IEC 14882:1998 . Sec. 2.11.2
  "and_eq", "and", "bitand", "bitor", "compl", "not_eq", "not", "or_eq", "or",
  "xor_eq", "xor", 0L};

const char *cppTypes[] = {
  "bool", "wchar_t", "mutable", 0L};
 
syntax::syntax(QTextEdit *edit) 
       :QSyntaxHighlighter(edit)
{
  e = edit;
}
    
syntax::~syntax()
{
}
 
int syntax::highlightParagraph(const QString &text, int endStateOfLastPara)
{
  char buf[1024];
  int start;
  int i,len;
  QColor red(255,0,0); 
  QColor green(0,255,0); 
  QColor blue(0,0,255);
  QColor grey(128,128,128);
  QColor black(0,0,0);
  
  if(text.isNull()) return 0;
  if(text.length() >= sizeof(buf)) return 0;
  strcpy(buf,text);
  
  setFormat(0,sizeof(buf)-1,black);
  //##########################################################################
  for(i=0; cKeywords[i] != 0L; i++)
  {
    len = strlen(cKeywords[i]);
    for(start=0; buf[start] != '\0'; start++)
    {
      if(strncmp(&buf[start],cKeywords[i],len) == 0 && (isspace(buf[start+len]) || buf[start+len] == '(' || buf[start+len] == ':' || buf[start+len] == ';'))
      {         
        if(start == 0)                 setFormat(start,len,red);
	else if(isspace(buf[start-1])) setFormat(start,len,red);
      }	
    }
  }
  //##########################################################################
  for(i=0; cppKeywords[i] != 0L; i++)
  {
    len = strlen(cppKeywords[i]);
    for(start=0; buf[start] != '\0'; start++)
    {
      if(strncmp(&buf[start],cppKeywords[i],len) == 0 && (isspace(buf[start+len]) || buf[start+len] == '(' || buf[start+len] == ':' || buf[start+len] == ';'))
      {         
        if(start == 0)                 setFormat(start,len,red);
	else if(isspace(buf[start-1])) setFormat(start,len,red);
      }	
    }
  }
  //##########################################################################
  for(i=0; cTypes[i] != 0L; i++)
  {
    len = strlen(cTypes[i]);
    for(start=0; buf[start] != '\0'; start++)
    {
      if(strncmp(&buf[start],cTypes[i],len) == 0 && (isspace(buf[start+len]) || buf[start+len] == '(' || buf[start+len] == ':' || buf[start+len] == ';'))
      {         
        if(start == 0)                 setFormat(start,len,blue);
	else if(isspace(buf[start-1])) setFormat(start,len,blue);
	else if(buf[start-1] == '(')   setFormat(start,len,blue);
      }	
    }
  }
  //##########################################################################
  for(i=0; cppTypes[i] != 0L; i++)
  {
    len = strlen(cppTypes[i]);
    for(start=0; buf[start] != '\0'; start++)
    {
      if(strncmp(&buf[start],cppTypes[i],len) == 0 && (isspace(buf[start+len]) || buf[start+len] == '(' || buf[start+len] == ':' || buf[start+len] == ';'))
      {         
        if(start == 0)                 setFormat(start,len,blue);
	else if(isspace(buf[start-1])) setFormat(start,len,blue);
	else if(buf[start-1] == '(')   setFormat(start,len,blue);
      }	
    }
  }
  //##########################################################################
  for(start=0; buf[start] != '\0'; start++)
  {
    if(buf[start] == '/' && buf[start+1] == '/')
    {
      setFormat(start,strlen(&buf[start]),grey);
      return 0;
    }
    else if(buf[start] == '(' || buf[start] == ')')
    {
      setFormat(start,1,blue);
    }
    else if(buf[start] == '[' || buf[start] == ']')
    {
      setFormat(start,1,blue);
    }
    else if(buf[start] == '{' || buf[start] == '}')
    {
      setFormat(start,1,blue);
    }
  }
    
  if(endStateOfLastPara == 0) return 0;
  return 0;
}
