/***************************************************************************
                          pvmviewer.cpp  -  description
                             -------------------
    begin                : Fre Nov 24 15:05:38 CET 2000
    copyright            : (C) 2000 by Rainer Lehrig
    email                : lehrig@t-online.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "pvmviewer.h"
//#include "filesave.xpm"
#include "fileopen.xpm"
//#include "filenew.xpm"
#include "fileprint.xpm"
#include "resource.h"

PvmViewer::PvmViewer()
{
  setCaption("PvmViewer 1.0");

  filename = "";
  ///////////////////////////////////////////////////////////////////
  // call inits to invoke all other construction parts
  initMenuBar();
  initToolBar();
  initStatusBar();

  initDoc();
  initView();  
}

PvmViewer::~PvmViewer()
{
}

void PvmViewer::initMenuBar()
{
  ///////////////////////////////////////////////////////////////////
  // MENUBAR

  ///////////////////////////////////////////////////////////////////
  // menuBar entry fileMenu

  fileMenu=new QPopupMenu();
  //fileMenu->insertItem("&New", this, SLOT(slotFileNew()), CTRL+Key_N, ID_FILE_NEW);
  fileMenu->insertItem("&Open...", this, SLOT(slotFileOpen()), CTRL+Key_O, ID_FILE_OPEN);
  //fileMenu->insertSeparator();
  //fileMenu->insertItem("&Save", this, SLOT(slotFileSave()), CTRL+Key_S, ID_FILE_SAVE);
  //fileMenu->insertItem("Save &as...", this, SLOT(slotFileSaveAs()), 0, ID_FILE_SAVE_AS);
  //fileMenu->insertItem("&Close", this, SLOT(slotFileClose()), CTRL+Key_W, ID_FILE_CLOSE);
  fileMenu->insertSeparator();
  fileMenu->insertItem("&Save as BMP", this, SLOT(slotFileSaveAs()), CTRL+Key_S, ID_FILE_SAVE_AS);
  fileMenu->insertItem("&Print", this, SLOT(slotFilePrint()), CTRL+Key_P, ID_FILE_PRINT);
  fileMenu->insertSeparator();
  fileMenu->insertItem("E&xit", this, SLOT(slotFileQuit()), CTRL+Key_Q, ID_FILE_QUIT);

  ///////////////////////////////////////////////////////////////////
  // menuBar entry editMenu
  editMenu=new QPopupMenu();
  //editMenu->insertItem("Cu&t", this, SLOT(slotEditCut()), CTRL+Key_X, ID_EDIT_CUT);
  editMenu->insertItem("&Copy", this, SLOT(slotEditCopy()), CTRL+Key_C, ID_EDIT_COPY);
  //editMenu->insertItem("&Paste", this, SLOT(slotEditPaste()), CTRL+Key_V, ID_EDIT_PASTE);
 
  
  ///////////////////////////////////////////////////////////////////
  // menuBar entry viewMenu
  viewMenu=new QPopupMenu();
  viewMenu->setCheckable(true);
  viewMenu->insertItem("Tool&bar", this, SLOT(slotViewToolBar()), 0, ID_VIEW_TOOLBAR);
  viewMenu->insertItem("&Statusbar", this, SLOT(slotViewStatusBar()), 0, ID_VIEW_STATUSBAR);

  viewMenu->setItemChecked(ID_VIEW_TOOLBAR, true);
  viewMenu->setItemChecked(ID_VIEW_STATUSBAR, true);

  ///////////////////////////////////////////////////////////////////
  // EDIT YOUR APPLICATION SPECIFIC MENUENTRIES HERE
  
  ///////////////////////////////////////////////////////////////////
  // menuBar entry helpMenu
  helpMenu=new QPopupMenu();
  helpMenu->insertItem("About...", this, SLOT(slotHelpAbout()), 0, ID_HELP_ABOUT);


  ///////////////////////////////////////////////////////////////////
  // MENUBAR CONFIGURATION
  // set menuBar() the current menuBar 

  menuBar()->insertItem("&File", fileMenu);
  menuBar()->insertItem("&Edit", editMenu);
  menuBar()->insertItem("&View", viewMenu);
  menuBar()->insertSeparator();
  menuBar()->insertItem("&Help", helpMenu);
  
  ///////////////////////////////////////////////////////////////////
  // CONNECT THE SUBMENU SLOTS WITH SIGNALS

  connect(fileMenu, SIGNAL(highlighted(int)), SLOT(statusCallback(int)));
  connect(editMenu, SIGNAL(highlighted(int)), SLOT(statusCallback(int)));
  connect(viewMenu, SIGNAL(highlighted(int)), SLOT(statusCallback(int)));
  connect(helpMenu, SIGNAL(highlighted(int)), SLOT(statusCallback(int)));

}

void PvmViewer::initToolBar()
{
  ///////////////////////////////////////////////////////////////////
  // TOOLBAR
  QPixmap openIcon, printIcon; //, saveIcon, newIcon;

  fileToolbar = new QToolBar(this, "file operations");
 
  //newIcon = QPixmap(filenew);
  //QToolButton *fileNew = new QToolButton(newIcon, "New File", 0, this,
  //                                       SLOT(slotFileNew()), fileToolbar);

  openIcon = QPixmap(fileopen);
  QToolButton *fileOpen = new QToolButton(openIcon, "Open File", 0, this,
                                          SLOT(slotFileOpen()), fileToolbar);

  printIcon = QPixmap(fileprint);
  QToolButton *filePrint = new QToolButton(printIcon, "Print File", 0, this,
                                          SLOT(slotFilePrint()), fileToolbar);

  //saveIcon = QPixmap(filesave);
  //QToolButton *fileSave = new QToolButton(saveIcon, "Save File", 0, this,
  //                                        SLOT(slotFileSave()), fileToolbar);
  
  
  fileToolbar->addSeparator();
  QWhatsThis::whatsThisButton(fileToolbar);
  //QWhatsThis::add(fileNew,"Click this button to create a new file.\n\n"
  //                "You can also select the New command from the File menu.");
  QWhatsThis::add(fileOpen,"Click this button to open a new file.\n\n"
                  "You can also select the Open command from the File menu.");
  QWhatsThis::add(filePrint,"Click this button to print the file.\n\n"
                  "You can also select the Print command from the File menu.");
  //QWhatsThis::add(fileSave,"Click this button to save the file you are "
  //                "editing. You will be prompted for a file name.\n\n"
  //                "You can also select the Save command from the File menu.");
  
}

void PvmViewer::initStatusBar()
{
  ///////////////////////////////////////////////////////////////////
  //STATUSBAR
  statusBar()->message(IDS_STATUS_DEFAULT, 2000);
}

void PvmViewer::initDoc()
{
}

void PvmViewer::initView()
{ 
  ////////////////////////////////////////////////////////////////////
  // set the main widget here
  draw = new QDrawWidget(this);
  draw->setBackgroundMode(QWidget::NoBackground); 
  setCentralWidget(draw);
}

bool PvmViewer::queryExit()
{
  int exit=QMessageBox::information(this, "Quit...",
                                    "Do your really want to quit?",
                                    QMessageBox::Ok, QMessageBox::Cancel);

  if (exit==1)
  {

  }
  else
  {

  };

  return (exit==1);
}

/////////////////////////////////////////////////////////////////////
// SLOT IMPLEMENTATION
/////////////////////////////////////////////////////////////////////


void PvmViewer::slotFileNew()
{
  statusBar()->message("Creating new file...");
  //doc->newDoc();
  statusBar()->message(IDS_STATUS_DEFAULT);
}

void PvmViewer::setFile(const char *file)
{
  int h;
  filename = file;
  QString capt = "PvmViewer ";
  capt += "1.0";
  capt += "  ";
  capt += filename;
  setCaption(capt);
  QString message="Loaded document: "+filename;
  statusBar()->message(message, 2000);
  draw->setZoomX(1.0f);
  draw->setZoomY(1.0f);
  draw->getDimensions(filename,&ow,&oh);
  h = oh;
  if(fileToolbar->isVisible()) h += fileToolbar->height();
  if(statusBar()->isVisible()) h += statusBar()->height();  
  if(menuBar()->isVisible())   h += menuBar()->height();
  resize(ow,h);
  draw->updateGeometry();
}

void PvmViewer::slotFileOpen()
{
  statusBar()->message("Opening file...");

  QString fileName = QFileDialog::getOpenFileName(0,"*.pvm",this);
  if (!fileName.isEmpty())
  {
    setFile(fileName);
  }
  else
  {
    statusBar()->message("Opening aborted", 2000);
  }
}


void PvmViewer::slotFileSave()
{
  statusBar()->message("Saving file...");
  statusBar()->message(IDS_STATUS_DEFAULT);
}

void PvmViewer::slotFileSaveAs()
{
  statusBar()->message("Saving file under new filename...");
  QString fn = QFileDialog::getSaveFileName(0,"*.bmp", this);
  if (!fn.isEmpty())
  {
    draw->logBmpToFile(fn);
  }
  else
  {
    statusBar()->message("Saving aborted", 2000);
  }

  statusBar()->message(IDS_STATUS_DEFAULT);
}

void PvmViewer::slotFileClose()
{
  statusBar()->message("Closing file...");

  statusBar()->message(IDS_STATUS_DEFAULT);
}

void PvmViewer::slotFilePrint()
{
  statusBar()->message("Printing...");
  draw->print();
  statusBar()->message(IDS_STATUS_DEFAULT);
}

void PvmViewer::slotFileQuit()
{ 
  statusBar()->message("Exiting application...");
  ///////////////////////////////////////////////////////////////////
  // exits the Application
/*
  if(doc->isModified())
  {
    if(queryExit())
    {
      qApp->quit();
    }
    else
    {

    };
  }
  else
  {
    qApp->quit();
  };
*/
  qApp->quit();
  statusBar()->message(IDS_STATUS_DEFAULT);
}

void PvmViewer::slotEditCut()
{
  statusBar()->message("Cutting selection...");

  statusBar()->message(IDS_STATUS_DEFAULT);
}

void PvmViewer::slotEditCopy()
{
  statusBar()->message("Copying selection to clipboard...");
  draw->copyToClipboard();
  statusBar()->message(IDS_STATUS_DEFAULT);
}

void PvmViewer::slotEditPaste()
{

  statusBar()->message("Inserting clipboard contents...");
  
  statusBar()->message(IDS_STATUS_DEFAULT);
}


void PvmViewer::slotViewToolBar()
{
  statusBar()->message("Toggle toolbar...");
  ///////////////////////////////////////////////////////////////////
  // turn Toolbar on or off
  
  if (fileToolbar->isVisible())
  {
    fileToolbar->hide();
    viewMenu->setItemChecked(ID_VIEW_TOOLBAR, false);
  }
  else
  {
    fileToolbar->show();
    viewMenu->setItemChecked(ID_VIEW_TOOLBAR, true);
  };

  statusBar()->message(IDS_STATUS_DEFAULT);
}

void PvmViewer::slotViewStatusBar()
{
  statusBar()->message("Toggle statusbar...");
  ///////////////////////////////////////////////////////////////////
  //turn Statusbar on or off

  if (statusBar()->isVisible())
  {
    statusBar()->hide();
    viewMenu->setItemChecked(ID_VIEW_STATUSBAR, false);
  }
  else
  {
    statusBar()->show();
    viewMenu->setItemChecked(ID_VIEW_STATUSBAR, true);
  }

  statusBar()->message(IDS_STATUS_DEFAULT);
}

void PvmViewer::slotHelpAbout()
{
  QMessageBox::about(this,"About...", "PvmViewer\nVersion 1.0");
}

void PvmViewer::slotStatusHelpMsg(const QString &text)
{
  ///////////////////////////////////////////////////////////////////
  // change status message of whole statusbar temporary (text, msec)
  statusBar()->message(text, 2000);
}

void PvmViewer::statusCallback(int id_)
{
  switch (id_)
  {
    case ID_FILE_NEW:
         slotStatusHelpMsg("Creates a new document");
         break;




    case ID_FILE_OPEN:
         slotStatusHelpMsg("Opens an PVM file");
         break;

    case ID_FILE_SAVE:
         slotStatusHelpMsg("Saves the actual document");
         break;

    case ID_FILE_SAVE_AS:
         slotStatusHelpMsg("Saves the actual document as...");
         break;

    case ID_FILE_CLOSE:
         slotStatusHelpMsg("Closes the application");
         break;

    case ID_FILE_PRINT:
         slotStatusHelpMsg("Prints out the actual PVM file");
         break;


    case ID_FILE_QUIT:
         slotStatusHelpMsg("Quits the application");
         break;

    case ID_EDIT_CUT:
         slotStatusHelpMsg("Cuts the selected section and puts it to the clipboard");
         break;

    case ID_EDIT_COPY:
         slotStatusHelpMsg("Copies the contents of the window to the clipboard");
         break;

    case ID_EDIT_PASTE:
         slotStatusHelpMsg("Pastes the clipboard contents to actual position");
         break;

    case ID_EDIT_SELECT_ALL:
         slotStatusHelpMsg("Selects the whole document contents");
         break;

    case ID_VIEW_TOOLBAR:
         slotStatusHelpMsg("Enables/disables the toolbar");
         break;

    case ID_VIEW_STATUSBAR:
         slotStatusHelpMsg("Enables/disables the statusbar");
         break;

    case ID_HELP_ABOUT:
         slotStatusHelpMsg("Shows an aboutbox");
         break;
  }
}

void PvmViewer::paintEvent(QPaintEvent *event)
{
  if(!filename.isEmpty())
  {
    draw->showFromFile(filename);
  }
  if(event == NULL) return;
}

void PvmViewer::resizeEvent(QResizeEvent *event)
{
  int   w,h;
  float zx,zy;

  QSize s = event->size();
  w = s.width();
  h = s.height();
  zx = ((float) w / (float) ow);
  zy = ((float) h / (float) oh);
  if(zx > zy)
  {
    draw->setZoomX(zy);
    draw->setZoomY(zy);
  }
  else
  {
    draw->setZoomX(zx);
    draw->setZoomY(zx); 
  }
  if(fileToolbar->isVisible()) h += fileToolbar->height();
  if(statusBar()->isVisible()) h += statusBar()->height();
  if(menuBar()->isVisible())   h += menuBar()->height();
  draw->resize(w,h);
  repaint(false);
}
