/***************************************************************************
                          tcputil.cpp  -  description
                             -------------------
    begin                : Sun Nov 12 2000
    copyright            : (C) 2000 by Rainer Lehrig
    email                : lehrig@t-online.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#define _QTSOCK_
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifndef _WIN32
#include <unistd.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#define closesocket close
#endif

#ifdef _WIN32
#include "winsock.h"
#define MSG_NOSIGNAL 0
#include <qapplication.h>
#endif

#ifndef MSG_NOSIGNAL
#define MSG_NOSIGNAL 0
#endif

int the_socket = -1;

int tcp_con(const char *adr, int port)
{
  static int                s;
  static struct sockaddr_in remoteAddr;
  static struct hostent     *host;
  static struct in_addr     RemoteIpAddress;
  int                       ret;

  the_socket = -1;

  s = socket(AF_INET,SOCK_STREAM,0);
  if(s == -1) return -1;

  /* fill destblk structure */
  host = gethostbyname(adr);
  if(host == NULL)
  {
     /* See if the host is specified in "dot address" form */
     if(strchr(adr,'.') == NULL) return -1;
     RemoteIpAddress.s_addr = inet_addr(adr);
     if(RemoteIpAddress.s_addr == 0x0ffffffff) return -1;
  }
  else
  {
     memcpy(&RemoteIpAddress,host->h_addr,host->h_length);
  }

  memset(&remoteAddr,0,sizeof(remoteAddr));
  remoteAddr.sin_family = AF_INET;
  remoteAddr.sin_port = htons(port);
  remoteAddr.sin_addr = RemoteIpAddress;

  ret = connect(s, (struct sockaddr *) &remoteAddr, sizeof(remoteAddr));
  if(ret == -1)
  {
    closesocket(s);
    return -1;
  }

  the_socket = s;
  return s;
}

int tcp_rec(int s, char *msg, int len)
{
  int ret,i;

  if(the_socket == -1) { msg[0] = '\0'; return -1; }
  i = 0;
  while(i < len-1)
  {
#ifdef _WIN32
tryagain:
#endif
    ret = recv(s,&msg[i],1,0);
    if(ret <= 0)
    {
#ifdef _WIN32
      if(WSAEWOULDBLOCK == WSAGetLastError())
      {
        if(i==0) return -2;
        qApp->processEvents();
        goto tryagain;
      }
#endif
      the_socket = -1;
      closesocket(s);
      return -1;
    }
    if(msg[i] == '\n')
    {
      i++;
      msg[i] = '\0';
      return i;
    }
    i++;
  }
  msg[i] = '\0';
  return i;
}

int tcp_rec_binary(int s, char *msg, int len)
{
  int ret,i;

  if(the_socket == -1) return -1;
  i = 0;
  while(i < len)
  {
#ifdef _WIN32
tryagain:
#endif
    ret = recv(s,&msg[i],len-i,0);
    if(ret <= 0)
    {
#ifdef _WIN32
      if(WSAEWOULDBLOCK == WSAGetLastError())
      {
        goto tryagain;
      }
#endif
      the_socket = -1;
      closesocket(s);
      return -1;
    }
    i += ret;
  }
  return i;
}

int tcp_send(int s, const char *msg, int len)
{
  int ret,bytes_left,first_byte;

  ret = 0;
  if(the_socket == -1) return -1;
  if(s == -1)          return -1; 
  bytes_left = len;
  first_byte = 0;

  while(bytes_left > 0)
  {
    ret = send(s,&msg[first_byte],bytes_left,MSG_NOSIGNAL);
    if(ret <= 0) { the_socket = -1; closesocket(s); return -1; }
    bytes_left -= ret;
    first_byte += ret;
  }
  return ret;
}

int tcp_close(int s)
{
  if(the_socket == -1) return -1;
  tcp_send(s,"shutup\n",7);
  the_socket = -1;
  closesocket(s);
  return 0;
}
