#! /bin/sh 
# 
# Generates a package from sourceforge cvs
#
# Usage: cvs2package.sh packagename
#

##########################
# check parameters
##########################

if [ $# -ne 1 ]
then
	echo "Usage: `basename $0` packagename"
	exit 1
fi

##########################
# we need doxygen and cvs
##########################
type doxygen > /dev/null 2> /dev/null
if [ $? -ne 0 ]
then
	echo "Can't find 'doxygen'"
	exit $?
fi

type cvs > /dev/null 2> /dev/null
if [ $? -ne 0 ]
then
	echo "Can't find 'cvs'"
	exit $?
fi

QWT_PKG=qwt-$1
DIR=$PWD

##########################
# Clean trash from 
# previous runs
##########################

if [ -x $QWT_PKG.tgz ]
then
	# ask and remove previus generated package

	rm -i $QWT_PKG.tgz
	if [ $? -ne 0 ]
	then
		exit $?
	fi
fi

# remove temporory directory. We don't ask
# when removing from the tmp dir


rm -rf /tmp/$QWT_PKG
if [ $? -ne 0 ]
then
	exit $?
fi

##########################
# Get a fresh cvs tree
# and remove files we
# don't need
##########################

cd /tmp
echo -n "Checking out qwt source tree to /tmp/$QWT_PKG ..."
cvs -q -z3 \
	-d:pserver:anonymous@cvs.qwt.sourceforge.net:/cvsroot/qwt co qwt > /dev/null
if [ $? -ne 0 ]
then
	echo "Can't access sourceforge CVS"
	exit $?
fi
mv qwt $QWT_PKG
echo " done"

cd /tmp/$QWT_PKG
if [ $? -ne 0 ]
then
	exit $?
fi

##########################
# Remove package non 
# relevant files
##########################

echo -n "Removing package non relevant files ..."
find . -name CVS -print | xargs rm -rf 
find . -name .cvsignore -exec rm -f {} \;
rm -f Doxyfile
rm -rf makefiles admin
echo " done"

##########################
# Change debug to release
# in all pro files
##########################

echo -n "Change profiles ..."
PROFILES=`find . -type f -name '*.pro' -print`
for PROFILE in $PROFILES 
do
	sed -e 's/debug/release/' $PROFILE > $PROFILE.sed
	mv $PROFILE.sed $PROFILE
done
unset PROFILES
echo " done"

##########################
# Replace tabs by 4 blanks
##########################

echo -n "Remove tabs ..."
HEADERS=`find . -type f -name '*.h' -print`
SOURCES=`find . -type f -name '*.cpp' -print`
PROFILES=`find . -type f -name '*.pro' -print`
for EXPANDFILE in $HEADERS $SOURCES $PROFILES
do
	expand -4 $EXPANDFILE > $EXPANDFILE.expand
	mv $EXPANDFILE.expand $EXPANDFILE
done
unset HEADERS SOURCES PROFILES
echo " done"


##########################
# Run doxygen
##########################

echo -n "Generating documentation ..."
cd /tmp/$QWT_PKG
if [ $? -ne 0 ]
then
	exit $?
fi
doxygen Doxyfile.users > /dev/null
rm -rf doc/images
echo " done"

##########################
# Tar/Zip packages and
# remove source tree
##########################

echo -n "Generating $QWT_PKG.tgz $QWT_PKG.tar.bz2 $QWT_PKG.zip  ..."
cd /tmp
if [ $? -ne 0 ]
then
	exit $?
fi

tar cfz $QWT_PKG.tgz $QWT_PKG
tar cfj $QWT_PKG.tar.bz2 $QWT_PKG
zip -r $QWT_PKG.zip $QWT_PKG > /dev/null
echo " done"

echo -n "Cleanup ..."
rm -rf $QWT_PKG
mv $QWT_PKG.tgz $QWT_PKG.tar.bz2 $QWT_PKG.zip $DIR/
echo " done"

exit 0
