#if defined(_MSC_VER) /* MSVC Compiler */
#pragma warning ( disable : 4786 )
#endif

#include <vector>
#include <qmime.h>
#include <qdragobject.h>

#include "qwtplugin.h"

#include "qwt_counter.h"
#include "qwt_plot.h"
#include "qwt_wheel.h"
#include "qwt_thermo.h"
#include "qwt_knob.h"
#include "qwt_scale.h"
#include "qwt_slider.h"
#include "qwt_compass.h"

namespace
{
    struct Entry
    {
        Entry( QString _classname, QString _header, QString  _pixmap,
                QString _tooltip, QString _whatshis):       
                classname(_classname),
                header(_header),
                pixmap(_pixmap),
                tooltip(_tooltip),
                whatshis(_whatshis)
        {}

        QString classname;
        QString header;
        QString pixmap;
        QString tooltip;
        QString whatshis;
    };

    std::vector<Entry> vec;

    std::vector<Entry>::iterator pos(const QString& str)
    {
        for (std::vector<Entry>::iterator i=vec.begin(); i!=vec.end(); ++i)
            if (str == i->classname)
                return i;
        return vec.end();
    }
}

QwtPlugin::QwtPlugin()
{
    vec.push_back(Entry("QwtPlot", "qwt_plot.h",
        "qwtplot.png", "QwtPlot", "whatsthis"));
    vec.push_back(Entry("QwtCompass", "qwt_compass.h",
        "qwtcompass.png", "QwtCompass", "whatsthis"));
    vec.push_back(Entry("QwtCounter", "qwt_counter.h", 
        "qwtcounter.png", "QwtCounter", "whatsthis"));
    vec.push_back(Entry("QwtKnob", "qwt_knob.h",
        "qwtknob.png", "QwtKnob", "whatsthis"));
    vec.push_back(Entry("QwtScale", "qwt_scale.h",
        "qwtscale.png", "QwtScale", "whatsthis"));
    vec.push_back(Entry("QwtSlider", "qwt_slider.h",
        "qwtslider.png", "QwtSlider", "whatsthis"));
    vec.push_back(Entry("QwtThermo", "qwt_thermo.h",
        "qwtthermo.png", "QwtThermo", "whatsthis"));
    vec.push_back(Entry("QwtWheel", "qwt_wheel.h",
        "qwtwheel.png", "QwtWheel", "whatsthis"));
}

QWidget* QwtPlugin::create(const QString &key, 
    QWidget* parent, const char* name)
{
    if ( key == "QwtCounter" )
        return new QwtCounter( parent, name);
    else if ( key == "QwtPlot" )
        return new QwtPlot( parent, name );
    else if ( key == "QwtWheel" )
        return new QwtWheel( parent, name );
    else if ( key == "QwtThermo" )
        return new QwtThermo( parent, name );
    else if ( key == "QwtKnob" )
        return new QwtKnob( parent, name );
    else if ( key == "QwtScale" )
        return new QwtScale( QwtScale::Left, parent, name );
    else if ( key == "QwtSlider" )
        return new QwtSlider( parent, name );
    else if ( key == "QwtCompass" )
        return new QwtCompass( parent, name );

    return 0;
}


QStringList QwtPlugin::keys() const
{
    QStringList list;
    
    for (unsigned i=0; i!=vec.size(); ++i)
        list << vec[i].classname;

    return list;
}

QString QwtPlugin::group( const QString& feature ) const
{
    if (pos(feature) != vec.end())
        return QString("Qwt"); 
    return QString::null;
}

QIconSet QwtPlugin::iconSet( const QString& pmap) const
{
    QString pixmapKey("qwtwidget.png");
    if (pos(pmap) != vec.end())
        pixmapKey = pos(pmap)->pixmap;

    const QMimeSource *ms =
        QMimeSourceFactory::defaultFactory()->data(pixmapKey);

    QPixmap pixmap;
    QImageDrag::decode(ms, pixmap);

    return QIconSet(pixmap);
}

QString QwtPlugin::includeFile( const QString& feature ) const
{
    if (pos(feature) != vec.end())
        return pos(feature)->header;        
    return QString::null;
}

QString QwtPlugin::toolTip( const QString& feature ) const
{
    if (pos(feature) != vec.end())
        return pos(feature)->tooltip;       
    return QString::null;
}

QString QwtPlugin::whatsThis( const QString& feature ) const
{
    if (pos(feature) != vec.end())
        return pos(feature)->whatshis;      
    return QString::null;
}

bool QwtPlugin::isContainer( const QString& ) const
{
    return FALSE;
}


Q_EXPORT_PLUGIN( QwtPlugin )
