#include <qapplication.h>
#include <qgrid.h>
#include <qwt_compass.h>
#include <qwt_compass_rose.h>
#include <qwt_dial_needle.h>

class Compass1: public QwtCompass
{
public:
	Compass1(QWidget *parent):
		QwtCompass(parent)
	{
		setMode(RotateScale);

		setLineWidth(6);
		setFrameShadow(Sunken);

		QwtSimpleCompassRose *rose = new QwtSimpleCompassRose(16, 2);
		rose->setWidth(0.15);

		setRose(rose);
	}
};

class Compass2: public QwtCompass
{
public:
	Compass2(QWidget *parent):
		QwtCompass(parent)
	{
		setLineWidth(6);
		setFrameShadow(Sunken);

		QMap<double, QString> map;
	    map.insert(0.0, "N");
    	map.insert(90.0, "E");
    	map.insert(180.0, "S");
    	map.insert(270.0, "W");

		setLabelMap(map);

		QwtSimpleCompassRose *rose = new QwtSimpleCompassRose(4, 1);
		setRose(rose);

		setNeedle(new QwtCompassNeedle2());
		setValue(60.0);
	}
};

class Compass3: public QwtCompass
{
public:
	Compass3(QWidget *parent):
		QwtCompass(parent)
	{
		setLineWidth(6);
		setFrameShadow(Raised);

		scaleDraw()->setTickLength(0, 0, 3);

		setNeedle(new QwtCompassMagnetNeedle(Qt::white, Qt::red));
		setValue(220.0);

	}
};

class Compass4: public QwtCompass
{
public:
	Compass4(QWidget *parent):
		QwtCompass(parent)
	{
		setLineWidth(6);
		setFrameShadow(Raised);

		QPalette p = palette();
    	for ( int i = 0; i < QPalette::NColorGroups; i++ )
		{
			const QPalette::ColorGroup cg = (QPalette::ColorGroup)i;
			p.setColor(cg, QColorGroup::Foreground, Qt::black);
		}
		setPalette(p);
		setNeedle(new QwtCompassLineNeedle(Qt::yellow));
		setValue(315.0);
	}
};

class Compass5: public QwtCompass
{
public:
	Compass5(QWidget *parent):
		QwtCompass(parent)
	{
		setLineWidth(6);
		setFrameShadow(Sunken);

		scaleDraw()->setTickLength(2, 3, 4);
	    setScale(36, 5, 0);

		setNeedle(new QwtCompassNeedle4);
		setValue(220.0);

        QPalette p = palette();
        for ( int i = 0; i < QPalette::NColorGroups; i++ )
        {
            const QPalette::ColorGroup cg = (QPalette::ColorGroup)i;
            p.setColor(cg, QColorGroup::Base, Qt::darkBlue);
            p.setColor(cg, QColorGroup::Foreground,
                QColor(Qt::darkBlue).dark(120));
            p.setColor(cg, QColorGroup::Text, Qt::white);
        }
        setPalette(p);
	}
};


class Compass6: public QwtCompass
{
public:
	Compass6(QWidget *parent):
		QwtCompass(parent)
	{
#if 1
		QPalette p = palette();
    	for ( int i = 0; i < QPalette::NColorGroups; i++ )
		{
			const QPalette::ColorGroup cg = (QPalette::ColorGroup)i;

			p.setColor(cg, QColorGroup::Base, 
				p.color(cg, QColorGroup::Background));
			p.setColor(cg, QColorGroup::Foreground, Qt::darkBlue);
		}
		setPalette(p);
#endif

		scaleDraw()->setOptions(scaleDraw()->options() 
			| QwtScaleDraw::Backbone);
		scaleDraw()->setTickLength(0, 0, 3);

		QMap<double, QString> map;
		for ( double d = 0.0; d < 360.0; d += 45.0 )
		{
			QString label;
			label.sprintf("%.1f", d);
	        map.insert(d, label);
		}
		setLabelMap(map);

		setNeedle(new QwtCompassLineNeedle(Qt::white));
		setOrigin(220.0);
		setValue(20.0);
	}
};

int main (int argc, char **argv)
{
    QApplication a(argc, argv);

	QGrid grid(3);
	
	(void)new Compass1(&grid);
	(void)new Compass2(&grid);
	(void)new Compass3(&grid);
	(void)new Compass4(&grid);
	(void)new Compass5(&grid);
	(void)new Compass6(&grid);

	a.setMainWidget(&grid);

	grid.resize(600, 400);
	grid.show();

    return a.exec();
}

