#include <iostream>
#include <fstream>
#include <qapp.h>
#include <qfont.h>
#include <qwt_thermo.h>
#include <qlabel.h>
#include <qwt_math.h>

class MainWin : public QWidget 
{
public:

    QwtThermo *t1;
    QwtThermo *t2;
    QwtThermo *t3;
    QLabel  *l1;
    QLabel  *l2;
    QLabel  *l3;

    int tmrID;
    
public:

    MainWin();
    ~MainWin();
    void start();
    void update();

protected:

    void timerEvent(QTimerEvent *e);
    
};

//---------------------------------------
// MainWin::start()
//
//  initialize thermometers,
//  start timer
//---------------------------------------
void MainWin::start()
{
    update();
    tmrID = startTimer(2000);
}


//---------------------------------------
// MainWin::update()
//
//	read values from /proc/loadavg
//  and display them. Adjust thermometer scales
//  if necessary.
//---------------------------------------
void MainWin::update()
{
    double v1, v2, v3;
    static double vmin = 0.1;
    double vmax, vnew;
    
    std::ifstream inp("/proc/loadavg");
    inp >> v1 >> v2 >> v3;

    // adjust and synchronize ranges
    vmax = qwtCeil125(qwtMax(qwtMax(qwtMax(v1,v2),v3),vmin));

    if ( (vmax > t1->maxValue()) 
	|| (vmax < 0.25 * t1->maxValue()) )
    {
	vnew = vmax;
	t1->setRange(0.0, vnew);
	t2->setRange(0.0, vnew);
	t3->setRange(0.0, vnew);
    }

    // set values
    t1->setValue(v1);
    t2->setValue(v2);
    t3->setValue(v3);
    
}

//---------------------------------------
// MainWin::timerEvent
//
// 	update thermomoters
//---------------------------------------
void MainWin::timerEvent(QTimerEvent *)
{
    update();
}


MainWin::MainWin()
: QWidget()
{
    t1 = new QwtThermo(this,"");
    t2 = new QwtThermo(this,"");
    t3 = new QwtThermo(this,"");
    l1 = new QLabel("1 min", this);
    l2 = new QLabel("10 min.", this);
    l3 = new QLabel("15 min.", this);

    t1->setGeometry(10,10,50,100);
    t2->setGeometry(70,10,50,100);
    t3->setGeometry(130,10,50,100);
    l1->setGeometry(10,115,50,10);
    l2->setGeometry(70,115,50,10);
    l3->setGeometry(130,115,50,10);

    t1->setOrientation(QwtThermo::Vertical, QwtThermo::Right);
    t1->setRange(0.0,1.0);
    t1->setValue(1.0);
    t1->setBorderWidth(1);
    t1->setPipeWidth(4);
    t1->setFont(QFont("Helvetica",10));
    t1->setScaleMaxMajor(6);
    t1->setFillColor(QColor("DarkRed"));

    t2->setOrientation(QwtThermo::Vertical, QwtThermo::Right);
    t2->setRange(0.0,1.0);
    t2->setValue(1.0);
    t2->setBorderWidth(1);
    t2->setPipeWidth(4);
    t2->setFont(QFont("Helvetica",10));
    t2->setScaleMaxMajor(6);
    t2->setFillColor(QColor("DarkGreen"));

    t3->setOrientation(QwtThermo::Vertical, QwtThermo::Right);
    t3->setRange(0.0,1.0);
    t3->setValue(1.0);
    t3->setBorderWidth(1);
    t3->setPipeWidth(4);
    t3->setFont(QFont("Helvetica",10));
    t3->setScaleMaxMajor(6);
    t3->setFillColor(QColor("DarkBlue"));

    l1->setText("1 min.");
    l2->setText("5 min.");
    l3->setText("15 min.");

    l1->setAlignment(AlignLeft|AlignVCenter);
    l2->setAlignment(AlignLeft|AlignVCenter);
    l3->setAlignment(AlignLeft|AlignVCenter);
    
    tmrID = 0;

    setFixedSize(185,135);
}


MainWin::~MainWin()
{
    delete t1;
    delete t2;
    delete t3;
    delete l1;
    delete l2;
    delete l3;

    if (tmrID != 0) killTimer(tmrID);
}


int main (int argc, char **argv)
{
    QApplication a(argc, argv);

    MainWin w;
    a.setMainWidget(&w);

    w.setCaption("load average");
    w.start();
    w.show();
    
    return a.exec();
}
