#include <qlabel.h>
#include <qhbox.h>
#include <qstatusbar.h>
#include <qtoolbar.h>
#include <qtoolbutton.h>
#include <qspinbox.h>
#include <qwhatsthis.h>
#include "randomplot.h"
#include "mainwindow.h"
#include "start.xpm"
#include "clear.xpm"

class MyToolBar: public QToolBar
{
public:
	MyToolBar(MainWindow *);
	void addSpacing(int);
	void addStretch();
};

MyToolBar::MyToolBar(MainWindow *parent):
	QToolBar(parent)
{
}

void MyToolBar::addSpacing(int spacing)
{
    QLabel *label = new QLabel(this);
    label->setFixedWidth(spacing);
}

void MyToolBar::addStretch()
{
    QLabel *label = new QLabel(this);
	setStretchableWidget(label);
}

MainWindow::MainWindow()
{
    setDockEnabled(TornOff, TRUE);
    setRightJustification(TRUE);

	(void)toolBar();
	(void)statusBar();

	_plot = new RandomPlot(this);
	setCentralWidget(_plot);

	connect(_startBtn, SIGNAL(toggled(bool)), this, SLOT(appendPoints(bool)));
	connect(_clearBtn, SIGNAL(clicked()), _plot, SLOT(clear()));
	connect(_plot, SIGNAL(running(bool)), this, SLOT(showRunning(bool)));

	initWhatsThis();
}

QToolBar *MainWindow::toolBar()
{
	MyToolBar *toolBar = new MyToolBar(this);

	_startBtn = new QToolButton(toolBar);
	_startBtn->setUsesTextLabel(TRUE);
	_startBtn->setPixmap(QPixmap(start_xpm));
	_startBtn->setToggleButton(TRUE);

	_clearBtn = new QToolButton(toolBar);
	_clearBtn->setUsesTextLabel(TRUE);
	_clearBtn->setPixmap(QPixmap(clear_xpm));
	_clearBtn->setTextLabel("Clear", FALSE);


	QToolButton *helpBtn = QWhatsThis::whatsThisButton(toolBar);
	helpBtn->setUsesTextLabel(TRUE);
	helpBtn->setTextLabel("Help", FALSE);

	toolBar->addSpacing(20);
	toolBar->addStretch();

	QHBox *hBox = new QHBox(toolBar);

	QLabel *label = new QLabel("Points ", hBox);
	_randomCount = new QSpinBox(1, 100000, 100, hBox);
	_randomCount->setValue(1000);

	toolBar->addSpacing(20);

	hBox = new QHBox(toolBar);

	label = new QLabel("Delay ", hBox);
	_timerCount = new QSpinBox(0, 100000, 100, hBox);
	_timerCount->setValue(0);
	label = new QLabel(" ms", hBox);

	toolBar->addSpacing(10);

	showRunning(FALSE);

	_startBtn->setMinimumWidth(helpBtn->sizeHint().width() + 20);
	_clearBtn->setMinimumWidth(helpBtn->sizeHint().width() + 20);
	helpBtn->setMinimumWidth(helpBtn->sizeHint().width() + 20);

	return toolBar;
}

void MainWindow::appendPoints(bool on)
{
	if ( on )
		_plot->append(_timerCount->text().toInt(),
			_randomCount->text().toInt());
	else
		_plot->stop();
}

void MainWindow::showRunning(bool running)
{
	_randomCount->setEnabled(!running);
	_timerCount->setEnabled(!running);
	_startBtn->setOn(running);
	_startBtn->setTextLabel(running ? "Stop" : "Start", FALSE);
}

void MainWindow::initWhatsThis()
{
	QWhatsThis::add(_plot,
		"Zooming is enabled until the selected area gets "
		"too small for the significance on the axes.\n\n"
    	"You can zoom in using the left mouse button.\n"
    	"The middle mouse button is used to go back to the "
	  	"previous zoomed area.\n"
		"The right mouse button is used to unzoom completely."
	);
	QWhatsThis::add(_randomCount,
		"Number of random points that will be generated." 
	);
	QWhatsThis::add(_timerCount,
		"Delay between the generation of two random points."
	);
	QWhatsThis::add(_startBtn,
		"Start generation of random points.\n\n"
		"The intention of this example is to show how to implement "
		"growing curves. The points will be generated and displayed "
		"one after the other.\n"
		"To check the performance, a small delay and a large number "
		"of points are useful. To watch the curve growing, a delay "
		" > 300 ms and less points are better.\n"
		"To inspect the curve, stacked zooming is implemented using the "
		"mouse buttons on the plot."
	);
	QWhatsThis::add(_clearBtn,
		"Remove all points."
	);
}

