/* -*- mode: C++ ; c-file-style: "stroustrup" -*- *****************************
 * Qwt Widget Library
 * Copyright (C) 1997   Josef Wilgen
 * Copyright (C) 2002   Uwe Rathmann
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the Qwt License, Version 1.0
 *****************************************************************************/

#ifndef QWT_DIAL_H
#define QWT_DIAL_H 1

#include <qframe.h>
#include <qpalette.h>
#include "qwt_global.h"
#include "qwt_sldbase.h"
#include "qwt_scldraw.h"

class QwtDialNeedle;
class QwtDial;

class QwtDialScaleDraw: public QwtScaleDraw
{
public:
    QwtDialScaleDraw(QwtDial *);
    virtual QString label(double value) const;
private:
    QwtDial *d_parent;
};

class QWT_EXPORT QwtDial: public QwtSliderBase
{
	Q_OBJECT

	Q_ENUMS(Shadow)
	Q_ENUMS(Mode)

    Q_PROPERTY(bool visibleBackground READ hasVisibleBackground WRITE showBackground)
    Q_PROPERTY(int lineWidth READ lineWidth WRITE setLineWidth)
    Q_PROPERTY(Shadow frameShadow READ frameShadow WRITE setFrameShadow)
    Q_PROPERTY(Mode mode READ mode WRITE setMode)
    Q_PROPERTY(double origin READ origin WRITE setOrigin)
    Q_PROPERTY(bool wrapping READ wrapping WRITE setWrapping)

	friend class QwtDialScaleDraw;
public:

	enum Shadow
	{
  		/*!
			\brief Frame shadow

			Unfortunately it is not possible to use QFrame::Shadow
			as a property of a widget that is not derived from QFrame
			The following enum is made for the designer only. It is safe
			to use QFrame::Shadow instead.
		*/

		Plain = QFrame::Plain,
		Raised = QFrame::Raised,
		Sunken = QFrame::Sunken
	};

    enum Mode
    {
        /*!
            In case of RotateNeedle the needle is rotating, in case of
            RotateScale, the needle points to origin()
            and the scale is rotating.
        */

        RotateNeedle,
        RotateScale
    };

	QwtDial( QWidget* parent=0, const char* name = 0);
	virtual ~QwtDial();

	void setFrameShadow(Shadow);
	Shadow frameShadow() const;

	bool hasVisibleBackground() const;
	void showBackground(bool);

	void setLineWidth(int);
	int lineWidth() const;

    void setMode(Mode);
    Mode mode() const;

    void setWrapping(bool);
    bool wrapping() const;

	void setScale(int maxMajIntv, int maxMinIntv, double step = 0.0);

	void setScaleArc(double min, double max);
	double minScaleArc() const { return d_minScaleArc; }
	double maxScaleArc() const { return d_maxScaleArc; }

	void setOrigin(double);
	double origin() const;

	void setNeedle(QwtDialNeedle *);
	const QwtDialNeedle *needle() const;
	QwtDialNeedle *needle();

	QRect boundingRect() const;
	QRect contentsRect() const;
	virtual QRect scaleContentsRect() const;

    virtual QSize sizeHint() const;
    virtual QSize minimumSizeHint() const;

	// setAutoDelete
protected:
	virtual void paintEvent(QPaintEvent *);
	virtual void resizeEvent(QResizeEvent *);

	virtual void drawFrame(QPainter *p);
	virtual void drawContents(QPainter *) const;

	virtual void drawScale(QPainter *, const QPoint &center,
		int radius, double origin, double arcMin, double arcMax) const;
	virtual void drawScaleContents(QPainter *, const QPoint &center, 
		int radius) const;

	virtual void drawNeedle(QPainter *, const QPoint &, 
		int radius, double direction, QPalette::ColorGroup) const;

	virtual void setScaleDraw(QwtDialScaleDraw *);
	QwtDialScaleDraw *scaleDraw() { return d_scaleDraw; }
	const QwtDialScaleDraw *scaleDraw() const { return d_scaleDraw; }

    virtual QString scaleLabel(double) const;
	void updateScale();

    virtual void rangeChange();
    virtual void valueChange();

    virtual double getValue(const QPoint &);
	virtual void getScrollMode(const QPoint &, 
		int &scrollMode, int &direction);

private:
	bool d_visibleBackground;
	Shadow d_frameShadow;
	int d_lineWidth;

    Mode d_mode;
	bool d_wrapping;

	double d_origin;
	double d_minScaleArc;
	double d_maxScaleArc;

	QwtDialScaleDraw *d_scaleDraw;
	int d_maxMajIntv;
	int d_maxMinIntv;
	double d_scaleStep;

	QwtDialNeedle *d_needle;
};

#endif
