/* -*- mode: C++ ; c-file-style: "stroustrup" -*- *****************************
 * Qwt Widget Library
 * Copyright (C) 1997   Josef Wilgen
 * Copyright (C) 2002   Uwe Rathmann
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the Qwt License, Version 1.0
 *****************************************************************************/

#ifndef QWT_DIAL_ITEM_H
#define QWT_DIAL_ITEM_H 1

#include <qpalette.h>
#include "qwt_global.h"

class QPainter;
class QPoint;

class QWT_EXPORT QwtDialNeedle
{
public:
	QwtDialNeedle();
	virtual ~QwtDialNeedle();

	virtual void draw(QPainter *, const QPoint &, int length, 
		double direction, QPalette::ColorGroup = QPalette::Active) const = 0;

	virtual void setPalette(const QPalette &);
	const QPalette &palette() const; 

protected:
	const QColorGroup &colorGroup(QPalette::ColorGroup) const;

private:
	QPalette d_palette;
};

class QWT_EXPORT QwtCompassMagnetNeedle: public QwtDialNeedle
{
public:
	QwtCompassMagnetNeedle(const QColor &light = Qt::white,
		const QColor &dark = Qt::red);

	virtual void draw(QPainter *, const QPoint &, int length, 
		double direction, QPalette::ColorGroup = QPalette::Active) const;

	static void drawNeedle(QPainter *, const QPoint &, 
		int length, double direction, 
		const QColor &light, const QColor &dark);
};

class QWT_EXPORT QwtCompassNeedle1: public QwtDialNeedle
{
public:
	QwtCompassNeedle1(const QColor &mid = Qt::black);

	virtual void draw(QPainter *, const QPoint &, int length, 
		double direction, QPalette::ColorGroup = QPalette::Active) const;

	static void drawNeedle(QPainter *, const QPoint &, 
		int length, double direction, const QColor &);
};

class QWT_EXPORT QwtCompassNeedle2: public QwtDialNeedle
{
public:
	QwtCompassNeedle2(const QColor &light = Qt::gray, const QColor &mid = Qt::black);

	virtual void draw(QPainter *, const QPoint &, int length, 
		double direction, QPalette::ColorGroup = QPalette::Active) const;

	static void drawNeedle(QPainter *, const QPoint &, 
		int length, double direction, const QColor &, const QColor &);
};

class QWT_EXPORT QwtCompassNeedle3: public QwtDialNeedle
{
public:
	QwtCompassNeedle3(const QColor &base = Qt::black, const QColor &mid = Qt::black);

	virtual void draw(QPainter *, const QPoint &, int length, 
		double direction, QPalette::ColorGroup = QPalette::Active) const;

	static void drawNeedle(QPainter *, const QPoint &, 
		int length, double direction, const QColor &, const QColor &);
};

class QWT_EXPORT QwtCompassNeedle4: public QwtDialNeedle
{
public:
    QwtCompassNeedle4(const QColor &light = Qt::white,
        const QColor &dark = Qt::red, const QColor &mid = Qt::gray);

	virtual void draw(QPainter *, const QPoint &, int length, 
		double direction, QPalette::ColorGroup = QPalette::Active) const;

	static void drawNeedle(QPainter *, const QPoint &, 
		int length, double direction, 
		const QColor &, const QColor &, const QColor &);

protected:
	static void drawPointer(QPainter *painter, const QColor &color,
    	int colorOffset, const QPoint &center, 
		int length, int width, double direction);

};

class QWT_EXPORT QwtCompassLineNeedle: public QwtDialNeedle
{
public:
	QwtCompassLineNeedle(const QColor &foreground = Qt::black);

	virtual void draw(QPainter *, const QPoint &, int length, 
		double direction, QPalette::ColorGroup = QPalette::Active) const;

	static void drawNeedle(QPainter *, const QPoint &, 
		int length, double direction, const QColor &);
};

#endif // QWT_DIAL_ITEM_H
