/* -*- mode: C++ ; c-file-style: "stroustrup" -*- *****************************
 * Qwt Widget Library
 * Copyright (C) 1997   Josef Wilgen
 * Copyright (C) 2002   Uwe Rathmann
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the Qwt License, Version 1.0
 *****************************************************************************/

#ifndef QWT_MARKER_H
#define QWT_MARKER_H

#include <qpen.h>
#include <qfont.h>
#include <qstring.h>
#include "qwt_global.h"
#include "qwt_symbol.h"

class QRect;

/*!
  \brief A class for drawing markers

  A marker can be a horizontal line, a vertical line,
  a symbol, a label or any combination of them, which can
  be drawn around a center point inside a bounding rectangle.

  The QwtMarker::setSymbol() member assigns a symbol to the marker.
  The symbol is drawn at the specified point.

  With QwtMarker::setLabel(), a label can be assigned to the marker.
  The QwtMarker::setLabelAlignment() member specifies where the label is
  drawn. All the Align*-constants in qwindefs.h (see Qt documentation)
  are valid. The interpretation of the alignment depends on the marker's
  line style. The alignment refers to the center point of
  the marker, which means, for example, that the label would be printed
  left above the center point if the alignment was set to AlignLeft|AlignTop.
*/

class QWT_EXPORT QwtMarker
{
public:

    /*!
        Line styles.
        \sa QwtMarker::setLineStyle, QwtMarker::lineStyle
    */
    enum LineStyle {NoLine, HLine, VLine, Cross};
   
    QwtMarker();
    virtual ~QwtMarker();

    const QwtMarker & operator=(const QwtMarker&);
    
    void setLineStyle(LineStyle st);
    LineStyle lineStyle() const;

    void setSymbol(const QwtSymbol &s);
    const QwtSymbol &symbol() const;

    void setLabel(const QString &txt);
    const QString& label() const;

    void setLabelAlignment(int align);
    int labelAlignment() const;

    void setLabelPen(const QPen &p);
    const QPen &labelPen() const;
    void setLinePen(const QPen &p);
    const QPen &linePen() const;

    void setFont(const QFont &f);
    const QFont &font() const;
    
    virtual void draw(QPainter *p, int x, int y, const QRect &r);
    
protected:
    virtual void markerChanged();
 
private:
    QString d_label;
    QPen d_pen;
    QPen d_tPen;
    QFont d_font;
    QwtSymbol d_sym;
    int d_align;
    LineStyle d_style;
};

#endif
