/* -*- mode: C++ ; c-file-style: "stroustrup" -*- *****************************
 * Qwt Widget Library
 * Copyright (C) 1997   Josef Wilgen
 * Copyright (C) 2002   Uwe Rathmann
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the Qwt License, Version 1.0
 *****************************************************************************/

#ifndef QWT_PLOT_CANVAS_H
#define QWT_PLOT_CANVAS_H

#include <qframe.h>
#include <qpen.h>
#include "qwt_global.h"
#include "qwt.h"
class QwtPlotCanvas;
#include "qwt_plot.h"

/*!
  \brief Canvas of a QwtPlot. 

  \sa  QwtPlot 
*/

class QWT_EXPORT QwtPlotCanvas : public QFrame
{
  Q_OBJECT
  friend class QwtPlot;
public:
    void enableOutline(bool tf);
    bool outlineEnabled() const;

    void setOutlinePen(const QPen &p);
    const QPen& outlinePen() const;

    void setOutlineStyle(Qwt::Shape os);
    Qwt::Shape outlineStyle() const;
    
signals:
    /*!
      A signal which is emitted when the mouse is 
      pressed in the canvas.
      \param e Mouse event object
     */
    void mousePressed(const QMouseEvent &e);

    /*!
      A signal which is emitted when a mouse button has been
      released in the canvas.
      \param e Mouse event object
     */
    void mouseReleased(const QMouseEvent &e);
    
    /*!
      A signal which is emitted when the mouse is moved 
      in the canvas.
      \param e Mouse event object
     */
    void mouseMoved(const QMouseEvent &e);

protected:
    QwtPlotCanvas(QwtPlot *);

  virtual void frameChanged();
  virtual void drawContents(QPainter *);

    virtual void mousePressEvent(QMouseEvent *e);
    virtual void mouseReleaseEvent(QMouseEvent *e);
    virtual void mouseMoveEvent(QMouseEvent *e);

private:    
    void drawOutline(QPainter &p);

    bool d_outlineEnabled;
    bool d_outlineActive;
    bool d_mousePressed;
    Qwt::Shape d_outline;

    QPen d_pen;
    QPoint d_entryPoint;
    QPoint d_lastPoint;
};

#endif
