/* -*- mode: C++ ; c-file-style: "stroustrup" -*- *****************************
 * Qwt Widget Library
 * Copyright (C) 1997   Josef Wilgen
 * Copyright (C) 2002   Uwe Rathmann
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the Qwt License, Version 1.0
 *****************************************************************************/

#ifndef QWT_THERMO_H
#define QWT_THERMO_H

#include <qwidget.h>
#include <qcolor.h>
#include <qfont.h>
#include <qrect.h>
#include "qwt_global.h"
#include "qwt_dimap.h"
#include "qwt_scldraw.h"
#include "qwt_sclif.h"


//! The Thermometer Widget
class QWT_EXPORT QwtThermo: public QWidget, public QwtScaleIf
{
    Q_OBJECT

public:
    /*! 
        Position of the scale
        \sa QwtThermo;;QwtThermo
     */
    enum ScalePos {None, Left, Right, Top, Bottom};

    QwtThermo(QWidget *parent = 0, const char *name = 0);
    virtual ~QwtThermo();

    void setOrientation(Qt::Orientation o, ScalePos s);
    void setBorderWidth(int w);
    void setFillColor(const QColor &c);
    void setAlarmColor(const QColor &c);
    void setAlarmLevel(double v);
    void setAlarmEnabled (int tf);
    void setPipeWidth(int w);
    void setRange(double vmin, double vmax);
    void setMargin(int m);
    //! \return max value
    double maxValue() { return d_maxValue; }
    //! \return min value
    double minValue() { return d_minValue; }
    //! \return value
    double value() { return d_value; }

    virtual QSize sizeHint() const;
    virtual QSize minimumSizeHint() const;
    virtual QSizePolicy sizePolicy() const;

public slots:
    void setValue(double val);
    
protected:
    void draw(QPainter *p, const QRect& update_rect);
    void drawThermo(QPainter *p);
    void layoutThermo( bool update = TRUE );
    virtual void scaleChange();
    virtual void fontChange(const QFont &oldFont);

    virtual void paintEvent(QPaintEvent *e);
    virtual void resizeEvent(QResizeEvent *e);

private:
    void init();
    
    QwtDiMap d_map;
    QRect d_thermoRect;
    QColor d_fillColor;
    QColor d_alarmColor;
    
    Qt::Orientation d_orient;
    ScalePos d_scalePos;
    int d_borderWidth;
    int d_scaleDist;
    int d_thermoWidth;

    double d_minValue;
    double d_maxValue;
    double d_value;
    double d_alarmLevel;
    int d_alarmEnabled;
};

#endif
