/***************************************************************************
                          qwtplotwidget.h  -  description
                             -------------------
    begin                : Mon Mai 26 2003
    copyright            : (C) 2003 by Rainer Lehrig
    email                : lehrig@t-online.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef QWTPLOTWIDGET_H
#define QWTPLOTWIDGET_H

#include <qwidget.h>
#include <qwt_plot.h>

/**
  *@author Rainer Lehrig
  */

class QwtPlotWidget : public QwtPlot
{
  public: 
	  QwtPlotWidget(QWidget *parent, int numberCurves=10, int numberMarker=1000);
	  ~QwtPlotWidget();
    int interpret(const char *command, double *x=NULL, double *y=NULL);

  private:
    int getText(const char *str, char *text, int maxlength);
    int isCommand(const char *command);
    const char *line;    
    int  nMarker;
    int  nCurves;
    long *curves;
    long *marker;
};

#endif
